import java.awt.Image;
import java.io.IOException;
import javax.imageio.*;

class MarisaReimu extends HybridBody<Reimu, Marisa> implements java.io.Serializable
{
    static final long serialVersionUID = 1L;
    public static final int type = 10000;
    public static final String nameJ = "れいむ";
    public static final String nameE = "Reimu";

    private static Image[][][] images = new Image[ImgFlag.NUM_OF_CONDITION][2][3];

    public static void loadImages (ClassLoader loader) throws IOException {
	final String path = "images/hybrid/marisa-reimu/";
	final String dir[] = {"left/", "right/"};

	for (int i=ImgFlag.LEFT; i <= ImgFlag.RIGHT; i++) {
	    images[ImgFlag.BODY][i][adultIndex] = ImageIO.read(loader.getResourceAsStream(path+dir[i]+"body.png"));
	    images[ImgFlag.LICK][i][adultIndex] = ImageIO.read(loader.getResourceAsStream(path+dir[i]+"lick.png"));
	    images[ImgFlag.BRAID][i][adultIndex] = ImageIO.read(loader.getResourceAsStream(path+dir[i]+"braid.png"));
	    images[ImgFlag.ACCESSORY][i][adultIndex] = ImageIO.read(loader.getResourceAsStream(path+dir[i]+"hat.png"));
	    images[ImgFlag.DAMAGED][i][adultIndex] = ImageIO.read(loader.getResourceAsStream(path+dir[i]+"damage.png"));
	    images[ImgFlag.SHIT][i][adultIndex] = ImageIO.read(loader.getResourceAsStream(path+"shit.png"));
	    images[ImgFlag.CRUSHED][i][adultIndex] = ImageIO.read(loader.getResourceAsStream(path+"crushed.png"));			
	    images[ImgFlag.NORMAL][i][adultIndex] = ImageIO.read(loader.getResourceAsStream(path+dir[i]+"faces/normal.png"));
	    images[ImgFlag.SLEEPING][i][adultIndex] = ImageIO.read(loader.getResourceAsStream(path+dir[i]+"faces/sleeping.png"));
	    images[ImgFlag.CHEER][i][adultIndex] = ImageIO.read(loader.getResourceAsStream(path+dir[i]+"faces/cheer.png"));
	    images[ImgFlag.SMILE][i][adultIndex] = ImageIO.read(loader.getResourceAsStream(path+dir[i]+"faces/smile.png"));
	    images[ImgFlag.TIRED][i][adultIndex] = ImageIO.read(loader.getResourceAsStream(path+dir[i]+"faces/tired.png"));
	    images[ImgFlag.PUFF][i][adultIndex] = ImageIO.read(loader.getResourceAsStream(path+dir[i]+"faces/puff.png"));
	    images[ImgFlag.CRYING][i][adultIndex] = ImageIO.read(loader.getResourceAsStream(path+dir[i]+"faces/crying.png"));
	    images[ImgFlag.EXCITING][i][adultIndex] = ImageIO.read(loader.getResourceAsStream(path+dir[i]+"faces/exciting.png"));
	    images[ImgFlag.REFRESHED][i][adultIndex] = ImageIO.read(loader.getResourceAsStream(path+dir[i]+"faces/refreshed.png"));
	    images[ImgFlag.DEAD][i][adultIndex] = ImageIO.read(loader.getResourceAsStream(path+dir[i]+"faces/dead.png"));
	    images[ImgFlag.RUDE][i][adultIndex] = ImageIO.read(loader.getResourceAsStream(path+dir[i]+"faces/rude.png"));
	}
	images[ImgFlag.ROLL][ImgFlag.LEFT][adultIndex] = ImageIO.read(loader.getResourceAsStream(path+"roll_left.png"));
	images[ImgFlag.ROLL][ImgFlag.RIGHT][adultIndex] = ImageIO.read(loader.getResourceAsStream(path+"roll_right.png"));

	for(Image[][] array2d : images) {	
	    for(Image[] array : array2d) {
		if(array[adultIndex] == null) {
		    continue;
		}
		// Scale larger images down for koyukkuri
		array[adultIndex] = array[adultIndex].getScaledInstance(adultWidth, adultHeight, Image.SCALE_AREA_AVERAGING);
		array[childIndex] = array[adultIndex].getScaledInstance(childWidth, childHeight, Image.SCALE_AREA_AVERAGING);
		array[babyIndex] = array[adultIndex].getScaledInstance(babyWidth, babyHeight, Image.SCALE_AREA_AVERAGING);
	    }
	}
    }

    public Image getImage (int type, int direction, AgeState age) { return images[type][direction][age.ordinal()]; }

    @Override
    public int getType () { return type; }

    @Override
    public String getNameJ () { return nameJ; }

    @Override
    public String getNameE () { return nameE; }

    @Override
    public MarisaReimu clone () { return new MarisaReimu(this); }

    @Override
    protected String msgWantFoodJ () {
	String[] output = {"ごはんしゃんのにおいがすりゅよ", "ごはんしゃんのにおいがすりゅよ", "ごはんさんのにおいがするよ"};
	return output[ageState.ordinal()];
    }

    @Override
    protected String msgWantFoodE () {
	String[] output = {"The shmell of mishder food!", "Shmell of mishder food!", "It's the smell of mister food!"};
	return output[ageState.ordinal()];
    }

    @Override
    protected String msgNoFoodJ()
    {
	String[][] output = {{"あまあまがにゃいよ！", "あまあまがにゃいよ？ばきゃなの？しにゅの？", "あまあまがないよ？ばかなの？しぬの？"},
		{"ごはんしゃんかえちて、、、", "ごはんしゃんかえちて、、、", "ごはんさんがえぢでぐだざいぃ、、、"}};
	return output[damageState.ordinal()][ageState.ordinal()];
    }

    @Override
    protected String msgNoFoodE()
    {
	String[][] output = {{"Mishder food ish nod here!", "Mishder food ish nod here! Are you shtoopid?  Wand choo die?", "Mister food is not here?  Are you stupid? Want to die?"},
		{"Gib back mishder food...", "Gib back mishder food...", "Pwease give back mister food..."}};
	return output[damageState.ordinal()][ageState.ordinal()];
    }

    @Override
    protected String msgExciteJ() { return "すっぎりじだいの〜！"; }

    @Override
    protected String msgExciteE() { return "Want to refresh~!"; }

    @Override
    protected String msgRelaxJ()
    {
	String output[] = {"ゆっきゅりしていっちぇね！", "ゆっきゅりしていっちぇね！", "ゆっくりしていってね！"};
	return output[ageState.ordinal()];
    }

    @Override
    protected String msgRelaxE()
    {
	String output[] = {"Chake id eajy!", "Chake id eajy!", "Take it easy!"};
	return output[ageState.ordinal()];
    }

    @Override
    protected String msgFuriFuriJ()
    {
	String output[] = {"ふーりふーり", "まりちゃかわいきゅてごみぇんね！", "まりさのあにゃるでしこってもいいよ！"};
	return output[ageState.ordinal()];
    }

    @Override
    protected String msgFuriFuriE()
    {
	String output[] = {"Relax-relax~", "Maricha ish showwy for being sho cude!", "Taste Marisa's anyaru is ok too!"};
	return output[ageState.ordinal()];
    }

    protected String msgWakeupJ()
    {
	String output[] = {"ゆっきゅりしていっちぇね！", "ゆっきゅりしていっちぇね！", "ゆっくりしていってね！"};
	return output[ageState.ordinal()];
    }

    protected String msgWakeupE()
    {
	String output[] = {"Chake id eajy!", "Chake id eajy!", "Take it easy!"};
	return output[ageState.ordinal()];
    }

    @Override
    protected String msgSleepJ() { return "すーやすーや"; }

    @Override
    protected String msgSleepE() { return "Sleep-Sleep---"; }

    @Override
    protected String msgScreamJ() {
	String[][] output = {{"ゆんやー！", "いちゃい！ぷきゅーじゃよ！", "いたい！ぷくーだよ！"},
		{"やめちぇにぇやめちぇにぇ", "ごめんなちゃいやめちぇにぇ、、、", "どぼじででいぶにこんなごどずるのぉ、、、"}};
	return output[damageState.ordinal()][ageState.ordinal()];
    }

    @Override
    protected String msgScreamE() {
	String[][] output = {{"YUNYA-!!", "ID HURD!  Going choo pyuff-pyuff!", "It hurts! Puff!!"},
		{"Shdop id shdop id-", "Maricha ish showwy sho pwease shdop id...", "Why would you do thisss...."}};
	return output[damageState.ordinal()][ageState.ordinal()];
    }

    @Override
    protected String msgScareJ () {
	String[][] output = {{"ゆんやー！", "ゆっくちできにゃいー！", "なんだかゆっくりできないよ！"},
		{"やめちぇにぇやめちぇにぇ", "ごめんなちゃいやめちぇにぇ、、、", "どぼじででいぶにこんなごどずるのぉ、、、"}};
	return output[damageState.ordinal()][ageState.ordinal()];
    }

    @Override
    protected String msgScareE () {
	String[][] output = {{"YUNYA-!!", "I can'ch chake id eajy!", "I feel like I can't take it easy!"},
		{"Shdop id shdop id-", "Maricha ish showwy sho pwease shdop id...", "Why would you do thisss...."}};
	return output[damageState.ordinal()][ageState.ordinal()];
    }

    @Override
    protected String msgAlarmJ () {
	String[][] output = {{"にゃんだかゆっくちできにゃい！", "にゃんだかゆっくちできにゃい！", "なんだかゆっくりできないよ！"},
		{"やめちぇにぇやめちぇにぇ", "ごめんなちゃいやめちぇにぇ、、、", "どぼじででいぶにこんなごどずるのぉ、、、"}};
	return output[damageState.ordinal()][ageState.ordinal()];
    }

    @Override
    protected String msgAlarmE () {
	String[][] output = {{"I can'ch chake id eajy!", "I can'ch chake id eajy!", "I feel like I can't take it easy!"},
		{"Shdop id shdop id-", "Maricha ish showwy sho pwease shdop id...", "Why would you do thisss...."}};
	return output[damageState.ordinal()][ageState.ordinal()];
    }

    @Override
    protected String msgDyingJ () {
	String[] output = {"ゆべっ！", "ぷきゅっ！", "げぼっ！"};
	return output[ageState.ordinal()];
    }

    @Override
    protected String msgDyingE () {
	String[] output = {"Yubee!!", "Puff!", "Blarg!"};
	return output[ageState.ordinal()];
    }

    @Override
    protected String msgDeadJ () {
	String[] output = {"もっちょゆっくちしちゃかった、、、", "もっちょゆっくちしちゃかった、、、", "もっとゆっくりしたかった、、、"};
	return output[ageState.ordinal()];
    }

    @Override
    protected String msgDeadE () {
	String[] output = {"Wanted choo chake id eajy more...", "Wanted choo chake id eajy more...", "Wanted to take it easy more..."};
	return output[ageState.ordinal()];
    }

    @Override
    protected String msgEatingJ () {
	String[][] output = {{"む〜ちゃむ〜ちゃ、ちあわちぇー", "むーちゃむーちゃ、ちあわちぇー", "むーしゃむーしゃ、しあわせー"},
		{"むっちゃむっちゃ、、、", "むちゃむちゃ、はふはふ", "むっしゃむっしゃ、うめぇ"}};
	return output[hungryState.ordinal()][ageState.ordinal()];
    }

    @Override
    protected String msgEatingE () {
	String[][] output = {{"Myunch-Myunch, happinesh~ ", "Myunch~ Myunch~ Happinesh~", "Munch munch, Happiness"},
		{"Myunch myunch...", "Myunch Myunch, nom nom", "Munch munch, so good!"}};
	return output[hungryState.ordinal()][ageState.ordinal()];
    }

    @Override
    protected String msgEatingShitJ () {
	String[] output = {"む〜ちゃむ〜ちゃ、げりょまじゅ、、、", "むーちゃむーちゃ、げろまじゅ、、、", "むーしゃむーしゃ、げろまず、、、"};
	return output[ageState.ordinal()];
    }

    @Override
    protected String msgEatingShitE () {
	String[] output = {"Myunch-Myunch, disgusting...", "Myunch~ Myunch~ disgusting...", "Munch munch, disgusting..."};
	return output[ageState.ordinal()];
    }

    @Override
    protected String msgFullJ () {
	String[] output = {"おにゃかいっぱい、、、", "おにゃかいっぱい、、、", "もうたべられないの、、、"};
	return output[ageState.ordinal()];
    }

    @Override
    protected String msgFullE () {
	String[] output = {"Tummy ish full...", "Tummy ish full...", "Can't eat anymore..."};
	return output[ageState.ordinal()];
    }

    @Override
    protected String msgHealingJ () {
	String[][] output = {{"あみゅあみゃ！", "ゆっきゅちしちゃよ！", "ゆっくりしたよ！"},
		{"あみゃあみゃ", "ゆっきゅちしちゃよ", "ゆっくりしたよ"}};
	return output[damageState.ordinal()][ageState.ordinal()];
    }

    @Override
    protected String msgHealingE () {
	String[][] output = {{"Shweet-shweet!", "Eajy!", "Can take it easy!"},
		{"Shweet-shweet", "Can chake id eajy", "Can take it easy"}};
	return output[damageState.ordinal()][ageState.ordinal()];
    }

    @Override
    protected String msgSukkiriJ () {
	String[] output = {"ちゅっきち！", "ちゅっきり！", "すっきり！"};
	return output[ageState.ordinal()];
    }

    @Override
    protected String msgSukkiriE () {
	String[] output = {"Wefweshed!", "Wefeshed!", "Refreshed!"};
	return output[ageState.ordinal()];
    }

    @Override
    protected String msgBirthJ () { return "ゆっくちちていっちぇね！まりちゃはりぇいみゅは!"; }

    @Override
    protected String msgBirthE () { return "Mawicha ish Weimu! Chake id eajy!"; }

    @Override
    protected String msgShitJ () {
	String[] output = {"うんうんぢぇりゅ！", "まりちゃのすーぴゃーうんうんちゃいみゅはぢみゃりゅにょ！", "まりさのすーぱーうんうんたいむはじまるよ！"};
	return output[ageState.ordinal()];
    }

    @Override
    protected String msgShitE () {
	String[] output = {"Poo-pooing!", "Maricha's shuupa poo-poo time ish shtarting!", "Marisa's super poo-poo time is starting!"};
	return output[ageState.ordinal()];
    }

    @Override
    protected String msgShit2J () {
	String[] output = {"すっきち！", "すっきちー！", "すっきりー！"};
	return output[ageState.ordinal()];
    }

    @Override
    protected String msgShit2E () {
	String[] output = {"Wefeshed!", "Wefeshed-!!", "Refreshed~!"};
	return output[ageState.ordinal()];
    }

    @Override
    protected String msgSuriSuriJ () {
	String[] output = {"ちゅりちゅり", "ちゅーりちゅーり", "すーりすーり"};
	return output[ageState.ordinal()];
    }

    @Override
    protected String msgSuriSuriE () {
	String[] output = {"Wub-wub", "Wub-wub", "Rub-rub"};
	return output[ageState.ordinal()];
    }

    @Override
    protected String msgPeroPeroJ () {
	String[] output = {"ぺりょぺりょ", "ぺーりょぺーりょ", "ぺーろぺーろ"};
	return output[ageState.ordinal()];
    }

    @Override
    protected String msgPeroPeroE () {
	String[] output = {"Wick-wick~", "Wick-wick~", "Lick-lick~"};
	return output[ageState.ordinal()];
    }

    @Override
    protected String msgBreedJ () { return "う、うばれる、、、"; }

    @Override
    protected String msgBreedE () { return "B...Being born..."; }

    @Override
    protected String msgBreed2J () { return "ゆっくりしていってね！"; }

    @Override
    protected String msgBreed2E () { return "Take it easy!"; }

    @Override
    protected String msgHateShitJ () {
	String[][] output = {{"くちゃい〜！", "うんうんくちゃい！しゅぎゅにかたじゅきぇりょ！", "うんうんかたづけてね！すぐでいいよ！"},
		{"くちゃい、、、", "くちゃいよ、ゆっきゅりできにゃい、、、", "くさいよ、ゆっくりできないよ、、、"}};
	return output[damageState.ordinal()][ageState.ordinal()];
    }

    @Override
    protected String msgHateShitE () {
	String[][] output = {{"Shmelly~!", "Poo-poo shdinky!!  Help eajy!!", "Hurry up and save me from poo-poo!! Right now is fine!"},
		{"Shmelly...", "Shmelly, can'ch chake id eajy...", "Smelly... can't take it easy..."}};
	return output[damageState.ordinal()][ageState.ordinal()];
    }

    @Override
    protected String msgHungryJ () {
	String[][] output = {{"あみゃあみゃちょうじゃい！", "ごはんしゃんをまりちゃにもってきちぇね！", "ごはんさんをまりさにちょうだいね！たくさんでいいよ！"},
		{"ごはんしゃんどきょ？", "おにゃきゃへっちゃよ、、、", "ばりざにごはんぐだざいぃ"}};
	return output[damageState.ordinal()][ageState.ordinal()];
    }

    @Override
    protected String msgHungryE () {
	String[][] output = {{"Gib up shweet-shweets!", "Bwing mishder munch-munch choo Mawicha!", "Bring the munch-munch to Marisa! A lot is fine!"},
		{"Where ish mishder food?", "Misder tummy ish hungwy...", "Pwease give Bawiza some food..."}};
	return output[damageState.ordinal()][ageState.ordinal()];
    }

    @Override
    protected String msgNoAccessoryJ () {
	String[] output = {"ゆぇーん！おりぼんしゃんどきょ？", "ゆぇーん！まりちゃのきゃわいいおりぼんしゃんどこ？", "まりさのおりぼんさんどこ？"};
	return output[ageState.ordinal()];
    }

    @Override
    protected String msgNoAccessoryE () {
	String[] output = {"Yunn~!  Where ish misder Wibbon?", "Yunn~!  Where ish Mawicha's cude-cude misder Wibbon?", "Where's Marisa's mister ribbon?"};
	return output[ageState.ordinal()];
    }

    @Override
    protected String msgHateYukkuriJ () {
	String[] output = {"ゆっくちできにゃいゆっくちがいりゅよ", "ゆっくちできにゃいゆっくちがいりゅよ", "ゆっくりできないゆっくりがいるよ！せいっさいするよ！"};
	return output[ageState.ordinal()];
    }

    @Override
    protected String msgHateYukkuriE () {
	String[] output = {"There'sh a yukkuri that can'ch chake id eajy", "There'sh a yukkuri that can'ch chake id eajy", "A yukkuri that can't take it easy!  Punishment time!"};
	return output[ageState.ordinal()];
    }

    @Override
    protected String msgFlyingJ () {
	String[] output = {"おちょらをとんでりゅみちゃい！", "まりちゃはおしょらをとぶとりさん！", "おそらをとんでるみたい！"};
	return output[ageState.ordinal()];
    }

    @Override
    protected String msgFlyingE () {
	String[] output = {"Ich feewsh wike fwying!", "Mawicha ish mishter flying bird!", "I feel like I'm flying!"};
	return output[ageState.ordinal()];
    }

    @Override
    protected String msgSadnessForChildJ () { return "おちびちゃんすきとおったきれいなおめめをあけてー！"; }

    @Override
    protected String msgSadnessForChildE () { return "Open your beautiful clear eyes, my little one!"; }

    @Override
    protected String msgSadnessForPartnerJ (Body partner) {
	return partner.getNameJ()+"めをあけてー！";
    }

    @Override
    protected String msgSadnessForPartnerE (Body partner) {
	return "Open your eyes, "+partner.getNameE()+"!";
    }

    // public methods
    public MarisaReimu(int initX, int initY, int initZ, Body.AgeState initAgeState, Body p1, Body p2) {
	super(initX, initY, initZ, initAgeState, p1, p2);
    }

    protected MarisaReimu (MarisaReimu other) { super(other); }
}