import java.util.Random;

public class Body extends Obj {
	// public variables	
	public static final int MARISA = 1;
	public static final int REIMU = 2;
	public static final int EATAMOUNT[] = {100*4, 100*6, 100*8};
	public static final int	BABY = 0;
	public static final int CHILD = 1;
	public static final int ADULT = 2;
	
	// private variables
	private static final int HUNGRYLIMIT[] = {100*24, 100*24*3, 100*24*7};
	private static final int SHITLIMIT[] = {100*8, 100*12, 100*24};
	private static final int DAMAGELIMIT[] = {100*24, 100*24*3, 100*24*7};
	private static final int BABYLIMIT = 100*24*2;
	private static final int CHILDLIMIT = 100*24*7;
	private static final int LIFELIMIT = 100*24*365*5;	
	private static final int HUNGRYNOT = 0;
	private static final int HUNGRYMUCH = 1;	
	private static final int DAMAGENOT = 0;
	private static final int DAMAGEMUCH = 1;
	private static final int STEP[] = {1, 2, 4};
	private static final int RELAXPERIOD = 100*1;
	private static final int EXCITEPERIOD = 100*3;
	private static final int PREGPERIOD = 100*24;
	private static final int SLEEPPERIOD = 100*3;
	private static final int ACTIVEPERIOD = 100*6;
	private static final int NEEDLE = 100;
	private static final int HAMMER = 100*24;
	private static final int TICK = 1;
	private static final int HOLDMESSAGE = 15;	
	private static final int STAYLIMIT = 15;

	private long age;				//counter indicating age
	private int ageState;			//BABY, CHILD, ADULT
	private String messageBuf;	
	private int yukkuriType;
	private int dextX = -1, destY = -1;		//destination
	private int	damage = 0;					//counter indicating damage
	private int damageState = DAMAGENOT;
	private int	hungry = 0;					//counter indicating how hungry
	private int hungryState = HUNGRYNOT;
	private int shit = 0;
	private int noDamagePeriod = 0;
	private int noHungryPeriod = 0;
	private boolean	hasAccessory = true;	//true if having accessory
	private boolean	hasBaby = false;		//having baby or not
	private int babyType;
	private int pregnant = 0;
	private boolean dead = false;			// dead of alive
	private boolean excitement = false; 	//
	private int excite = 0;
	private boolean relax = false;
	private boolean sleeping = false;
	private int sleep = 0;
	private long wakeUpTime;
	private Random rnd = new Random();
	private int countX = 0, countY = 0;		// how many steps to same direction
	private int dirX = 0, dirY = 0;			// direction to move on
	private int messageCount = 0;
	private boolean staying = false;
	private int staycount = 0;
	private int stayTime = STAYLIMIT;
	private boolean toFood = false;
	private boolean toSukkiri = false;
	private boolean shitting = false;
	private boolean birth = false;
	private boolean ungry = false;
	private boolean furifuri = false;
	private boolean strike = false;
	private boolean eating = false;
	private boolean peropero = false;
	private boolean sukkiri = false;
	
	// private methods
	private int checkAageState() {
		int state;
		if (age < BABYLIMIT) {
			state = BABY;
		} else if (age < CHILDLIMIT) {
			state = CHILD;
		} else {
			state = ADULT;
		}
		return state;
	}
	
	private int checkHungryState() {
		int state;
		if (hungry < HUNGRYLIMIT[ageState]/4) {
			state = HUNGRYNOT;
		} else {
			state = HUNGRYMUCH;
		}
		return state;
	}
	
	private int checkDamageState() {
		int state;
		if (damage < DAMAGELIMIT[ageState]/2) {
			state = DAMAGENOT;
		} else {
			state = DAMAGEMUCH;
		}
		return state;
	}
	
	private void checkHungry() {
		if (excitement == true || hasBaby == true) {
			hungry += TICK*2;
		} else {
			hungry += TICK;
		}
		if (hungry > HUNGRYLIMIT[ageState]) {
			dead = true;
		}
		if (hungryState == HUNGRYNOT && checkHungryState() == HUNGRYNOT) {
			noHungryPeriod += TICK;
		} else {
			noHungryPeriod = 0;
		}
		hungryState = checkHungryState();
	}

	private void checkDamage() {
		if (hungryState == HUNGRYNOT) {
			damage -= TICK;
		}
		if (damage < 0) {
			damage = 0;
		} else if (damage > DAMAGELIMIT[ageState]) {
			dead = true;
		}
		if (damageState == DAMAGENOT && checkDamageState() == DAMAGENOT) {
			noDamagePeriod += TICK;
		} else {
			noDamagePeriod = 0;
		}
		damageState = checkDamageState();
	}
	
	private boolean checkShit() {
		boolean cantMove = false;
		if (hungryState == HUNGRYNOT) {
			shit += TICK*2;
		} else {
			shit += TICK;
		}
		if (shit > SHITLIMIT[ageState] - TICK*100) {
			cantMove = true;
			shitting = true;
			showShit();
		}
		if (shit > SHITLIMIT[ageState]) {
			shitting = false;
			shit = 0;
			showShit2();
		}
		return cantMove;
	}

	private boolean checkPregnant() {
		boolean cantMove = false;
		if (hasBaby) {
			pregnant += TICK;
			if (pregnant > PREGPERIOD - TICK*100) {
				cantMove = true;
				birth = true;
				showBreed();
			}
			if (pregnant > PREGPERIOD) {
				// Keep babyType for generating baby.
				pregnant = 0;
				birth = false;
				hasBaby = false;
				showBreed2();
			}
		}
		return cantMove;
	}
	
	private boolean checkSleep() {
		if (wakeUpTime + ACTIVEPERIOD < age && excitement == false && relax == true) {
			toFood = false;
			sleeping = true;
			ungry = false;
			sleep += TICK;
			if (sleep > SLEEPPERIOD) {
				showWakeup();
				wakeup();
			}
		} else {
			sleep = 0;
			sleeping = false;
		}
		return sleeping;
	}
	
	private void wakeup() {
		sleep = 0;
		sleeping = false;
		wakeUpTime = age;
	}
	
	private void checkExciteAndRelax() {
		if (noHungryPeriod > RELAXPERIOD && noDamagePeriod > RELAXPERIOD && !sleeping && hasAccessory) {
			if (excitement == false && relax == false) {
				int r = rnd.nextInt(24);
				if (ageState == ADULT && hasBaby == false && r == 0) {
					excitement = true;
					relax = false;
					showExcite();
				}
				else {
					excitement = false;
					relax = true;
					ungry = false;
					showRelax();
				}
			} else {
				excite += TICK;
				if (excite > EXCITEPERIOD) {
					excite = 0;
					excitement = false;
					relax = false;
				}
			}
		}
		if (hungryState != HUNGRYNOT || damageState != DAMAGENOT || !hasAccessory) {
			relax = false;
			wakeup();
		}
	}
		
	private void checkMessage() {
		if (--messageCount <= 0) {
			messageCount = 0;
			messageBuf = null;
			furifuri = false;
			strike = false;
			eating = false;
			peropero = false;
			sukkiri = false;
		}
		if (dead) {
			String messages[] = {"ႩAAA", "ႩAAA", "Ƃ肵AAA"};
			setMessage(messages[ageState]);
		} else if (messageBuf == null) {
			if (toFood) {
				showWantFood();
			}
			else if (toSukkiri) {
				showExcite();
			}
			else if (sleeping) {
				if (rnd.nextInt(10) == 0) {
					showSleep();
				}
			}
			else if (!hasAccessory) {
				showNoAccessory();
			}
			else if (isHungry()) {
				if (rnd.nextInt(15) == 0) {
					showHungry();
				}
			}
		}
	}
	
	private void stay() {
		staying = true;
		stayTime = STAYLIMIT;
	}
	
	private void stay(int time) {
		staying = true;
		stayTime = time;
	}
	
	private void moveBody() {
		int sameDest = 30 * STEP[ageState];
		int step;
		if (hasBaby || hungryState == HUNGRYMUCH || damageState == DAMAGEMUCH) {
			step = STEP[ageState]/2;
		} else {
			step = STEP[ageState];
		}
		if (step == 0) {
			step = 1;
		}
		int freq = STEP[ADULT]/step;
		if (age % freq != 0) {
			return;
		}
		step = 1;
		// calculate x axis
		if (dextX >= 0) {
			if (dextX - x > step) {
				x += step;
			} else if (x - dextX > step) {
				x -= step;
			} else {
				dextX = -1;
			}
		} else {
			if (countX++ == 0) {
				int r = rnd.nextInt(2);
				switch (dirX) {
				case 0: {
					if (r == 0) {
						dirX = 1;
					} else {
						dirX = -1;
					}
					break;
				}
				case 1: {
					if (r == 0) {
						dirX = 0;
					}
					break;
				}
				case -1: {
					if (r == 0) {
						dirX = 0;
					}
					break;
				}
				default:
					break;
				}
			} else {
				if (countX++ >= sameDest) {
					countX = 0;
				}
			}
			x += dirX * step;
		}
		if (x < 0) {
			x = 0;
			dirX *= -1;
		} else if (x > Box.maxX) {
			x = Box.maxX;
			dirX *= -1;
		}
		// calculate y axis
		if (destY >= 0) {
			if (destY - y > step) {
				y += step;
			} else if (y - destY > step) {
				y -= step;
			} else {
				destY = -1;
			}
		} else {
			if (countY++ == 0) {
				int r = rnd.nextInt(2);
				switch (dirY) {
				case 0: {
					if (r == 0) {
						dirY = 1;
					} else {
						dirY = -1;
					}
					break;
				}
				case 1: {
					if (r == 0) {
						dirY = 0;
					}
					break;
				}
				case -1: {
					if (r == 0) {
						dirY = 0;
					}
					break;
				}
				default:
					break;
				}
			} else {
				if (countY++ >= sameDest) {
					countY = 0;
				}
			}
			y += dirY * step;
		}
		if (y < 0) {
			y = 0;
			dirY *= -1;
		} else if (y > Box.maxY) {
			y = Box.maxY;
			dirY *= -1;
		}
	}
	
	private void setMessage(String message) {
		if (staying == true && messageBuf != null) {
			return;
		}
		messageCount = HOLDMESSAGE;
		messageBuf = message;
	}
	private void setMessage(String message, int count) {
		if (staying == true && messageBuf != null) {
			return;
		}
		messageCount = count;
		messageBuf = message;
	}

	private void showWantFood() {
		switch (yukkuriType) {
		case MARISA: {
			String messages[] = {"͂񂵂̂ɂ̂", "͂񂵂̂ɂ̂", "͂񂳂̂ɂ̂"};
			setMessage(messages[ageState]);
		}
		break;
		case REIMU: {
			String messages[] = {"͂񂵂̂ɂ", "͂񂵂̂ɂ", "͂񂳂̂ɂ"};
			setMessage(messages[ageState]);
		}
		break;
		default:
			System.out.println("Uknown type");
		break;
		}			
	}
	
	public void showNoFood() {
		if (toFood == false) {
			return;
		}
		toFood = false;
		switch (yukkuriType) {
		case MARISA: {
			String messages[][] = {{"͂񂵂ɂႢI", "͂񂵂ɂႢɂ傶H΂Ȃ́Hɂ́H", "͂񂳂Ȃ̂H΂Ȃ́Hʂ́H"},
									{"͂񂵂񂩂āAAA", "͂񂵂񂩂āAAA", "͂񂳂񂪂łAAA"}};
			setMessage(messages[damageState][ageState]);
		}
		break;
		case REIMU: {
			String messages[][] = {{"͂񂵂ɂႢI", "͂񂵂ɂႢH΂Ȃ́Hɂ́H", "͂񂳂ȂH΂Ȃ́Hʂ́H"},
									{"͂񂵂񂩂āAAA", "͂񂵂񂩂āAAA", "͂񂳂񂪂łAAA"}};
			setMessage(messages[damageState][ageState]);
		}
		break;
		default:
			System.out.println("Uknown type");
		break;
		}
		stay();
	}
	
	private void showExcite() {
		if (excitement) {
			switch(yukkuriType) {
			case MARISA: {
				setMessage("肶̂`I");
			}
			break;
			case REIMU: {
				setMessage("肶́`I");
			}
			break;
			}			
		}
	}

	private void showRelax() {
		switch (yukkuriType) {
		case MARISA: {
			if (rnd.nextInt(2) == 0) {
				String messages[] = {"Ӂ[Ӂ[", "܂肿͂傤ɂ傶I", "܂肳͂傤Ȃ̂I"};
				furifuri = true;
				setMessage(messages[ageState], 30);
				stay(30);
			}
			else {
				String messages[] = {"肵ĂˁI", "肵ĂˁI", "肵ĂĂˁI"};
				setMessage(messages[ageState]);
				stay();
			}
		}
		break;
		case REIMU: {
			if (rnd.nextInt(2) == 0) {
				String messages[] = {"Ӂ[Ӂ[", "ꂢ݂ォ킢Ă݂ˁI", "ꂢނ̂ɂłĂI"};
				furifuri = true;
				setMessage(messages[ageState], 30);
				stay(30);
			}
			else {
				String messages[] = {"肵ĂˁI", "肵ĂˁI", "肵ĂĂˁI"};
				setMessage(messages[ageState]);
				stay();
			}
		}
		break;
		default:
			System.out.println("Uknown type");
		break;
		}		
	}
	
	private void showWakeup() {
		String messages[] = {"肵ĂˁI", "肵ĂˁI", "肵ĂĂˁI"};
		setMessage(messages[ageState]);
		stay();
	}

	private void showSleep() {
		if (sleep != 0) {
			setMessage("[₷[");
		}		
	}
	
	private void showScream() {
		staying = false;
		strike = true;
		switch (yukkuriType) {
		case MARISA: {
			String messages[][] = {{"[I", "ႢIՂ[̂I", "߂񂾂IՂ[I"},
								{"߂ɂ߂ɂAAA", "߂ɂႿႢ߂ˁAAA", "˂΂A߂łAAA"}};
			setMessage(messages[damageState][ageState]);
		}
		break;
		case REIMU: {
			String messages[][] = {{"[I", "ႢIՂ[I", "IՂ[I"},
					   			{"߂ɂ߂ɂ", "߂ȂႢ߂ɂAAA", "ǂڂłłԂɂȂǂ̂AAA"}};
			setMessage(messages[damageState][ageState]);
		}
		break;
		default:
			System.out.println("Uknown type");
		break;
		}
		stay();
	}
	
	private void showDieing() {
		staying = false;
		switch (yukkuriType) {
		case MARISA: {
			String messages[] = {"ׂI", "ՂI", "ԂڂI"};
			setMessage(messages[ageState]);
		}
		break;
		case REIMU: {
			String messages[] = {"ׂI", "ՂI", "ڂI"};
			setMessage(messages[ageState]);
		}
		break;
		default:
			System.out.println("Uknown type");
		break;
		}
		stay();
	}
	
	private void showEating() {
		eating = true;
		switch (yukkuriType) {
		case MARISA: {
			String messages[][] = {{"ށ`ށ`A킿[", "ށ[ށ[A킿[", "ށ[ށ[A킹["},
								{"ނނAAA", "ނނA͂ӂ͂", "ނނA߂Ⴄ߂"}};
			setMessage(messages[hungryState][ageState]);
		}
		break;
		case REIMU: {
			String messages[][] = {{"ށ`ށ`A킿[", "ށ[ށ[A킿[", "ށ[ށ[A킹["},
								{"ނނAAA", "ނނA͂ӂ͂", "ނނA߂"}};
			setMessage(messages[hungryState][ageState]);
		}
		break;
		default:
			System.out.println("Uknown type");
		break;
		}
		stay();
	}
	
	private void showFull() {
		switch (yukkuriType) {
		case MARISA: {
			String messages[] = {"ɂႩςAAA", "ɂႩςAAA", "ׂȂ̂AAA"};
			setMessage(messages[ageState]);
		}
		break;
		case REIMU: {
			String messages[] = {"ɂႩςAAA", "ɂႩςAAA", "ׂȂ́AAA"};
			setMessage(messages[ageState]);
		}
		break;
		default:
			System.out.println("Uknown type");
		break;
		}
		stay();
	}
	
	private void showHealing() {
		switch (yukkuriType) {
		case MARISA: {
			String messages[][] = {{"݂Ⴀ݂I", "タ̂I", "肵̂I"},
									{"݂Ⴀ݂", "タ", "肵̂"}};
			setMessage(messages[damageState][ageState]);
		}
		break;
		case REIMU: {
			String messages[][] = {{"݂゠݂I", "タI", "肵I"},
									{"݂Ⴀ݂", "タ", "肵"}};
			setMessage(messages[damageState][ageState]);
		}
		break;
		default:
			System.out.println("Uknown type");
		break;
		}
		stay();
	}
	
	private void showSukkiri() {
		String messages[] = {"I", "I", "I"};
		setMessage(messages[ageState], 30);
		sukkiri = true;
		stay(30);
	}
	
	private void showBirth() {
		setMessage("ĂˁI", 30);
		stay(30);
	}

	private void showShit() {
		switch (yukkuriType) {
		case MARISA: {
			String messages[] = {"񂤂I", "܂肿̂[҂[񂤂񂿂Ⴂ݂ɂ傶I", "܂肳̂[ρ[񂤂񂽂ނ̂I"};
			setMessage(messages[ageState]);
		}
		break;
		case REIMU: {
			String messages[] = {"񂤂I", "肥݂̂[҂[񂤂񂿂Ⴂ݂݂͂ɂI", "ꂢނ̂[ρ[񂤂񂽂ނ͂܂I"};
			setMessage(messages[ageState]);
		}
		break;
		default:
			System.out.println("Uknown type");
		break;
		}
	}
	
	private void showShit2() {
		String messages[] = {"I", "[I", "[I"};
		setMessage(messages[ageState]);
		furifuri = true;
		stay();
	}
	
	private void showSurisuri() {
		String messages[] = {"肿", "[肿[", "[肷["};
		setMessage(messages[ageState]);
		stay();
	}

	private void showPeroPero() {
		peropero = true;
		String messages[] = {"؂؂", "؁[؁[", "؁[؁["};
		setMessage(messages[ageState]);
		stay();
	}
	
	private void showBreed() {
		setMessage("A΂AAA");
	}
	
	private void showBreed2() {
		messageBuf = null;
		setMessage("肵ĂĂˁI");
		furifuri = true;
		stay();
	}
	
	public void showHateShit() {
		String messages[][] = {{"ႢI", "񂤂񂭂ႢIガɂカI", "񂤂񂩂ÂĂˁIłI"},
								{"ႢAAA", "ႢAłɂႢAAA", "AłȂAAA"}};
		setMessage(messages[damageState][ageState]);
	}
	
	private void showHungry() {
		switch (yukkuriType) {
		case MARISA: {
			String messages[][] = {{"݂Ⴀ݂Ⴟ傤ႢI", "͂񂵂܂肵ɂĂ̂I", "͂񂳂܂肳ɂ悱̂IłI"},
									{"͂񂵂ǂH", "ɂႫւ̂AAA", "΂肴ɂ͂񂮂"}};
			setMessage(messages[damageState][ageState]);
		}
		break;
		case REIMU: {
			String messages[][] = {{"݂Ⴀ݂Ⴟ傤ႢI", "͂񂵂ꂢ݂ɂĂˁI", "͂񂳂ꂢނɂ傤ˁIłI"},
									{"͂񂵂ǂH", "ɂႫւAAA", "łԂɂ͂񂮂"}};
			setMessage(messages[damageState][ageState]);
		}
		break;
		default:
			System.out.println("Uknown type");
		break;
		}
		stay();
	}
	
	private void showNoAccessory() {
		switch (yukkuriType) {
		case MARISA: {
			String messages[] = {"䂥[IڂǂH", "䂥[I܂肿̂킢т傤ǂɂ̂H", "܂肳̂ڂǂȂ̂H"};
			setMessage(messages[ageState]);
		}
		break;
		case REIMU: {
			String messages[] = {"䂥[IႶ肵ǂH", "䂥[I肥݂̂킢Ⴖ肵ǂH", "ꂢނ̂肳ǂH"};
			setMessage(messages[ageState]);
		} 
		break;
		default:
			System.out.println("Uknown type");
		break;
		}		
	}
	
	public void showHateYukkuri() {
		switch (yukkuriType) {
		case MARISA: {
			String messages[] = {"łɂႢ", "łɂႢ̂", "łȂ肪̂ÎI"};
			setMessage(messages[ageState]);
		}
		break;
		case REIMU: {
			String messages[] = {"łɂႢ", "łɂႢ", "łȂ肪II"};
			setMessage(messages[ageState]);
		} 
		break;
		default:
			System.out.println("Uknown type");
		break;
		}				
	}

	// public methods
	public Body(int initX, int initY, int initType, int initAgeState) {
		objType = YUKKURI;
		x = initX;
		y = initY;
		z = 0;
		yukkuriType = initType;
		switch (initAgeState) {
		case BABY:
			age = 0;
			showBirth();
			break;
		case CHILD:
			age = BABYLIMIT;
			break;
		case ADULT:
		default:
			age = CHILDLIMIT;
			break;
		}
		age += rnd.nextInt(100);
		ageState = checkAageState();
		shit = rnd.nextInt(SHITLIMIT[ageState]);
		wakeUpTime = age;
		removed = false;
	}
	
	public int getBodyType() {
		return yukkuriType;
	}
	
	public int getBabyType() {
		return babyType;
	}
	
	public int getAgeState() {
		return ageState;
	}
	
	public long getAge() {
		return age;
	}
	
	public int getEatAmount() {
		return EATAMOUNT[ageState];
	}
	
	public int getStep() {
		return STEP[ageState];
	}
	
	public String getMessage() {
		return messageBuf;
	}
	
	public boolean isDead() {
		return dead;
	}
	
	public boolean isAdult() {
		if (ageState == ADULT) {
			return true;
		}
		else {
			return false;
		}
	}
	
	public boolean isSleeping() {
		if (dead) {
			return false;
		}
		return sleeping;
	}
	
	public boolean isHungry() {
		if (dead) {
			return false;
		}
		if (hungry >= HUNGRYLIMIT[ageState]/8) {
			return true;
		}
		return false;
	}
	
	public boolean isShitting() {
		if (dead) {
			return false;
		}
		return(shitting);
	}
	
	public boolean isExciting() {
		if (dead) {
			return false;
		}
		return(excitement);
	}
	
	public boolean isUngry() {
		if (dead) {
			return false;
		}
		return (ungry);
	}
	
	public boolean isFurifuri() {
		if (dead) {
			return false;
		}
		return (furifuri);
	}
	
	public boolean isStrike() {
		if (dead) {
			return false;
		}
		return strike;
	}
	
	public boolean isDamaged() {
		if (checkDamageState() == DAMAGEMUCH) {
			return true;
		}
		return false;
	}
	
	public boolean isBirth() {
		if (dead) {
			return false;
		}
		if (birth) {
			return true;
		}
		return false;
	}
	
	public boolean isAccessory() {
		return hasAccessory;
	}
	
	public boolean isEating() {
		if (dead) {
			return false;
		}
		return eating;
	}
	
	public boolean isPeroPero() {
		if (dead) {
			return false;
		}
		return peropero;
	}
	
	public boolean isSukkiri() {
		if (dead) {
			return false;
		}
		return sukkiri;
	}
		
	public void doSukkiri(Body partner) {
		if (dead) {
			return;
		}
		toSukkiri = false;
		// show message
		showSukkiri();
		partner.showSukkiri();
		// change state
		excitement = false;
		relax = false;
		ungry = false;
		noHungryPeriod = 0;
		hungry += 100*12;
		hungryState = checkHungryState();
		//change partner state
		partner.hasBaby = true;
		if (yukkuriType == partner.yukkuriType) {
			partner.babyType = yukkuriType;
		} else if (rnd.nextInt(2) == 0) {
			partner.babyType = yukkuriType;
		} else {
			partner.babyType = partner.yukkuriType;
		}
		partner.excitement = false;
		partner.relax = false;
		partner.ungry = false;
		partner.noHungryPeriod = 0;
		partner.hungry += 100*24;
		partner.hungryState = partner.checkHungryState();
	}
	
	public void forceSukkiri() {
		if (dead || !hasAccessory) {
			return;
		}
		if (hasBaby == false) {
			excitement = true;
			showExcite();
		}
		stay();
	}
	
	public void doSurisuri(Body partner) {
		if (dead) {
			return;
		}
		if (ageState == ADULT && partner.ageState != ADULT) {
			showPeroPero();
		}
		else {
			showSurisuri();
		}
		ungry = false;
		partner.ungry = false;
		//partner.stay();
	}
	
	public void moveTo(int toX, int toY) {
		if (dead) {
			return;
		}
		dextX = toX;
		destY = toY;
	}
	
	public void moveToFood(int toX, int toY) {
		toFood = true;
		toSukkiri = false;
		moveTo(toX, toY);
	}
	
	public void moveToSukkiri(int toX, int toY) {
		toSukkiri = true;
		toFood = false;
		moveTo(toX, toY);
	}
	
	public void eatFood(int amount) {
		if (dead) {
			return;
		}
		toFood = false;
		if (!isHungry()) {
			showFull();
			return;
		}
		hungry -= amount;
		if (hungry < 0) {
			hungry = 0;
		}
		showEating();
		hungryState = checkHungryState();
		ungry = false;
	}
	
	public void strike(int amount) {
		if (dead) {
			return;
		}
		damage += amount;
		showScream();
		damageState = checkDamageState();
		if (damageState == DAMAGENOT && hasAccessory) {
			ungry = true;
		}
		else {
			ungry = false;
		}
		wakeup();
	}
	
	public void strikeByNeedle() {
		strike(NEEDLE);
	}

	public void strikeByHammer() {
		if (dead) {
			return;
		}
		strike(HAMMER);
		if (damage > DAMAGELIMIT[ageState]) {
			showDieing();
		}
	}
	
	public void takeAccessory() {
		hasAccessory = false;
	}
	
	public void giveAccessory() {
		hasAccessory = true;
	}
	
	public void giveJuice(){
		if (dead) {
			return;
		}
		damage -= 100*100;
		if (damage < 0) {
			damage = 0;
		}
		showHealing();
		damageState = checkDamageState();
		ungry = false;
	}

	// calling every tick
	public int clockTick() {
		int retval = DONOTHING;
		
		// if removed, remove body
		if (removed) {
			return REMOVED;
		}
		
		// if dead, do nothing.
		if (dead) {
			checkMessage();
			return DEAD;
		}
		
		// check age
		age += TICK;
		if (age > LIFELIMIT) {
			dead = true;
		}
		ageState = checkAageState();
		
		// check hungry
		checkHungry();
		
		// check damage
		checkDamage();
		
		// check events
		boolean dontMove = false;
		
		// check shit
		int oldShit = shit;
		if (checkShit()) {
			dontMove = true;
		}
		if (oldShit != 0 && shit == 0) {
			retval = DOSHIT;
		}
		
		// check pregnant
		boolean oldHasBaby = hasBaby;
		if (checkPregnant()) {
			dontMove = true;
		}
		if (oldHasBaby == true && hasBaby == false) {
			retval = BIRTHBABY;
		}
		
		// check sleep
		if (checkSleep()) {
			dontMove = true;
		}
		
		// check relax and excitement
		checkExciteAndRelax();
		
		if (staying) {
			staycount += TICK;
			if (staycount > stayTime) {
				staycount = 0;
				staying = false;
			} else {
				dontMove = true;
			}
		}
		
		// move to destination
		// if there is no destination, walking randomly.
		if (dontMove == false) {
			moveBody();
		}
		
		//
		checkMessage();
		
		return retval;
	}
}
