import java.awt.Image;
import java.io.IOException;

import javax.imageio.ImageIO;

public class Food extends Obj implements java.io.Serializable {
	static final long serialVersionUID = 2L;

	public enum type {SHIT, YUKKURIFOOD, CAKE};

	private type foodType;
	private int amount;

	private static final int foodSize = 64;
	private static Image[] images = new Image[ImgFlag.NUM_OF_FOOD_STATE];
	
	public static void loadImages (ClassLoader loader) throws IOException {
		final String path = "images/";

		images[ImgFlag.FOOD_EMPTY] = ImageIO.read(loader.getResourceAsStream(path+"gohan1.png"));
		images[ImgFlag.FOOD_NOT_EMPTY] = ImageIO.read(loader.getResourceAsStream(path+"gohan2.png"));
		images[ImgFlag.FOOD_SHADOW] = ImageIO.read(loader.getResourceAsStream(path+"gohan-shadow.png"));
		
		for (int i=0; i < ImgFlag.NUM_OF_FOOD_STATE; i++) {
			images[i] = images[i].getScaledInstance(foodSize, foodSize/2, Image.SCALE_AREA_AVERAGING);
		}
	}
	
	public Image getImage() {
		if (isEmpty())
			return images[ImgFlag.FOOD_EMPTY];
		else
			return images[ImgFlag.FOOD_NOT_EMPTY];
	}
	
	public Image getShadowImage() {
		return images[ImgFlag.FOOD_SHADOW];
	}
	
	public int getSize() {
		return foodSize;
	}
	
	public static int getSizeS() {
		return foodSize;
	}

	public Food(int initX, int initY, type initType) {
		objType = Type.FOOD;
		x = initX;
		y = initY;
		z = 0;
		foodType = initType;
		switch (initType) {
		case YUKKURIFOOD:
			amount = 60*60*2;
			break;
		case CAKE:
			amount = 60*60;
			break;
		default:
			amount = 60*60;
		}
		removed = false;
	}

	public type getFoodType() {return foodType; }

	public boolean isEmpty() { return (amount == 0); }

	public void eatFood(int eatAmount)
	{
		if (isEmpty()) {
			return;
		}
		amount -= eatAmount;
		if (amount < 0) {
			amount = 0;
		}
	}

	public Event clockTick()
	{
		if (removed) {
			return Event.REMOVED;
		}
		if (!grabbed && z > 0)
		{
			z -= 2;
			if (z <= 0) {
				z = 0;
			}
		}
		return Event.DONOTHING;
	}
}