/* 
 *    Copyright 2013 Mimisuke
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */

public class Obj implements java.io.Serializable {
	static final long serialVersionUID = 1L;

	public enum Type {YUKKURI, SHIT, FOOD, TOILET, TOY}
	public enum Event {DONOTHING, BIRTHBABY, DOSHIT, DEAD, REMOVED}

	public static final int TICK = 1;

	// basic attributes
	protected long age;			//age of this object
	protected int x, y, z;		//location
	protected int vx, vy, vz;	//velocity of the object
	protected Type objType;		//YUKKURI, SHIT, FOOD, TOILET, TOY
	protected boolean removed = false;
	protected boolean grabbed = false;

	public long getAge() {
		return age;
	}

	public int getX() {
		return x;
	}

	public int getY() {
		return y;
	}

	public int getZ() {
		return z;
	}

	public int getVX() {
		return vx;
	}

	public int getVY() {
		return vy;
	}

	public int getVZ() {
		return vz;
	}

	public void setX (int X)
	{
		if (X < 0) {
			x = 0;
		}
		else if (X > Terrarium.MAX_X) {
			x = Terrarium.MAX_X;
		}
		else {
			x = X;
		}
	}

	public void setY (int Y) {
		if (Y < 0) {
			y = 0;
		}
		else if(Y > Terrarium.MAX_Y) {
			y = Terrarium.MAX_Y;
		}
		else {
			y = Y;
		}
	}

	public void setZ(int Z)
	{
		if (Z < 0) {
			z = 0;
		}
		else if (Z > Terrarium.MAX_Z) {
			z = Terrarium.MAX_Z;
		}
		else {
			z = Z;
		}
	}

	public void grab() {
		grabbed = true;
	}

	public void release() {
		grabbed = false;
	}

	public boolean isGrabbed() {
		return grabbed;
	}

	public Type getObjType() {
		return objType;
	}

	public void remove() {
		removed = true;
	}
	
	public void kick(int vX, int vY, int vZ) {
		vx = vX;
		vy = vY;
		vz = vZ;
	}
	
	public void kick() {
	}

	public Event clockTick()
	{
		if (removed) {
			return Event.REMOVED;
		}
		if (!grabbed) {
			if (vx != 0) {
				x += vx;
				if (x < 0) {
					x = 0;
					vx *= -1;
				}
				else if (x > Terrarium.MAX_X) {
					x = Terrarium.MAX_X;
					vx *= -1;
				}
			}
			if (vy != 0) {
				y += vy;
				if (y < 0) {
					y = 0;
					vy *= -1;
				}
				else if (y > Terrarium.MAX_Y) {
					y = Terrarium.MAX_Y;
					vy *= -1;
				}
			}
			if (z != 0 || vz != 0) {
				vz += 1;
				z -= vz;
				if (z <= 0) {
					z = 0;
					vx = 0;
					vy = 0;
					vz = 0;
				}
			}
		}
		return Event.DONOTHING;
	}
}