/* 
 *    Copyright 2013 Mimisuke
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */

import java.awt.Image;
import java.io.IOException;
import java.util.Random;
import javax.imageio.*;

public class Reimu extends Body implements java.io.Serializable {
	static final long serialVersionUID = 2L;
	public static final int type = 1;
	public static final String nameJ = "れいむ";
	public static final String nameE = "Reimu";

	private static Image[][][] images = new Image[NUM_OF_CONDITIONS][2][3];

	public static void loadImages (ClassLoader loader) throws IOException {
		final String path = "images/reimu/";

		// left face
		images[BODY][LEFT][adultIndex] =		ImageIO.read(loader.getResourceAsStream(path+"left/body.png"));
		images[LICK][LEFT][adultIndex] =		ImageIO.read(loader.getResourceAsStream(path+"left/lick.png"));
		images[BRAID][LEFT][adultIndex] =		ImageIO.read(loader.getResourceAsStream(path+"left/braid.png"));
		images[ACCESSORY][LEFT][adultIndex] =	ImageIO.read(loader.getResourceAsStream(path+"left/ribbon.png"));
		images[DAMAGED][LEFT][adultIndex] =		ImageIO.read(loader.getResourceAsStream(path+"left/damage.png"));
		images[PANTS][LEFT][adultIndex] =		ImageIO.read(loader.getResourceAsStream(path+"left/pants.png"));
		images[STAIN][LEFT][adultIndex] =		ImageIO.read(loader.getResourceAsStream(path+"left/shit.png"));
		images[SICK][LEFT][adultIndex] =		ImageIO.read(loader.getResourceAsStream(path+"left/sick.png"));
		images[NORMAL][LEFT][adultIndex] =		ImageIO.read(loader.getResourceAsStream(path+"left/faces/normal.png"));
		images[SLEEPING][LEFT][adultIndex] =	ImageIO.read(loader.getResourceAsStream(path+"left/faces/sleeping.png"));
		images[CHEER][LEFT][adultIndex] =		ImageIO.read(loader.getResourceAsStream(path+"left/faces/cheer.png"));
		images[SMILE][LEFT][adultIndex] =		ImageIO.read(loader.getResourceAsStream(path+"left/faces/smile.png"));
		images[TIRED][LEFT][adultIndex] =		ImageIO.read(loader.getResourceAsStream(path+"left/faces/tired.png"));
		images[PUFF][LEFT][adultIndex] =		ImageIO.read(loader.getResourceAsStream(path+"left/faces/puff.png"));
		images[CRYING][LEFT][adultIndex] =		ImageIO.read(loader.getResourceAsStream(path+"left/faces/crying.png"));
		images[EXCITING][LEFT][adultIndex] =	ImageIO.read(loader.getResourceAsStream(path+"left/faces/exciting.png"));
		images[REFRESHED][LEFT][adultIndex] =	ImageIO.read(loader.getResourceAsStream(path+"left/faces/refreshed.png"));
		images[DEAD][LEFT][adultIndex] =		ImageIO.read(loader.getResourceAsStream(path+"left/faces/dead.png"));
		images[RUDE][LEFT][adultIndex] =		ImageIO.read(loader.getResourceAsStream(path+"left/faces/rude.png"));
		// right face
		images[BODY][RIGHT][adultIndex] =		flipImage(images[BODY][LEFT][adultIndex]);
		images[LICK][RIGHT][adultIndex] =		flipImage(images[LICK][LEFT][adultIndex]);
		images[BRAID][RIGHT][adultIndex] =		flipImage(images[BRAID][LEFT][adultIndex]);
		images[ACCESSORY][RIGHT][adultIndex] =	flipImage(images[ACCESSORY][LEFT][adultIndex]);
		images[DAMAGED][RIGHT][adultIndex] =	flipImage(images[DAMAGED][LEFT][adultIndex]);
		images[PANTS][RIGHT][adultIndex] =		flipImage(images[PANTS][LEFT][adultIndex]);
		images[STAIN][RIGHT][adultIndex] =		flipImage(images[STAIN][LEFT][adultIndex]);
		images[SICK][RIGHT][adultIndex] =		flipImage(images[SICK][LEFT][adultIndex]);		
		images[NORMAL][RIGHT][adultIndex] =		flipImage(images[NORMAL][LEFT][adultIndex]);
		images[SLEEPING][RIGHT][adultIndex] =	flipImage(images[SLEEPING][LEFT][adultIndex]);
		images[CHEER][RIGHT][adultIndex] =		flipImage(images[CHEER][LEFT][adultIndex]);
		images[SMILE][RIGHT][adultIndex] =		flipImage(images[SMILE][LEFT][adultIndex]);
		images[TIRED][RIGHT][adultIndex] =		flipImage(images[TIRED][LEFT][adultIndex]);
		images[PUFF][RIGHT][adultIndex] =		flipImage(images[PUFF][LEFT][adultIndex]);
		images[CRYING][RIGHT][adultIndex] =		flipImage(images[CRYING][LEFT][adultIndex]);
		images[EXCITING][RIGHT][adultIndex] =	flipImage(images[EXCITING][LEFT][adultIndex]);
		images[REFRESHED][RIGHT][adultIndex] =	flipImage(images[REFRESHED][LEFT][adultIndex]);
		images[DEAD][RIGHT][adultIndex] =		flipImage(images[DEAD][LEFT][adultIndex]);
		images[RUDE][RIGHT][adultIndex] =		flipImage(images[RUDE][LEFT][adultIndex]);		
		// center
		images[CRUSHED][LEFT][adultIndex] =		ImageIO.read(loader.getResourceAsStream(path+"crushed.png"));			
		images[CRUSHED2][LEFT][adultIndex] =	ImageIO.read(loader.getResourceAsStream(path+"crushed2.png"));			
		images[SHIT][LEFT][adultIndex] =		ImageIO.read(loader.getResourceAsStream(path+"shit.png"));
		images[ROLL_ACCESSORY][LEFT][adultIndex] =		ImageIO.read(loader.getResourceAsStream(path+"ribbon.png"));
		images[ROLL_SHIT][LEFT][adultIndex] =	ImageIO.read(loader.getResourceAsStream(path+"roll_left.png"));
		images[ROLL_SHIT][RIGHT][adultIndex] =	ImageIO.read(loader.getResourceAsStream(path+"roll_right.png"));
		images[PANTS2][LEFT][adultIndex] =		ImageIO.read(loader.getResourceAsStream(path+"pants.png"));
		images[PANTS2_ROLL][LEFT][adultIndex] = ImageIO.read(loader.getResourceAsStream(path+"left_pants.png"));
		images[PANTS2_ROLL][RIGHT][adultIndex] = ImageIO.read(loader.getResourceAsStream(path+"right_pants.png"));

		for(Image[][] array2d : images) {	
			for(Image[] array : array2d) {
				if(array[adultIndex] == null) {
					continue;
				}
				// Scale larger images down
				array[adultIndex] = array[adultIndex].getScaledInstance(adultSize, adultSize, Image.SCALE_AREA_AVERAGING);
				array[childIndex] = array[adultIndex].getScaledInstance(childSize, childSize, Image.SCALE_AREA_AVERAGING);
				array[babyIndex] =  array[adultIndex].getScaledInstance(babySize, babySize, Image.SCALE_AREA_AVERAGING);
			}
		}
	}

	public Image getImage(int type, int direction) {
		return images[type][direction][ageState.ordinal()];
	}

	@Override
	public int getType() {
		return type;
	}

	@Override
	public int getHybridType(int partnerType) {
		switch (partnerType) {
		case Marisa.type:
			return MarisaReimu.type;
		default:
			return Reimu.type;
		}
	}

	@Override
	public String getNameJ() {
		return nameJ;
	}

	@Override
	public String getNameE() {
		return nameE;
	}

	@Override
	protected String msgWantFoodJ () {
		if (!isRudeMessage()) {
			String[] output = {"ごはんしゃんのにおいがすりゅよ", "ごはんしゃんのにおいがすりゅよ", "ごはんさんのにおいがするよ"};
			return output[ageState.ordinal()];
		}
		else {
			String[] output = {"りぇいみゅのごはんしゃん！", "りぇいむのごはんしゃんのにおいがしゅりゅよ！", "れいむのごはんさんのにおいがするよ！"};
			return output[ageState.ordinal()];			
		}
	}

	@Override
	protected String msgWantFoodE () {
		if (!isRudeMessage()) {
			String[] output = {"The shmell of mishder food!", "Shmell of mishder food!", "It's the smell of mister food!"};
			return output[ageState.ordinal()];
		}
		else {
			String[] output = {"Weimu's mishder food!", "Shmell of Weimu's mishder food!", "It's the smell of Reimu's mister food!"};
			return output[ageState.ordinal()];			
		}
	}

	@Override
	protected String msgNoFoodJ()
	{
		if (!isRudeMessage()) {
			String[][] output = {{"ごはんしゃんにゃいよ！", "ごはんしゃんにゃいよ？", "ごはんさんないよ？"},
					{"ごはんしゃんくだちゃい、、、", "ごはんしゃんくだちゃい、、、", "ごはんざんぐだざいぃ、、、"}};
			return output[damageState.ordinal()][ageState.ordinal()];
		}
		else {
			String[][] output = {{"ごはんしゃんにゃいよ！", "ごはんしゃんにゃいよ？ばきゃなの？しにゅの？", "ごはんさんないよ？ばかなの？しぬの？"},
					{"ごはんしゃんくだちゃい、、、", "ごはんしゃんくだちゃい、、、", "ごはんざんぐだざいぃ、、、"}};
			return output[damageState.ordinal()][ageState.ordinal()];			
		}
	}

	@Override
	protected String msgNoFoodE()
	{
		if (!isRudeMessage()) {
			String[][] output = {{"Mishder food ish nod here!", "Mishder food ish nod here?", "Mister food is not here?"},
					{"Gib me mishder food...", "Gib me mishder food...", "Please give me mister food..."}};
			return output[damageState.ordinal()][ageState.ordinal()];
		}
		else {
			String[][] output = {{"Mishder food ish nod here!", "Mishder food ish nod here! Are you shtoopid?  Wand choo die?", "Mister food is not here?  Are you stupid? Want to die?"},
					{"Gib me mishder food...", "Gib me mishder food...", "Pwease give me misder food..."}};
			return output[damageState.ordinal()][ageState.ordinal()];			
		}
	}

	@Override
	protected String msgExciteJ() { return "すっぎりじだいの〜！"; }

	@Override
	protected String msgExciteE() { return "Want to refresh~!"; }

	@Override
	protected String msgRelaxJ()
	{
		Random rnd = new Random();
		if (!isRudeMessage()) {
			if (rnd.nextInt(2) == 0) {
				String output[] = {"ゆっきゅりしていっちぇね！", "ゆっきゅりしていっちぇね！", "ゆっくりしていってね！"};
				return output[ageState.ordinal()];
			}
			else {
				String output[] = {"ゆっゆ～♪ゆっゆ～♪", "ゆっくりにょひ～♪まったりにょひ～♪", "ゆっくりのひ～♪まったりのひ～♪すっきりのひ～♪"};
				return output[ageState.ordinal()];		
			}
		}
		else {
			String output[] = {"くしょどれいはゆっきゅりちね！", "くしょどれいはあみゃあみゃもってきょい！", "ここをれいむのゆっくりぷれいすにするよ！"};
			return output[ageState.ordinal()];
		}
	}

	@Override
	protected String msgRelaxE()
	{
		Random rnd = new Random();
		if (!isRudeMessage()) {
			if (rnd.nextInt(2) == 0) {
				String output[] = {"Chake id eajy!", "Chake id eajy!", "Take it easy!"};
				return output[ageState.ordinal()];
			}
			else {
				String output[] = {"Yu~♪Yu~♪", "Eajy~jay~♪Relaxing~jay~♪", "Easy~Day~♪Relaxing~Days~♪Refresh~Days~♪"};
				return output[ageState.ordinal()];		
			}
		}
		else {
			String output[] = {"Shitty slave go die easy!", "Shitty slave bwing shweet-shweets!", "This will be Marisa's easy place!"};
			return output[ageState.ordinal()];
		}
	}

	@Override
	protected String msgFuriFuriJ()
	{
		if (!isRudeMessage()) {
			String output[] = {"ふーりふーり", "れいみゅかわいきゅてごみぇんね！", "れいむかわいくてごめんね！"};
			return output[ageState.ordinal()];
		}
		else {
			String output[] = {"ふーりふーり", "れいみゅのあにゃるでしこってもいいよ！", "れいむのあにゃるでしこってもいいよ！"};
			return output[ageState.ordinal()];
		}
	}

	@Override
	protected String msgFuriFuriE()
	{
		if (!isRudeMessage()) {
			String output[] = {"Relax~relax~", "Weimu ish showwy for being sho cude!", "Reim is sorry for being so cute!"};
			return output[ageState.ordinal()];
		}
		else {
			String output[] = {"Relax~relax~", "You can use Weimu's anyaru to mashterbate!", "You can use Reimu's anyaru to masturbate!"};
			return output[ageState.ordinal()];
		}
	}

	protected String msgWakeupJ()
	{
		String output[] = {"ゆっきゅりしていっちぇね！", "ゆっきゅりしていっちぇね！", "ゆっくりしていってね！"};
		return output[ageState.ordinal()];
	}

	protected String msgWakeupE()
	{
		String output[] = {"Chake id eajy!", "Chake id eajy!", "Take it easy!"};
		return output[ageState.ordinal()];
	}

	@Override
	protected String msgSleepJ() { return "すーやすーや"; }

	@Override
	protected String msgSleepE() { return "Sleep-Sleep---"; }

	@Override
	protected String msgScreamJ() {
		if (!isRudeMessage()) {
			String[][] output = {{"ゆんやー！", "ゆんやー！やめちぇにぇ？やめちぇにぇ？", "いたい！やめてね？やめてね？"},
					{"ゆ、ゆ、ゆ、、、", "やめちぇね、、、", "やめてくださいぃ、、、"}};
			return output[damageState.ordinal()][ageState.ordinal()];
		}
		else {
			String[][] output = {{"ゆんやー！", "ゆんやー！にゃにすりゅの？ぷきゅーじゃよ！", "いだいぃ！やめろくそどれい！ぷくーだよ！"},
					{"ゆ、ゆ、ゆ、、、", "ごみぇんなさいりぇいみゅがわりゅかったでしゅ", "れいむがわるかったです、ごめんなさい、やめてくださいぃ"}};
			return output[damageState.ordinal()][ageState.ordinal()];			
		}
	}

	@Override
	protected String msgScreamE() {
		if (!isRudeMessage()) {
			String[][] output = {{"YUNYA-!!", "YUNYA-! Shdop id! Shdop id!", "It hurts! Please stop it! Stop it!"},
					{"Yu,Yu,Yu...", "Shdop id...", "Please stop it..."}};
			return output[damageState.ordinal()][ageState.ordinal()];
		}
		else {
			String[][] output = {{"YUNYA-!!", "YUNYA-!! What are you doing? Going choo pyuff-pyuff!", "It hurts! Stop it shitty slave! Puff!!"},
					{"Yu,Yu,Yu...", "Weimu ish showwy sho pwease shdop id...", "Reimu is sorry, so please stop it..."}};
			return output[damageState.ordinal()][ageState.ordinal()];			
		}
	}

	@Override
	protected String msgScareJ () {
		String[][] output = {{"ゆんやー！", "ゆっくちできにゃいー！", "なんだかゆっくりできないよ！"},
				{"ゆ、ゆ、ゆ、、、", "ごめんなちゃいやめちぇにぇ、、、", "どぼじででいぶにこんなごどずるのぉ、、、"}};
		return output[damageState.ordinal()][ageState.ordinal()];
	}

	@Override
	protected String msgScareE () {
		String[][] output = {{"YUNYA-!!", "I can'ch chake id eajy!", "I feel like I can't take it easy!"},
				{"Yu,Yu,Yu...", "Weimu ish showwy sho pwease shdop id...", "Why would you do thisss...."}};
		return output[damageState.ordinal()][ageState.ordinal()];
	}

	@Override
	protected String msgAlarmJ () {
		if (!isRudeMessage()) {
			String[][] output = {{"ゆー！", "にゃんだかゆっくちできにゃい！", "なんだかゆっくりできないよ！"},
					{"ゆ、ゆ、ゆ、、、", "ごめんなちゃいやめちぇにぇ、、、", "やめてください、、、"}};
			return output[damageState.ordinal()][ageState.ordinal()];
		}
		else {
			String[][] output = {{"ゆー！", "ゆっくちできにゃい！やめりょくしょどれい！", "なんだかゆっくりできないよ！すぐにやめてね！"},
					{"ゆ、ゆ、ゆ、、、", "ごめんなちゃい、、、", "れいむがわるかったですぅ、やめてくださいぃ、、、"}};
			return output[damageState.ordinal()][ageState.ordinal()];			
		}
	}

	@Override
	protected String msgAlarmE () {
		if (!isRudeMessage()) {
			String[][] output = {{"Yu-!!", "I can'ch chake id eajy!", "I feel like I can't take it easy!"},
					{"Yu,Yu,Yu...", "Weimu ish showwy sho pwease shdop id...", "Please stop it..."}};
			return output[damageState.ordinal()][ageState.ordinal()];
		}
		else {
			String[][] output = {{"Yu-!!", "I can'ch chake id eajy! Shdop id shitty slave!", "I feel like I can't take it easy! Stop it quickly!"},
					{"Yu,Yu,Yu...", "Weimu ish showwy...", "Reimu is sorry, so please stop it!"}};
			return output[damageState.ordinal()][ageState.ordinal()];			
		}
	}

	@Override
	protected String msgDyingJ () {
		String[] output = {"ゆべっ！", "ぷきゅっ！", "げぼっ！"};
		return output[ageState.ordinal()];
	}

	@Override
	protected String msgDyingE () {
		String[] output = {"Yubee!!", "Puff!", "Blarg!"};
		return output[ageState.ordinal()];
	}

	@Override
	protected String msgDeadJ () {
		String[] output = {"もっちょゆっくち、、、", "もっちょゆっくちしちゃかった、、、", "もっとゆっくりしたかった、、、"};
		return output[ageState.ordinal()];
	}

	@Override
	protected String msgDeadE () {
		String[] output = {"Wanted choo chake id eajy more...", "Wanted choo chake id eajy more...", "Wanted to take it easy more..."};
		return output[ageState.ordinal()];
	}

	@Override
	protected String msgEatingJ () {
		if (!isRudeMessage()) {
			String[][] output = {{"ゆ～ゆ～ゆ～、ちあわちぇー", "むーちゃむーちゃ、ちあわちぇー", "むーしゃむーしゃ、しあわせー"},	
					{"ゆ！ゆ！ゆ！", "むちゃむちゃ、ちあわちぇー！！！", "むっしゃむっしゃ、しあわせー！！！"}};
			return output[hungryState.ordinal()][ageState.ordinal()];
		}
		else {
			String[][] output = {{"む〜ちゃむ〜ちゃ、しょれにゃりー", "むーちゃむーちゃ、しょりぇにゃりー", "むーしゃむーしゃ、それなりー"},	
					{"ゆ！ゆ！ゆ！", "むちゃむちゃ、はふはふ", "むっしゃむっしゃ、うめぇ"}};
			return output[hungryState.ordinal()][ageState.ordinal()];	    
		}
	}

	@Override
	protected String msgEatingE () {
		if (!isRudeMessage()) {
			String[][] output = {{"Yu~Yu~Yu~, happinesh~", "Myunch~ Myunch~ Happinesh~", "Munch munch, Happiness"},	
					{"Yu!Yu!Yu!", "Myunch Myunch, nom nom", "Munch munch, so good!"}};
			return output[hungryState.ordinal()][ageState.ordinal()];
		}
		else {
			String[][] output = {{"Myunch-Myunch, can'ch chake id eajy...", "Myunch-Myunch, can'ch chake id eajy...", "Munch munch, can't take it easy~"},	
					{"Yu!Yu!Yu!", "Myunch Myunch, nom nom", "Munch munch, so good!"}};
			return output[hungryState.ordinal()][ageState.ordinal()];	    
		}
	}

	@Override
	protected String msgEatingShitJ () {
		String[] output = {"む〜ちゃむ〜ちゃ、げりょまじゅ、、、", "むーちゃむーちゃ、げろまじゅ、、、", "むーしゃむーしゃ、げろまず、、、"};
		return output[ageState.ordinal()];
	}

	@Override
	protected String msgEatingShitE () {
		String[] output = {"Myunch-Myunch, disgusting,,,", "Myunch~ Myunch~ disgusting,,,", "Munch munch, disgusting,,,"};
		return output[ageState.ordinal()];
	}
	
	@Override
	protected String msgEatingBitterJ () {
		String[] output = {"む〜ちゃむ〜ちゃ、こりぇどきゅはいっちぇりゅ！", "むーちゃむーちゃ、こりぇどきゅはいっちぇりゅ！", "むーしゃむーしゃ、これどくはいってる！"};
		return output[ageState.ordinal()];
	}

	@Override
	protected String msgEatingBitterE () {
		String[] output = {"Myunch-Myunch, this is poison!", "Myunch~ Myunch~ this is poison!", "Munch munch, this is poison!"};
		return output[ageState.ordinal()];
	}

	@Override
	protected String msgFullJ () {
		String[] output = {"おにゃかいっぱい、、、", "おにゃかいっぱい、、、", "もうたべられないの、、、"};
		return output[ageState.ordinal()];
	}

	@Override
	protected String msgFullE () {
		String[] output = {"Tummy ish full...", "Tummy ish full...", "Can't eat anymore..."};
		return output[ageState.ordinal()];
	}

	@Override
	protected String msgHealingJ () {
		if (!isRudeMessage()) {
			String[][] output = {{"あみゃあみゃ！", "あまあまおいしい！", "あまあまおいしいね！"},
					{"あみゃあみゃ！", "りぇいみゅはふっかつしちゃよ！", "れいむはふっかつしたよ！"}};
			return output[damageState.ordinal()][ageState.ordinal()];
		}
		else {
			String[][] output = {{"あみゅあみゃ！", "りぇいみゅにあまあまもっとちょうだいにぇ！", "れいむにあまあまもっとちょうだいね！"},
					{"あみゃあみゃ！", "りぇいみゅはかれいにふっかつしちゃよ！", "れいむはかれいにふっかつしたよ！"}};
			return output[damageState.ordinal()][ageState.ordinal()];
		}
	}

	@Override
	protected String msgHealingE () {
		if (!isRudeMessage()) {
			String[][] output = {{"Shweet-shweet!", "Shweet-shweet! tasht good!", "Sweet-sweet! Taste good!"},
					{"Shweet-shweet!", "Weimu ish coming back!", "Reimu is coming back!"}};
			return output[damageState.ordinal()][ageState.ordinal()];
		}
		else {
			String[][] output = {{"Shweet-shweet!", "Gib Weimu shweet-shweet more!", "Give Reimu sweet-sweet more!"},
					{"Shweet-shweet!", "Weimu ish coming back gorgeously!", "Reimu is coming back gorgeously!"}};
			return output[damageState.ordinal()][ageState.ordinal()];
		}
	}

	@Override
	protected String msgSukkiriJ () {
		String[] output = {"ちゅっきち！", "ちゅっきり！", "すっきり！"};
		return output[ageState.ordinal()];
	}

	@Override
	protected String msgSukkiriE () {
		String[] output = {"Wefweshed!", "Wefeshed!", "Refreshed!"};
		return output[ageState.ordinal()];
	}

	@Override
	protected String msgBirthJ () { return "ゆっくちちていっちぇね！"; }

	@Override
	protected String msgBirthE () { return "Chake id eajy!"; }

	@Override
	protected String msgShitJ () {
		if (!hasPants) {
			if (!isRudeMessage()) {
				String[] output = {"うんうんぢぇりゅ！", "りぇいみゅのすーぴゃーうんうんちゃいみゅはじみゃるよ！", "れいむのすーぱーうんうんたいむはじまるよ！"};
				return output[ageState.ordinal()];
			}
			else {
				String[] output = {"うんうんぢぇりゅ！", "くしょどれいはりぇいみゅのうんうんたべてもいいよ！", "くそどれいはれいむのうんうんたべてもいいよ！"};
				return output[ageState.ordinal()];	    
			}
		}
		else {
			String[] output = {"うんうんぢぇりゅ！", "うんうんしゃんもれりゅぅ！", "うんうんさんもれるぅ！"};
			return output[ageState.ordinal()];
		}
	}

	@Override
	protected String msgShitE () {
		if (!hasPants) {
			if (!isRudeMessage()) {
				String[] output = {"Poo-pooing!", "Weimu's shuupa poo-poo time ish shtarting!", "Reimu's super poo-poo time is starting!"};
				return output[ageState.ordinal()];
			}
			else {
				String[] output = {"Poo-pooing!", "Shitty shlave can eat Weimu's poo-poo!", "Shitty slave can eat Reimu's poo-poo!"};
				return output[ageState.ordinal()];	    				
			}
		}
		else {
			String[] output = {"Poo-poo Weimyu's pants!", "Poo-poo Weimu's pants!", "Leaking mister poo-poo!"};
			return output[ageState.ordinal()];
		}
	}

	@Override
	protected String msgShit2J () {
		if (!hasPants) {
			String[] output = {"すっきち！", "すっきちー！", "すっきりー！"};
			return output[ageState.ordinal()];
		}
		else {
			String[] output = {"ゆんやー！", "ゆんやー！", "えぐっえぐっ、、、"};
			return output[ageState.ordinal()];			
		}
	}

	@Override
	protected String msgShit2E () {
		if (!hasPants) {
			String[] output = {"Wefeshed!", "Wefeshed-!!", "Refreshed~!"};
			return output[ageState.ordinal()];
		}
		else {
			String[] output = {"Yun ya-!", "Yun ya-!", "Yuuu,,,"};
			return output[ageState.ordinal()];
		}
	}
	
	@Override
	protected String msgSuriSuriJ () {
		String[] output = {"ちゅりちゅり", "ちゅーりちゅーり", "すーりすーり"};
		return output[ageState.ordinal()];
	}

	@Override
	protected String msgSuriSuriE () {
		String[] output = {"Wub-wub", "Wub-wub", "Rub-rub"};
		return output[ageState.ordinal()];
	}

	@Override
	protected String msgPeroPeroJ () {
		String[] output = {"ぺりょぺりょ", "ぺーりょぺーりょ", "ぺーろぺーろ"};
		return output[ageState.ordinal()];
	}

	@Override
	protected String msgPeroPeroE () {
		String[] output = {"Wick-wick~", "Wick-wick~", "Lick-lick~"};
		return output[ageState.ordinal()];
	}

	@Override
	protected String msgBreedJ() {
		return "う、うばれる、、、";
	}

	@Override
	protected String msgBreedE() {
		return "B...Being born...";
	}

	@Override
	protected String msgBreed2J() {
		if (!hasPants) {
			return "ゆっくりしていってね！";
		}
		else {
			return "れいむのおちびちゃんがあぁ！";
		}
	}

	@Override
	protected String msgBreed2E() {
		if (!hasPants) {
			return "Take it easy!";
		}
		else {
			return "Reimu's little one!";
		}
	}

	@Override
	protected String msgHateShitJ () {
		if (!isRudeMessage()) {
			String[][] output = {{"くちゃい〜！", "うんうんかたじゅけてにぇ！", "うんうんかたづけてね！"},
					{"くちゃい、、、", "くちゃいよ、ゆっきゅりできにゃい、、、", "くさいよ、ゆっくりできないよ、、、"}};
			return output[damageState.ordinal()][ageState.ordinal()];
		}
		else {
			String[][] output = {{"くちゃい～！", "くちゃい～！しゅぎゅにかたじゅきぇりょ！", "うんうんかたづけてね！すぐでいいよ！"},
					{"くちゃい、、、", "くちゃいよ、ゆっきゅりできにゃい、、、", "くさいよ、ゆっくりできないよ、、、"}};
			return output[damageState.ordinal()][ageState.ordinal()];			
		}
	}

	@Override
	protected String msgHateShitE () {
		if (!isRudeMessage()) {
			String[][] output = {{"Shmelly~!", "Clean up poo-poo!", "Clean up mister poo-poo!"},
					{"Shmelly...", "Shmelly, can'ch chake id eajy...", "Smelly... can't take it easy..."}};
			return output[damageState.ordinal()][ageState.ordinal()];
		}
		else {
			String[][] output = {{"Shmelly~!", "Shmelly~! Clean up poo-poo quickly!", "Clean up Poo-poo quickly!"},
					{"Shmelly...", "Shmelly, can'ch chake id eajy...", "Smelly... can't take it easy..."}};
			return output[damageState.ordinal()][ageState.ordinal()];			
		}
	}

	@Override
	protected String msgHungryJ () {
		if (!isRudeMessage()) {
			String[][] output = {{"ごはんしゃんちょうじゃい！", "ごはんしゃんをれいみゅにちょうじゃいね！", "ごはんさんをれいむにちょうだいね！"},
					{"ゆ～、ごはんしゃん、、、", "おにゃきゃへっちゃよ、、、", "れいむにごはんぐだざいぃ"}};
			return output[damageState.ordinal()][ageState.ordinal()];
		}
		else {
			String[][] output = {{"あみゃあみゃもってきょい！", "りぇいみゅのあまあましゅぎゅにもってきょい！", "れいむのあままをすぐにもってきてね！たくさんでいいよ！"},
					{"ゆ～、ごはんしゃん、、、", "おにゃきゃへっちゃよ、、、", "でいぶにごはんぐだざいぃ"}};
			return output[damageState.ordinal()][ageState.ordinal()];			
		}
	}

	@Override
	protected String msgHungryE () {
		if (!isRudeMessage()) {
			String[][] output = {{"Gib me shweet-shweet!", "Bwing mishder munch-munch choo Weimu!", "Bring mister munch-munch to Reimu!"},
					{"Yu... mishder food...", "Misder tummy ish hungwy...", "Pwease give Reimu some food..."}};
			return output[damageState.ordinal()][ageState.ordinal()];
		}
		else {
			String[][] output = {{"Bwing shweet-shweet!", "Bwing Weimu's shweet-shweet quickly!", "Bring Reimu's sweet-sweet! A lot is fine!"},
					{"Where ish mishder food?", "Misder tummy ish hungwy...", "Pwease give Deibu some food..."}};
			return output[damageState.ordinal()][ageState.ordinal()];			
		}
	}

	@Override
	protected String msgNoAccessoryJ () {
		String[] output = {"ゆぇーん！かえちてね？かえちてね？", "ゆぇーん！りぇいみゅのきゃわいいおりぼんしゃんかえちてね？", "れいむのすてきなおりぼんさんどこにいったの？"};
		return output[ageState.ordinal()];
	}

	@Override
	protected String msgNoAccessoryE () {
		String[] output = {"Yunn~!  Where ish misder Wibbon?", "Yunn~!  Where ish Weimu's cude-cude misder Wibbon?", "Where's Reimu's mister ribbon?"};
		return output[ageState.ordinal()];
	}

	@Override
	protected String msgHateYukkuriJ () {
		if (!isRudeMessage()) {
			String[] output = {"ゆっくちできにゃいゆっくちがいりゅよ", "ゆっくちできにゃいゆっくちがいりゅよ", "ゆっくりできないゆっくりがいるよ！"};
			return output[ageState.ordinal()];
		}
		else {
			String[] output = {"ゆっくちできにゃいゆっくちがいりゅよ", "ゆふふ、ゆっくちできにゃいゆっくちがいりゅよ", "ゆふふ、ゆっくりできないゆっくりがいるよ！せいっさいするよ！"};
			return output[ageState.ordinal()];
		}
	}

	@Override
	protected String msgHateYukkuriE () {
		if (!isRudeMessage()) {
			String[] output = {"There'sh a yukkuri that can'ch chake id eajy", "There'sh a yukkuri that can'ch chake id eajy", "A yukkuri that can't take it easy!"};
			return output[ageState.ordinal()];
		}
		else {
			String[] output = {"There'sh a yukkuri that can'ch chake id eajy", "Yu-hum, there'sh a yukkuri that can'ch chake id eajy", "Yu-hum, a yukkuri that can't take it easy!  Punishment time!"};
			return output[ageState.ordinal()];
		}
	}

	@Override
	protected String msgFlyingJ () {
		String[] output = {"おちょらをとんでりゅみちゃい！", "りぇいむはおしょらをとぶとりさん！", "おそらをとんでるみたい！"};
		return output[ageState.ordinal()];
	}

	@Override
	protected String msgFlyingE () {
		String[] output = {"Ich feewsh wike fwying!", "Weimu ish mishter flying bird!", "I feel like I'm flying!"};
		return output[ageState.ordinal()];
	}

	@Override
	protected String msgSadnessForChildJ() {
		return "おちびちゃんすきとおったきれいなおめめをあけてー！";
	}

	@Override
	protected String msgSadnessForChildE() {
		return "Open your beautiful clear eyes, my little one!";
	}

	@Override
	protected String msgSadnessForPartnerJ (Body partner) {
		return partner.getNameJ()+"めをあけてー！";
	}

	@Override
	protected String msgSadnessForPartnerE (Body partner) {
		return "Open your eyes, "+partner.getNameE()+"!";
	}
	
	@Override
	protected String msgSadnessForSisterJ (Body partner) {
		if (isAdult()) {
			return partner.getNameJ()+"めをあけてー!";
		}
		else if (age < partner.age) {
			return "おねぇしゃんめをあけてー！";
		}
		else {
			return "いもうちょめをあけてー！";
		}
	}

	@Override
	protected String msgSadnessForSisterE (Body partner) {
		if (isAdult()) {
			return "Open your eyes, "+partner.getNameE()+"!";
		}
		else if (age < partner.age) {
			return "Open your eyes, my elder sister!";
		}
		else {
			return "Open your eyes, my sister!";
		}
	}

	@Override
	protected String msgBlockedByWallJ () {
		if (!isRudeMessage()) {
			String[] output = {"りぇいみゅしゅしゅめにゃいにょぉぉぉ！？", "にゃんでかべしゃんじゃましゅりゅにょぉぉぉ！？", "なんでかべさんじゃまするのおぉぉぉ！？"};
			return output[ageState.ordinal()];
		}
		else {
			String[] output = {"くちょかびぇはちね！！", "くちょかべはちね！！ぷきゅーじゃよ！！", "じゃまなかべさんはどいてね！すぐでいいよ！"};
			return output[ageState.ordinal()];
		}
	}
	
	@Override
	protected String msgBlockedByWallE () {
		if (!isRudeMessage()) {
			String[] output = {"Weimu can'ch go forward!?", "Why would mishter Wall block me!?", "Why would mister Wall block me!?"};
			return output[ageState.ordinal()];
		}
		else {
			String[] output = {"Die shitty wall!", "Die shitty Wall! Puff!", "Mister Wall is in my way! Move! Quickly is fine!"};
			return output[ageState.ordinal()];
		}
	}

	// public methods
	public Reimu(int initX, int initY, int initZ, Body.AgeState initAgeState, Body p1, Body p2) {
		super(initX, initY, initZ, initAgeState, p1, p2);
	}
	
	public void tuneParameters() {
		if (rnd.nextBoolean()) {
			motherhood = true;
		}
		double factor = Math.random()*2+1;
		HUNGRYLIMIT[AgeState.ADULT.ordinal()] *= factor;
		HUNGRYLIMIT[AgeState.CHILD.ordinal()] *= factor;
		HUNGRYLIMIT[AgeState.BABY.ordinal()] *= factor;
		factor = Math.random()*2+1;
		SHITLIMIT[AgeState.ADULT.ordinal()] *= factor;
		SHITLIMIT[AgeState.CHILD.ordinal()] *= factor;
		SHITLIMIT[AgeState.BABY.ordinal()] *= factor;
		factor = Math.random()+0.5;
		DAMAGELIMIT[AgeState.ADULT.ordinal()] *= factor;
		DAMAGELIMIT[AgeState.CHILD.ordinal()] *= factor;
		DAMAGELIMIT[AgeState.BABY.ordinal()] *= factor;
		factor = Math.random()+0.5;
		BABYLIMIT *= factor;
		CHILDLIMIT *= factor;
		LIFELIMIT *= factor;
		factor = Math.random()+1;
		RELAXPERIOD *= factor;
		EXCITEPERIOD *= factor;
		PREGPERIOD *= factor;
		SLEEPPERIOD *= factor;
		ACTIVEPERIOD *= factor;
		sameDest = rnd.nextInt(20)+20;
		DECLINEPERIOD *= (Math.random()+0.5);
		DISCIPLINELIMIT *= (Math.random()+1);
		ROBUSTNESS = rnd.nextInt(5)+2;
		//EYESIGHT /= 4;
		factor = Math.random()+0.5;
		STRENGTH[AgeState.ADULT.ordinal()] *= factor;
		STRENGTH[AgeState.CHILD.ordinal()] *= factor;
		STRENGTH[AgeState.BABY.ordinal()] *= factor;
	}
}