import java.awt.Image;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

import javax.imageio.ImageIO;

public class MachinePress extends ObjEX implements java.io.Serializable {
	static final long serialVersionUID = 1L;

	public static List<ObjEX> objEXList = new ArrayList<ObjEX>();

	public int type = 0;
	public static final int hitCheckObjType = 3;
	public static final int size = 256;
	private static final int images_num = 8; //このクラスの総使用画像数
	private static final int anime_pattern = 1; //このクラスのアニメーション数
	private static int AnimeImagesNum[] = {8};//アニメごとに何枚使うか
	private static Image[] images = new Image[images_num];

	private static final int value = 30000;
	private static final int cost = 100;

	public static void loadImages (ClassLoader loader) throws IOException {
		final String path = "images/machinepress/";
		for( int i = 0; i < images_num ; i++ ){
			images[i] = ImageIO.read(loader.getResourceAsStream(path+"machinepress"+String.format("%03d",i+1)+".png"));		
			images[i] = images[i].getScaledInstance(size*8/8, size*4/4, Image.SCALE_AREA_AVERAGING);
		}
	}
	
	public Image getImage() {
			return images[(int)age/2%AnimeImagesNum[0]];
	}
	
	public int getSize() {
		return size;
	}

	@Override
	public int checkHitObj( Obj o ) {
		int objX = o.getX();
		int objY = o.getY();
		int objZ = o.getZ();
		int platformSize = getSize()/2;
		int platformX = getX();
		int platformY = getY();
		int platformZ = getZ();
		int offsetX = (Body.MAXSIZE - getSize())*7/32-28;
		int offsetY = (Body.MAXSIZE - getSize())*6/16-40;
			if ( objZ == 0 ){	//空中の物は移動させない
				if ((platformX + offsetX+15)<=(objX) && (objX)<=(platformX + offsetX + platformSize-25)){	//X軸比較
					if ((platformY + offsetY+50)<=(objY) && (objY)<=(platformY + offsetY + platformSize-25)){	//Y軸比較
						objHitProcess( o );
						return 1;
					}
				}
			}
		return 0;
	}

	public int objHitProcess( Obj o ) {
		if ( o.objType == Obj.Type.YUKKURI && (int)age/2%AnimeImagesNum[0] == 0) {
			Body p = (Body)o;
			p.strikeByPress();
		}
		return 0;
	}

	@Override
	public void upDate() {
		if ( age % 150 == 0 ){
			Cash.addCash(-getCost()/4);
		}
	}

	@Override
	public int getValue() {
		return value;
	}

	@Override
	public int getCost() {
		return cost;
	}
	
	@Override
	public void removeListData(){
		objEXList.remove(this);
	}
	
	public MachinePress(int initX, int initY, Direction initDir) {
		super(initX, initY, initDir);
		objEXList.add(this);
		objType = Type.FIX_OBJECT;
	}
}