<?php
/*
 * system/tools/notify/mailbody/Form.class.php
 * 
 * CopyRight(C) 2010 Shopformer Development Team. All Right Reserved
 * URL: http://sourceforge.jp/projects/shopformer/
 * 
 * 
 * Mail: m_nakashima@users.sourceforge.jp
 * Auther: Masanori Nakashima
 * Last Update: 2010-06-18
 */
require_once( dirname(dirname(dirname(dirname(__FILE__))))
	.DIRECTORY_SEPARATOR.'login'
	.DIRECTORY_SEPARATOR.'ModuleBase.class.php');
require_once( dirname(dirname(dirname(dirname(__FILE__))))
	.DIRECTORY_SEPARATOR.'define.inc.php');
require_once( dirname(dirname(dirname(dirname(__FILE__))))
	.DIRECTORY_SEPARATOR.'DataFileWriter.class.php');
/**
 * パスワードリマインダ文章変更モジュール
 * 
 * @package system
 * @subpackage tools
 * @category module
 * @version 1.2.00
 * @copyright Copyright(c)2011, Shopformer Development Team. <shopformer-dev@lists.sourceforge.jp>
 * @author Masanori Nakashima
 * @access public
 */
class system_tools_notify_mailbody_Form extends system_login_ModuleBase {
	
	function system_tools_notify_mailbody_Form(){
	}
	function execute( & $request ) {
		
		$agent					= trim(stripslashes( $_GET['agent'] ));	
		if( 'mobile' != $agent ) {
			$agent	= 'default';
		}
		$command				= trim(stripslashes( $_GET['cmd'] ));
		$sessionObjectName		= 'system.tools.notify.mailbody.modify.object.'.$agent;
		$sessionConfirmName		= 'system.tools.notify.mailbody.modify.confirm.'.$agent;
		$mailHash				= $request->getSession($sessionObjectName);

		$fileName 				= 'mail.password.'.$agent.'.txt';
		$mailContents			= '';

		// 初期化コマンドなら
		if( preg_match( '/[iI][nN][iI][tT]/',$command ) > 0 ) {
			$filePath		= dirname(__FILE__).DIRECTORY_SEPARATOR.$fileName;
			$mailContents	= file_get_contents($filePath);
			$mailContents			= str_replace( "\r\n", "\n", $mailContents );
			$mailContents			= str_replace( "\r", "\n", $mailContents );
			$mailLines				= explode("\n",$mailContents);
			$mailHash['subject']	= array_shift($mailLines);
			$mailHash['body']		= implode("\n",$mailLines);
		} else {
			if( is_array($mailHash) ) {
				// セッションにあるならそのまま利用
			} else {
				$mailHash	= array();
				// セッションにないなら対象ブラウザ用の文章を読み込む
				$fileUri		= '/system/tools/notify/'.$fileName;
				if( system_DataFileWriter::isExists( $request, $fileUri ) ) {
					// dataフォルダ以下にファイルが存在するなら読み込み
					$mailContents	= system_DataFileWriter::getContents( $request, $fileUri );
				} else {
					// 保存ファイルがないなら初期値用テンプレートファイルを読み込み
					$filePath		= dirname(__FILE__).DIRECTORY_SEPARATOR.$fileName;
					$mailContents	= file_get_contents($filePath);
				}
				$mailContents			= str_replace( "\r\n", "\n", $mailContents );
				$mailContents			= str_replace( "\r", "\n", $mailContents );
				$mailLines				= explode("\n",$mailContents);
				$mailHash['subject']	= array_shift($mailLines);
				$mailHash['body']		= implode("\n",$mailLines);
			}
		}

		// 初期化コマンドならパラメータを除去してリダイレクト
		if( preg_match( '/[iI][nN][iI][tT]/',$command ) > 0 ) {
			$request->setSession($sessionObjectName, $mailHash);
			$uri	= substr( SPIDER_URI_REQUEST, 0, strpos(SPIDER_URI_REQUEST, '?' ) ).'?agent='.$agent;
			$request->redirectTo($uri);
		}
		
		$request->setAttribute('system.tools.notify.mailbody.agent', $agent);
		$request->setAttribute('system.tools.notify.mailbody.mail_hash', $mailHash);
	}
}
?>