<?php
/*
 * system/login/Logout.class.php
 * 
 * CopyRight(C) 2010 Shopformer Development Team. All Right Reserved
 * URL: http://sourceforge.jp/projects/shopformer/
 * 
 * 
 * Mail: m_nakashima@users.sourceforge.jp
 * Auther: Masanori Nakashima
 * Last Update: 2010-06-18
 */
require_once( dirname(__FILE__)
.DIRECTORY_SEPARATOR.'ModuleBase.class.php');
/**
 * ログウト用アクションモジュールクラス
 * 
 * 管理システムにログインする機能を提供します。
 * ログイン情報読み込みの処理は設定ファイルに指定されたsystem_admin_IFLoginインターフェースの
 * 実装に移譲します。設定ファイルにログイン情報読み込み処理が指定されていない場合、
 * システム管理者ログイン情報を利用してログイン処理を行います。
 * 
 * @package system
 * @subpackage login
 * @category module
 * @version 1.2.00
 * @copyright Copyright(c)2011, Shopformer Development Team. <shopformer-dev@lists.sourceforge.jp>
 * @author Masanori Nakashima
 * @access public
 */
class system_login_Logout extends system_login_ModuleBase {
	function system_login_Logout(){
	}
	function execute( & $request ) {
		$is_login	= $this->isLogin( $request );
		if( $is_login === true ) {
			// ログイン情報セッションを削除
			$request->removeSession( SYSTEM_SESSION_NAME_LOGIN_INFORMATION, SPIDER_SESSION_SCOPE_GLOBAL );
			$request->removeSession( SYSTEM_SESSION_NAME_LOGIN_CLASS_NAME, SPIDER_SESSION_SCOPE_GLOBAL );
			$isLogin	= false;
			$loginInfo	= null;
			$request->setAttribute('system.login.logininformation',$loginInfo);
			$request->setAttribute('system.login.is_login',$isLogin);
			$cartObject = null;
			$request->setAttribute('shopping.order.orderObject',$cartObject);
			$request->removeSession('shopping.order.orderObject');
			$_SESSION	= array();
			session_destroy();
			// ログアウト操作のたびにセッションIDを変更
			$request->renewSessionId();
		}
	}
}
?>