<?php
/*
 * framework-spider
 * spider/tags/PageTitle.class.php
 * 
 * CopyRight(C)Framework-Spider Developer Team. 2010. All Right Reserved. 
 * URL         : http://sourceforge.jp/projects/frameworkspider/
 * Mail        : frameworkspider-dev@lists.sourceforge.jp
 * Auther      : Masanori Nakashima
 * Modifier    : Masanori Nakashima
 * Last Updated: 2010.06.23
 * 
 */
require_once(dirname(__FILE__).DIRECTORY_SEPARATOR.'TagBase.class.php');
/**
 * HTML用変換タグ:ページタイトルタグ
 * 
 * {page-title:[ページタイトル文言]}で、モジュール実行に優先して
 * ページタイトルをpage_titleという属性名でrequestに登録します。
 * 
 * @package spider spiderのコアパッケージ
 * @version 1.2.00
 * @copyright Copyright &copy; 2008, <m_nakashima@users.sourceforge.jp> http://sourceforge.jp/projects/shopformer/
 * @author  m.nakashima <m_nakashima@users.sourceforge.jp>
 * @since PHP 4.3
 */
class spider_tags_PageTitle extends spider_tags_TagBase {

	/**
	 * コンストラクタ
	 */
	function spider_tags_PageTitle() {
		$this->priority	= 60;
	}
	/**
	 * コンバートメソッド
	 */
	function convert( &$result_strings, &$build_information ){
		$page_title	= '';
		// ページ名指定行を取得
		if( preg_match_all( '/\\{page\\-title\\:[^\\}]*?\\}/'
			, $result_strings
			, $output_array
			, PREG_PATTERN_ORDER ) > 0 ) {
			foreach ( $output_array as $output ) {
				foreach ( $output as $target ) {
					$page_title	= preg_replace( '/\\{page\\-title\\:/','', $target );
					$page_title	= preg_replace( '/\\}/','', $page_title );
					$result_strings = str_replace( "\n".$target."\n", "", $result_strings );
					$result_strings = str_replace( $target, "", $result_strings );
					$page_title	= trim($page_title);
				}
			}
		}
		// 前処理追加:ページタイトルを属性にセット
		$process_code	= '$page_title="'.str_replace("'","\\'",$page_title).'";'."\n";
		$process_code	.= '$request_object->setAttribute("page_title",$page_title );'."\n";
		if( !isset($build_information->processPreModuleHash)
			|| !is_array($build_information->processPreModuleHash) ){
			$build_information->processPreModuleHash	= array();
		}
		if( !isset($build_information->processPreModuleHash[$this->priority])
			|| !is_array($build_information->processPreModuleHash[$this->priority]) ){
			$build_information->processPreModuleHash[$this->priority]	= array();
		}
		array_push( $build_information->processPreModuleHash[$this->priority], $process_code );
	}
}
?>