<?php
/*
 * framework-spider
 * spider/tags/Module.class.php
 * 
 * CopyRight(C)Framework-Spider Developer Team. 2010. All Right Reserved. 
 * URL         : http://sourceforge.jp/projects/frameworkspider/
 * Mail        : frameworkspider-dev@lists.sourceforge.jp
 * Auther      : Masanori Nakashima
 * Modifier    : Masanori Nakashima
 * Last Updated: 2010.06.23
 * 
 */
require_once(dirname(__FILE__).DIRECTORY_SEPARATOR.'TagBase.class.php');
/**
 * HTML用変換タグ:インラインモジュールタグ
 * 
 * {imodule:[パッケージ名].[モジュール名]}によってテンプレート、ウィジェット、ページファイル内から
 * プログラムモジュールを呼び出す処理を追加するタグです。
 * 
 * テンプレート、ウィジェット、ページ内のどこで記述されても、
 * モジュール実行はページ内インラインに行われます。すなわちif分岐処理内で記述した場合に条件によって実行しないモジュール呼び出しを実現できます。
 * 
 * インラインモジュールタグは追加パラメータとして以下のパラメータをとることができます。
 * 
 * post([URLエンコードしたPOST文字列])
 *   モジュール実行時に、POST値があるなしに関わらず強制的にPOSTに代入してモジュールを
 *   実行することができます。
 *   POST値変更は呼び出しモジュールに対する一時的なものであり、
 *   他のモジュールを実行される場合には元のPOST値に復元されます。
 * 
 * get([URLエンコードしたGET文字列])
 *   モジュール実行時に、GET値があるなしに関わらず強制的にPOSTに代入してモジュールを
 *   実行することができます。
 *   GET値変更は呼び出しモジュールに対する一時的なものであり、
 *   他のモジュールを実行される場合には元のGET値に復元されます。
 * 
 * attribute_prefix([英数字のプレフィックス])
 *   実行モジュールで登録する属性名は通常[パッケージ名].[モジュール名].が付加されますが
 *   本オプションパラメータにて[プレフィックス].[パッケージ名].[モジュール名].として
 *   属性名を変更することができます。
 *   同じモジュールを複数の条件で呼び出して結果を表示する場合にpost()やget()と組み合わせ
 *   ることで有効な利用ができます。
 * 
 * force
 *   既に実行されたモジュールの場合でも強制的に再実行します
 * 
 * @package spider spiderのコアパッケージ
 * @version 1.2.00
 * @copyright Copyright &copy; 2008, <m_nakashima@users.sourceforge.jp> http://sourceforge.jp/projects/shopformer/
 * @author  m.nakashima <m_nakashima@users.sourceforge.jp>
 * @since PHP 4.3
 */
class spider_tags_ModuleInline extends spider_tags_TagBase {

	/**
	 * コンストラクタ
	 */
	function spider_tags_ModuleInline() {
		$this->priority	= 11;
		$this->tag_name	= 'imodule';
	}
	/**
	 * 個々のタグ文字列の変換後文字列を取得します
	 */
	function getConvertedStrings( &$resultStrings, &$buildInformation, $optionArray=array(), $valiableCounter=0 ) {
		// モジュール実行文字列に置換
		if( count($optionArray) > 0 ) {
			$execModule	= array_shift($optionArray);
			$attPrefix	= '';
			$getParms	= '';
			$postParams	= '';
			$force		= 'false';
			foreach( $optionArray as $optionStr ) {
				$optionStr	= trim($optionStr);
				if( preg_match('/^[aA]]tT][tT][rR][iI][bB][uU][tT][eE]\\_[pP][rR][eE][fF][iI][xX]\\([0-9a-zA-Z\\.]+\\)$/', $optionStr) > 0 ) {
					$optionStr	= preg_replace('/^[aA]]tT][tT][rR][iI][bB][uU][tT][eE]\\_[pP][rR][eE][fF][iI][xX]\\(/','',$optionStr);
					$attPrefix	= preg_replace('/\\)$/','',$optionStr);
				} else if( preg_match('/^[gG][eE][tT]\\([^\\)]+\\)$/', $optionStr) > 0 ) {
					$optionStr	= preg_replace('/^[gG][eE][tT]\\(/','',$optionStr);
					$getParms	= preg_replace('/\\)$/','',$optionStr);
				} else if( preg_match('/^[pP][oO][sS][tT]\\([^\\)]+\\)$/', $optionStr) > 0 ) {
					$optionStr	= preg_replace('/^[pP][oO][sS][tT]\\(/','',$optionStr);
					$postParams	= preg_replace('/\\)$/','',$optionStr);
				} else if( preg_match('/^[fF][oO][rR][cC][eE]$/', $optionStr) > 0 ) {
					$force		= 'true';
				}
			}
			$execString	= '<?php $controller->loadModule("'.$execModule.'", '.$force.',"'.$attPrefix.'","'.$getParms.'", "'.$postParams.'" ); ?>';
			return $execString;
		}
		// 空のモジュールタグは削除
		return '';
	}
}
?>