<?php
/*
 * framework-spider
 * spider/tags/DynamicPage.class.php
 * 
 * CopyRight(C)Framework-Spider Developer Team. 2010. All Right Reserved. 
 * URL         : http://sourceforge.jp/projects/frameworkspider/
 * Mail        : frameworkspider-dev@lists.sourceforge.jp
 * Auther      : Masanori Nakashima
 * Modifier    : Masanori Nakashima
 * Last Updated: 2010.06.23
 * 
 */
require_once(dirname(__FILE__).DIRECTORY_SEPARATOR.'TagBase.class.php');
/**
 * HTML用変換タグの動的ページタグクラス
 * 
 * {dynamic-page}タグをブラウザに応じて準備された動的ページフォルダ内のファイルに記述された
 * 文字列に変更します。
 * 
 * ブラウザごとの振り分けフォルダの定義はDATA/define.inc.phpの記述に準じます。
 * ターゲットブラウザのフォルダが見つからない場合は、defaultフォルダ内を検索します。
 * 
 * 定数 DIR_NAME_PAGESが定義されていない場合は変換を実行しません。
 * 
 * 通常、DIR_NAME_PAGESは公開ドキュメントルート内の
 * spider.inc.phpファイルのファイル行頭部分で定義しています。
 * デフォルトでは[pages]となっています。
 * 
 * define('DIR_NAME_PAGES', 'pages');
 * 
 * 一つのspiderのDATAフォルダで複数のドキュメントルートを公開したい場合は、
 * ドキュメントルートごとのspider.inc.phpにてDIR_NAME_PAGESをpages以外に
 * 変更し、DATAフォルダ内に指定した名前のフォルダを作成してください。
 * 
 * 例）
 * define('DIR_NAME_PAGES', 'pages2');
 * DATA/pages2フォルダを作成
 * 
 * @package spider spiderのコアパッケージ
 * @subpackage tags spiderのテンプレートタグ変換クラスパッケージ
 * @version 1.2.00
 * @copyright Copyright &copy; 2008, <m_nakashima@users.sourceforge.jp> http://sourceforge.jp/projects/shopformer/
 * @author  m.nakashima <m_nakashima@users.sourceforge.jp>
 * @since PHP 4.3
 */
class spider_tags_DynamicPage extends spider_tags_TagBase {

	var $request_uri	= null;
	
	/**
	 * コンストラクタ
	 */
	function spider_tags_DynamicPage() {
		$this->priority	= 1;
	}
	/**
	 * コンバートメソッド
	 */
	function convert( &$result_strings, &$build_information ){

		// ユーザーエージェントタイプ確認
		$agent_class	= $build_information->agent_class;
		
		// ダイナミックページの内容
		$dynamic_page_contents	= '';
		if( defined('DIR_NAME_PAGES') && defined('DIR_PATH_PAGES') ) {
			// 動的ページファイルパスの確定
			$page_file_path		= $this->getRealPageFilePath( $build_information );
			if( false !== $page_file_path ) {
				// ファイル内容を取得
				$dynamic_page_contents	= file_get_contents($page_file_path);
			} else {
				// ファイルが取得できなかった場合
				$dynamic_page_contents	= 'ご利用のブラウザではこのページを閲覧できません。'
					.'['.$build_information->agent_class.']';
			}
		} else {
			$dynamic_page_contents	= 'ダイナミックページタグを利用するドキュメントルートとして指定されていません。';
		}
		
		// ダイナミックタグ変換
		preg_match_all( '/\\{dynamic\\-page\\}/'
			, $result_strings
			, $output_array
			, PREG_PATTERN_ORDER );
		foreach ( $output_array as $output ) {
			foreach ( $output as $target ) {
				$result_strings = preg_replace( '/\\{dynamic\\-page\\}/'
					,$dynamic_page_contents, $result_strings );
			}
		}
	}
	/**
	 * ユーザーエージェント分類にあったテンプレートファイルのパスを取得する
	 */
	function getRealPageFilePath( &$build_information ) {
		// ターゲットユーザーエージェントページファイルを確認
		$page_file_path		= $this->getAgentFile( $build_information );
		if( file_exists( $page_file_path ) ) {
			$build_information->addCompareFile( $page_file_path );
			return $page_file_path;
		} else {
			// ターゲットファイルが存在しない場合、生成されていれば再ビルド
			$build_information->addConfirmFile( $page_file_path );
		}
		// 代替ページファイルの確認
		$altAgent	= null;
		if( is_array($GLOBALS['SPIDER_USER_AGENT_CLASS_ALT_HASH'])
			&& count($GLOBALS['SPIDER_USER_AGENT_CLASS_ALT_HASH']) > 0 ) {
			$altAgent	= $build_information->agent_class;
			while( isset($GLOBALS['SPIDER_USER_AGENT_CLASS_ALT_HASH'][$altAgent])
				&& strlen($GLOBALS['SPIDER_USER_AGENT_CLASS_ALT_HASH'][$altAgent]) > 0 ) {
				$altAgent		= $GLOBALS['SPIDER_USER_AGENT_CLASS_ALT_HASH'][$altAgent];
				$pageFilePath	= $this->getAgentFile( $build_information, $altAgent );
				if( file_exists( $pageFilePath ) ) {
					// 代替ファイルがあるならタイムスタンプ比較を追加してリターン
					$build_information->addCompareFile( $pageFilePath );
					return $pageFilePath;
				} else {
					// 代替ファイルもないなら存在確認ファイルとして追加
					$build_information->addConfirmFile( $pageFilePath );
				}
			}
		}
		// デフォルトファイルを確認
		$page_file_path		= $this->getAgentFile( $build_information, 'default' );
		if( file_exists( $page_file_path ) ) {
			// デフォルトファイルがあるならタイムスタンプ比較を追加してリターン
			$build_information->addCompareFile( $page_file_path );
			return $page_file_path;
		} else {
			// デフォルトファイルもない場合、出来ていたら再ビルド
			$build_information->addConfirmFile( $page_file_path );
		}
		return false;
	}
	/**
	 * ユーザーエージェント分類ごとのファイルパスを取得します（存在確認なし）
	 */
	function getAgentFile( & $build_information, $agent_class=null ) {
		if( is_null($agent_class) || strlen($agent_class) == 0 ) {
			$agent_class	= $build_information->agent_class;
		}
		$page_file_path		= DIR_PATH_PAGES
			.'/'.$agent_class.$build_information->getPageUri();
		return $page_file_path;
	}
}
?>