<?php
/*
 * shopping/promotion/Form.class.php
 * 
 * CopyRight(C) 2010 Shopformer Development Team. All Right Reserved
 * URL: http://sourceforge.jp/projects/shopformer/
 * 
 * 
 * Mail: m_nakashima@users.sourceforge.jp
 * Auther: Masanori Nakashima
 * Last Update: 2010-02-12
 * 
 */
require_once( dirname(dirname(__FILE__))
.DIRECTORY_SEPARATOR.'PackageConfig.class.php');
class shopping_promotion_Form extends system_login_ModuleBase {
	function shopping_promotion_Form(){
	}
	function execute( & $request ) {
		
		$dbo						= $request->getAttribute( 'dbo' );
		$promotionNumber				= stripslashes( $_GET['shppn'] );
		$promotionId					= stripslashes( $_GET['shppi'] );
		$sessionObjectName			= 'shopping.promotion.modify.object.'.$promotionNumber;
		$sessionConfirmName			= 'shopping.promotion.modify.confirm.'.$promotionNumber;
		$shoppingProductObject		= $request->getSession($sessionObjectName);
		if( is_object( $shoppingProductObject ) && is_object($shoppingProductObject->uploader) ) {
			$shoppingProductObject->uploader->deleteTempFiles( $request );
		}
		$loginUserObject			= $this->getLoginUserObject( $request );
		$compareShoppingProductObject	= spider_Controller::createObject('shopping_DaoShoppingPromotion');
		$request->removeSession($sessionObjectName);
		$request->removeSession($sessionConfirmName);
		
		if( !$request->isError() ) {
			if( get_class($compareShoppingProductObject) == get_class($shoppingProductObject) ){
				// セッションに登録済みならそのまま利用する
			} else {
				// セッションにないなら作成する
				$shoppingProductObject	= spider_Controller::createObject('shopping_DaoShoppingPromotion');
				if( strlen(trim($promotionNumber)) > 0 ) {
					// IDが指定されているなら編集のため読み込み
					if( $dbo->loadByNumber( $shoppingProductObject, $promotionNumber, true ) ){
					} else {
						$request->addLocaledError('system.error.common.data.invalidselect',SPIDER_LOG_LEVEL_FATAL,array(''));
					}
				} else if( strlen(trim($promotionId)) > 0 ) {
					// IDが指定されているなら編集のため読み込み
					if( $dbo->loadById( $shoppingProductObject, $promotionId, true ) ){
					} else {
						$request->addLocaledError('system.error.common.data.invalidselect',SPIDER_LOG_LEVEL_FATAL,array(''));
					}
				} else {
					// IDが指定されていないなら新規作成
					$shoppingProductObject	= spider_Controller::createObject('shopping_DaoShoppingPromotion');
				}
			}
		}
		if( !$request->isError() ) {
			// promotion_numberが設定済みならロック処理
			if( strlen($shoppingProductObject->promotion_number ) > 0 ) {
				if( false === $this->lockData( $request, $shoppingProductObject ) ) {
					$request->addLocaledError('system.error.common.data.locked',SPIDER_LOG_LEVEL_FATAL,array(''));
				}
			}
		}
		$request->setAttribute('shopping.promotion.promotion_object',		$shoppingProductObject);
	}
}
?>