<?php
/*
 * shopping/promotion/Confirm.class.php
 * 
 * CopyRight(C) 2010 Shopformer Development Team. All Right Reserved
 * URL: http://sourceforge.jp/projects/shopformer/
 * 
 * 
 * Mail: m_nakashima@users.sourceforge.jp
 * Auther: Masanori Nakashima
 * Last Update: 2010-02-12
 * 
 */
require_once( dirname(dirname(__FILE__))
.DIRECTORY_SEPARATOR.'PackageConfig.class.php');
class shopping_promotion_Confirm extends system_login_ModuleBase {
	function shopping_promotion_Confirm(){
	}
	function execute( & $request ) {
		
		$dbo				= $request->getAttribute( 'dbo' );
		$promotionNumber	= stripslashes( $_GET['shppn'] );
		$sessionObjectName	= 'shopping.promotion.modify.object.'.$promotionNumber;
		$sessionConfirmName	= 'shopping.promotion.modify.confirm.'.$promotionNumber;
		// セッション上にあるなら一時アップロードファイルを削除
		$shoppingProductObject	= $request->getSession($sessionObjectName);
		if( is_object( $shoppingProductObject ) && is_object($shoppingProductObject->uploader) ) {
			$shoppingProductObject->uploader->deleteTempFiles( $request );
			$request->removeSession($sessionObjectName);
			$request->removeSession($sessionConfirmName);
		}
		$shoppingProductObject	= spider_Controller::createObject('shopping_DaoShoppingPromotion');
		$loginUserObject	= $this->getLoginUserObject( $request );

		if( !$request->isError() ) {
			if( strlen(trim($promotionNumber)) > 0 ) {
				// データ番号が指定されているなら編集の為読み込み
				if( $dbo->loadByNumber( $shoppingProductObject, $promotionNumber ) ) {
					if( false === $this->lockData( $request, $shoppingProductObject ) ) {
						$request->addLocaledError('system.error.common.data.locked',SPIDER_LOG_LEVEL_FATAL,array(''));
					} else if (SYSTEM_LOGIN_USER_ADMINISTRATORS != $loginUserObject->getLoginGroupLevel()) {
						$request->addLocaledError('system.error.login.user.noauthexec',SPIDER_LOG_LEVEL_ERROR,array());
					}
				} else {
					$request->addLocaledError('system.error.common.data.invalidselect',SPIDER_LOG_LEVEL_FATAL,array(''));
				}
			}
	
			// 入力値のセットとチェック
			$promotion_id								= stripslashes($_POST['promotion_id']);
			$shoppingProductObject->promotion_name		= stripslashes($_POST['promotion_name']);
			$shoppingProductObject->promotion_kana		= stripslashes($_POST['promotion_kana']);
			$shoppingProductObject->promotion_code		= stripslashes($_POST['promotion_code']);
			if( strlen($shoppingProductObject->member_id) == 0 ) {
				$shoppingProductObject->promotion_rank		= stripslashes($_POST['promotion_rank']);
			}
			$shoppingProductObject->description			= stripslashes($_POST['description']);
			// 卸販売許可フラグ
			$shoppingProductObject->buying_flag			= stripslashes($_POST['buying_flag']);
			$shoppingProductObject->buying_rate			= stripslashes($_POST['buying_rate']);

			$shoppingProductObject->exec_tax			= stripslashes($_POST['exec_tax']);
			$shoppingProductObject->exec_tag			= stripslashes($_POST['exec_tag']);
			$shoppingProductObject->exec_url			= stripslashes($_POST['exec_url']);
			$shoppingProductObject->tag_item_format		= stripslashes($_POST['tag_item_format']);
			$shoppingProductObject->tag_item_implode	= stripslashes($_POST['tag_item_implode']);
			
			$shoppingProductObject->discount_type		= stripslashes($_POST['discount_type']);
			$shoppingProductObject->discount_value		= stripslashes($_POST['discount_value']);

			$shoppingProductObject->pay_type			= stripslashes($_POST['pay_type']);
			$shoppingProductObject->pay_value			= stripslashes($_POST['pay_value']);

			// プロモーションID
			if( SYSTEM_LOGIN_USER_ADMINISTRATORS == $loginUserObject->getLoginGroupLevel() ) {
				// 管理者ログインの場合のみ、オブジェクトにセット
				if ( strlen(trim($promotion_id)) > 0 ) {
					$shoppingProductObject->promotion_id		= $promotion_id;
				}
			} else {
				// 管理者ログイン以外は、プロモーションIDの変更はできない
			}
			
			$shoppingProductObject->convertKanaFields('KVas');
			
			// 入力値の妥当性検査を行う
			$shoppingProductObject->validate( $request );
			
		}

		if( $request->isError() ) {
			$request->removeSession($sessionConfirmName);
		} else {
			$request->setSession($sessionConfirmName,'OK');
		}
		$request->setSession($sessionObjectName,$shoppingProductObject);
		$request->setAttribute('shopping.promotion.promotion_object',		$shoppingProductObject);
	}
}
?>