<?php
/*
 * shopping/product/unit/LoadList.class.php
 * 
 * CopyRight(C) 2010 Shopformer Development Team. All Right Reserved
 * URL: http://sourceforge.jp/projects/shopformer/
 * 
 * 
 * Mail: m_nakashima@users.sourceforge.jp
 * Auther: Masanori Nakashima
 * Last Update: 2010-06-18
 */
require_once(dirname(dirname(dirname(__FILE__)))
.DIRECTORY_SEPARATOR.'PackageConfig.class.php' );
class shopping_product_unit_LoadList extends system_login_ModuleBase {
	function shopping_product_unit_LoadList() {
	}
	function execute( & $request ) {

		$dbo				= $request->getAttribute( 'dbo' );
		$pageRows			= stripslashes( $_GET['pr'] );
		$pageNumber			= stripslashes( $_GET['pn'] );
		$queryWords			= mb_convert_kana( trim( stripslashes( $_GET['shpq'] ) ), 'KVas' );
		$sortItem			= $_GET['shpsi'];
		$sortOrder			= $_GET['shpso'];
		$shoppingCategoryId	= $_GET['shpci'];
		$lowerLimit			= stripslashes($_GET['shpll'] );
		$upperLimit			= stripslashes($_GET['shpul'] );
		$shoppingFlagId		= $_GET['shpfi'];
		$statusFlag			= trim( stripslashes( $_GET['shpstf']) );
		$deliveryType		= $request->getParam('shppudt','get');
		
		$userAgentClass			= $request->getAttribute('spider.access_agent_class');
		$loginUserObject		= $this->getLoginUserObject( $request );

		$accessAgentClass	= $request->getAttribute('spider.access_agent_class');
		$loginUserObject	= $this->getLoginUserObject( $request );
		// ページング制御
		if ( !is_numeric( $pageNumber ) || $pageNumber < 1 ) {
			$pageNumber	= 1;
		}
		if ( !is_numeric( $pageRows ) || $pageRows < 1 ) {
			if( 'au'==$accessAgentClass || 'docomo'==$accessAgentClass || 'docomo2'==$accessAgentClass || 'softbank'==$accessAgentClass) {
				$pageRows		= 5;
			} else {
				$pageRows		= 20;
			}
		} else if ( $pageRows > 100 ) {
			if( 'au'==$accessAgentClass || 'docomo'==$accessAgentClass || 'docomo2'==$accessAgentClass || 'softbank'==$accessAgentClass) {
				$pageRows		= 5;
			} else {
				$pageRows		= 20;
			}
		}
		// 並び替え制御
		$sortOrderArray = array();
		if ( is_array($sortOrder) ) {
			$sortOrderArray = $sortOrder;
		} else {
			if ( strlen(trim($sortOrder)) > 0 ) {
				array_push($sortOrderArray,$sortOrder);
			}
		}
		$sortItemArray			= array();
		$orderConditionArray	= array();
		$duplicateCheckArray	= array();
		if ( is_array($sortItem) ) {
			$sortItemArray = $sortItem;
		} else {
			if ( strlen(trim($sortItem)) > 0 ) {
				array_push($sortItemArray,$sortItem);
			}
		}
		// 並べ替え
		if( !is_array($sortItemArray) ){
			$sortItemArray	= array();
		}
		if( !is_array($sortOrderArray) ){
			$sortOrderArray	= array();
		}
		if ( strlen($shoppingFlagId)>0 ) {
				array_push($sortItemArray,'flag_order');
				array_push($sortOrderArray,'ASC');
		} else if ( count($sortItemArray) == 0 ) {
			// 並び替え項目が指定されていなければ
			array_push($sortItemArray,'order');
			array_push($sortItemArray,'upd');
			$sortOrderArray	= array();
			array_push($sortOrderArray,'ASC');
			array_push($sortOrderArray,'DESC');
		} else {
			// 並び替え項目が指定されている場合
			if( !in_array('order',$sortItemArray) ) { array_push($sortItemArray,'order'); array_push($sortOrderArray,'ASC'); }
			if( !in_array('upd',$sortItemArray) ) { array_push($sortItemArray,'upd'); array_push($sortOrderArray,'DESC'); }
			if( !in_array('reg',$sortItemArray) ) { array_push($sortItemArray,'reg'); array_push($sortOrderArray,'DESC'); }
		}
		foreach ( $sortItemArray as $key => $sortItemName ) {
			$orderCondition	= '';
			if ( strlen(trim($sortItemName)) > 0 && !in_array($sortItemName,$duplicateCheckArray) ) {
				// 並び替えの設定
				if ( strlen(trim($sortOrderArray[$key])) == 0 ) {
					// 何も指定されていなければ、降順
					$sortOrderArray[$key]	= 'DESC';
				} else {
					if( preg_match('/^[aA][sS][cC]$/',$sortOrderArray[$key] ) > 0 ) {
						$sortOrderArray[$key]	= 'ASC';
					} else {
						$sortOrderArray[$key]	= 'DESC';
					}
				}

				if( 'did' == $sortItemName ) {
					$orderCondition	= TABLE_NAME_SHOPPING_PRODUCT_UNIT.'.unit_id '.$sortOrderArray[$key];
				} else if ( 'upd' == $sortItemName ) {
					$orderCondition	= TABLE_NAME_SHOPPING_PRODUCT_UNIT.'.updated_date '.$sortOrderArray[$key];
				} else if ( 'dname' == $sortItemName ) {
					$orderCondition	= TABLE_NAME_SHOPPING_PRODUCT_UNIT.'.product_kana '.$sortOrderArray[$key];
				} else if ( 'order_count' == $sortItemName ) {
					$orderCondition	= 'order_count '.$sortOrderArray[$key];
				} else if( 'flag_order' == $sortItemName ) {
					$orderCondition	= 'flag_order '.$sortOrderArray[$key];
				}
				if( strlen($orderCondition) > 0 ) {
					array_push($orderConditionArray,$orderCondition);
					array_push($duplicateCheckArray,$sortItemName);
				}
			}
		}
		$orderConditionString	= '';
		if ( count( $orderConditionArray ) > 0 ) {
			$orderConditionString	= ' ORDER BY ' . implode( ', ', $orderConditionArray );
		}
		
		$categoryIdArray = array();
		if ( is_array($shoppingCategoryId) ) {
			$categoryIdArray = $shoppingCategoryId;
		} else {
			if ( strlen(trim($shoppingCategoryId))>0 ) {
				array_push($categoryIdArray,$shoppingCategoryId);
			}
		}

		$condition_array	= array();
		$joinTables			= array();
		
		// ログイン状態ごとの条件
		spider_Controller::loadClassDefinition('util_CharUtility');
		if( preg_match('/^\\/'.util_CharUtility::escapeRegxStr(SYSTEM_DIR_NAME_ADMIN_PANEL).'\\//',SPIDER_URI_APP) > 0 ){
			// 管理パネルの場合
			if( preg_match('/^[0-9]{1,3}$/',$statusFlag) > 0 ) {
				$str = TABLE_NAME_SHOPPING_PRODUCT_UNIT.'.status_flag='.$statusFlag;
				array_push( $condition_array, $str );
			} else {
				$str = '( '.TABLE_NAME_SHOPPING_PRODUCT_UNIT.'.status_flag>=0'
				.' AND '.TABLE_NAME_SHOPPING_PRODUCT_UNIT.'.status_flag<200 )';
				array_push( $condition_array, $str );
			}
		} else if( $this->isLogin( $request ) && is_a($loginUserObject,'member_DaoMember') ) {
			// 会員ログインの場合は自己所有商品で削除以外と公開商品
			$str = '( ( '.TABLE_NAME_SHOPPING_PRODUCT_UNIT.'.status_flag>=100'
			.' AND '.TABLE_NAME_SHOPPING_PRODUCT_UNIT.'.status_flag<200 ) OR ('
			.TABLE_NAME_SHOPPING_PRODUCT_UNIT.'.status_flag<200'
			.' AND '.TABLE_NAME_SHOPPING_PRODUCT_UNIT.'.owner_id='.$dbo->quote($loginUserObject->getUniqueId()).' ) )';
			array_push( $condition_array, $str );
			// 会員ログインの場合は会員種別で条件
			$definedClassKeyArray	= array_keys($GLOBALS['MEMBER_MEMBER_CLASS_HASH']);
			$str	= '(';
			$keyCol = 1;
			foreach ( $definedClassKeyArray as $key=>$classKey ) {
				if ( $classKey == $loginUserObject->member_class ) {
					$str	.= TABLE_NAME_SHOPPING_PRODUCT_UNIT.'.member_viewable & '.$keyCol.' = '.$keyCol.' OR ';
					break;
				}
				$keyCol = $keyCol * 2;
			}
			$str	.= TABLE_NAME_SHOPPING_PRODUCT_UNIT.'.owner_id='.$dbo->quote($loginUserObject->getUniqueId()).' )';
			array_push( $condition_array, $str );
		} else {
			// ログインしていない場合は公開商品のみ
			$str = '( '.TABLE_NAME_SHOPPING_PRODUCT_UNIT.'.status_flag>=100'
			.' AND '.TABLE_NAME_SHOPPING_PRODUCT_UNIT.'.status_flag<200 )';
			array_push( $condition_array, $str );
			// 非公開が閲覧可能な場合のみ閲覧可能
			$str	= TABLE_NAME_SHOPPING_PRODUCT_UNIT.'.member_viewable & 1 = 1';
			array_push( $condition_array, $str );
			// TODO: ログインしていない場合はプロモーション紹介特別商品も表示
			
		}
		// 配送種別
		if(preg_match('/^[0-9]{1,6}$/',$deliveryType) > 0) {
			$str	= '( '.TABLE_NAME_SHOPPING_PRODUCT.'.delivery_type='.$deliveryType.' )';
			array_push( $condition_array, $str );
		}
		
		// カテゴリ条件
		if( count($categoryIdArray) > 0 ) {
			$categoryConditionArray	= array();
			foreach( $categoryIdArray as $categoryId ) {
				if( strlen(trim($categoryId)) > 0 ) {
					$categoryObject	= spider_Controller::createObject('shopping_DaoShoppingCategory');
					if( $dbo->loadById( $categoryObject, $categoryId, true ) ) {
						array_push( $categoryConditionArray, $dbo->quote($categoryId) );
						$idArray	= $categoryObject->getAllChildCategoryIdArray();
						if( is_array( $idArray ) ) {
							foreach( $idArray as $id ) {
								array_push( $categoryConditionArray, $dbo->quote($id) );
							}
						}
					}
				}
			}
			if( count($categoryConditionArray) > 0 ) {
				array_push( $joinTables,TABLE_NAME_SHOPPING_CATEGORY_PRODUCT );
				$str	= TABLE_NAME_SHOPPING_CATEGORY_PRODUCT.'.category_id IN('.implode(',',$categoryConditionArray).')';
				array_push( $condition_array, $str );
			}
		}
		
		// 価格条件
		if( preg_match('/^[0-9]{1,9}$/',$lowerLimit ) > 0 && preg_match('/^[0-9]{1,9}$/',$upperLimit ) > 0 ) {
			if( $lowerLimit > $upperLimit ) {
				$tmp	= $lowerLimit;
				$lowerLimit	= $upperLimit;
				$upperLimit	= $tmp;
			}
			// 下限価格と上限価格
			$str	= TABLE_NAME_SHOPPING_PRODUCT_UNIT.'.price_sell BETWEEN '.$lowerLimit.' AND '.$upperLimit;
			array_push( $condition_array, $str );
		} else if( preg_match('/^[0-9]{1,9}$/',$lowerLimit ) > 0 ) {
			// 下限価格のみ
			$str	= TABLE_NAME_SHOPPING_PRODUCT_UNIT.'.price_sell >= '.$lowerLimit;
			array_push( $condition_array, $str );
		} else if( preg_match('/^[0-9]{1,9}$/',$upperLimit ) > 0 ) {
			// 上限価格のみ
			$str	= TABLE_NAME_SHOPPING_PRODUCT_UNIT.'.price_sell <= '.$upperLimit;
			array_push( $condition_array, $str );
		}
		
		// 商品フラグ
		if ( strlen($shoppingFlagId)>0 ) {
			$str	= TABLE_NAME_SHOPPING_PRODUCT_UNIT_FLAG_RELATION.'.flag_id = '.$dbo->quote($shoppingFlagId)
				.' AND (('.TABLE_NAME_SHOPPING_PRODUCT_UNIT_FLAG_RELATION.'.open_date IS NULL'
				.' AND '.TABLE_NAME_SHOPPING_PRODUCT_UNIT_FLAG_RELATION.'.close_date IS NULL)' 
				.' OR ('.TABLE_NAME_SHOPPING_PRODUCT_UNIT_FLAG_RELATION.'.open_date <= '.$dbo->quote(date('Y-m-d'))
				.' AND '.TABLE_NAME_SHOPPING_PRODUCT_UNIT_FLAG_RELATION.'.close_date >= '.$dbo->quote(date('Y-m-d')).')'
				.' OR ('.TABLE_NAME_SHOPPING_PRODUCT_UNIT_FLAG_RELATION.'.open_date <= '.$dbo->quote(date('Y-m-d'))
				.' AND '.TABLE_NAME_SHOPPING_PRODUCT_UNIT_FLAG_RELATION.'.close_date IS NULL)'
				.' OR ('.TABLE_NAME_SHOPPING_PRODUCT_UNIT_FLAG_RELATION.'.open_date IS NULL'
				.' AND '.TABLE_NAME_SHOPPING_PRODUCT_UNIT_FLAG_RELATION.'.close_date >= '.$dbo->quote(date('Y-m-d')).'))'
			;
			array_push( $condition_array, $str );
		}
		
		// 検索ワード
		if ( strlen(trim($queryWords)) > 0 ) {
			$queryWords	= str_replace('　', ' ', $queryWords);
			$queryWordArray	= explode(' ',$queryWords);
			foreach( $queryWordArray as $queryWord ) {
				if( strlen($queryWord) > 0 ) {
					// 検索文字列
					$str	= '( '.TABLE_NAME_SHOPPING_PRODUCT_UNIT.'.unit_id LIKE ' . $dbo->quote( '%'.$queryWord.'%' )
						. ' OR '
						. TABLE_NAME_SHOPPING_PRODUCT_UNIT.'.unit_name LIKE ' . $dbo->quote( '%'.$queryWord.'%' )
						. ' OR '
						. TABLE_NAME_SHOPPING_PRODUCT_UNIT.'.unit_kana LIKE ' . $dbo->quote( '%'.$queryWord.'%' )
						. ' OR '
						. TABLE_NAME_SHOPPING_PRODUCT_UNIT.'.description LIKE ' . $dbo->quote( '%'.$queryWord.'%' )
					;
					$str	.= ' )'	;
					array_push( $condition_array, $str );
				}
			}
		}
		
		$condition_string	= '';
		if ( count( $condition_array ) > 0 ) {
			$condition_string	= ' WHERE ' . implode( ' AND ', $condition_array );
		}
		
		// トータル件数を取得
		$sql	= 'SELECT COUNT(DISTINCT('.TABLE_NAME_SHOPPING_PRODUCT_UNIT. '.unit_id)) '
			.' FROM ' . TABLE_NAME_SHOPPING_PRODUCT_UNIT
			.' LEFT OUTER JOIN ' . TABLE_NAME_SHOPPING_PRODUCT
			.' ON ' . TABLE_NAME_SHOPPING_PRODUCT . '.product_id='.TABLE_NAME_SHOPPING_PRODUCT_UNIT.'.product_id '
		;
		if ( in_array( TABLE_NAME_SHOPPING_CATEGORY_PRODUCT, $joinTables ) ) {
			$sql	.= ' LEFT OUTER JOIN ' . TABLE_NAME_SHOPPING_CATEGORY_PRODUCT
				. ' ON ' . TABLE_NAME_SHOPPING_CATEGORY_PRODUCT . '.product_id='.TABLE_NAME_SHOPPING_PRODUCT.'.product_id '
			;
		}
		if ( strlen($shoppingFlagId)>0 ) {
			$sql	.= ' LEFT OUTER JOIN ' . TABLE_NAME_SHOPPING_PRODUCT_UNIT_FLAG_RELATION
				. ' ON ' . TABLE_NAME_SHOPPING_PRODUCT_UNIT_FLAG_RELATION . '.unit_id='.TABLE_NAME_SHOPPING_PRODUCT_UNIT.'.unit_id '
			;
		}
		$sql	.= $condition_string;
		$totalCount	= 0;
		$totalCount	= $dbo->queryOne( $sql );
		if ( $totalCount === false ) {
			$request->addLocaledError('database2.error.common',SPIDER_LOG_LEVEL_FATAL,array($sql));
		} else {
			if ( is_numeric( $totalCount ) || $totalCount < 0 ) {
				$totalPage		= ceil( $totalCount / $pageRows );
			} else {
				$totalCount	= 0;
				$totalPage		= 1;
			}
		}
		// オフセットの整理
		if ( !is_numeric( $pageNumber ) || $pageNumber <= 0 ) {
			$pageNumber	= 1;
		} else if ( $pageNumber > $totalPage	 ) {
			$pageNumber	= $totalPage;
		}
		
		// IDをページ分取得
		$sql	= 'SELECT DISTINCT '.TABLE_NAME_SHOPPING_PRODUCT_UNIT.'.* ';
		if ( in_array('order_count',$sortItemArray) ) {
			$sql	.= ', COUNT('.TABLE_NAME_SHOPPING_ORDER_ITEM.'.item_number) AS order_count ';
		}
		if ( strlen($shoppingFlagId)>0 ) {
			$sql	.= ', '.TABLE_NAME_SHOPPING_PRODUCT_UNIT_FLAG_RELATION.'.order_number AS flag_order ';
		}
		$sql	.= ' FROM ' . TABLE_NAME_SHOPPING_PRODUCT_UNIT
			.' LEFT OUTER JOIN ' . TABLE_NAME_SHOPPING_PRODUCT
			.' ON ' . TABLE_NAME_SHOPPING_PRODUCT . '.product_id='.TABLE_NAME_SHOPPING_PRODUCT_UNIT.'.product_id '
		;
		if ( in_array( TABLE_NAME_SHOPPING_CATEGORY_PRODUCT, $joinTables ) ) {
			$sql	.= ' LEFT OUTER JOIN ' . TABLE_NAME_SHOPPING_CATEGORY_PRODUCT
				. ' ON ' . TABLE_NAME_SHOPPING_CATEGORY_PRODUCT . '.product_id='.TABLE_NAME_SHOPPING_PRODUCT.'.product_id '
			;
		}
		if ( strlen($shoppingFlagId)>0 ) {
			$sql	.= ' LEFT OUTER JOIN ' . TABLE_NAME_SHOPPING_PRODUCT_UNIT_FLAG_RELATION
				. ' ON ' . TABLE_NAME_SHOPPING_PRODUCT_UNIT_FLAG_RELATION . '.unit_id='.TABLE_NAME_SHOPPING_PRODUCT_UNIT.'.unit_id '
			;
		}
		if ( in_array('order_count',$sortItemArray) ) {
			$sql	.= ' LEFT OUTER JOIN ' . TABLE_NAME_SHOPPING_ORDER_ITEM
				. ' ON ' . TABLE_NAME_SHOPPING_ORDER_ITEM . '.unit_id='.TABLE_NAME_SHOPPING_PRODUCT_UNIT.'.unit_id '
			;
		}
		$sql	.= $condition_string
			. ' GROUP BY '
			.TABLE_NAME_SHOPPING_PRODUCT_UNIT.'.unit_id '
			. $orderConditionString
		;
		$dbo->setLimit( $pageRows, ( $pageNumber - 1 ) * $pageRows );
		$shoppingProductUnitObject	= spider_Controller::createObject('shopping_DaoShoppingProductUnit');
		$productObjectUnitArray	= $dbo->queryAll( $sql, $shoppingProductUnitObject, false, false );
		if ( $productObjectUnitArray === false ) {
			$request->addLocaledError('database2.error.common',SPIDER_LOG_LEVEL_FATAL,array($sql));
		} else {
			$unitIdArray		= array();
			$productIdArray		= array();
			$productUnitObjectHash		= array();
			foreach( $productObjectUnitArray as $key => $object ) {
				$unitId			= $object->unit_id;
				$this->setLockStatus( $request, $object );
				if( 'default' != $accessAgentClass ) {
					// 携帯の場合は文字数を削っておく
					if( mb_strlen( $object->description ) > 60 ) {
						$object->description	= mb_substr( $object->description, 0, 56 ).'..';
					}
				}
				// オプション文字列の分割
				for( $i=1; $i<=5; $i++ ) {
					$optionFieldName		= 'option'.$i.'_items';
					$optionNameArrayName	= 'option'.$i.'_item_array';
					$optionPriceArrayName	= 'option'.$i.'_price_array';
					if( strlen( $object->$optionFieldName ) > 0 ) {
						// オプション選択肢が設定されているなら処理
						$object->$optionFieldName			= str_replace("\r\n","\n",$object->$optionFieldName);
						$object->$optionFieldName			= str_replace("\r","\n",$object->$optionFieldName);
						$object->$optionNameArrayName		= array();
						$object->$optionPriceArrayName	= array();
						$itemStringArray				= explode("\n",$object->$optionFieldName);
						if( preg_match('/\\:/',$object->$optionFieldName) > 0 ) {
							// :を含むなら価格と分割
							foreach( $itemStringArray as $str ) {
								list( $itemName, $itemPrice )	= explode(':',$str);
								array_push($object->$optionNameArrayName,$itemName);
								if( strlen($itemPrice)==0 ) {
									$itemPrice	= 0;
								}
								array_push($object->$optionPriceArrayName,$itemPrice);
							}
						} else {
							$object->$optionNameArrayName	= $itemStringArray;
						}
					}
				}
				$productUnitObjectHash[$unitId]	= $object;
				array_push($unitIdArray,$object->unit_id);
				if ( !in_array($object->product_id,$productIdArray) ) {
					array_push($productIdArray,$object->product_id);
				}
			}
			// プロダクトオブジェクトの作成
			$productObjectHash = array();
			foreach ( $productIdArray as $productId ) {
				$shoppingProductObject	= spider_Controller::createObject('shopping_DaoShoppingProduct');
				if( $dbo->loadById( $shoppingProductObject, $productId, false ) ) {
					$shoppingProductObject->loadRelatedSearchData( $dbo );
					$productObjectHash[$productId] = $shoppingProductObject;
				}
			}
			
			// 所属カテゴリIDの読み込み
			$sql	= 'SELECT * FROM '.TABLE_NAME_SHOPPING_CATEGORY_PRODUCT
				.' WHERE product_id IN (\''.implode('\',\'',$productIdArray).'\')'
				.' ORDER BY order_number ASC'
			;
			$rows	= $dbo->queryAll( $sql, 'hash', false );
			if( false === $rows ) {
				$request->addLocaledError('database2.error.common',SPIDER_LOG_LEVEL_FATAL,array($sql));
			} else {
				foreach( $rows as $row ) {
					$productId	= trim($row['product_id']);
					$categoryId	= trim($row['category_id']);
					if( isset($productObjectHash[$productId]) ) {
						array_push($productObjectHash[$productId]->categoryIdArray,$categoryId);
					}
				}
			}
			// shopping_product_unit_fileの読み込み
			$sql	= 'SELECT * FROM '.TABLE_NAME_SHOPPING_PRODUCT_UNIT_FILE
				.' WHERE unit_id IN (\''.implode('\',\'',$unitIdArray).'\')'
				.' ORDER BY order_number ASC'
			;
			$rows	= $dbo->queryAll( $sql, 'hash', false );
			if( false === $rows ) {
				$request->addLocaledError('database2.error.common',SPIDER_LOG_LEVEL_FATAL,array($sql));
			} else {
				foreach( $rows as $row ) {
					$unitId		= trim($row['unit_id']);
					$fileId			= trim($row['file_id']);
					$orderNumber	= trim($row['order_number']);
					if( isset($productUnitObjectHash[$unitId]) ) {
						$productUnitObjectHash[$unitId]->fileIdArray[$orderNumber]	= $fileId;
					}
				}
			}
			// shopping_product_fileの読み込み
			$sql	= 'SELECT * FROM '.TABLE_NAME_SHOPPING_PRODUCT_FILE
				.' WHERE product_id IN (\''.implode('\',\'',$productIdArray).'\')'
				.' ORDER BY order_number ASC'
			;
			$rows	= $dbo->queryAll( $sql, 'hash', false );
			if( false === $rows ) {
				$request->addLocaledError('database2.error.common',SPIDER_LOG_LEVEL_FATAL,array($sql));
			} else {
				foreach( $rows as $row ) {
					$productId		= trim($row['product_id']);
					$fileId			= trim($row['file_id']);
					$orderNumber	= trim($row['order_number']);
					if( isset($productObjectHash[$productId]) ) {
						$productObjectHash[$productId]->fileIdArray[$orderNumber]	= $fileId;
					}
				}
			}
			$productObjectUnitArray	= $productUnitObjectHash;
			$productObjectArray 	= $productObjectHash;
			foreach( $productObjectUnitArray as $key => $unitObject ) {
				$productObjectUnitArray[$key]->shoppingProductObject	= $productObjectHash[$unitObject->product_id];
			}
			$request->setAttribute( 'shopping.product.unit.unit_array',		$productObjectUnitArray );
			$request->setAttribute( 'shopping.product.unit.product_array',	$productObjectArray );
			$request->setAttribute( 'shopping.product.unit.total_count',	$totalCount );
			$request->setAttribute( 'shopping.product.unit.total_page',		$totalPage );
			$request->setAttribute( 'shopping.product.unit.page_number',		$pageNumber );
			$request->setAttribute( 'shopping.product.unit.page_rows',			$pageRows );
			$request->setAttribute( 'shopping.product.unit.query',				$queryWords );
			$request->setAttribute( 'shopping.product.unit.lowerLimit',			$lowerLimit );
			$request->setAttribute( 'shopping.product.unit.upperLimit',			$upperLimit );
			$request->setAttribute( 'shopping.product.unit.sort_item_array',			$sortItemArray );
			$request->setAttribute( 'shopping.product.unit.sort_order_array',		$sortOrderArray );
			$request->setAttribute( 'shopping.product.unit.category_id_array',	$categoryIdArray );
			$request->setAttribute( 'shopping.product.unit.flag_id',	$shoppingFlagId );
			$request->setAttribute( 'shopping.product.unit.status_flag',		$statusFlag );
			$request->setAttribute( 'shopping.product.unit.deliveryType',	$deliveryType );
			
			$has_next_page	= false;
			if( $pageNumber < $totalPage ) {
				$has_next_page	= true;
			}
			$request->setAttribute( 'shopping.product.unit.has_next_page', $has_next_page );
			$has_prev_page	= false;
			if( $pageNumber > 1 ) {
				$has_prev_page	= true;
			}
			$request->setAttribute( 'shopping.product.unit.has_prev_page', $has_prev_page );
			
			// ページナビゲーション配列作成
			$page_navi_array = array();
			if ( $pageNumber < 10 ) {
				if ( $totalPage < 10 ) {
					for($i=1;$i<=$totalPage;$i++) {
						array_push($page_navi_array,$i);
					}
				} else {
					for($i=1;$i<=10;$i++) {
						array_push($page_navi_array,$i);
					}
				}
			} else {
				$startPage	= floor(($pageNumber-1)/10) * 10 + 1;
				for($i=$startPage;( $i<$startPage+10 && $i<=$totalPage );$i++) {
					array_push($page_navi_array,$i);
				}
			}
			$request->setAttribute('shopping.product.unit.page_navi_array', $page_navi_array );
		}
	}
}
?>