<?php
/*
 * shopping/order/step/ConfirmComment.class.php
 * 
 * CopyRight(C) 2010 Shopformer Development Team. All Right Reserved
 * URL: http://sourceforge.jp/projects/shopformer/
 * 
 * 
 * Mail: m_nakashima@users.sourceforge.jp
 * Auther: Masanori Nakashima
 * Last Update: 2010-10-04
 */
require_once(dirname(dirname(dirname(__FILE__)))
.DIRECTORY_SEPARATOR.'PackageConfig.class.php' );
require_once( dirname(dirname(dirname(__FILE__)))
	.DIRECTORY_SEPARATOR.'DaoShoppingOrder.class.php' );
class shopping_order_step_ConfirmComment extends system_login_ModuleBase {
	/**
	 * コンストラクタ
	 */
	function shopping_order_step_ConfirmComment() {
		array_push($this->require_module_array,'shopping.LoadConfig');
		array_push($this->require_module_array,'shopping.order.option.LoadList');
		array_push($this->require_module_array,'shopping.order.settlement.LoadList');
		if( isset($_GET['shpoi']) && strlen(trim($_GET['shpoi'])) > 0 ) {
			array_push($this->require_module_array,'shopping.order.CartAdmin');
		} else {
			array_push($this->require_module_array,'shopping.order.Cart');
		}
		array_push($this->require_module_array,'shopping.order.step.ConfirmStock');
	}
	/**
	 * executeメソッド
	 */
	function execute( & $request ) {
		// カートオブジェクトの取得
		$shoppingOrderObject	= $request->getAttribute('shopping.order.orderObject');
		$redirect		= $request->getParam('redirect','post');
		// 通信欄
		$shoppingOrderObject->order_comment		= trim(stripslashes($_POST['order_comment']));
		// 妥当性検査
		unset($shoppingOrderObject->columnErrorHash['order_comment']);
		// 妥当性検査：通信欄
		if( strlen($shoppingOrderObject->order_comment) == 0 ) {
		} else if( strlen($shoppingOrderObject->order_comment) > 1500 ) {
			$shoppingOrderObject->addColumnError($request,'order_comment', 'shopping.error.cart.comment.overlength');
		}
		// 宛先ごとの通信欄
		foreach( $shoppingOrderObject->shoppingOrderAddressObjectArray as $num => $addressObject ) {
			$shoppingOrderAddressObject	= & $shoppingOrderObject->shoppingOrderAddressObjectArray[$num];
			if( isset($_POST['address_order_comment']) ) {
				$shoppingOrderAddressObject->order_comment	= $request->getParam('address_order_comment','post',null,$num);
			}
			if( strlen($shoppingOrderAddressObject->order_comment) == 0 ) {
			} else if( strlen($shoppingOrderAddressObject->order_comment) > 1500 ) {
				$shoppingOrderAddressObject->addColumnError($request,'order_comment', 'shopping.error.cart.comment.overlength');
			}
		}
		// エラーがある場合は前のページにリダイレクトを設定
		if( $request->isError() ) {
			$request->removeSession(SHOPPING_SESSION_NAME_ORDER_CONFIRM_COMMENT);
			if( strlen($_SERVER['HTTP_REFERER']) > 0 ) {
				$request->redirectTo($_SERVER['HTTP_REFERER']);
			} else if( preg_match('/^\\.\\//',trim($_POST['referer'])) > 0 ) {
				$request->redirectTo(trim($_POST['referer']));
			}
		} else {
			$confirmResult	= 'OK';
			$shoppingOrderObject->columnErrorHash	= array();
			$request->setSession(SHOPPING_SESSION_NAME_ORDER_CONFIRM_COMMENT,$confirmResult);
		}
		$request->setAttribute('shopping.order.orderObject',	$shoppingOrderObject );
	}
}
?>