<?php
/*
 * shopping/order/settlement/MethodBankPre.class.php
 * 
 * CopyRight(C) 2010 Shopformer Development Team. All Right Reserved
 * URL: http://sourceforge.jp/projects/shopformer/
 * 
 * 
 * Mail: m_nakashima@users.sourceforge.jp
 * Auther: Masanori Nakashima
 * Last Update: 2010-06-18
 */
require_once(dirname(__FILE__).DIRECTORY_SEPARATOR.'MethodBase.class.php');
/**
 * shopping_order_settlement_MethodPoint
 * 決済プラグイン：ポイント支払向け決済プラグインクラス
 * 
 * 銀行振込(先払い)向けの決済プラグイン実装クラスです。
 * 注文が完了した場合にデフォルトで注文状態を「新規」、決済状態を「請求済」に設定します。
 * 外部サービスとの連携は存在しません。
 * 
 */
class shopping_order_settlement_MethodPoint extends shopping_order_settlement_MethodBase {
	/**
	 * コンストラクタ
	 */
	function shopping_order_settlement_MethodPoint() {
		$this->enable			= false;
		$this->memberClassArray	= array(1,51,52,53);
		$this->viewName			= 'ポイント支払';
		$this->feeType			= 0;
		$this->feeValue			= 0;
		$this->statusSettle		= 101;
		$this->mailTemplateName	= 'claim';
		$this->mailComment	= "ポイントでお支払いが完了しています。";
		$this->mailOrder	= "";
		$this->explanation	= <<< __METHOD_EXPLANATION__
<div>
ポイントでのお支払いです。<br />
保有ポイントが決済金額よりも多くのポイントを保有している必要があります。
</div>
__METHOD_EXPLANATION__;
	}
	/**
	 * 決済方法名を取得
	 */
	function getMethodName() {
		return 'ポイント決済プラグイン';
	}
	/**
	 * 決済方法固有の番号を取得します。
	 */
	function getMethodNumber() {
		return '16';
	}
	/**
	 * confirm時の処理
	 * @param $request spider_HttpRequestインスタンス参照
	 * @param $shoppingOrderObject shopping_DaoShoppingOrderインスタンス参照
	 * @return boolean 成功したらtrue/失敗したらfalse
	 */
	function confirm( & $request, & $shoppingOrderObject ) {
		// 会員情報を確認
		if( $shoppingOrderObject->payment_total == 0 ) {
			// 支払金額が0の場合は会員チェックもスルーする
		} else {
			$dbo		= $request->getAttribute('dbo');
			$memberId	= $shoppingOrderObject->memberObject->member_id;
			$sql		= 'SELECT member_number, member_class, point  FROM '.TABLE_NAME_MEMBER
				.' WHERE member_id='.$dbo->quote($memberId);
			$result		= $dbo->queryAll($sql,'hash');
			if( false === $result ) {
				$shoppingOrderObject->addColumnError($request,'settle_method_errors','保有ポイント確認問い合わせに失敗しました。');
			} else if( count($result) == 0 ) {
				$shoppingOrderObject->addColumnError($request,'settle_method_errors','会員登録してからでないとポイント清算はおこなえません。');
			} else if( $result[0]['member_class'] < 1 ){
				$shoppingOrderObject->addColumnError($request,'settle_method_errors','会員登録してからでないとポイント清算はおこなえません。');
			} else if( $result[0]['point'] < $shoppingOrderObject->payment_total ) {
				$shoppingOrderObject->addColumnError($request,'settle_method_errors','保有ポイントが足りません。');
			}
		}
		if( $request->isError() ) {
			return false;
		} else {
			return true;
		}
	}
	/**
	 * execute時の処理
	 */
	function execute( & $request, & $shoppingOrderObject ) {
		$dbo		= $request->getAttribute('dbo');
		$memberId	= $shoppingOrderObject->memberObject->member_id;
		// 実行直前にも妥当性検査
		if( $this->confirm($request,$shoppingOrderObject) ) {
			$shoppingOrderObject->point_use	= $shoppingOrderObject->payment_total;
		}
		$shoppingOrderObject->setSettlePrice( $request, $shoppingOrderObject->payment_total );
		if( $request->isError() ) {
			return false;
		} else {
			return true;
		}
	}
}
?>