<?php
/*
 * shopping/order/settlement/MethodCollect.class.php
 * 
 * CopyRight(C) 2010 Shopformer Development Team. All Right Reserved
 * URL: http://sourceforge.jp/projects/shopformer/
 * 
 * 
 * Mail: m_nakashima@users.sourceforge.jp
 * Auther: Masanori Nakashima
 * Last Update: 2010-06-18
 */
require_once(dirname(__FILE__).DIRECTORY_SEPARATOR.'MethodBase.class.php');
/**
 * shopping_order_settlement_MethodCollect
 * 決済プラグイン：代金引換向けクラス
 * 
 * 代金引換向けの決済プラグイン実装クラスです。
 * 注文が完了した場合にデフォルトで注文状態を「新規」、決済状態を「未決済」に設定します。
 * 外部サービスとの連携は存在しません。
 * 
 */
class shopping_order_settlement_MethodCollect extends shopping_order_settlement_MethodBase {
	/**
	 * コンストラクタ
	 */
	function shopping_order_settlement_MethodCollect() {
		$this->viewName			= '代金引換';
		$this->feeType			= 1;
		$this->feeValue			= 800;
		$this->statusSettle		= 0;
		$this->mailTemplateName	= 'confirm';
		$this->mailComment	= "代金引換でご注文頂いております。商品到着時に配送業者に代金をお支払いください。";
		$this->mailOrder	= "代金引換(お客様への請求額={order::payment_total}円で配送お願いします。\n"
			."御社宛てに卸値との差分を請求させて頂きます。";
		$this->explanation	= <<< __METHOD_EXPLANATION__
<div>
○○運輸株式会社の代金引換サービスで発送いたします。<br />
商品お届け時に運送会社に料金をお支払いください。<br />
代金引換の決済手数料として800円をご負担いただきます。
</div>
__METHOD_EXPLANATION__;
	}
	/**
	 * 決済方法名を取得
	 */
	function getMethodName() {
		return '代金引換決済プラグイン';
	}
	/**
	 * 決済方法固有の番号を取得します。
	 */
	function getMethodNumber() {
		return '0';
	}
	/**
	 * 決済手数料を注文情報に設定
	 * @param $request spider_HttpRequestインスタンス参照
	 * @param $shoppingOrderObject shopping_DaoShoppingOrderオブジェクト
	 */
	function setSettleFee( & $request, & $shoppingOrderObject ) {
		$feeTotal	= 0;
		foreach( $shoppingOrderObject->shoppingOrderAddressObjectArray as $num => $addressObject ) {
			if( count($addressObject->shoppingOrderItemObjectArray) > 0 ) {
				if( $this->feeType == 2 ) {
					$shoppingOrderObject->shoppingOrderAddressObjectArray[$num]->settle_fee
						= ceil($addressObject->getTotalPaymentPrice( $request )*$this->feeValue/100);
				} else if( $this->feeType == 1 ) {
					$shoppingOrderObject->shoppingOrderAddressObjectArray[$num]->settle_fee	= $this->feeValue;
				} else {
					$shoppingOrderObject->shoppingOrderAddressObjectArray[$num]->settle_fee	= 0;
				}
				$feeTotal	+= $shoppingOrderObject->shoppingOrderAddressObjectArray[$num]->settle_fee;
			} else {
				$shoppingOrderObject->shoppingOrderAddressObjectArray[$num]->settle_fee	= 0;
			}
		}
		$shoppingOrderObject->settle_fee	= $feeTotal;
	}
	/**
	 * 指定された注文情報に対して本決済プラグインを利用可能か確認します
	 * @param $request spider_HttpRequestインスタンス参照
	 * @param $shoppingOrderObject shopping_DaoShoppingOrderインスタンス参照
	 * @return boolean 利用可能ならtrue/不可ならfalse
	 */
	function enableOnOrder( & $request, & $shoppingOrderObject ) {
		if( !is_null($shoppingOrderObject) ) {
			$productUnitHash	= $shoppingOrderObject->getProductUnitHash( $request );
			foreach( $productUnitHash as $key => $unitObject ) {
				if( $unitObject->delivery_type != '0' && $unitObject->delivery_type != '1' ) {
					// カートに実配送が発生しない商品が含まれている場合は対応しません
					return false;
				}
			}
		}
		return true;
	}
}
?>