<?php
/*
 * shopping/order/CartAdmin.class.php
 * 
 * CopyRight(C) 2010 Shopformer Development Team. All Right Reserved
 * URL: http://sourceforge.jp/projects/shopformer/
 * 
 * 
 * Mail: m_nakashima@users.sourceforge.jp
 * Auther: Masanori Nakashima
 * Last Update: 2010-10-07
 */
require_once( dirname(__FILE__)
.DIRECTORY_SEPARATOR.'Cart.class.php' );
class shopping_order_SelectDatetime extends shopping_order_Cart {
	function shopping_order_SelectDatetime() {
		array_push($this->require_module_array,'database2.Connect');
		array_push($this->require_module_array,'shopping.product.unit.Load');
	}
	function execute( & $request ) {
		$targetDateArray	= $request->getParam('target_date','post','array');
		$pageDateArray		= $request->getParam('page_date','post','array');
		$shoppingProductUnitObject	= $request->getAttribute('shopping.product.unit.unit_object');
		if( !is_object($shoppingProductUnitObject) ){
			$request->addLocaledError('shopping.error.product.notfound',SPIDER_LOG_LEVEL_FATAL,array(''));
			return;
		}
		// カレンダーチェック状況をセッションから取得
		$selectedDateHash	= $request->getSession('shopping.order.selectedDateHash',SPIDER_SESSION_SCOPE_GLOBAL);
		if( !is_array($selectedDateHash) ) {
			$selectedDateHash	= array();
		}
		// ページ表示分の日付が入力されていたら一旦全て削除
		if( is_array($selectedDateHash[$shoppingProductUnitObject->unit_id]) ) {
			$newArray	= array();
			foreach( $selectedDateHash[$shoppingProductUnitObject->unit_id] as $val ) {
				if( !in_array($val,$pageDateArray) ) {
					array_push($newArray,$val);
				}
			}
			$selectedDateHash[$shoppingProductUnitObject->unit_id]	= $newArray;
		}
		// チェックされた日付を追加
		if( !is_array($selectedDateHash[$shoppingProductUnitObject->unit_id]) ) {
			$selectedDateHash[$shoppingProductUnitObject->unit_id]	= $targetDateArray;
		} else {
			$selectedDateHash[$shoppingProductUnitObject->unit_id]
			= array_merge($selectedDateHash[$shoppingProductUnitObject->unit_id], $targetDateArray);
		}
		$selectedDateHash[$shoppingProductUnitObject->unit_id]
		= array_unique($selectedDateHash[$shoppingProductUnitObject->unit_id]);
		$newHash	= array();
		foreach( $selectedDateHash[$shoppingProductUnitObject->unit_id] as $timeStr ) {
			if( strlen(trim($timeStr)) > 0 ) {
				array_push($newHash,$timeStr);
			}
		}
		// ユニーク化してソート
		$newHash	= array_unique($newHash);
		asort($newHash);
		// 連続した時間をキープしているか確認
		$termCount	= 1;
		if( 900 == $shoppingProductUnitObject->delivery_type ){
			// 宿泊予約商品の場合
			$lastTime		= 0;
			foreach( $newHash as $dateStr ){
				$dateTime	= strtotime($dateStr);
				if( $lastTime > 0 ){
					if( $dateTime - $lastTime > (24*60*60) ){
						$termCount++;
					}
				}
				$lastTime	= $dateTime;
			}
		} else if( 200 <= $shoppingProductUnitObject->delivery_type ){
			// 時間予約の場合
			$onTermTime	= $shoppingProductUnitObject->service_term;
			$lastTime		= 0;
			foreach( $newHash as $dateStr ){
				$dateTime	= strtotime($dateStr);
				if( $lastTime > 0 ){
					if( $dateTime - $lastTime > $onTermTime ){
						$termCount++;
					}
				}
				$lastTime	= $dateTime;
			}
		}
		if( defined('SHOPPING_RSV_LIMIT_TERM_AT_ONCE')
		&& preg_match('/^[0-9]{1,2}$/',SHOPPING_RSV_LIMIT_TERM_AT_ONCE) > 0 ) {
			if( $termCount > SHOPPING_RSV_LIMIT_TERM_AT_ONCE ) {
				$request->addLocaledError('shopping.error.reserve.termlimitatonce',SPIDER_LOG_LEVEL_FATAL,array(''));
				return;
			}
		}
		$selectedDateHash[$shoppingProductUnitObject->unit_id]	= $newHash;
		$request->setSession('shopping.order.selectedDateHash',$selectedDateHash,SPIDER_SESSION_SCOPE_GLOBAL);
		$request->setAttribute('shopping.order.selectedDateHash', $selectedDateHash);
	}
	/**
	 * モジュールの後処理を行います。
	 * @param $request spider_HttpRequestオブジェクト参照
	 */
	function post_process( & $request ) {
	}
}
?>