<?php
/*
 * shopping/order/SaveSettlePrice.class.php
 * 
 * CopyRight(C) 2010 Shopformer Development Team. All Right Reserved
 * URL: http://sourceforge.jp/projects/shopformer/
 * 
 * 
 * Mail: m_nakashima@users.sourceforge.jp
 * Auther: Masanori Nakashima
 * Last Update: 2010-06-18
 */
require_once( dirname(dirname(__FILE__))
.DIRECTORY_SEPARATOR.'PackageConfig.class.php' );
class shopping_order_SaveSettlePrice extends system_login_ModuleBase {
	function shopping_order_SaveSettlePrice() {
		array_push($this->require_module_array,'database2.Transaction');
		array_push($this->require_module_array,'shopping.order.settlement.LoadList');
	}
	function execute( & $request ) {
		$dbo			= $request->getAttribute( 'dbo' );
		$orderId		= $request->getParam('order_id','post');
		$settlePrice	= $request->getParam('settle_price','post');
		$settleDate		= $request->getParam('settle_date','post');
		$loginUserObject	= $this->getLoginUserObject( $request );
		if( strlen($orderId) == 0 ) {
			$request->addLocaledError('shopping.error.order.required',SPIDER_LOG_LEVEL_ERROR,array(''));
		} else if( strlen($settlePrice) == 0 ) {
			$request->addLocaledError('shopping.error.cart.admin.settledprice.required',SPIDER_LOG_LEVEL_ERROR,array(''));
		} else if( preg_match('/^[0-9]{1,6}$/',$settlePrice) == 0 ) {
			$request->addLocaledError('shopping.error.cart.admin.settledprice.invalid',SPIDER_LOG_LEVEL_ERROR,array(''));
		} else if( strlen($settleDate) > 0 && preg_match('/[0-9]{4}\\-[0-9]{1,2}-[0-9]{1,2}(|\s[0-9]{1,2}:[0-9]{1,2})/',$settleDate) == 0 ){
			$request->addLocaledError('shopping.error.cart.admin.settleddate.invalid',SPIDER_LOG_LEVEL_ERROR,array(''));
		} else if( strlen($settleDate) > 0 && strtotime($settleDate) <= 0 ){
			$request->addLocaledError('shopping.error.cart.admin.settleddate.invalid',SPIDER_LOG_LEVEL_ERROR,array(''));
		} else {
			$shoppingOrderObject	= spider_Controller::createObject('shopping_DaoShoppingOrder');
			if( $dbo->loadById( $shoppingOrderObject, $orderId, true ) ) {
				$oldSettlePrice	= $shoppingOrderObject->settle_price;
				$operationType	= 0;
				if( !$request->isError() ) {
					$operationType	= $shoppingOrderObject->confirmModifyPermittion( $request, $loginUserObject );
				}
				if( $operationType == 0 || $operationType == 2 ) {
					$request->addLocaledError('system.error.login.user.noauthexec',SPIDER_LOG_LEVEL_ERROR,array());
				} else {
					// 読み込みができたら支払済み金額カラムに適用
					$shoppingOrderObject->settle_price	= $settlePrice;
					if( strlen($settleDate)== 0 ){
						$shoppingOrderObject->settle_date		= date('Y-m-d H:i:s');
					} else {
						$shoppingOrderObject->settle_date		= $settleDate;
					}
					// 金額の再計算
					$shoppingOrderObject->calculate( $request, true );
					// 履歴テキストの追記
					$historyNote	= '\\'.number_format($oldSettlePrice)
					.' -> \\'.number_format($shoppingOrderObject->settle_price)
					.'に変更され、お支払いが必要な残額が\\'.number_format($shoppingOrderObject->payment_total-$shoppingOrderObject->settle_price)
					.'になりました。';
					// 更新日と状態の変更
					$shoppingOrderObject->updated_date	= date('Y-m-d H:i:s');
					if( $dbo->update( $shoppingOrderObject ) ) {
						if(!$shoppingOrderObject->writeHistoryNote( $request, '支払済金額変更', $historyNote, '', $loginUserObject )){
							$request->addLocaledError('shopping.error.order.failtohistory',SPIDER_LOG_LEVEL_FATAL,array(''));
						}
					} else {
						$request->addLocaledError('shopping.error.order.save',SPIDER_LOG_LEVEL_FATAL,array(''));
					}
				}
			} else {
				$request->addLocaledError('shopping.error.order.notfound',SPIDER_LOG_LEVEL_FATAL,array(''));
			}
			$request->setAttribute('shopping.order.shoppingOrderObject',	$shoppingOrderObject );
		}
	}
}
?>