<?php
/*
 * shopping/category/Execute.class.php
 * 
 * CopyRight(C) 2010 Shopformer Development Team. All Right Reserved
 * URL: http://sourceforge.jp/projects/shopformer/
 * 
 * 
 * Mail: m_nakashima@users.sourceforge.jp
 * Auther: Masanori Nakashima
 * Last Update: 2010-02-12
 * 
 */
require_once( dirname(dirname(__FILE__))
.DIRECTORY_SEPARATOR.'PackageConfig.class.php' );
require_once( dirname(dirname(dirname(__FILE__)))
.DIRECTORY_SEPARATOR.'system'
.DIRECTORY_SEPARATOR.'login'
.DIRECTORY_SEPARATOR.'ModuleBase.class.php');
require_once( dirname(dirname(dirname(__FILE__)))
.DIRECTORY_SEPARATOR.'content'
.DIRECTORY_SEPARATOR.'Uploader.class.php');
require_once( dirname(dirname(__FILE__))
.DIRECTORY_SEPARATOR.'DaoShoppingCategory.class.php');
class shopping_category_Execute extends system_login_ModuleBase {
	
	function shopping_category_Execute(){
		array_push($this->require_module_array,'database2.Connect');
	}
	function execute( & $request ) {
		
		$dbo						= $request->getAttribute( 'dbo' );
		$shoppingCategoryNumber		= stripslashes( $_GET['shpcn'] );
		$sessionObjectName			= 'shopping.category.modify.object.'.$shoppingCategoryNumber;
		$sessionConfirmName			= 'shopping.category.modify.confirm.'.$shoppingCategoryNumber;
		$shoppingCategoryObject		= $request->getSession($sessionObjectName);
		$confirmResult				= $request->getSession($sessionConfirmName);
		$loginUserObject			= $this->getLoginUserObject( $request );
		
		if( 'OK' != $confirmResult ) {
			$request->addLocaledError('system.error.common.session.timeout',SPIDER_LOG_LEVEL_ERROR,array());
		} else if ( 'shopping_daoshoppingcategory' != strtolower(get_class($shoppingCategoryObject)) ){
			$request->addLocaledError('system.error.common.session.timeout',SPIDER_LOG_LEVEL_ERROR,array());
		} else {
			$compareShoppingCategoryObject	= spider_Controller::createObject('shopping_DaoShoppingCategory');
			if( $dbo->loadById( $compareShoppingCategoryObject, $shoppingCategoryObject->category_id ) ) {
				if( $shoppingCategoryObject->category_number != $compareShoppingCategoryObject->category_number ) {
				$request->addLocaledError('shopping.error.category.duplicated',SPIDER_LOG_LEVEL_FATAL,array());
				}
			}
			if( !$request->isError() ) {
				// ログインしている場合としていない場合の振り分け
				if( $this->isLogin( $request ) ) {
					// ログインしているなら編集ユーザーのユニークIDを設定
					$shoppingCategoryObject->modifier_id	= $loginUserObject->getUniqueId();
				}
				if( strlen(trim($shoppingCategoryObject->category_number)) > 0 ) {
					// カテゴリ番号が設定済みなら更新
					$shoppingCategoryObject->updated_date	= date('Y-m-d H:i:s');
					if( $dbo->update($shoppingCategoryObject,true) ) {
						// ファイルアップロード完了処理
						if( is_object($shoppingCategoryObject->contentUploader)
							&& 'content_uploader' == strtolower(get_class($shoppingCategoryObject->contentUploader)) ) {
							$categoryId	= $shoppingCategoryObject->category_id;
							// カテゴリ画像は10個までとする
							$fileNameArray	= array();
							for( $num=0; $num<10; $num++ ){
								array_push($fileNameArray,$categoryId.'_'.sprintf('%02d',$num).'.jpg');
							}
							$shoppingCategoryObject->contentUploader->uploadExecute( $request, $fileNameArray );
						}
					} else {
						$request->addLocaledError('database2.error.update',SPIDER_LOG_LEVEL_ERROR,array());
					}
				} else {
					// カテゴリ番号がないなら新規挿入
					if( $this->isLogin( $request ) ) {
						// ログインしているならオーナーユーザーのユニークIDを設定
						$shoppingCategoryObject->owner_id	= $loginUserObject->getUniqueId();
					}
					$shoppingCategoryObject->updated_date		= date('Y-m-d H:i:s');
					$shoppingCategoryObject->registered_date	= date('Y-m-d H:i:s');
					if ( strlen(trim($shoppingCategoryObject->category_id)) == 0 ) {
						// カテゴリIDが未入力の場合、IDを自動生成する
						if( !$dbo->setNextId( $shoppingCategoryObject, 'SCHCA{num:5}' ) ) {
							$request->addLocaledError('database2.error.setnextid',SPIDER_LOG_LEVEL_ERROR,array());
						}
					}
					if( !$request->isError() ) {
						// エラーがなければ、インサート
						if( $dbo->insert($shoppingCategoryObject) ){
							// ファイルアップロード完了処理
							if( is_object($shoppingCategoryObject->contentUploader)
								&& 'content_uploader' == strtolower(get_class($shoppingCategoryObject->contentUploader)) ) {
								$categoryId	= $shoppingCategoryObject->category_id;
								// カテゴリ画像は10個までとする
								$fileNameArray	= array();
								for( $num=0; $num<10; $num++ ){
									array_push($fileNameArray,$categoryId.'_'.sprintf('%02d',$num).'.jpg');
								}
								$shoppingCategoryObject->contentUploader->uploadExecute( $request, $fileNameArray );
							}
						} else {
							$request->addLocaledError('database2.error.common',SPIDER_LOG_LEVEL_ERROR,array($shoppingCategoryObject->error_sql));
						}
					}
				}
				// エラーがないなら順序押し出し
				if( !$request->isError() ) {
					$sql	= 'UPDATE '.TABLE_NAME_SHOPPING_CATEGORY.' SET order_number=order_number+1'
					.' WHERE category_id<>'.$dbo->quote($shoppingCategoryObject->category_id)
					.' AND order_number>='.$shoppingCategoryObject->order_number;
					if( strlen($shoppingCategoryObject->parent_id) > 0 ){
						$sql	.= ' AND parent_id='.$dbo->quote($shoppingCategoryObject->parent_id);
					} else {
						$sql	.= ' AND ( parent_id IS NULL OR parent_id='.$dbo->quote('').' )';
					}
					$dbo->query($sql);
				}
			}
		}
		$request->removeSession($sessionObjectName);
		$request->removeSession($sessionConfirmName);
		$request->setAttribute('shopping.category.category_object',		$shoppingCategoryObject);
		$request->setAttribute('shopping.category.require_columns_hash',	$GLOBALS['SHOPPING_CATEGORY_REQUIRE_COLUMNS_HASH']);
		$request->setAttribute('shopping.category.regist_permit_hash',	$GLOBALS['REGIST_PERMIT_HASH']);
	}
}
?>