<?php
/*
 * shopping/category/Delete.class.php
 * 
 * CopyRight(C) 2010 Shopformer Development Team. All Right Reserved
 * URL: http://sourceforge.jp/projects/shopformer/
 * 
 * 
 * Mail: m_nakashima@users.sourceforge.jp
 * Auther: Masanori Nakashima
 * Last Update: 2010-02-12
 * 
 */
require_once( dirname(dirname(dirname(__FILE__)))
.DIRECTORY_SEPARATOR.'system'
.DIRECTORY_SEPARATOR.'login'
.DIRECTORY_SEPARATOR.'ModuleBase.class.php');
require_once( dirname(dirname(__FILE__))
.DIRECTORY_SEPARATOR.'PackageConfig.class.php' );
require_once( dirname(dirname(__FILE__))
.DIRECTORY_SEPARATOR.'DaoShoppingCategory.class.php' );
class shopping_category_Delete extends system_login_ModuleBase {
	
	function shopping_category_Delete(){
		array_push($this->require_module_array,'database2.Connect');
	}
	function execute( & $request ) {
		
		$dbo						= $request->getAttribute( 'dbo' );
		$categoryNumber	= $request->getParam('category_number');
		$shoppingCategoryObject	= spider_Controller::createObject('shopping_DaoShoppingCategory');
		$loginUserObject				= $this->getLoginUserObject( $request );
		
		// セッションにないなら作成する
		if( strlen(trim($categoryNumber)) > 0 ) {
			// IDが指定されているなら編集のため読み込み
			if( $dbo->loadByNumber( $shoppingCategoryObject, $categoryNumber ) ){
				$shoppingCategoryObject->modifier_id	= $loginUserObject->getUniqueId();
				// IDが存在するなら削除処理
				// 商品との関連付けは全て削除する
				$sql = 'DELETE FROM '.TABLE_NAME_SHOPPING_CATEGORY_DATA
				.' WHERE category_id='.$dbo->quote($shoppingCategoryObject->category_id);
				$dbo->query($sql);
				// カテゴリIDは再利用可能にする為削除時に変更
				$shoppingCategoryObject->category_id = 'SDELETED'.sprintf('%08d',$categoryNumber);
				$shoppingCategoryObject->status_flag	= 255;
				$shoppingCategoryObject->updated_date	= date('Y-m-d H:i:s');
				if( $dbo->update( $shoppingCategoryObject,true ) ) {
				} else {
					$request->addLocaledError('database2.error.delete',SPIDER_LOG_LEVEL_FATAL,array());
				}
			} else {
				$request->addLocaledError('shopping.error.category.notfound',SPIDER_LOG_LEVEL_FATAL,array());
			}
		} else {
			// IDが指定されていないならエラー
			$request->addLocaledError('shopping.error.category.selectcategory',SPIDER_LOG_LEVEL_FATAL,array());
		}
		$request->setAttribute('shopping.category.category_object',		$shoppingCategoryObject);
		$request->setAttribute('shopping.category.require_columns_hash',	$GLOBALS['SHOPPING_CATEGORY_REQUIRE_COLUMNS_HASH']);
		$request->setAttribute('shopping.category.regist_permit_hash',	$GLOBALS['REGIST_PERMIT_HASH']);
	}
}
?>