<?php
/*
 * shopping/category/Delete.class.php
 * 
 * CopyRight(C) 2010 Shopformer Development Team. All Right Reserved
 * URL: http://sourceforge.jp/projects/shopformer/
 * 
 * 
 * Mail: m_nakashima@users.sourceforge.jp
 * Auther: Masanori Nakashima
 * Last Update: 2010-02-12
 * 
 */
require_once( dirname(dirname(__FILE__))
.DIRECTORY_SEPARATOR.'PackageConfig.class.php' );
class shopping_category_ChangeOrder extends system_login_ModuleBase {
	
	function shopping_category_ChangeOrder(){
		array_push($this->require_module_array,'database2.Connect');
		array_push($this->require_module_array,'shopping.category.LoadList');
	}
	function execute( & $request ) {
		$dbo						= $request->getAttribute( 'dbo' );
		$categoryId			= $request->getParam('category_id','post');
		$moveDirection	= $request->getParam('direction','post');
		$loginUserObject	= $this->getLoginUserObject( $request );
		$objectHash			= $request->getAttribute('shopping.category.objectHash');
		if( is_array($objectHash) && isset($objectHash[$categoryId]) ){
			$targetCategory	= $objectHash[$categoryId];
			// 親があるなら親を取得
			if( strlen($targetCategory->parent_id) > 0 ){
				// 同じ親カテゴリのカテゴリを取り出し
				if( !is_object($targetCategory->parent_category_object) ){
					$dbo->loadById($targetCategory->parent_category_object,$targetCategory->parent_id);
				}
				$parentCategory	= & $targetCategory->parent_category_object;
				$parentCategory->_load_optional_data( $dbo, true, false );
				$targetOrder	= 0;
				foreach( $parentCategory->child_category_object_array as $orderNumber => $childCategoryObject ){
					if( $categoryId == $childCategoryObject->category_id ){
						// 対象カテゴリの現在の並び順を取得
						$targetOrder	= $orderNumber;
						break;
					}
				}
				foreach( $parentCategory->child_category_object_array as $orderNumber => $childCategoryObject ){
					if( preg_match('/^[dD][oO][wW][nN]$/',$moveDirection) > 0 ){
						// 下方移動
						$sql	= 'UPDATE '.TABLE_NAME_SHOPPING_CATEGORY.' SET order_number=';
						if( $orderNumber == $targetOrder ){
							$sql	.= ($orderNumber + 1);
						} else if( $orderNumber == $targetOrder + 1 ){
							$sql	.= ($orderNumber - 1);
						} else {
							$sql	.= $orderNumber;
						}
						$sql	.= ' WHERE category_id='.$dbo->quote($childCategoryObject->category_id);
						$dbo->query($sql);
					} else {
						// それ以外は上方移動
						$sql	= 'UPDATE '.TABLE_NAME_SHOPPING_CATEGORY.' SET order_number=';
						if( $orderNumber == $targetOrder ){
							$sql	.= ($orderNumber - 1);
						} else if( $orderNumber == $targetOrder - 1 ){
							$sql	.= ($orderNumber + 1);
						} else {
							$sql	.= $orderNumber;
						}
						$sql	.= ' WHERE category_id='.$dbo->quote($childCategoryObject->category_id);
						$dbo->query($sql);
					}
				}
			} else {
				// 親がない場合はルートカテゴリの配列を操作
				$categoryObjectArray	= $request->getAttribute('shopping.category.data_array');
				foreach( $categoryObjectArray as $orderNumber => $categoryObject ){
					if( $categoryId == $categoryObject->category_id ){
						// 対象カテゴリの現在の並び順を取得
						$targetOrder	= $orderNumber;
						break;
					}
				}
				foreach( $categoryObjectArray as $orderNumber => $categoryObject ){
					if( preg_match('/^[dD][oO][wW][nN]$/',$moveDirection) > 0 ){
						// 下方移動
						$sql	= 'UPDATE '.TABLE_NAME_SHOPPING_CATEGORY.' SET order_number=';
						if( $orderNumber == $targetOrder ){
							$sql	.= ($orderNumber + 1);
						} else if( $orderNumber == $targetOrder + 1 ){
							$sql	.= ($orderNumber - 1);
						} else {
							$sql	.= $orderNumber;
						}
						$sql	.= ' WHERE category_id='.$dbo->quote($categoryObject->category_id);
						$dbo->query($sql);
					} else {
						// それ以外は上方移動
						$sql	= 'UPDATE '.TABLE_NAME_SHOPPING_CATEGORY.' SET order_number=';
						if( $orderNumber == $targetOrder ){
							$sql	.= ($orderNumber - 1);
						} else if( $orderNumber == $targetOrder - 1 ){
							$sql	.= ($orderNumber + 1);
						} else {
							$sql	.= $orderNumber;
						}
						$sql	.= ' WHERE category_id='.$dbo->quote($categoryObject->category_id);
						$dbo->query($sql);
					}
				}
			}
		}
	}
}
?>