<?php
/*
 * member/package_define.inc.php
 * 
 * CopyRight(C) 2010 Shopformer Development Team. All Right Reserved
 * URL: http://sourceforge.jp/projects/shopformer/
 * 
 * 
 * Mail: m_nakashima@users.sourceforge.jp
 * Auther: Masanori Nakashima
 * Last Update: 2010-06-18
 */
/**
 * 会員管理パッケージ 定義ファイル
 * 
 * @package member 会員管理パッケージ
 * @version 1.1.00
 * @author  <m_nakashima@users.sourceforge.jp>
 * @since PHP 4.3
 */
/** パッケージバージョン	*/
define('MEMBER_VERSION', '1.1.00');
/** 会員テーブル	*/
define('TABLE_NAME_MEMBER', 'member' );
/** 会員情報履歴テーブル	*/
define('TABLE_NAME_MEMBER_HISTORY', 'member_history' );
/** 会員オプションテーブル	*/
define('TABLE_NAME_MEMBER_OPTION', 'member_option' );
/** 会員オプション履歴テーブル	*/
define('TABLE_NAME_MEMBER_OPTION_HISTORY', 'member_option_history' );
/** ログイン履歴テーブル	*/
define('TABLE_NAME_MEMBER_LOGIN_HISTORY', 'member_login_history' );
/** ポイント履歴テーブル	*/
define('TABLE_NAME_MEMBER_POINT_HISTORY', 'member_point_history' );
/** メールアドレス保存用一時テーブル	*/
define('TABLE_NAME_MEMBER_REGIST_TEMPORARY',	'member_regist_temporary' );
/** 振込先銀行口座テーブル	*/
define('TABLE_NAME_MEMBER_BANK_ACCOUNT', 'member_bank_account' );

/** メンバーメールテーブル	*/
define('TABLE_NAME_MEMBER_MAIL', 'member_mail' );
/** メンバーメール関連テーブル	*/
define('TABLE_NAME_MEMBER_MAIL_LOG', 'member_mail_log' );
/** メンバーメールテンプレートテーブル	*/
define('TABLE_NAME_MEMBER_MAIL_TEMPLATE', 'member_mail_template' );
/** メンバーメールテンプレート履歴テーブル	*/
define('TABLE_NAME_MEMBER_MAIL_TEMPLATE_HISTORY', 'member_mail_template_history' );
/** メンバーメール メールマガジン種別テーブル	*/
define('TABLE_NAME_MEMBER_MAIL_REJECT', 'member_mail_reject' );
/** メンバーメール メールマガジン種別履歴テーブル	*/
define('TABLE_NAME_MEMBER_MAIL_REJECT_HISTORY', 'member_mail_reject_history' );
/** メンバーメール メールマガジン種別メンバーテーブル	*/
define('TABLE_NAME_MEMBER_MAIL_REJECT_MEMBER', 'member_mail_reject_member' );
/** メンバーメール メールマガジン種別メンバー履歴テーブル	*/
define('TABLE_NAME_MEMBER_MAIL_REJECT_MEMBER_HISTORY', 'member_mail_reject_member_history' );

/** メンバー対応履歴テーブル	*/
define('TABLE_NAME_MEMBER_CORRESPOND', 'member_correspond' );
/** メンバー対応履歴コメントテーブル	*/
define('TABLE_NAME_MEMBER_CORRESPOND_COMMENT', 'member_correspond_comment' );

/** 会員エラー記録テーブル	*/
define ( 'TABLE_NAME_MEMBER_ERROR_COUNT', 'member_error_count' );

/** 会員選択リストのセッション名称	*/
define('MEMBER_SESSION_NAME_SELECTED_LIST', 'member.selected_array' );
/** メール送信確認フラグのセッション名称	*/
define('MEMBER_SESSION_NAME_SENDMAIL_CONFIRM_RESULT', 'member.mail.confirm_result' );
/** メール送信対象会員リストのセッション名称	*/
define('MEMBER_SESSION_NAME_SENDMAIL_LIST', 'member.mail.member_id_array' );
/** メール送信対象メール種別のセッション名称	*/
define('MEMBER_SESSION_NAME_SENDMAIL_TARGET_MAIL', 'member.mail.target_mail' );
/** メール件名のセッションオブジェクト	*/
define('MEMBER_SESSION_NAME_SENDMAIL_SUBJECT', 'member.mail.subject' );
/** メール本文のセッションオブジェクト	*/
define('MEMBER_SESSION_NAME_SENDMAIL_BODY', 'member.mail.body' );
/** メール送信ログファイルパスのセッション名称	*/
define('MEMBER_SESSION_NAME_SENDMAIL_FILE_PATH_LOG', 'member.mail.file_path_log' );
/** メール送信 マガジンオブジェクトのセッション名称	*/
define('MEMBER_SESSION_NAME_MAIL_OBJECT', 'member.mail.mail_object' );

/** 会員検索SQL文のセッション名称	*/
define('MEMBER_SESSION_NAME_LOADCOUNT_QUERY', 'member.loadcount.query' );
/** 会員検索SQL文のセッション名称	*/
define('MEMBER_SESSION_NAME_LOADLIST_QUERY', 'member.loadlist.query' );
/** セッション名称:最後に実行した検索結果ページURI	*/
define('MEMBER_SESSION_NAME_LAST_SEARCH_LIST_URI','member.loadlist.lastUri');

/** 送信ＰＩＤ	*/
define('MEMBER_MAIL_FILE_PATH_DELIVERY_RUNNING_PID',	DIR_PATH_TMP.DIRECTORY_SEPARATOR.'member.mail.deliverypid');

/** 会員種別ハッシュ	*/
$GLOBALS['MEMBER_MEMBER_CLASS_HASH']	= array(
	'0'	=> '非会員',
	'1'	=> '正規会員',
);
/** 登録項目→フィールド配列	*/
$GLOBALS['MEMBER_MEMBER_RESIT_ITEM_FIELD_HASH']	= array(
	'name'				=> array('family_name','first_name'),
	'name_kana'		=> array('family_kana','first_kana'),
	'zip_code'			=> array('zip_code','zip_code_pre','zip_code_pst'),
	'prefecture'		=> array('prefecture_number'),
	'address'			=> array('address','building'),
	'telephone'		=> array('telephone_number'),
	'faximili'			=> array('faximili_number'),
	'zip_code2'		=> array('zip_code2','zip_code_pre2','zip_code_pst2'),
	'prefecture2'		=> array('prefecture_number2'),
	'address2'			=> array('address2','building2'),
	'telephone2'		=> array('telephone_number2'),
	'faximili2'		=> array('faximili_number2'),
	'mobile'			=> array('mobile_number'),
	'company_name'	=> array('company_name'),
	'section_name'	=> array('section_name'),
	'sex'				=> array('sex'),
	'birth_year'		=> array('birth_year'),
	'birth_month'		=> array('birth_month'),
	'birth_day'		=> array('birth_day'),
	'blood_type'		=> array('blood_type'),
	'height'		=> array('height'),
	'weight'		=> array('weight'),
	'bwh'		=> array('bwh'),
);
/** 登録必須項目→フィールド配列	*/
$GLOBALS['MEMBER_MEMBER_REQUIRE_ITEM_FIELD_HASH']	= array(
	'name'				=> array('family_name'=>'姓','first_name'=>'名'),
	'name_kana'		=> array('family_kana'=>'姓フリガナ','first_kana'=>'名フリガナ'),
	'zip_code'			=> array('zip_code'=>'郵便番号'),
	'prefecture'		=> array('prefecture_number'=>'都道府県'),
	'address'			=> array('address'=>'住所'),
	'telephone'		=> array('telephone_number'=>'電話番号'),
	'faximili'			=> array('faximili_number'=>'FAX番号'),
	'zip_code2'		=> array('zip_code2'=>'郵便番号2'),
	'prefecture2'		=> array('prefecture_number2'=>'都道府県2'),
	'address2'			=> array('address2'=>'住所2'),
	'telephone2'		=> array('telephone_number2'=>'電話番号2'),
	'faximili2'		=> array('faximili_number2'=>'FAX番号2'),
	'mobile'			=> array('mobile_number'=>'携帯電話番号'),
	'company_name'	=> array('company_name'=>'会社名'),
	'section_name'	=> array('section_name'=>'部署名'),
	'sex'				=> array('sex'=>'性別'),
	'birth_year'		=> array('birth_year'=>'生年'),
	'birth_month'		=> array('birth_month'=>'生月'),
	'birth_day'		=> array('birth_day'=>'生日'),
	'blood_type'		=> array('blood_type'=>'血液型'),
	'height'		=> array('height'=>'身長'),
	'weight'		=> array('weight'=>'体重'),
	'bwh'		=> array('bwh'=>'バスト/ウエスト/ヒップ'),
);
/** 性別ハッシュ	*/
$GLOBALS['MEMBER_MEMBER_SEX_HASH']	= array(
	0	=> '秘密',
	1	=> '女性',
	2	=> '男性',
);
/** 血液型ハッシュ	*/
$GLOBALS['MEMBER_MEMBER_BLOOD_TYPE_HASH']	= array(
	0	=> '秘密',
	1	=> 'A',
	2	=> 'B',
	3	=> 'O',
	4	=> 'AB',
);
/** CSVアップロード：CSVファイル文字コード判断順序	*/
define( 'MEMBER_UPLOAD_CHARSET_ORDER_IMPORT_CSV', 'UTF-8,SJIS-win,EUC-JP,SJIS' );
/** CSVアップロード：アップロード最大レコード数	*/
define( 'MEMBER_UPLOAD_MAX_TOTAL_COUNT', 1000 );
/** CSVアップロード一時ディレクトリパス	*/
define( 'MEMBER_DIR_PATH_UPLOAD_CSV_TMP', DIR_PATH_TMP. DIRECTORY_SEPARATOR.'member.upload.csv' );
/** セッション名：検索用CSVアップロードファイルURI	*/
define( 'MEMBER_SESSION_NAME_UPLOAD_CSV_FILE_URI', 'member.upload.file_uri' );
/** セッション名：検索用CSVアップロード確認結果	*/
define( 'MEMBER_SESSION_NAME_UPLOAD_CSV_CONFIRM_RESULT', 'member.upload.confirm_result' );
/** セッション名：検索用CSVアップロードトータル件数	*/
define( 'MEMBER_SESSION_NAME_UPLOAD_CSV_TOTAL_COUNT', 'member.upload.total_count' );
/** セッション名：検索用CSVアップロード現在の処理開始オフセット(実行時)	*/
define( 'MEMBER_SESSION_NAME_UPLOAD_CURRENT_OFFSET_CONFIRM', 'member.upload.confirm.current_offset' );
/** セッション名：検索用CSVアップロード現在の処理開始オフセット(実行時)	*/
define( 'MEMBER_SESSION_NAME_UPLOAD_CURRENT_OFFSET_EXECUTE', 'member.upload.execute.current_offset' );
/** セッション名：検索用CSVアップロード現在の処理開始オフセット(実行時)	*/
define( 'MEMBER_SESSION_NAME_UPLOAD_EXECUTE_COUNT_AT_ONCE', 50 );
/** セッション名：検索用CSVアップロード取り込みカラム定義配列	*/
define( 'MEMBER_SESSION_NAME_UPLOAD_CSV_COLUMN_DEFINITION', 'member.upload.column_definition' );

/** CSVダウンロード一時ディレクトリパス	*/
define( 'MEMBER_DIR_PATH_DOWNLOAD_CSV_TMP', DIR_PATH_TMP. DIRECTORY_SEPARATOR.'member.download.csv' );
/** セッション名：検索用CSVダウンロードファイルURI	*/
define( 'MEMBER_SESSION_NAME_DOWNLOAD_CSV_FILE_URI', 'member.download.file_uri' );
/** セッション名：検索用CSVダウンロード出力カラム定義配列	*/
define( 'MEMBER_SESSION_NAME_DOWNLOAD_CSV_COLUMN_DEFINITION', 'member.download.column_definition' );
/** CSVダウンロード:セッション名称 CSVファイル作成オフセット	*/
define( 'MEMBER_SESSION_NAME_DOWNLOAD_CSV_OFFSET', 'member.download.offset' );
/** CSVダウンロード:セッション名称 CSV作成処理数/req	*/
define( 'MEMBER_DOWNLOAD_WORK_AT_ONCE', 25 );

/** CSVアップロード必須項目キー配列	*/
$GLOBALS['MEMBER_UPLOAD_REQUIRED_COLUMN_DEFINITION']	= array(
	'member_member_id'
	,'member_family_name'
);

/** 個人情報の呼称	*/
if( !isset($GLOBALS['MEMBER_PERSONAL_LABEL']) ) {
$GLOBALS['MEMBER_PERSONAL_LABEL']	= '会員';
}

/** 携帯メールアドレスドメイン名	*/
$GLOBALS['MEMBER_MOBILE_MAIL_DOMAIN_ARRAY'] = array(
	'docomo.ne.jp'
	,'ezweb.ne.jp'
	,'yy.ezweb.ne.jp'
	,'t.vodafone.ne.jp'
	,'d.vodafone.ne.jp'
	,'h.vodafone.ne.jp'
	,'c.vodafone.ne.jp'
	,'r.vodafone.ne.jp'
	,'k.vodafone.ne.jp'
	,'n.vodafone.ne.jp'
	,'s.vodafone.ne.jp'
	,'q.vodafone.ne.jp'
	,'softbank.ne.jp'
	,'disney.ne.jp'
	,'i.softbank.jp'
);
/** CSVアップロード用デフォルトカラム定義	*/
$GLOBALS['MEMBER_UPLOAD_COLUMN_DEFINITION']	= array(
	'member_id'				=> '1'
	,'member_class'			=> '2'
	,'login_id'				=> '3'
	,'login_password'			=> '4'
	,'view_name'				=> '5'
	,'family_name'			=> '6'
	,'family_kana'			=> '7'
	,'first_name'				=> '8'
	,'first_kana'				=> '9'
	,'pc_mail'					=> '10'
	,'mb_mail'					=> '11'
	,'sex'						=> '12'
	,'blood_type'				=> '13'
	,'birth_year'				=> '14'
	,'birth_month'			=> '15'
	,'birth_day'				=> '16'
	,'description'			=> '17'
	,'zip_code'				=> '18'
	,'prefecture_number'		=> '19'
	,'address'					=> '20'
	,'building'				=> '21'
	,'telephone_number'		=> '22'
	,'faximili_number'		=> '23'
	,'mobile_number'			=> '24'
	,'zip_code2'				=> '25'
	,'prefecture_number2'	=> '26'
	,'address2'				=> '27'
	,'building2'				=> '28'
	,'telephone_number2'		=> '29'
	,'faximili_number2'		=> '30'
	,'company_name'			=> '31'
	,'section_name'			=> '32'
	,'point'					=> '33'
	,'status_flag'					=> '34'
);

/** CSVアップロード用カラム名称定義	*/
$GLOBALS['MEMBER_UPLOAD_COLUMN_NAME_DEFINITION']	= array(
	'member_id'				=> '会員ID'
	,'member_class'			=> '種別'
	,'login_id'				=> 'ログインID'
	,'login_password'			=> 'ログインパスワード'
	,'view_name'				=> 'ニックネーム'
	,'family_name'			=> '姓'
	,'family_kana'			=> '姓フリガナ'
	,'first_name'				=> '名'
	,'first_kana'				=> '名フリガナ'
	,'pc_mail'					=> 'PCメールアドレス'
	,'mb_mail'					=> '携帯メールアドレス'
	,'sex'						=> '性別'
	,'blood_type'				=> '血液型'
	,'birth_year'				=> '生年'
	,'birth_month'			=> '生月'
	,'birth_day'				=> '生日'
	,'description'			=> '備考'
	,'zip_code'				=> '住所1 郵便番号'
	,'prefecture_number'		=> '住所1 都道府県'
	,'address'					=> '住所1 住所・番地'
	,'building'				=> '住所1 建物名・部屋番号'
	,'telephone_number'		=> '住所1 電話番号'
	,'faximili_number'		=> '住所1 FAX番号'
	,'mobile_number'			=> '携帯電話番号'
	,'zip_code2'				=> '住所2 郵便番号'
	,'prefecture_number2'	=> '住所2 都道府県'
	,'address2'				=> '住所2 住所・番地'
	,'building2'				=> '住所2 建物・部屋番号'
	,'telephone_number2'		=> '住所2 電話番号'
	,'faximili_number2'		=> '住所2 FAX番号'
	,'company_name'			=> '会社名'
	,'section_name'			=> '部署名'
	,'point'					=> '所持ポイント数'
	,'status_flag'					=> '状態'
);

if( file_exists(DIR_PATH_DATA.DIRECTORY_SEPARATOR.'member.define.inc.php') ) {
	require_once(DIR_PATH_DATA.DIRECTORY_SEPARATOR.'member.define.inc.php');
}

/** メール送信ステータス	*/
$GLOBALS['MEMBER_MAIL_DELIVERY_STATUS_HASH']	= array(
	0		=>'送信前',
	1		=>'正常送信済',
	101		=>'対象メールアドレスなし',
	102		=>'退会済',
	103		=>'拒否設定',
	104		=>'EL',
	105		=>'アドレス重複の為未配信',
	201		=>'送信エラー発生',
	204		=>'システム設定エラー',
	211		=>'エラー戻り',
	255		=>'削除',
);
/** 対応開始タイプ	*/
$GLOBALS['MEMBER_CORERSPOND_TYPE_HASH']	= array(
	'0'		=> '自己発信',
	'10'	=> $GLOBALS['MEMBER_PERSONAL_LABEL'].'発信',
);
/** お客様対応方法	*/
$GLOBALS['MEMBER_CORERSPOND_METHOD_HASH']	= array(
	'0'		=> 'メール',
	'10'	=> '電話',
	'20'	=> 'FAX',
	'30'	=> '郵送',
	'100'	=> '訪問',
	'110'	=> '来社',
	'200'	=> 'その他',
);
/** お客様対応カテゴリ	*/
$GLOBALS['MEMBER_CORRESPOND_CATEGORIES']	= array(
	'MCC001'	=> '全般的な問合せ',
	'MCC002'	=> '技術的な問合せ',
	'MCC003'	=> '経理関連の問合せ',
	'MCC004'	=> '制度・規約に関する問合せ',
	'MCC011'	=> '営業案内',
	'MCC012'	=> 'サービス案内',
	'MCC999'	=> 'その他',
);
/** 対応状態	*/
$GLOBALS['MEMBER_CORERSPOND_STATUS_HASH']	= array(
	'0'		=> '新規',
	'11'	=> '要次対応',
	'51'	=> '回答待ち',
	'101'	=> '完了',
	'255'	=> '削除',
);
/** 会員状態	*/
$GLOBALS['MEMBER_STATUS_HASH']	= array(
	'0'		=> '新規',
	'101'	=> '認証済',
	'251'	=> '削除(会員)',
	'255'	=> '削除(管理者)',
);

if( file_exists(DIR_PATH_DATA.DIRECTORY_SEPARATOR.'member.define.inc.php') ) {
	require_once(DIR_PATH_DATA.DIRECTORY_SEPARATOR.'member.define.inc.php');
}
?>