<?php
/*
 * member/member/reject/Execute.class.php
 * 
 * CopyRight(C) 2010 Shopformer Development Team. All Right Reserved
 * URL: http://sourceforge.jp/projects/shopformer/
 * 
 * 
 * Mail: m_nakashima@users.sourceforge.jp
 * Auther: Masanori Nakashima
 * Last Update: 2010-06-18
 */
require_once(dirname(dirname(dirname(__FILE__)))
.DIRECTORY_SEPARATOR.'PackageConfig.class.php');
/**
 * spider : 会員テーブル操作 ポイント編集実行用アクションモジュールクラス
 * 
 * @package member 会員管理パッケージ
 * @subpackage member 会員テーブル操作パッケージ
 * @version 1.0.0
 * @author  <m_nakashima@users.sourceforge.jp>
 * @since PHP 4.0
 */
class member_member_reject_Execute extends system_login_ModuleBase {
	function member_member_reject_Execute() {
		array_push($this->require_module_array,'database2.Connect');
		array_push( $this->require_module_array, 'member.mail.reject.LoadList' );
	}
	function execute( & $request ) {
		$dbo					= $request->getAttribute( 'dbo' );
		$memberId				= stripslashes( $_GET['mi'] );
		$temporaryId			= trim(stripslashes($_GET['tkey']));		
		$sessionObjectName		= 'member.member.reject.modify.object.'.$memberId;
		$sessionConfirmName		= 'member.member.reject.modify.confirm.'.$memberId;
		$memberObject			= $request->getSession($sessionObjectName);
		$compareMemberObject	= spider_Controller::createObject('member_DaoMember');
		$loginUserObject		= $this->getLoginUserObject( $request );
		$comfirmResult			= $request->getSession($sessionConfirmName);
		
		if( 'OK' != $comfirmResult ) {
			$request->addLocaledError('system.error.common.session.timeout',SPIDER_LOG_LEVEL_ERROR,array());
		} else if ( get_class($memberObject) != get_class($compareMemberObject) ){
			$request->addLocaledError('system.error.common.session.timeout',SPIDER_LOG_LEVEL_ERROR,array());
		} else {
			// 変更者のIDを登録
			$memberObject->modifier_id	= $loginUserObject->getUniqueId();
			$memberObject->convertKanaFields( 'KVa' );
			$memberObject->updated_date	= date('Y-m-d H:i:s');
			if( $memberObject->canEditData( $request, $loginUserObject ) ) {
				if( $this->lockData( $request, $memberObject ) ) {
					// 編集ロックを再取得できたら更新
					$memberObject->updated_date	= date('Y-m-d H:i:s');
					$errors	= array();
					if( $dbo->update($memberObject,true) ) {
					} else {
						$request->addLocaledError('database2.error.update',SPIDER_LOG_LEVEL_FATAL,array(""));
					}
					$this->unlockData( $request, $memberObject );
				} else {
					$request->addLocaledError('system.error.common.data.locked',SPIDER_LOG_LEVEL_FATAL,array(''));
				}
			} else {
				$request->addLocaledError('system.error.login.user.noauthexec',SPIDER_LOG_LEVEL_FATAL,array(''));
			}
		}
		$request->removeSession($sessionConfirmName);
		$request->removeSession($sessionObjectName);
		$request->setAttribute('member.member.reject.memberObject',$memberObject);
	}
}
?>