<?php
/*
 * member/mail/reject/Execute.class.php
 * 
 * CopyRight(C) 2010 Shopformer Development Team. All Right Reserved
 * URL: http://sourceforge.jp/projects/shopformer/
 * 
 * 
 * Mail: m_nakashima@users.sourceforge.jp
 * Auther: Masanori Nakashima
 * Last Update: 2010-06-18
 */
require_once(dirname(dirname(dirname(__FILE__)))
.DIRECTORY_SEPARATOR.'PackageConfig.class.php');
/**
 * spider : メンバーメール 配信メールマガジン種別作成実行用アクションモジュールクラス
 * 
 * @package member メンバー管理パッケージ
 * @subpackage mail メールパッケージ
 * @subpackage reject メールマガジン種別パッケージ
 * @version 1.0.0
 * @author  <m_nakashima@users.sourceforge.jp>
 * @since PHP 4.0
 */
class member_mail_reject_Execute extends system_login_ModuleBase {
	function member_mail_reject_Execute(){
		array_push($this->require_module_array,'database2.Connect');
	}
	function execute( & $request ) {
		
		$dbo						= $request->getAttribute( 'dbo' );

		$list_id					= stripslashes( $_GET['rli'] );
		$sessionObjectName		= 'member.mail.reject.modify.object.'.$list_id;
		$sessionConfirmName		= 'member.mail.reject.modify.confirm.'.$list_id;
		$rejectListObject			= $request->getSession($sessionObjectName);
		$confirm_result				= $request->getSession($sessionConfirmName);
		$loginUserObject			= $this->getLoginUserObject( $request );
		$compare_reject_list		= spider_Controller::createObject('member_DaoMemberMailReject');

		if( 'OK' != $confirm_result ) {
			$request->addLocaledError('system.error.common.session.timeout',SPIDER_LOG_LEVEL_ERROR,array());
		} else if ( get_class($rejectListObject) != get_class($compare_reject_list) ){
			$request->addLocaledError('system.error.common.session.timeout',SPIDER_LOG_LEVEL_ERROR,array());
		}
		if( !$request->isError() ) {
			if( strlen(trim($rejectListObject->list_id)) > 0 ) {
				if( $this->lockData( $request, $rejectListObject ) ) {
					// IDが設定済みなら更新
					$rejectListObject->modifier_id	= $loginUserObject->getUniqueId();
					$rejectListObject->updated_date	= date('Y-m-d H:i:s');
					if( $dbo->update($rejectListObject,true) ) {
					} else {
						$request->addLocaledError('database2.error.update',SPIDER_LOG_LEVEL_FATAL,array(''));
					}
					// エラー有無に関わらずロックを解除
					$this->unlockData( $request, $rejectListObject );
				}
			} else {
				// IDがないなら新規挿入
				$rejectListObject->owner_id		= $loginUserObject->getUniqueId();
				$rejectListObject->modifier_id	= $loginUserObject->getUniqueId();
				$rejectListObject->updated_date		= date('Y-m-d H:i:s');
				$rejectListObject->registered_date	= date('Y-m-d H:i:s');
				if( !is_null( $loginUserObject ) && strlen( $loginUserObject->getUniqueId() ) > 0 ) {
					// 管理者ログインからの登録なら管理者IDを登録しておく
					$rejectListObject->owner_id	= $loginUserObject->getUniqueId();
				}
				if( !$dbo->setNextId($rejectListObject,'MMRA{num:4}') ) {
					$request->addLocaledError('database2.error.setnextid',SPIDER_LOG_LEVEL_FATAL,array(''));
				} else {
					if( $dbo->insert($rejectListObject) ){
					} else {
						$request->addLocaledError('database2.error.insert',SPIDER_LOG_LEVEL_FATAL,array(''));
					}
				}
			}
		}
		$request->removeSession($sessionConfirmName);
		$request->removeSession($sessionObjectName);
		$request->setAttribute('member.mail.reject.reject_list_object',$rejectListObject);

	}
}
?>