<?php
/*
 * member/mail/reject/Delete.class.php
 * 
 * CopyRight(C) 2010 Shopformer Development Team. All Right Reserved
 * URL: http://sourceforge.jp/projects/shopformer/
 * 
 * 
 * Mail: m_nakashima@users.sourceforge.jp
 * Auther: Masanori Nakashima
 * Last Update: 2010-06-18
 */
require_once(dirname(dirname(dirname(__FILE__)))
.DIRECTORY_SEPARATOR.'PackageConfig.class.php');
/**
 * spider : メンバーメール 配信メールマガジン種別削除用アクションモジュールクラス
 * 
 * @package member メンバー管理パッケージ
 * @subpackage mail メールパッケージ
 * @subpackage reject メールマガジン種別パッケージ
 * @version 1.0.0
 * @author  <m_nakashima@users.sourceforge.jp>
 * @since PHP 4.0
 */
class member_mail_reject_Delete extends system_login_ModuleBase {
	function member_mail_reject_Delete(){
		array_push($this->require_module_array,'database2.Connect');
	}
	function execute( & $request ) {
		
		$dbo						= $request->getAttribute( 'dbo' );
		$list_id					= stripslashes( $_POST['list_id'] );
		$rejectListObject			= spider_Controller::createObject('member_DaoMemberMailReject');
		$loginUserObject			= $this->getLoginUserObject( $request );

		// セッションにないなら作成する
		if( strlen(trim($list_id)) > 0 ) {
			// IDが指定されているなら編集のため読み込み
			if( $dbo->loadById($rejectListObject, $list_id) ){
				// IDが存在するなら削除処理
				if( $this->lockData( $request, $rejectListObject ) ) {
					$rejectListObject->modifier_id	= $loginUserObject->getUniqueId();
					$rejectListObject->status_flag	= 255;
					$rejectListObject->updated_date	= date('Y-m-d H:i:s');
					if( $dbo->update($rejectListObject, true ) ) {
						
					} else {
						$request->addLocaledError('database2.error.delete',SPIDER_LOG_LEVEL_FATAL,array(""));
					}
					// エラー有無に関わらずロックを解除
					$this->unlockData( $request, $rejectListObject );
				}
			} else {
				$request->addLocaledError('system.error.common.data.invalidselect',SPIDER_LOG_LEVEL_FATAL,array());
			}
		} else {
			// IDが指定されていないならエラー
			$request->addLocaledError('system.error.common.data.invalidselect',SPIDER_LOG_LEVEL_FATAL,array());
		}

		$request->setAttribute('member.mail.reject.reject_list_object',$rejectListObject);

	}
}
?>