<?php
/*
 * member/mail/Execute.class.php
 * 
 * CopyRight(C) 2010 Shopformer Development Team. All Right Reserved
 * URL: http://sourceforge.jp/projects/shopformer/
 * 
 * 
 * Mail: m_nakashima@users.sourceforge.jp
 * Auther: Masanori Nakashima
 * Last Update: 2010-06-18
 */
require_once( dirname(dirname(__FILE__))
.DIRECTORY_SEPARATOR.'PackageConfig.class.php');
require_once( dirname(dirname(dirname(__FILE__)))
.DIRECTORY_SEPARATOR.'util'
.DIRECTORY_SEPARATOR.'LockProcess.class.php');
require_once( dirname(dirname(__FILE__))
.DIRECTORY_SEPARATOR.'DaoMember.class.php');
require_once( dirname(dirname(__FILE__))
.DIRECTORY_SEPARATOR.'DaoMemberMail.class.php');
require_once( dirname(dirname(__FILE__))
.DIRECTORY_SEPARATOR.'DaoMemberMailLog.class.php');
require_once( dirname(dirname(__FILE__))
.DIRECTORY_SEPARATOR.'DaoMemberMailReject.class.php');
require_once( dirname(dirname(__FILE__))
.DIRECTORY_SEPARATOR.'DaoMemberMailRejectMember.class.php');
/**
 * spider : メンバーメール 配信実行用アクションモジュールクラス
 * 
 * @package member メンバー管理パッケージ
 * @subpackage mail メールパッケージ
 * @version 1.0.0
 * @author  <m_nakashima@users.sourceforge.jp>
 * @since PHP 4.0
 */
class member_mail_Execute extends system_login_ModuleBase {
	function member_limit_Execute(){
		array_push($this->require_module_array,'database2.Connect');
	}
	function execute( & $request ) {
		$dbo					= $request->getAttribute( 'dbo' );
		$member_id				= $_GET['mi'];
		$select_type			= trim(stripslashes( $_GET['stype'] ));
		if( 'q' != $select_type && 's' != $select_type ) {
			$select_type		= 'm';
		}
		$session_sufix			= '_'.$select_type.'_';
		if(is_array($member_id)) {
			$session_sufix		.= implode('.',$member_id);
		} else {
			$session_sufix		.= trim($member_id);
		}
		$sessionObjectName	= MEMBER_SESSION_NAME_MAIL_OBJECT.$session_sufix;
		$sessionConfirmName	= MEMBER_SESSION_NAME_SENDMAIL_CONFIRM_RESULT.$session_sufix;
		$memberMailObject		= $request->getSession($sessionObjectName);
		$confirm_result			= $request->getSession($sessionConfirmName);
		$confirm_mail				= new member_DaoMemberMail();
		$loginUserObject		= $this->getLoginUserObject( $request );

		if( 'OK' != $confirm_result ) {
			$request->addLocaledError('system.error.common.session.timeout',SPIDER_LOG_LEVEL_ERROR,array());
		} else if ( get_class( $confirm_mail ) != get_class( $memberMailObject ) ) {
			$request->addLocaledError('system.error.common.session.timeout',SPIDER_LOG_LEVEL_ERROR,array());
		} else {
			// エラーがないならメール内容を総件数の取得をしてから保存
			list( $count_sql, $list_sql )		= explode(' ; ', $memberMailObject->select_condition );
			$memberMailObject->total_count	= 0;
			$result			= $dbo->queryOne( $count_sql );
			if ( $result === false ) {
				$request->addLocaledError('database2.error.common',SPIDER_LOG_LEVEL_FATAL,array($count_sql));
			} else {
				$memberMailObject->total_count	= $result;
				if( $dbo->setNextId( $memberMailObject, 'MMDA{num:12}' ) ) {
					$memberMailObject->updated_date		= date('Y-m-d H:i:s');
					$memberMailObject->registered_date	= date('Y-m-d H:i:s');
					if( !is_null($loginUserObject) && strlen( $loginUserObject->getUniqueId() ) > 0 ) {
						// 管理者ログインからの登録なら管理者IDを登録しておく
						$memberMailObject->owner_id			= $loginUserObject->getUniqueId();
						$memberMailObject->modifier_id		= $loginUserObject->getUniqueId();
					}
					if( $dbo->insert($memberMailObject) ) {
					} else {
						$request->addLocaledError('database2.error.insert',SPIDER_LOG_LEVEL_FATAL,array(''));
					}
				} else {
					$request->addLocaledError('database2.error.setnextid',SPIDER_LOG_LEVEL_FATAL,array(''));
				}
			}
		}

//		// 実行されていないならバックグラウンド処理呼び出し
//		$process_file	= MEMBER_MAIL_FILE_PATH_DELIVERY_RUNNING_PID;
//		if( !file_exists($process_file) || time() - filemtime($process_file) > 60 * 5 ) {
//			// 実行指令ファイルが作成されていないなら作成して実行
//			if( @touch($process_file) ) {
//				@chmod($process_file,0666);
//				if( defined('MEMBER_MAIL_EXECUTE_PHP_COMMAND_PATH')
//					&& strlen(trim(MEMBER_MAIL_EXECUTE_PHP_COMMAND_PATH)) > 0
//					&& file_exists(MEMBER_MAIL_EXECUTE_PHP_COMMAND_PATH)
//					) {
//					// 配信に利用するphpコマンドパスが指定されている
//					if( preg_match('/[wW][iI][nN][dD][oO][wW][sS]/',php_uname()) > 0 ) {
//						// Windowsの場合はatコマンドで一分後に一回タスクを実行するようにする
//						$cmd	= 'runas /user:'.MEMBER_MAIL_EXECUTE_PHP_COMMAND_USER_ACCOUNT
//							.' "at '.date('H:i',strtotime('+ 2 minutes') ) .' '
//							.trim(MEMBER_MAIL_EXECUTE_PHP_COMMAND_PATH)
//							.' '.dirname(__FILE__).DIRECTORY_SEPARATOR.'send.cmd.php"'
//						;
//						$pp		= @popen($cmd,'r+');
//						if($pp) {
//							echo fgets($pp);
//							fwrite($pp,MEMBER_MAIL_EXECUTE_PHP_COMMAND_USER_PASSWORD);
//							pclose($pp);
//						} else {
//							$request->addError('バックグラウンドコマンド実行失敗');
//						}
//					} else {
//						 Unix/Linux バックグラウンド処理
//						$cmd	= trim(MEMBER_MAIL_EXECUTE_PHP_COMMAND_PATH)
//							.' '.__FILE__
//							.' > /dev/null &';
//						$res	= shell_exec($cmd);
//					}
//				} else {
//					 phpコマンドパスが指定されていないか見つからない
//					$request->addError('PHPコマンドのパスが指定されていません。システム設置者に問い合わせてください。');
//				}
//			} else {
//				$request->addError('プロセスファイルの作成に失敗しました。');
//			}
//			if( $request->isError() ) {
//				if( file_exists($process_file) ) {
//					@unlink($process_file);
//				}
//			}
//			
//		}

		$request->removeSession($sessionConfirmName);
		$request->removeSession($sessionObjectName);
		$request->setAttribute('member.mail.mail_object',$memberMailObject );

	}
}
?>