<?php
/*
 * member/history/LoadList.class.php
 * 
 * CopyRight(C) 2010 Shopformer Development Team. All Right Reserved
 * URL: http://sourceforge.jp/projects/shopformer/
 * 
 * 
 * Mail: m_nakashima@users.sourceforge.jp
 * Auther: Masanori Nakashima
 * Last Update: 2010-06-18
 */
require_once( dirname(dirname(__FILE__))
.DIRECTORY_SEPARATOR.'PackageConfig.class.php');
/**
 * spider : 会員履歴表示用アクションモジュールクラス
 * 
 * @package member 会員管理パッケージ
 * @subpackage history 履歴パッケージ
 * @version 1.0.0
 * @author <m_nakashima@users.sourceforge.jp>
 * @since PHP 4.0
 */
class member_history_LoadList extends system_login_ModuleBase {
	function member_history_LoadList() {
		array_push($this->require_module_array,'database2.Connect');
	}
	function execute( & $request ) {

		$dbo				= $request->getAttribute( 'dbo' );
		$page_rows			= stripslashes( $_GET['pr'] );
		$page_number		= stripslashes( $_GET['pn'] );
		$client_id			= stripslashes( $_GET['ci'] );
		$member_id			= stripslashes( $_GET['mi'] );
		$target_year		= stripslashes( $_GET['ty'] );
		$target_month		= stripslashes( $_GET['tm'] );
		if ( !is_numeric( $page_number ) || $page_number < 1 ) {
			$page_number	= 1;
		}
		if ( !is_numeric( $page_rows ) || $page_rows < 1 ) {
			$page_rows		= 1000;
		}
		$order_condition	= ' ORDER BY '.TABLE_NAME_MEMBER_LOGIN_HISTORY.'.login_date DESC';
		
		$condition_array	= array();
		array_push( $condition_array, TABLE_NAME_MEMBER.'.status_flag<200' );
		if( strlen(trim($client_id)) > 0 ) {
			array_push( $condition_array, TABLE_NAME_MEMBER.'.client_id='.$dbo->quote($client_id) );
		}
		if( strlen(trim($member_id)) > 0 ) {
			array_push( $condition_array, TABLE_NAME_MEMBER_LOGIN_HISTORY.'.member_id='.$dbo->quote($member_id) );
		}
		if( !is_numeric( $target_year ) || $target_year < 2000 || $target_year > date('Y') ) {
			$target_year	= date('Y');
		}
		if( !is_numeric( $target_month ) || $target_month < 1 || $target_month > 12 ) {
			$target_month	= date('m');
		}
		$start_date	= $target_year.'-'.$target_month.'-01 00:00:00';
		$end_date	= $target_year.'-'.$target_month.'-'.date( 't', strtotime($start_date) ).' 23:59:59';
		$str		= '( login_date>='.$dbo->quote($start_date).' AND login_date<='.$dbo->quote( $end_date).' )';
		array_push( $condition_array, $str );
		
		$condition_string	= '';
		if ( count( $condition_array ) > 0 ) {
			$condition_string	= ' WHERE '.implode( ' AND ', $condition_array );
		}
		
		// トータル件数を取得
		$sql	= 'SELECT COUNT(DISTINCT('.TABLE_NAME_MEMBER_LOGIN_HISTORY
			.'.history_number)) '
			.' FROM '.TABLE_NAME_MEMBER_LOGIN_HISTORY
			.' LEFT OUTER JOIN '.TABLE_NAME_MEMBER
			.' ON '.TABLE_NAME_MEMBER.'.member_id='.TABLE_NAME_MEMBER_LOGIN_HISTORY.'.member_id '
			.$condition_string
		;
		$total_count	= 0;
		$result			= $dbo->queryOne( $sql );
		if ( false === $result ) {
			$request->addLocaledError('database2.error.common',SPIDER_LOG_LEVEL_FATAL,array($sql));
		} else {
			$total_count	= $result;
		}
		$total_page			= ceil( $total_count / $page_rows );
		if ( $page_number > $total_page ) {
			$page_number	= $total_page;
		}
		
		// IDをページ分取得
		$sql	= 'SELECT '.TABLE_NAME_MEMBER_LOGIN_HISTORY.'.*'
		.' FROM '.TABLE_NAME_MEMBER_LOGIN_HISTORY
		.' LEFT OUTER JOIN '.TABLE_NAME_MEMBER
		.' ON '.TABLE_NAME_MEMBER.'.member_id='.TABLE_NAME_MEMBER_LOGIN_HISTORY.'.member_id '
		.$condition_string
		.$order_condition;
		$dbo->setLimit( $page_rows, ( $page_number - 1 ) * $page_rows );
		$result			= $dbo->queryAll( $sql,null,MDB2_FETCHMODE_ASSOC );
		if ( false === $result ) {
			$request->addLocaledError('database2.error.common',SPIDER_LOG_LEVEL_FATAL,array($sql));
		} else {
			$array	= $result;
			$request->setAttribute( 'member.history.data_array', $array );
			$request->setAttribute( 'member.history.total_count', $total_count );
			$request->setAttribute( 'member.history.total_page', $total_page );
			$request->setAttribute( 'member.history.page_number', $page_number );
			$request->setAttribute( 'member.history.client_id', $client_id );
			$request->setAttribute( 'member.history.member_id', $member_id );
			$request->setAttribute( 'member.history.target_year', $target_year );
			$request->setAttribute( 'member.history.target_month', $target_month );
			$has_next_page	= false;
			if( $page_number < $total_page ) {
				$has_next_page	= true;
			}
			$request->setAttribute( 'member.history.has_next_page', $has_next_page );
			$has_prev_page	= false;
			if( $page_number > 1 ) {
				$has_prev_page	= true;
			}
			$request->setAttribute( 'member.history.has_prev_page', $has_prev_page );
		}
	}
}
?>