<?php
/*
 * member/DaoMember.class.php
 * 
 * CopyRight(C) 2010 Shopformer Development Team. All Right Reserved
 * URL: http://sourceforge.jp/projects/shopformer/
 * 
 * 
 * Mail: m_nakashima@users.sourceforge.jp
 * Auther: Masanori Nakashima
 * Last Update: 2010-06-18
 * 
 * 会員登録パッケージ共通で利用するグローバル関数ファイル
 * 2009/03/05
 */
/**
 * エラー戻りしたメールアドレス名でファイルを作成します
 */
function gb_member_registReturnMailAddress( $mail_address ) {
	$file_name		= gb_member_encodeMailAddress( $mail_address );
	// 会員登録パッケージフォルダ内で固定パスのフォルダに保存
	$folder_path	= 'mailscript'.DIRECTORY_SEPARATOR.'return_addresses';
	return gb_member_writeDataFile( $file_name, $folder_path, time() );
}
/**
 * エラー戻りしたアドレスか確認します
 */
function gb_member_isReturnMailAddress( $mail_address, $confirm_days = 30 ) {
	// 確認時はこのサーバのみ
	$file_path	= DIR_PATH_DATA.DIRECTORY_SEPARATOR.'member'
		.DIRECTORY_SEPARATOR.'mailscript'
		.DIRECTORY_SEPARATOR.'return_addresses'
		.DIRECTORY_SEPARATOR.gb_member_encodeMailAddress( $mail_address );
	if( file_exists( $file_path ) ) {
		if( time() - filemtime($file_path) > 60 * 60 * 24 * $confirm_days ) {
			@unlink($file_path);
			return false;
		} else {
			return true;
		}
	} else {
		return false;
	}
}
/**
 * メールアドレスをローカルアカウント利用可能文字/ファイル名利用可能文字に変換します
 */
function gb_member_encodeMailAddress( $mail_address ) {
	$mail_address	= urlencode( $mail_address );
	$mail_address	= str_replace( '-', '%45', $mail_address );
	$mail_address	= str_replace( '.', '%46', $mail_address );
	return $mail_address;
}
/**
 * ローカルアカウント利用可能文字/ファイル名利用可能文字にエンコードされた文字列をでコードします
 */
function gb_member_decodeMailAddress( $string ) {
	$string	= str_replace( '%46', '.', $string );
	$string	= str_replace( '%45', '-', $string );
	$string	= trim(urldecode( $string ));
	return $string;
}
/**
 * 複数サーバーにまたがってDATA/date/member/mailscript/内指定フォルダの指定ファイルに文字列を書き込みます。
 */
function gb_member_writeDataFile( $file_name, $folder_path, $strings ) {
		if( defined('DIR_PATH_DATA') && strlen(DIR_PATH_DATA) > 5 ) {
		} else {
			return false;
		}
		if( !class_exists('system_PackageConfig') ) {
			return false;
		}
		$base_configuration_object	= new system_PackageConfig();
		if( $base_configuration_object->load() ) {
			$mount_point_array		= array();
			if( is_array($base_configuration_object->mount_point_data_array)
				&& count($base_configuration_object->mount_point_data_array) > 0 ) {
				$mount_point_array	 = $base_configuration_object->mount_point_data_array;
			}
			// このサーバのDATA/dataフォルダパスを書き出し先に追加する
			array_push( $mount_point_array, DIR_PATH_DATA );
			// 各マウントポイントのファイルに書き出し
			foreach( $mount_point_array as $mount_point ) {
				$file_path	= gb_member_getSaveFileAbsolutePath($file_name,$folder_path,$mount_point);
				if( false === $file_path ) {
					return false;
				} else {
					$fp		= @fopen( $file_path, "w" );
					if( $fp ) {
						if (flock($fp, LOCK_EX)) {
							fwrite( $fp, $strings );
							flock($fp, LOCK_UN);
						}
						fclose( $fp );
					} else {
						return false;
					}
					@chmod( $file_path, SPIDER_PERMITTION_DATA_FILE );
				}
			}
			return true;
		}
}
/**
 * DATA/dataマウントポイントからの指定名称のフォルダ・ファイルパスを作成して取得します
 */
function gb_member_getSaveFileAbsolutePath($file_name,$folder_path=null,$mount_point=null) {
	$file_path	= gb_member_createSaveFolderAbsolutePath($folder_path,$mount_point);
	if( false === $file_path ) {
		return false;
	} else {
		$file_path	.= DIRECTORY_SEPARATOR.$file_name;
		return $file_path;
	}
}
/**
 * DATA/dataマウントポイントからの指定名称のデータフォルダ絶対パスを作成して取得します
 */
function gb_member_createSaveFolderAbsolutePath($folder_path=null,$mount_point=null) {
	if( is_null( $mount_point ) || strlen(trim($mount_point)) == 0 ) {
		if( defined('DIR_PATH_DATA') && strlen(DIR_PATH_DATA) > 5 ) {
			$mount_point	= DIR_PATH_DATA;
		} else {
			return false;
		}
	}
	$absolute_path	= $mount_point.DIRECTORY_SEPARATOR.'member';
	if( !file_exists($absolute_path) ) {
		if( @mkdir( $absolute_path, SPIDER_PERMITTION_DATA_FOLDER ) ) {
			@chmod( $absolute_path,SPIDER_PERMITTION_DATA_FOLDER );
		} else {
			return false;
		}
	}
	if( strlen(trim($folder_path)) > 0 ) {
		// 1文字以上のフォルダ名配列を作成
		$folder_name_array		= array();
		$folder_name_tmp_array	= explode( DIRECTORY_SEPARATOR, $folder_path );
		foreach( $folder_name_tmp_array as $name ) {
			if( strlen(trim($name)) > 0 ) {
				array_push( $folder_name_array, $name );
			}
		}
		// フォルダを作成しながら連結
		foreach( $folder_name_array as $folder_name ) {
			$absolute_path	.= DIRECTORY_SEPARATOR.$folder_name;
			if( !file_exists($absolute_path) ) {
				if( @mkdir( $absolute_path, SPIDER_PERMITTION_DATA_FOLDER ) ) {
					@chmod( $absolute_path,SPIDER_PERMITTION_DATA_FOLDER );
				} else {
					return false;
				}
			}
		}
	}
	return $absolute_path;
}

?>