<?php
/*
 * member/DaoMemberMail.class.php
 * 
 * CopyRight(C) 2010 Shopformer Development Team. All Right Reserved
 * URL: http://sourceforge.jp/projects/shopformer/
 * 
 * 
 * Mail: m_nakashima@users.sourceforge.jp
 * Auther: Masanori Nakashima
 * Last Update: 2010-06-18
 */
require_once( dirname( __FILE__ )
.DIRECTORY_SEPARATOR.'package_define.inc.php');
require_once( dirname( __FILE__ )
.DIRECTORY_SEPARATOR.'PackageConfig.class.php');
require_once( dirname( __FILE__ )
.DIRECTORY_SEPARATOR.'DaoMemberMailTemplate.class.php');
require_once( dirname(dirname( __FILE__ ))
.DIRECTORY_SEPARATOR.'database2'
.DIRECTORY_SEPARATOR.'AbstractData.class.php');
/**
 * メンバーメールテーブルレコード対応 DAOクラス
 * 
 * @package member メンバー管理パッケージ
 * @version 1.0.0
 * @author  <m_nakashima@users.sourceforge.jp>
 * @since PHP 4.0
 */
class member_DaoMemberMail extends member_DaoMemberMailTemplate {

	var $mail_number;
	var $mail_id;
	var $target_type			= 'p';
	var $mail_type				= 'p';
	var $bgcolor				= '';
	var $subject;
	var $mail_from_name;
	var $mail_from_address;
	var $mail_reply_address;
	var $mail_return_path;
	var $body;
	var $header;
	var $select_type			= 'i';
	var $list_id;
	var $select_condition;
	var $total_count			= 0;
	var $list_count				= 0;
	var $status_flag			= 0;
	var $send_params;
	var $reserve_date;
	var $completed_date;
	var $updated_date;
	var $registered_date;
	var $owner_admin_id;
	var $owner_group_id;
	var $modifier_id;
	
	// オブジェクト拡張
	/** 配信結果ログカウントハッシュ： delivery_status=>数	*/
	var $delivery_status_hash	= array();
	/**
	 * コンストラクタ
	 */
	function member_DaoMemberMail(){
		$this->member_id_array			= array();
		$this->member_id_object_hash	= array();
		$this->delivery_status_hash		= array();
	}
	/**
	 * オプションテーブルを読み込む
	 */
	function _load_optional_data( $dbo ) {
		$this->subject_mobile		= $this->subject;
		$this->text_body_default	= $this->body;
		$this->text_body_mobile		= $this->body;
		$this->html_body_default	= $this->body;
		$this->html_body_mobile		= $this->body;
		$this->delivery_status_hash		= array();
		$sql	= 'SELECT delivery_status, COUNT(log_number) AS delivery_count'
			.' FROM '.TABLE_NAME_MEMBER_MAIL_LOG
			.' WHERE '
			.' mail_id='.$dbo->quote($this->mail_id)
			.' GROUP BY delivery_status'
			.' ORDER BY delivery_status ASC'
		;
		$result		= $dbo->queryAll( $sql,null,MDB2_FETCHMODE_ASSOC );
		if ( $result === false ) {
		} else {
			foreach( $result as $row ) {
				$delivery_status	= trim($row['delivery_status']);
				$delivery_count		= trim($row['delivery_count']);
				$this->delivery_status_hash[$delivery_status]	= $delivery_count;
			}
		}
	}
	/**
	 * 本メールテンプレートの内容をそのままでメール送信を実行します
	 * @param & $request spider_HttpRequestオブジェクト参照
	 * @param $mailToAddress 宛先メールアドレス
	 * @param $replaceWordHash 置換ワードハッシュ
	 * @param $mailType p=plain, h=html
	 * @return 配信結果ステータス: 1=正常配信
	 * 				201=Fail to send mail!
	 * 				204=Fail to create mail_sender!
	 * 				254=Fail to load member package configuration!
	 */
	function sendMail( & $request, $mailToAddress, $replaceWordHash=array(), $mailType=null ) {
		return parent::sendMail( $request, $mailToAddress, $replaceWordHash, $this->mail_type );
	}
}
?>