<?php
/*
 * file/PackageConfig.class.php
 * 
 * CopyRight(C) 2010 Shopformer Development Team. All Right Reserved
 * URL: http://sourceforge.jp/projects/shopformer/
 * 
 * 
 * Mail: m_nakashima@users.sourceforge.jp
 * Auther: Masanori Nakashima
 * Last Update: 2010-06-18
 * 
 * design_PackageConfig
 * ver 1.0.01 build on 2010-03-31
 * 
 * [変更履歴]
 * 2010-03-31
 * system_package_PackageConfigBaseクラスのinstallメソッドとuninstallメソッドを呼び出すよう変更。
 * 
 */
require_once(dirname(__FILE__)
.DIRECTORY_SEPARATOR.'package_define.inc.php');
require_once(dirname(dirname(__FILE__))
.DIRECTORY_SEPARATOR.'database2'
.DIRECTORY_SEPARATOR.'PackageConfigBase.class.php' );
require_once(dirname(dirname(__FILE__))
.DIRECTORY_SEPARATOR.'system'
.DIRECTORY_SEPARATOR.'login'
.DIRECTORY_SEPARATOR.'ModuleBase.class.php');
require_once(dirname(dirname( __FILE__ ))
.DIRECTORY_SEPARATOR.'database2'
.DIRECTORY_SEPARATOR.'AbstractData.class.php' );
require_once(dirname(dirname( __FILE__ ))
.DIRECTORY_SEPARATOR.'database2'
.DIRECTORY_SEPARATOR.'AbstractUser.class.php' );
require_once( dirname(dirname( __FILE__ ))
.DIRECTORY_SEPARATOR.'system'
.DIRECTORY_SEPARATOR.'DataFileWriter.class.php' );
require_once( dirname(dirname( __FILE__ ))
.DIRECTORY_SEPARATOR.'util'
.DIRECTORY_SEPARATOR.'CharUtility.class.php' );
/**
 * ファイル登録パッケージ基本情報保持クラス
 * 
 * - 概要
 *   データベースにファイルを格納し管理するパッケージ
 *   管理Webシステム上から操作する機能は現在実装していません。
 *   他パッケージからファイルを登録、取得する為のインターフェースを提供します。
 * - バージョン
 *   1.0
 * - 対応データベース
 *   MySQL
 *   PostgreSQL
 * - パッケージの詳細
 *   バイナリデータをBASE64エンコードしてデータベースに保存し、取り出し時に自動的に
 *   BASE64デコードしてバイナリファイルをキャッシュディレクトリ下に配置します。
 *   データベースの保存データ型は文字列型である為、データベースの文字列長の3/4のサイズの
 *   バイナリデータを格納できます。
 *   登録時、読み込み時は、package_define.inc.phpにて指定したサイズ（FILE_BIN_INSERT_AT_ONCE）
 *   にファイルを分割して登録、読み込みを行う為、サーバーのレスポンス最大タイム範囲内で
 *   ループ処理が終わるサイズまでを登録できます。これはサーバーのスペックにより異なります。
 * 
 * @package file ファイル登録パッケージ
 * @version 1.1.00
 * @author  <m_nakashima@users.sourceforge.jp>
 * @since PHP 4.3
 * 
 */
class file_PackageConfig extends database2_PackageConfigBase {
	function file_PackageConfig() {
		$this->definitionHash		= array(
			'FILE_INIT_OPTION'			=> '2',
			'FILE_SAVE_PATH'				=> DIR_PATH_DATA.DIRECTORY_SEPARATOR.'file',
			'FILE_USE_CACHE'				=> '1',
		);
	}
	/**
	 * パッケージの表示順序を取得
	 * @return int パッケージ順序
	 */
	function getPackageOrder() {
		return 20;
	}
	/**
	 * パッケージの表示名を取得
	 * @return string パッケージ名称
	 */
	function getPackageViewName() {
		return '共通ファイル管理';
	}
	/**
	 * definitionHashに設定された値の妥当性検査を行います。
	 * @param $request spider_HttpRequestクラスオブジェクトの参照
	 * @return boolean エラーがあるならfalse
	 */
	function validateDifinitionHash( & $request ) {
		if( preg_match('/^[0-3]$/',$this->definitionHash['FILE_INIT_OPTION']) == 0 ) {
			$request->addError($this->getPackageViewName().'：データベース初期化オプションの選択が正しくありません。');
		}
		if( strlen($this->definitionHash['FILE_SAVE_PATH']) == 0 ) {
			$request->addError($this->getPackageViewName().'：ファイル保存フォルダを指定してください。');
		} else if( strpos($this->definitionHash['FILE_SAVE_PATH'],DIR_PATH_DATA) !== 0 ) {
			if( !file_exists($this->definitionHash['FILE_SAVE_PATH']) ) {
				$request->addError($this->getPackageViewName().'：指定されたファイル保存フォルダは存在しません。');
			} else if( !is_dir($this->definitionHash['FILE_SAVE_PATH']) ) {
				$request->addError($this->getPackageViewName().'：ファイル保存フォルダにはフォルダを指定してください。');
			} else if( !is_writable($this->definitionHash['FILE_SAVE_PATH']) ) {
				$request->addError($this->getPackageViewName().'：指定されたファイル保存フォルダは書込できないパーミッションになっています。');
			}
		}
		if( preg_match('/^[12]$/',$this->definitionHash['FILE_USE_CACHE']) == 0 ) {
			$request->addError($this->getPackageViewName().'：キャッシュファイル利用の選択が正しくありません。');
		}
	}
	/**
	 * パッケージ概要説明を取得します。
	 */
	function getPackageDescription() {
		return 'ファイルをアップロードしてデータベースに登録し、ダウンロード・表示する基本機能を提供します。';
	}
	/**
	 * パッケージ依存関係のハッシュを取得
	 * @return hash array('packageId'=>array('version','version',...))
	 */
	function getPackageDependenciesHash() {
		return array(
			'database2'	=> array('1.0.02'),
		);
	}
	/*
	 * インストール関連のメソッド
	 */
	/**
	 * インストールを実行します。
	 */
	function install( & $request ) {
		return parent::install($request);
	}
	/*
	 * アンインストール関連メソッド
	 */
	/**
	 * アンインストールを実行します。
	 */
	function uninstall( & $request ) {
		return parent::uninstall($request);
	}
}
?>