<?php
/*
 * design/template/publish/Validate.class.php
 * 
 * CopyRight(C) 2010 Shopformer Development Team. All Right Reserved
 * URL: http://sourceforge.jp/projects/shopformer/
 * 
 * 
 * Mail: m_nakashima@users.sourceforge.jp
 * Auther: Masanori Nakashima
 * Last Update: 2010-06-18
 */
require_once( dirname(dirname(dirname(dirname(__FILE__))))
	.DIRECTORY_SEPARATOR.'system'
	.DIRECTORY_SEPARATOR.'login'
	.DIRECTORY_SEPARATOR.'ModuleBase.class.php');
require_once( dirname(dirname(dirname(__FILE__)))
	.DIRECTORY_SEPARATOR.'DaoTemplate.class.php');
class design_template_publish_Validate extends system_login_ModuleBase {
	function design_template_publish_Validate() {
	}
	function execute( & $request ) {
		$fileName			= strtolower(trim(stripslashes($_GET['fmt'])));
		if( strlen(trim($fileName)) == 0 ) {
			$request->addError('テンプレートファイル名を指定してください');
		}
		
		if( !$request->isError() ) {
			$templateObject			= new design_DaoTemplate($fileName);

			$templateObject->loadInfo( $request );
			$templateObject->view_name			= stripslashes($_POST['name']);
			$templateObject->name				= stripslashes($_POST['name']);
			$templateObject->copyright			= stripslashes($_POST['copyright']);
			$templateObject->url				= stripslashes($_POST['url']);
			$templateObject->auth_url			= stripslashes($_POST['auth_url']);
			$templateObject->html_edit			= stripslashes($_POST['html_edit']);
			$templateObject->publish_key_plain	= stripslashes($_POST['publish_key_plain']);
			$templateObject->publish_key_new	= stripslashes($_POST['publish_key_new']);
			$templateObject->include_pages		= stripslashes($_POST['include_pages']);
			$templateObject->include_pages		= str_replace("\r\n","\n",$templateObject->include_pages);
			$templateObject->include_pages		= str_replace("\r","\n",$templateObject->include_pages);
			$templateObject->include_files		= stripslashes($_POST['include_files']);
			$templateObject->include_files		= str_replace("\r\n","\n",$templateObject->include_files);
			$templateObject->include_files		= str_replace("\r","\n",$templateObject->include_files);

			if( preg_match('/^[fF](|[aA][lL][sS][eE])$/',$templateObject->html_edit) > 0 ) {
				$templateObject->html_edit	= false;
			} else {
				$templateObject->html_edit	= true;
			}
			
			// サイト固有知変数の一時出力設定
			$variableKeyArray		= $request->getParam('variable_key','post','array');
			$variableNoteArray		= $request->getParam('variable_note','post','array');
			$variableValueArray		= $request->getParam('variable_value','post','array');
			$altVariableHash		= array();
			if( is_array($variableKeyArray) ) {
				foreach( $variableKeyArray as $num => $key ) {
					if( is_array($variableNoteArray) && isset($variableNoteArray[$num])
						&& is_array($variableValueArray) && isset($variableValueArray[$num]) ) {
						$altVariableHash[$key]	= array(
							'key'		=> $key,
							'label'	=> str_replace("\n","",str_replace("\r","",$variableNoteArray[$num])),
							'value'	=> str_replace("\n","",str_replace("\r","",$variableValueArray[$num])),
						);
					}
				}
			}
			
			if( $templateObject->createArchiveValidate( $request, $altVariableHash ) ) {
			}
			$request->setAttribute('design.template.publish.templateObject',$templateObject );
		}
	}
}
?>