<?php
/*
 * design/template/publish/Download.class.php
 * 
 * CopyRight(C) 2010 Shopformer Development Team. All Right Reserved
 * URL: http://sourceforge.jp/projects/shopformer/
 * 
 * 
 * Mail: m_nakashima@users.sourceforge.jp
 * Auther: Masanori Nakashima
 * Last Update: 2010-06-18
 */
require_once( dirname(dirname(dirname(dirname(__FILE__))))
	.DIRECTORY_SEPARATOR.'system'
	.DIRECTORY_SEPARATOR.'login'
	.DIRECTORY_SEPARATOR.'ModuleBase.class.php');
require_once( dirname(dirname(dirname(__FILE__)))
	.DIRECTORY_SEPARATOR.'DaoTemplate.class.php');
class design_template_publish_Download extends system_login_ModuleBase {
	var $temporaryFileUri	= null;
	function design_template_publish_Download() {
	}
	function execute( & $request ) {
		$fileName			= strtolower(trim(stripslashes($_GET['fmt'])));
		if( strlen(trim($fileName)) == 0 ) {
			$request->addError('テンプレートファイル名を指定してください');
		}
		
		if( !$request->isError() ) {
			$templateObject			= new design_DaoTemplate($fileName);

			$templateObject->loadInfo( $request );
			$templateObject->view_name			= stripslashes($_POST['name']);
			$templateObject->name				= stripslashes($_POST['name']);
			$templateObject->copyright			= stripslashes($_POST['copyright']);
			$templateObject->url				= stripslashes($_POST['url']);
			$templateObject->auth_url			= stripslashes($_POST['auth_url']);
			$templateObject->html_edit			= stripslashes($_POST['html_edit']);
			$templateObject->publish_key_plain	= stripslashes($_POST['publish_key_plain']);
			$templateObject->publish_key_new	= stripslashes($_POST['publish_key_new']);
			$templateObject->install_key_plain	= stripslashes($_POST['install_key_plain']);
			$templateObject->include_pages		= stripslashes($_POST['include_pages']);
			$templateObject->include_pages		= str_replace("\r\n","\n",$templateObject->include_pages);
			$templateObject->include_pages		= str_replace("\r","\n",$templateObject->include_pages);
			$templateObject->include_files		= stripslashes($_POST['include_files']);
			$templateObject->include_files		= str_replace("\r\n","\n",$templateObject->include_files);
			$templateObject->include_files		= str_replace("\r","\n",$templateObject->include_files);

			if( preg_match('/^[fF](|[aA][lL][sS][eE])$/',$templateObject->html_edit) > 0 ) {
				$templateObject->html_edit	= false;
			} else {
				$templateObject->html_edit	= true;
			}
			
			// サイト固有知変数の一時出力設定
			$variableKeyArray		= $request->getParam('variable_key','post','array');
			$variableNoteArray		= $request->getParam('variable_note','post','array');
			$variableValueArray		= $request->getParam('variable_value','post','array');
			$altVariableHash		= array();
			if( is_array($variableKeyArray) ) {
				foreach( $variableKeyArray as $num => $key ) {
					if( is_array($variableNoteArray) && isset($variableNoteArray[$num])
						&& is_array($variableValueArray) && isset($variableValueArray[$num]) ) {
						$altVariableHash[$key]	= array(
							'key'		=> $key,
							'label'	=> str_replace("\n","",str_replace("\r","",$variableNoteArray[$num])),
							'value'	=> str_replace("\n","",str_replace("\r","",$variableValueArray[$num])),
						);
					}
				}
			}
			
			$this->temporaryFileUri		= '/design/template/archive/tmp/template_'.time().'.fmt';
			if( $templateObject->createArchiveExecute( $request, $this->temporaryFileUri, $altVariableHash, DIR_NAME_TMP ) ) {
				// 作成に成功したらダウンロード
				$nameArray	= explode('.',$fileName);
				array_pop( $nameArray );
				$downloadName	= implode('.',$nameArray).'.fmt';
				$realPath		= system_DataFileWriter::getRealAbsolutePath( $request, $this->temporaryFileUri, DIR_NAME_TMP );
				$request->setResponseHeader( 'Content-Disposition', 'attachment; filename="'.$downloadName.'"' );
				$request->setResponseHeader( 'Content-Length', filesize( $realPath ) );
				$request->setResponseHeader( 'Content-Type', 'application/octet-stream' );
				$request->setResponseFile( $realPath );
			}
			$request->setAttribute('design.template.publish.templateObject',$templateObject );
		}
	}
	/**
	 * モジュールの後処理を行います。
	 * このメソッドをオーバーライドすることにより、モジュールの後処理として実行されます。
	 * @param $request 
	 */
	function post_process( & $request ) {
		if( !is_null($this->temporaryFileUri) && strlen($this->temporaryFileUri) > strlen('/design/template/archive/tmp/') ) {
			system_DataFileWriter::delete( $request, $this->temporaryFileUri, DIR_NAME_TMP );
		}
	}
}
?>