<?php
/*
 * content/upload/Confirm.class.php
 * 
 * CopyRight(C) 2010 Shopformer Development Team. All Right Reserved
 * URL: http://sourceforge.jp/projects/shopformer/
 * 
 * 
 * Mail: m_nakashima@users.sourceforge.jp
 * Auther: Masanori Nakashima
 * Last Update: 2010-06-18
 */
require_once( dirname(dirname(dirname(__FILE__)))
	.DIRECTORY_SEPARATOR.'system'
	.DIRECTORY_SEPARATOR.'login'
	.DIRECTORY_SEPARATOR.'ModuleBase.class.php');
require_once( dirname(dirname(dirname(__FILE__)))
	.DIRECTORY_SEPARATOR.'util'
	.DIRECTORY_SEPARATOR.'CharUtility.class.php');
require_once( dirname(dirname(dirname(__FILE__)))
	.DIRECTORY_SEPARATOR.'system'
	.DIRECTORY_SEPARATOR.'DataFileWriter.class.php');
require_once( dirname(dirname(__FILE__))
	.DIRECTORY_SEPARATOR.'Uploader.class.php' );
require_once( dirname(dirname(__FILE__))
	.DIRECTORY_SEPARATOR.'package_define.inc.php' );
class content_upload_Confirm extends system_login_ModuleBase {
	
	function content_upload_Confirm() {
	}
	function execute( & $request ) {

		$sessionObjectName		= 'content.upload.uploader';
		$sessionConfirmName		= 'content.upload.confirm';
		$contentUploader		= $request->getSession($sessionObjectName);
		
		// アップロード先フォルダURI
		$targetFolderUri		= trim(stripslashes($_POST['target_uri']));
		if( strlen($targetFolderUri) == 0 ) {
			$targetFolderUri	= '/upload';
		}
		if( preg_match('/^\\/([0-9a-zA-Z\\_\\.]+\\/)*([0-9a-zA-Z\\_\\.]+)$/',$targetFolderUri) == 0 ) {
			$request->addError('アップロード先フォルダの指定が正しくありません。'.$targetFolderUri);
			return;
		}
		$targetFolderUri	= preg_replace('/\\/$/','',$targetFolderUri);
		//
		// アップロードファイル情報ハッシュ
		// 
		//
		if( !isset($_FILES['upfile']) || !is_array($_FILES['upfile']) || !strlen($_FILES['upfile']['name']) > 0 ) {
			$request->addError('ファイルがアップロードされていません');
			return;
		}
		
		// コンテンツアップローダー
		if( is_object($contentUploader) && 'content_uploader' == strtolower(get_class($contentUploader)) ) {
			$contentUploader->initialize( $request );
		} else {
			$contentUploader	= new content_Uploader('upfile');
		}
		
		// 一時アップロード実行
		$contentUploader->uploadConfirm( $request, $targetFolderUri, null, array(array('width'=>100,'height'=>100)), $_POST['regist_file_name'] );
		if( !is_array($contentUploader->contentFileObjectArray)
			|| count($contentUploader->contentFileObjectArray) == 0 ) {
			$request->addError('ファイルがアップロードされていません');
		}
		if( $request->isError() ) {
			$request->removeSession($sessionConfirmName);
		} else {
			$request->setSession($sessionConfirmName,'OK');
		}
		$request->setSession($sessionObjectName,$contentUploader);
		$request->setAttribute('content.upload.uploaderObject',$contentUploader);
	}
}
?>