<?php include_once( "../../../spider.inc.php" ); ?>
{charset:UTF-8}
{template:admin_default.tpl}
{module:system.login.Require}
{module:system.package.LoadList}
{preset:page_title 'システム設定 > ソフトウェアアップデート'}

	<div class="panc">
		<a href="../../">管理パネルトップ</a>
		&gt; <a href="../">システム設定</a>
		&gt; ソフトウェアアップデート
	</div>
	<h1>
		システム設定
		&gt; ソフトウェアアップデート
	</h1>
	{if:count(system.package.installedPackageIdArray)>0}
	{if:IS_ERROR}
		<ul class="error">
		{foreach:errors error}
			<li>{write:error}</li>
		{/foreach}
		</ul>
		<p style="text-align:right;">
			<a href="../">システム設定ページへ</a>
		</p>
	{else}
	
		<div id="update-info" style="width:95%;margin:0 auto;">
		</div>
		
		<p style="text-align:right;">
			<a href="../">システム設定ページへ</a>
		</p>

<script language="JavaScript" type="text/javascript"><!--
// version.xmlを確認
var mdsToolsVersionHttpObject;
var updateFilesHash = new Object();
var updateFileCount	= 0;
function systemGetMdsToolsVersion() {
	var updateBlock		= document.getElementById('update-info');
	if( updateBlock ) {
		updateBlock.innerHTML = '';
	}
	updateFilesHash = new Object();
	mdsToolsVersionHttpObject	= FormerCommon.createHttpRequest(systemGetMdsToolsVersionResult);
	if( mdsToolsVersionHttpObject ) {
		mdsToolsVersionHttpObject.open("GET",'../../getnews.php?rt=ver',true);
		mdsToolsVersionHttpObject.send(null);
	} else {
		alert('サーバー通信作成に失敗しました!');
	}
}
function systemGetMdsToolsVersionResult() {
	if ((mdsToolsVersionHttpObject.readyState == 4) && (mdsToolsVersionHttpObject.status == 200)){
		var updateBlock		= document.getElementById('update-info');
		if( updateBlock ) {
			updateBlock.innerHTML	= '';
			var domDoc			= mdsToolsVersionHttpObject.responseXML;
			var nodes			= domDoc.getElementsByTagName('release');
			var nowVersionNum	= new String('<?php echo RELEASE_VERSION; ?>').replace('.','');
			var newerVersionArray	= new Array();
			for( var num=0; num<nodes.length; num++ ) {
				var targetVersionInfo	= nodes[num];
				var targetVersionNum	= targetVersionInfo.getAttributeNode("version").value.replace('.','');
				if( targetVersionNum > nowVersionNum ) {
					newerVersionArray.unshift(targetVersionInfo);
				}
			}
			if( newerVersionArray.length == 0 ) {
				updateBlock.innerHTML = 'ソフトウェアは最新の状態です。';
			} else {
				var canUpdate = true;
				for( var num=0; num<newerVersionArray.length; num++ ) {
					var targetVersionInfo = newerVersionArray[num];
					// version name
					var versionName = targetVersionInfo.getAttributeNode("version").value;
					var releaseDate = targetVersionInfo.getAttributeNode("date").value;
					var versionElm  = document.createElement('div');
					versionElm.className = 'version-title';
					versionElm.innerHTML = 'ver ' + versionName;
					updateBlock.appendChild(versionElm);
					// release date
					var dateElm  = document.createElement('div');
					dateElm.className = 'version-date';
					var date = new Date(releaseDate);
					dateElm.innerHTML = date.getFullYear() + '年' + (date.getMonth()+1) + '月' + date.getDate() + '日';
					updateBlock.appendChild(dateElm);
					// information
					var childs	= targetVersionInfo.childNodes;
					var description;
					var updateFileStr = '';
					for( var cnum=0; cnum<childs.length; cnum++ ) {
						if( childs[cnum].tagName == 'description' ) {
							description	= childs[cnum].firstChild.nodeValue;
						} else if( childs[cnum].tagName == 'upfiles' ) {
							var gchilds = childs[cnum].childNodes;
							var fileArray = new Array();
							for( var gcnum=0; gcnum<gchilds.length; gcnum++ ) {
								var gchild = gchilds[gcnum];
								if( gchild.tagName == 'file' ) {
									var upFileName = gchild.firstChild.nodeValue;
									if( updateFileStr.length > 0 ) {
										updateFileStr += ', ';
									}
									updateFileStr += upFileName;
									fileArray.push(upFileName);
								}
							}
							updateFilesHash[versionName]	= fileArray;
						}
					}
					// description
					var descriptionElm = document.createElement('div');
					descriptionElm.className = 'version-description';
					descriptionElm.innerHTML = description;
					updateBlock.appendChild(descriptionElm);
					// files
					updateFileCount	= fileArray.length;
					var filesElm = document.createElement('div');
					filesElm.className = 'version-files';
					filesElm.innerHTML = 'Update files: ' + updateFileCount + 'file<br />';
					updateBlock.appendChild(filesElm);
					// update
					if( canUpdate ) {
						var updateElm = document.createElement('div');
						updateElm.className = 'version-update';
						updateElm.innerHTML = '<a href="javascript:systemSoftwareUpdate(\''+versionName+'\')">&gt;&gt; ver.'+versionName+'にアップデートする</a>';
						updateBlock.appendChild(updateElm);
						canUpdate = false;
					}
				}
			}
		}
	} else if ((mdsToolsVersionHttpObject.readyState == 4) && (mdsToolsVersionHttpObject.status != 200)){
		alert('適用時にサーバー通信でエラーが発生しました。');
	}
}
var systemUpdateTargetVersion;
var systemUpdateTargetTotalCount = 0;
var systemUpdateTargetFileArray;
var systemUpdateHttpObject;
function systemSoftwareUpdate(versionName) {
	if( confirm('ソフトウェアを ver. '+versionName+'に更新してよろしいですか？') ) {
		systemUpdateTargetVersion		= versionName;
		systemUpdateTargetFileArray 	= updateFilesHash[versionName];
		systemUpdateTargetTotalCount	= systemUpdateTargetFileArray.length;
		FormerCommon.displayGrayOut(9999);
		systemSoftwareUpdateSend();
	}
}
function systemSoftwareUpdateSend() {
	var targetFile = systemUpdateTargetFileArray.shift();
	if( targetFile && targetFile.length > 0 ) {
		systemUpdateHttpObject	= FormerCommon.createHttpRequest(systemSoftwareUpdateSendResult);
		if( systemUpdateHttpObject ) {
			var contents = encodeURIComponent('product')+ "="+encodeURIComponent('<?php echo RELEASE_NAME; ?>');
			contents += '&'+encodeURIComponent('version')+ "="+encodeURIComponent(systemUpdateTargetVersion);
			contents += '&'+encodeURIComponent('targetFile')+ "="+encodeURIComponent(targetFile);
			FormerCommon.displayGrayoutMessage(targetFile+'を更新しています...<br />' + updateFileCount + 'ファイル中' + systemUpdateTargetFileArray.length + 'ファイル目');
			systemUpdateHttpObject.open("POST",'./update.php',true);
			systemUpdateHttpObject.setRequestHeader("Content-Type", "application/x-www-form-urlencoded");
			systemUpdateHttpObject.send(contents);
		} else {
			alert('サーバー通信作成に失敗しました!');
			setTimeout(FormerCommon.displayWhiteIn, 100);
		}
	} else {
		alert('ソフトウェアアップデートが完了しました!');
		setTimeout(FormerCommon.displayWhiteIn, 100);
		setTimeout(systemGetMdsToolsVersion, 600);
	}
}
function systemSoftwareUpdateSendResult() {
	if ((systemUpdateHttpObject.readyState == 4) && (systemUpdateHttpObject.status == 200)){
	    var lines	= systemUpdateHttpObject.responseText.cr2lf().split(LF);
	    var isError = false;
	    var error_message	= '';
	    for( var i=0; i<lines.length; i++ ){
			if( String(lines[i]).cr2lf().trim().length>0 ){
				var result	= String(lines[i]).cr2lf().trim();
				if( result == 'OK' ) {
					break;
				} else if( isError ) {
					error_message += result + "\n";
				} else {
					isError	= true;
				}
			}
		}
		if( isError ) {
			alert('ファイルの更新に失敗しました!\n'+error_message);
			setTimeout(FormerCommon.displayWhiteIn, 100);
		} else {
			if( systemUpdateTargetFileArray.length == 0 ) {
				alert('ソフトウェアアップデートが完了しました!');
				setTimeout(FormerCommon.displayWhiteIn, 100);
				setTimeout(systemGetMdsToolsVersion, 600);
			} else {
				systemSoftwareUpdateSend();
			}
		}
	} else if ((systemUpdateHttpObject.readyState == 4) && (systemUpdateHttpObject.status != 200)){
		alert('適用時にサーバー通信でエラーが発生しました。Status = ' + systemUpdateHttpObject.status);
		setTimeout(FormerCommon.displayWhiteIn, 100);
	}
}
if(window.attachEvent){
	window.attachEvent('onload',systemGetMdsToolsVersion);
}else{
	window.addEventListener('DOMContentLoaded',systemGetMdsToolsVersion,false);
}
//--></script>
<style type="text/css">
div.version-title {
	font-size: 16px;
	font-weight: bold;
	color : #008000;
}
div.version-date {
	text-align: right;
}
div.version-description {
	
}
div.version-files {
	font-size: x-small;
	margin-top: 1em;
	margin-bottom: 1.5em;
	border: dotted 1px #c0c0c0;
	padding: 5px;
}
div.version-update {
	text-align: right;
	margin-bottom: 2em;
}
</style>
	{/if}
	{else}
		<p>パッケージがインストールされていません</p>
	{/if}
