<?php include_once( "../../../../spider.inc.php" ); ?>
{charset:UTF-8}
{template:admin_default.tpl}
{module:shopping.category.LoadList}
{module:shopping.product.unit.Load}
{preset:page_title 'ショップ管理 > ' . SHOPPING_LABEL_PRODUCT . '管理 > 販売単位の詳細'}

	{set:shoppingProductObject shopping.product.unit.unit_object->'shoppingProductObject'}
	{set:searchDataObject shoppingProductObject->'searchDataObject'}
	<div class="panc">
		<a href="../../../">管理パネルトップ</a>
		{if:is_object(shoppingProductObject->'searchDataObject')}
		&gt; <a href="../../../search/data/detail.php?schdi={write:shoppingProductObject->'searchDataObject'->'data_id'}">{write:shoppingProductObject->'searchDataObject'->'subject'}</a>
		&gt; <a href="../?schdi={write:shoppingProductObject->'searchDataObject'->'data_id'}">{write:SHOPPING_LABEL_PRODUCT}一覧</a>
		{else}
		&gt; <a href="../../">ショップ管理</a>
		&gt; <a href="../">{write:SHOPPING_LABEL_PRODUCT}管理</a>
		{/if}
		&gt; <a href="../detail.php?shpdn={write:shoppingProductObject->'product_number'}">{write:shoppingProductObject->'product_name'}</a>
		&gt; {write:shopping.product.unit.unit_object->'unit_name'}
	</div>

	<h1 style="font-size:14px;">
		{write:SHOPPING_LABEL_PRODUCT}管理
		{if:is_object(shoppingProductObject->'searchDataObject')}
		&gt;{write:shoppingProductObject->'searchDataObject'->'subject'}
		{/if}
		&gt; {write:shoppingProductObject->'product_name'}
		&gt; {write:shopping.product.unit.unit_object->'unit_name'}
	</h1>

{if:IS_ERROR}
	<ul class="error">
	{foreach:errors error}
		<li>{write:error}</li>
	{/foreach}
	</ul>
	<p style="text-align:center;">
		<input type="button" value="戻る"
			onclick="window.history.back();"
		/><br />
	</p>
	<br />
{else}

	{if:shoppingProductObject->'status_flag'<100}
	<div style="width:96%;margin:0 auto;color:#ff0000;">
		この販売単位が属する{write:SHOPPING_LABEL_PRODUCT}は現在非公開です。公開するには状態を「掲載中」に変更してください。
	</div>
	{/if}
	{if:shopping.product.unit.unit_object->'status_flag'<100}
	<div style="width:96%;margin:0 auto;color:#ff0000;">
		この販売単位は現在非公開です。公開するには販売単位の状態を「掲載中」に変更してください。
	</div>
	{/if}

	<div style="width:96%;margin:0 auto;text-align:right;">
		<a href="./form.php?shpun={write:shopping.product.unit.unit_object->'unit_number'}" title="この内容を編集します"
		>&gt;&gt;編集する</a>
	</div>
	
	<h2 class="global">{write:SHOPPING_LABEL_PRODUCT}の基本情報</h2>
	<table class="detail" style="width:96%;margin:0 auto;">
	<tbody>
	<tr>
		<th style="width:12em;">{write:SHOPPING_LABEL_PRODUCT}ID</th>
		<td>{write:shoppingProductObject->'product_id'}</td>
	</tr>
	<tr>
		<th style="width:12em;">{write:SHOPPING_LABEL_PRODUCT}の状態</th>
		<td>
			<select name="status_flag_{write:shoppingProductObject->'product_number'}"
			onchange="shoppingProductStatusChange({write:shoppingProductObject->'product_number'},this.options[this.selectedIndex].value)">
			{foreach:SHOPPING_PRODUCT_STATUS_HASH key status_name}
				<option value="{write:key}"
					{if:key==shoppingProductObject->'status_flag'} selected{/if}
					>{write:status_name}</option>
			{/foreach}
			</select>
		</td>
	</tr>
	<tr>
		<th style="width:12em;">{write:SHOPPING_LABEL_PRODUCT}名</th>
		<td>{write:shoppingProductObject->'product_name'}</td>
	</tr>
	</tbody>
	</table>
	<br />

	<h2 class="global">販売単位の基本情報</h2>
	<table class="detail" style="width:96%;margin:0 auto;">
	<tbody>
	<tr>
		<th style="width:12em;">{write:SHOPPING_LABEL_PRODUCT}販売単位ID</th>
		<td>{write:shopping.product.unit.unit_object->'unit_id'}</td>
	</tr>
	<tr>
		<th style="width:12em;">{write:SHOPPING_LABEL_PRODUCT}販売単位名</th>
		<td>{write:shopping.product.unit.unit_object->'unit_name'}</td>
	</tr>
	<tr>
		<th style="width:12em;">{write:SHOPPING_LABEL_PRODUCT}販売単位名フリガナ</th>
		<td>{write:shopping.product.unit.unit_object->'unit_kana'}</td>
	</tr>
	<tr>
		<th style="width:12em;">販売単位の状態</th>
		<td>
			<select name="status_flag"
			onchange="shoppingProductUnitStatusChange({write:shopping.product.unit.unit_object->'unit_number'},this.options[this.selectedIndex].value)">
			{foreach:SHOPPING_PRODUCT_STATUS_HASH key status_name}
				<option value="{write:key}"
					{if:key==shopping.product.unit.unit_object->'status_flag'} selected{/if}
					>{write:status_name}</option>
			{/foreach}
			</select>
		</td>
	</tr>
	<tr>
		<th style="width:12em;">Web用在庫数</th>
		<td>
			{if:'-4'==shopping.product.unit.unit_object->'stock'}
				在庫連動(合計)<br />
				{write:shopping.product.unit.unit_object->'stock_relation'}<br />
				在庫共有減算数:{write:shopping.product.unit.unit_object->'stock_relation_count'}個
			{else-if:'-3'==shopping.product.unit.unit_object->'stock'}
				在庫連動(最多)<br />
				{write:shopping.product.unit.unit_object->'stock_relation'}<br />
				在庫共有減算数:{write:shopping.product.unit.unit_object->'stock_relation_count'}個
			{else-if:'-2'==shopping.product.unit.unit_object->'stock'}
				在庫連動(最少)<br />
				{write:shopping.product.unit.unit_object->'stock_relation'}<br />
				在庫共有減算数:{write:shopping.product.unit.unit_object->'stock_relation_count'}個
			{else-if:'-1'==shopping.product.unit.unit_object->'stock'}
				無制限
			{else}
				{write:shopping.product.unit.unit_object->'stock'}
			{/if}
		</td>
	</tr>
	<tr>
		<th style="width:12em;">実在庫数</th>
		<td>
			{if:''==shopping.product.unit.unit_object->'stock_display'}
				Web用在庫数と同じ
			{else-if:'-1'==shopping.product.unit.unit_object->'stock_display'}
				無制限
			{else}
				{write:shopping.product.unit.unit_object->'stock_display'}
			{/if}
		</td>
	</tr>
	<tr>
		<th style="width:12em;">最大同時{write:SHOPPING_LABEL_ORDER}数</th>
		<td>
			{write:shopping.product.unit.unit_object->'max_at_once'}
		</td>
	</tr>
	<tr>
		<th style="width:12em;">公開販売期間</th>
		<td>
			{if:strlen(shopping.product.unit.unit_object->'open_date')==0 && strlen(shopping.product.unit.unit_object->'close_date')==0}
				制限なし
			{else}
				{if:strlen(shopping.product.unit.unit_object->'open_date')>0}
					{write:shopping.product.unit.unit_object->'open_date'}から
				{/if}
				{if:strlen(shopping.product.unit.unit_object->'close_date')>0}
					{write:shopping.product.unit.unit_object->'close_date'}まで
				{/if}
			{/if}
		</td>
	</tr>
	{if:shopping.product.unit.unit_object->'shoppingProductObject'->'delivery_type'==900}
	<tr>
		<th style="width:12em;">チェックイン時間</th>
		<td>
			{write:shopping.product.unit.unit_object->'default_start_time'}
		</td>
	</tr>
	<tr>
		<th style="width:12em;">チェックアウト時間</th>
		<td>
			{write:substr(shopping.product.unit.unit_object->'default_start_time',0,2) + (shopping.product.unit.unit_object->'service_term'/(60*60)) - 24}:00
		</td>
	</tr>
	{else-if:shopping.product.unit.unit_object->'shoppingProductObject'->'delivery_type'>=200}
	<tr>
		<th style="width:12em;">サービス提供時間</th>
		<td>
			{if:(shopping.product.unit.unit_object->'service_term' % (60*60))==0}
				{write:(shopping.product.unit.unit_object->'service_term' / (60*60))}時間
			{else-if:(shopping.product.unit.unit_object->'service_term' % (60))==0}
				{write:(shopping.product.unit.unit_object->'service_term' / (60))}分
			{else}
				{write:(shopping.product.unit.unit_object->'service_term')}秒
			{/if}
		</td>
	</tr>
	{/if}
	{if:shopping.product.unit.unit_object->'shoppingProductObject'->'delivery_type'>=200}
	<tr>
		<th style="width:12em;white-space:nowrap;">カレンダー種別</th>
		<td>
			{if:'1'==shopping.product.unit.unit_object->'calendar_type'}個別カレンダー利用
			{else-if:'2'==shopping.product.unit.unit_object->'calendar_type'}プロダクトカレンダー利用
			{else}全体カレンダー利用{/if}
		</td>
	</tr>
	<tr>
		<th style="width:12em;">予約日制限</th>
		<td>
			{if:strlen(shopping.product.unit.unit_object->'rsv_permit_start')>0 && shopping.product.unit.unit_object->'rsv_permit_start'>0}
			{write:shopping.product.unit.unit_object->'rsv_permit_start'}営業日後から
			{else}
			当日から
			{/if}
			{if:strlen(shopping.product.unit.unit_object->'rsv_permit_limit')>0 && shopping.product.unit.unit_object->'rsv_permit_limit'>0}
				{write:shopping.product.unit.unit_object->'rsv_permit_limit'}日後まで
			{else}
			制限なく
			{/if}
			予約可能
		</td>
	</tr>
	{/if}
	<tr>
		<th style="width:12em;">{write:SHOPPING_LABEL_PRODUCT}フラグ</th>
		<td>
			{if:count(shopping.product.unit.unit_object::flagObjectHash)>0}
			<table>
			<tbdy>
			<tr>
				<th style="border-style:none;">{write:SHOPPING_LABEL_PRODUCT}フラグ種別</th>
				<th style="border-style:none;">表示順序</th>
				<th style="border-style:none;">公開日</th>
			</tr>
			{foreach:shopping.product.unit.unit_object::flagObjectHash flagId flagObjectHash}
			<tr>
				<td style="border-style:none;vertical-align:top;">
					{write:flagObjectHash['flag_name']}
				</td>
				<td style="border-style:none;vertical-align:top;text-align:center;">
					{write:flagObjectHash['order_number']}
				</td>
				<td style="border-style:none;vertical-align:top;">
					{if:strlen(flagObjectHash['open_date'])>0 or strlen(flagObjectHash['close_date'])>0}
					<span style="white-space:nowrap;">
					{if:strlen(flagObjectHash['open_date'])>0}
					{write:flagObjectHash['open_date_year']}年
					{write:flagObjectHash['open_date_month']}月
					{write:flagObjectHash['open_date_day']}日
					{/if}
					&nbsp;～
					{if:strlen(flagObjectHash['close_date'])>0}
					{write:flagObjectHash['close_date_year']}年
					{write:flagObjectHash['close_date_month']}月
					{write:flagObjectHash['close_date_day']}日
					{/if}
					</span>
					{/if}
				</td>
			</tr>
			{/foreach}
			</tbody>
			</table>
			{/if}
		</td>
	</tr>
	<tr>
		<th style="width:12em;">付与ポイント数</th>
		<td>
			{write:shopping.product.unit.unit_object->'present_point'}Pt.
		</td>
	</tr>
	<tr>
		<th style="width:12em;">梱包目安値</th>
		<td>
			{write:shopping.product.unit.unit_object->'delivery_weight'}
		</td>
	</tr>
	<tr>
		<th style="width:12em;">標準価格(税込)</th>
		<td>{write:shopping.product.unit.unit_object->'price_standard'}円</td>
	</tr>
	<tr>
		<th style="width:12em;">販売価格(税込)</th>
		<td>{write:shopping.product.unit.unit_object->'price_sell'}円</td>
	</tr>
	<tr>
		<th style="width:12em;">仕入れ値(税込)</th>
		<td>{write:shopping.product.unit.unit_object->'cost'}円</td>
	</tr>
	<tr>
		<th style="width:12em;">月次課金価格(税込)</th>
		<td>{write:shopping.product.unit.unit_object->'price_monthly'}円</td>
	</tr>
	<tr>
		<th style="width:12em;">順序番号</th>
		<td>{write:shopping.product.unit.unit_object->'order_number'}</td>
	</tr>
	<tr>
		<th style="width:12em;">プロモ割引</th>
		<td>
			{if:shopping.product.unit.unit_object->'discount_exception'!='1'}通常{/if}
			{if:shopping.product.unit.unit_object->'discount_exception'=='1'}割引しない{/if}
		</td>
	</tr>
	<tr>
		<th style="width:12em;">紹介文</th>
		<td>{write:nl2br(shopping.product.unit.unit_object->'description')}</td>
	</tr>
	</tbody>
	</table>
	<br />
	
	{set:fileIdArray shopping.product.unit.unit_object->'fileIdArray'}
	{if:isset(fileIdArray[0]) || isset(fileIdArray[1]) || isset(fileIdArray[2])}
	<h2>{write:SHOPPING_LABEL_PRODUCT}画像</h2>
	<div style="width:96%;margin:0 auto;text-align:center;">
		{if:isset(fileIdArray[0])}
			<img src="/file/download.php?fi={write:fileIdArray[0]}&amp;w=240&amp;h=240" />
		{/if}
		{if:isset(fileIdArray[1])}
			<img src="/file/download.php?fi={write:fileIdArray[1]}&amp;w=240&amp;h=240" />
		{/if}
		{if:isset(fileIdArray[2])}
			<img src="/file/download.php?fi={write:fileIdArray[2]}&amp;w=240&amp;h=240" />
		{/if}
	</div>
	<br />
	{/if}
	
	<h2>{write:SHOPPING_LABEL_PRODUCT}情報の上書き設定</h2>
	<table class="detail" style="width:96%;margin:0 auto;">
	<tbody>
	<tr>
		<th style="width:12em;">数え方</th>
		<td>{write:shopping.product.unit.unit_object->'unit_string'}</td>
	</tr>
	<tr>
		<th style="width:12em;">商品種別</th>
		<td>{write:SHOPPING_DELIVERY_TYPE_HASH[shopping.product.unit.unit_object->'delivery_type']}</td>
	</tr>
	<tr>
		<th style="width:12em;">閲覧許可</th>
		<td style="padding:0px;">
			{foreach:MEMBER_MEMBER_CLASS_HASH key value}
			<input type="checkbox" name="member_viewable[]" value="{write:key}"
			{if:in_array(key,shopping.product.unit.unit_object->'memberViewableArray')} checked{/if}
			onclick="shoppingProductUnitOpenChange()"
			/>{write:mb_substr(value,0,10)}
			{/foreach}
		</td>
	</tr>
	<tr>
		<th style="width:12em;">{write:SHOPPING_LABEL_ORDER}許可</th>
		<td style="padding:0px;">
			{foreach:MEMBER_MEMBER_CLASS_HASH key value}
			<input type="checkbox" name="member_purchasable[]" value="{write:key}"
			{if:in_array(key,shopping.product.unit.unit_object->'memberPurchasableArray')} checked{/if}
			onclick="shoppingProductUnitOpenChange()"
			/>{write:mb_substr(value,0,10)}
			{/foreach}
		</td>
	</tr>
	</tbody>
	</table><br />
	
	{if:strlen(shopping.product.unit.unit_object->'detail_comment')>0}
	<h2>追加説明文(HTML可)</h2>
	<div style="width:96%;margin:0 auto;border:solid 1px #808080;padding:3px;">
		{write:shopping.product.unit.unit_object->'detail_comment' noescape}
	</div>
	<br />
	{/if}
	
	{if:'11'==shopping.product.unit.unit_object->'delivery_type'}
	<h2 class="global">ダウンロード用ファイル</h2>
	<table class="detail" style="width:96%;margin:0 auto;">
	<tbody>
	{foreach:fileIdArray num fileId}{if:num>=100}
	<tr>
		<th style="width:12em;">ダウンロードファイル{write:num-99}</th>
		<td>
			<a href="/file/download.php?fi={write:fileId}&amp;dt=download" target="_blank">ダウンロード確認</a>
		</td>
	</tr>
	{/if}{/foreach}
	</tbody>
	</table><br />
	{/if}

	{if:strlen(shopping.product.unit.unit_object->'option1_name')>0 || strlen(shopping.product.unit.unit_object->'option2_name')>0 || strlen(shopping.product.unit.unit_object->'option3_name')>0 || strlen(shopping.product.unit.unit_object->'option4_name')>0 || strlen(shopping.product.unit.unit_object->'option5_name')>0}
	<h2 class="global">販売単位の固有の{write:SHOPPING_LABEL_ORDER}オプション</h2>

	<?php
		for( $GLOBALS['optionNumber']=1; $GLOBALS['optionNumber']<=5; $GLOBALS['optionNumber']++ ) {
			$GLOBALS['optionVarName']		= 'option'.$GLOBALS['optionNumber'].'_name';
			$GLOBALS['optionItemsName']	= 'option'.$GLOBALS['optionNumber'].'_items';
			$GLOBALS['optionUrlName']		= 'option'.$GLOBALS['optionNumber'].'_url';
			$GLOBALS['optionExpName']	= 'option'.$GLOBALS['optionNumber'].'_explanation';
			$GLOBALS['optionCalcName']		= 'option'.$GLOBALS['optionNumber'].'_calculate';
			$optionItemArray	= explode("\n",str_replace("\n\n","\n",str_replace("\r\n","\n",str_replace("\r","\n",trim($GLOBALS['shopping.product.unit.unit_object']->$GLOBALS['optionItemsName'])))));
			$GLOBALS['optionType']		= $optionItemArray[0];
			if( '__INPUT_TYPE_TEXT__' == $GLOBALS['optionType'] ) {
				$GLOBALS['optionCols']	= $optionItemArray[1];
			} else if( '__INPUT_TYPE_TEXTAREA__' == $GLOBALS['optionType'] ) {
				$GLOBALS['optionCols']	= $optionItemArray[1];
				$GLOBALS['optionRows']	= $optionItemArray[2];
			} else {
				$GLOBALS['optionType']	= '__SELECT__';
			}
	?>
	{if:strlen(trim(shopping.product.unit.unit_object->optionItemsName))>0}
	<table class="detail" style="width:95%;margin:0 auto;">
	<tbody>
	<tr>
		<th style="width:12em;">オプション{write:optionNumber}項目名</th>
		<td>{write:shopping.product.unit.unit_object->optionVarName}</td>
	</tr>
	<tr>
		<th style="width:12em;">オプション{write:optionNumber}設定</th>
		<td>
			{if:optionType=='__INPUT_TYPE_TEXT__'}
				[テキスト] 入力欄サイズ：{write:optionCols}
			{else-if:optionType=='__INPUT_TYPE_TEXTAREA__'}
				[複数行テキスト] 横幅：{write:optionCols} 行数：{write:optionRows}
			{else-if:strlen(trim(shopping.product.unit.unit_object->optionItemsName))>0}
				[選択ボックス]<br />
				{write:nl2br(shopping.product.unit.unit_object->optionItemsName)}
			{/if}
		</td>
	</tr>
	<tr>
		<th style="width:12em;">オプション{write:optionNumber}説明文</th>
		<td>
			{write:shopping.product.unit.unit_object->optionExpName noescape}
		</td>
	</tr>
	<tr>
		<th style="width:12em;">オプション金額計算方法</th>
		<td>
			{if:'1'!=shopping.product.unit.unit_object->optionCalcName}注文数で乗算する{/if}
			{if:'1'==shopping.product.unit.unit_object->optionCalcName}注文数で乗算しない{/if}
		</td>
	</tr>
	</tbody>
	</table><br />
	{/if}
	<?php } ?>
	
	{/if}
	
	{if:shopping.product.unit.unit_object->'delivery_type'>=200}
	<h2>予約状況レポート</h2>
	<form name="sform" method="get" action="./index.php">
	<input type="hidden" name="shpdi" value="{write:shopping.calendar.productId}" />
	<input type="hidden" name="shpui" value="{write:shopping.calendar.unitId}" />
	<div style="width:96%;margin:0 auto;font-size:large;">
		<select name="sclty">
		<?php for( $year = date('Y')+1; $year>date('Y')-3; $year-- ) { ?>
			<option value="<?php echo $year; ?>"
				<?php if($year==date('Y')) { ?> selected<?php } ?>
			><?php echo $year; ?></option>
		<?php } ?>
		</select>年<select name="scltm" onchange="shoppingCalendarShow();">
		<?php for( $month = 1; $month<=12; $month++ ) { ?>
			<option value="<?php echo $month; ?>"
				<?php if($month==date('m')) { ?> selected<?php } ?>
			><?php echo $month; ?></option>
		<?php } ?>
		</select>月
	</div>
	</form>
	<div id="shopping-calendar-area"></div>
	{/if}
<style type="text/css"><!--
table.calendar {
	border: solid 1px #808080;
	border-collapse: collapse;
}
table.calendar thead tr th {
	border: solid 1px #c0c0c0;
	padding: 3px;
	background-color: #e0e0e0;
	border: solid 1px #808080;
}
table.calendar tbody tr td {
	vertical-align: top;
	border: solid 1px #808080;
}
//--></style>
<script type="text/javascript"><!--
var shoppingProductStatusHttpObject;
//
// {write:SHOPPING_LABEL_PRODUCT}の状態を変更する
//
function shoppingProductStatusChange(productNumber,statusFlag) {
	var contents	= 'product_number='+productNumber
	+'&status_flag='+statusFlag;
	shoppingProductStatusHttpObject	= FormerCommon.createHttpRequest(shoppingProductStatusChangeResult);
	if( shoppingProductStatusHttpObject ) {
		FormerCommon.displayGrayOut(9999);
		shoppingProductStatusHttpObject.open("POST",'../status.php',true);
		shoppingProductStatusHttpObject.setRequestHeader("Content-Type", "application/x-www-form-urlencoded");
		shoppingProductStatusHttpObject.send(contents);
	} else {
		alert('サーバー通信作成に失敗しました!');
	}
}
function shoppingProductStatusChangeResult(){
	if ((shoppingProductStatusHttpObject.readyState == 4) && (shoppingProductStatusHttpObject.status == 200)){
		setTimeout(FormerCommon.displayWhiteIn, 100);
	    var lines	= shoppingProductStatusHttpObject.responseText.cr2lf().split(LF);
	    var result	= '';
	    while( result.length == 0 && lines.length > 0 ) {
	    	result	= lines.shift();
	    }
	    if( 'OK' == result ) {
	    } else {
	    	alert(shoppingProductStatusHttpObject.responseText);
	    }
	} else if ((shoppingProductStatusHttpObject.readyState == 4) && (shoppingProductStatusHttpObject.status != 200)){
		alert('状態変更中にサーバー通信に失敗しました');
	}
}
//
// 販売単位の状態を変更する
//
function shoppingProductUnitStatusChange(unitNumber,statusFlag) {
	var contents	= 'unit_number='+unitNumber
	+'&status_flag='+statusFlag;
	shoppingProductStatusHttpObject	= FormerCommon.createHttpRequest(shoppingProductUnitStatusChangeResult);
	if( shoppingProductStatusHttpObject ) {
		FormerCommon.displayGrayOut(9999);
		shoppingProductStatusHttpObject.open("POST",'./status.php',true);
		shoppingProductStatusHttpObject.setRequestHeader("Content-Type", "application/x-www-form-urlencoded");
		shoppingProductStatusHttpObject.send(contents);
	} else {
		alert('サーバー通信作成に失敗しました!');
	}
}
function shoppingProductUnitStatusChangeResult(){
	if ((shoppingProductStatusHttpObject.readyState == 4) && (shoppingProductStatusHttpObject.status == 200)){
		setTimeout(FormerCommon.displayWhiteIn, 100);
	    var lines	= shoppingProductStatusHttpObject.responseText.cr2lf().split(LF);
	    var result	= '';
	    while( result.length == 0 && lines.length > 0 ) {
	    	result	= lines.shift();
	    }
	    if( 'OK' == result ) {
	    } else {
	    	alert(shoppingProductStatusHttpObject.responseText);
	    }
	} else if ((shoppingProductStatusHttpObject.readyState == 4) && (shoppingProductStatusHttpObject.status != 200)){
		alert('状態変更中にサーバー通信に失敗しました');
	}
}
//
// {write:SHOPPING_LABEL_PRODUCT}の権限を変更する
//
function shoppingProductUnitOpenChange() {
	var contents	= 'unit_number={write:shopping.product.unit.unit_object->'unit_number'}';
	var checkName	= 'member_viewable[]';
	var viewCheckArray	= document.getElementsByName(checkName);
	for( var num=0; num<viewCheckArray.length; num++ ) {
		if( viewCheckArray[num] && viewCheckArray[num].checked ) {
			contents	+= '&'+encodeURIComponent('member_viewable[]')+'='+viewCheckArray[num].value;
		}
	}
	checkName	= 'member_purchasable[]';
	var purchaseCheckArray	= document.getElementsByName(checkName);
	for( var num=0; num<purchaseCheckArray.length; num++ ) {
		if( purchaseCheckArray[num] && purchaseCheckArray[num].checked ) {
			contents	+= '&'+encodeURIComponent('member_purchasable[]')+'='+purchaseCheckArray[num].value;
		}
	}
	shoppingProductStatusHttpObject	= FormerCommon.createHttpRequest(shoppingProductUnitOpenChangeResult);
	if( shoppingProductStatusHttpObject ) {
		FormerCommon.displayGrayOut(9999);
		shoppingProductStatusHttpObject.open("POST",'./memberclass.php',true);
		shoppingProductStatusHttpObject.setRequestHeader("Content-Type", "application/x-www-form-urlencoded");
		shoppingProductStatusHttpObject.send(contents);
	} else {
		alert('サーバー通信作成に失敗しました!');
	}
}
function shoppingProductUnitOpenChangeResult(){
	if ((shoppingProductStatusHttpObject.readyState == 4) && (shoppingProductStatusHttpObject.status == 200)){
		setTimeout(FormerCommon.displayWhiteIn, 100);
	    var lines	= shoppingProductStatusHttpObject.responseText.cr2lf().split(LF);
	    var result	= '';
	    while( result.length == 0 && lines.length > 0 ) {
	    	result	= lines.shift();
	    }
	    if( 'OK' == result ) {
	    } else {
	    	alert(shoppingProductStatusHttpObject.responseText);
	    }
	} else if ((shoppingProductStatusHttpObject.readyState == 4) && (shoppingProductStatusHttpObject.status != 200)){
		alert('状態変更中にサーバー通信に失敗しました');
	}
}
{if:shopping.product.unit.unit_object->'delivery_type'>=200}
//
// カレンダー
//
var shoppingCalendarHttpObject;
var shoppingCalendarToReserve	= false;
//
// カレンダー表示を更新する
//
function shoppingCalendarShow(){
	var targetYear	= document.sform.sclty.options[document.sform.sclty.selectedIndex].value;
	var targetMonth	= document.sform.scltm.options[document.sform.scltm.selectedIndex].value;
	shoppingCalendarHttpObject	= FormerCommon.createHttpRequest(shoppingCalendarShowResult);
	if( shoppingCalendarHttpObject ) {
		FormerCommon.displayGrayOut(9999);
		{if:shopping.product.unit.unit_object->'delivery_type'==900}
		var uri = './cal.php?sclty='+targetYear+'&scltm='+targetMonth+'&shpui='+encodeURIComponent('{write:shopping.product.unit.unit_object->'unit_id'}');
		{else}
		var uri = './tt.php?sclty='+targetYear+'&scltm='+targetMonth+'&shpui='+encodeURIComponent('{write:shopping.product.unit.unit_object->'unit_id'}');
		{/if}
		shoppingCalendarHttpObject.open("GET",uri,true);
		shoppingCalendarHttpObject.setRequestHeader("Content-Type", "application/x-www-form-urlencoded");
		shoppingCalendarHttpObject.send(null);
	} else {
		alert('サーバー通信作成に失敗しました!');
	}
}
function shoppingCalendarShowResult() {
	if ((shoppingCalendarHttpObject.readyState == 4) && (shoppingCalendarHttpObject.status == 200)){
	    var calendarArea	= document.getElementById('shopping-calendar-area');
	    if( calendarArea ) {
	    	calendarArea.innerHTML	= shoppingCalendarHttpObject.responseText;
	    }
	    setTimeout(FormerCommon.displayWhiteIn, 100);
	} else if ((shoppingCalendarHttpObject.readyState == 4) && (shoppingCalendarHttpObject.status != 200)){
		alert('状態変更中にサーバー通信に失敗しました');
		setTimeout(FormerCommon.displayWhiteIn, 100);
	}
}
if(window.attachEvent){
	window.attachEvent('onload',shoppingCalendarShow);
}else{
	window.addEventListener('DOMContentLoaded',shoppingCalendarShow,false);
}
{/if}
//--></script>
{/if}
	<hr style="width:96%;margin:0 auto;margin-top:1em;" />
	<div style="width:96%;margin:0 auto;text-align:right;">
		{if:is_object(shoppingProductObject->'searchDataObject')}
		<span style="white-space:nowrap"><a href="../../../search/data/detail.php?schdi={write:shoppingProductObject->'searchDataObject'->'data_id'}"
		>&gt;&gt;{write:shoppingProductObject->'searchDataObject'->'subject'}の詳細</a></span>
		<span style="white-space:nowrap">&nbsp;&nbsp;<a href="../?schdi={write:shoppingProductObject->'searchDataObject'->'data_id'}"
		>&gt;&gt;{write:shoppingProductObject->'searchDataObject'->'subject'}の{write:SHOPPING_LABEL_PRODUCT}一覧</a></span>
		<span style="white-space:nowrap">&nbsp;&nbsp;<a href="../detail.php?shpdn={write:shoppingProductObject->'product_number'}"
		>&gt;&gt;{write:shoppingProductObject->'product_name'}の詳細</a></span>
		{else}
		<span style="white-space:nowrap"><a href="../">&gt;&gt;{write:SHOPPING_LABEL_PRODUCT}管理</a></span>
		<span style="white-space:nowrap">&nbsp;&nbsp;<a href="../">&gt;&gt;{write:SHOPPING_LABEL_PRODUCT}一覧</a></span>
		{/if}
		<span style="white-space:nowrap">&nbsp;&nbsp;<a href="./form.php?shpun={write:shopping.product.unit.unit_object->'unit_number'}" title="この内容を編集します"
		>&gt;&gt;編集する</a></a>
	</div>