<?php include_once( "../../../../spider.inc.php" ); ?>
{charset:UTF-8}
{template:admin_default.tpl}
{module:shopping.category.LoadList}
{module:shopping.product.unit.Confirm}
{preset:page_title 'ショップ管理 > ' . SHOPPING_LABEL_PRODUCT . '管理 > 販売単位の追加・編集'}

	{set:shoppingProductObject shopping.product.unit.unit_object->'shoppingProductObject'}
	{set:searchDataObject shoppingProductObject->'searchDataObject'}
	<div class="panc">
		<a href="../../../">管理パネルトップ</a>
		{if:is_object(shoppingProductObject->'searchDataObject')}
		&gt; <a href="../../../search/data/detail.php?schdi={write:shoppingProductObject->'searchDataObject'->'data_id'}">{write:shoppingProductObject->'searchDataObject'->'subject'}</a>
		&gt; <a href="../?schdi={write:shoppingProductObject->'searchDataObject'->'data_id'}">{write:SHOPPING_LABEL_PRODUCT}一覧</a>
		{else}
		&gt; <a href="../../">ショップ管理</a>
		&gt; <a href="../">{write:SHOPPING_LABEL_PRODUCT}管理</a>
		{/if}
		&gt; <a href="../detail.php?shpdn={write:shoppingProductObject->'product_number'}">{write:shoppingProductObject->'product_name'}</a>
		{if:strlen(shopping.product.unit.unit_object->'unit_number')==0}
		&gt; 販売単位の新規作成
		{else}
		&gt; <a href="./detail.php?shpun={write:shopping.product.unit.unit_object->'unit_number'}">{write:shopping.product.unit.unit_object->'unit_name'}</a>
		&gt; 編集
		{/if}
	</div>

	<h1>
		{write:SHOPPING_LABEL_PRODUCT}管理 &gt; {write:shoppingProductObject->'product_name'}
		{if:strlen(shopping.product.unit.unit_object->'unit_number')==0}
		&gt; 販売単位の新規作成
		{else}
		&gt; {write:shopping.product.unit.unit_object->'unit_name'}
		&gt; 編集
		{/if}
	</h1>

{if:IS_ERROR}
	<ul class="error">
	{foreach:errors error}
		<li>{write:error}</li>
	{/foreach}
	</ul>
	<p style="text-align:center;">
		<input type="button" value="戻る"
			onclick="window.history.back();"
		/><br />
	</p>
	<br />
{else}

	<form name="cform" action="./execute.php?shpun={write:shopping.product.unit.unit_object->'unit_number'}" method="post">
	<p style="text-align:center;">
		入力内容に間違いなければ「実行」ボタンをクリックしてください。
	</p>
	<h2 class="global">{write:SHOPPING_LABEL_PRODUCT}の基本情報</h2>
	<table class="detail" style="width:96%;margin:0 auto;">
	<tbody>
	<tr>
		<th style="width:12em;">{write:SHOPPING_LABEL_PRODUCT}ID</th>
		<td>{write:shoppingProductObject->'product_id'}</td>
	</tr>
	<tr>
		<th style="width:12em;">{write:SHOPPING_LABEL_PRODUCT}名</th>
		<td>{write:shoppingProductObject->'product_name'}</td>
	</tr>
	</tbody>
	</table>
	<br />

	<h2 class="global">販売単位の基本情報</h2>
	<table class="detail" style="width:96%;margin:0 auto;">
	<tbody>
	<tr>
		<th style="width:12em;">販売単位ID</th>
		<td>{write:shopping.product.unit.unit_object->'unit_id'}</td>
	</tr>
	<tr>
		<th style="width:12em;">販売単位名</th>
		<td>{write:shopping.product.unit.unit_object->'unit_name'}</td>
	</tr>
	<tr>
		<th style="width:12em;">販売単位名フリガナ</th>
		<td>{write:shopping.product.unit.unit_object->'unit_kana'}</td>
	</tr>
	<tr>
		<th style="width:12em;">Web用在庫数</th>
		<td>
			{if:'-4'==shopping.product.unit.unit_object->'stock'}
				在庫連動(合計)<br />
				{write:shopping.product.unit.unit_object->'stock_relation'}<br />
				在庫共有減算数:{write:shopping.product.unit.unit_object->'stock_relation_count'}個
			{else-if:'-3'==shopping.product.unit.unit_object->'stock'}
				在庫連動(最多)<br />
				{write:shopping.product.unit.unit_object->'stock_relation'}<br />
				在庫共有減算数:{write:shopping.product.unit.unit_object->'stock_relation_count'}個
			{else-if:'-2'==shopping.product.unit.unit_object->'stock'}
				在庫連動(最少)<br />
				{write:shopping.product.unit.unit_object->'stock_relation'}<br />
				在庫共有減算数:{write:shopping.product.unit.unit_object->'stock_relation_count'}個
			{else-if:'-1'==shopping.product.unit.unit_object->'stock'}
				無制限
			{else}
				{write:shopping.product.unit.unit_object->'stock'}
			{/if}
		</td>
	</tr>
	<tr>
		<th style="width:12em;">実在庫数</th>
		<td>
			{if:''==shopping.product.unit.unit_object->'stock_display'}
				Web用在庫数と同じ
			{else-if:'-1'==shopping.product.unit.unit_object->'stock_display'}
				無制限
			{else}
				{write:shopping.product.unit.unit_object->'stock_display'}
			{/if}
		</td>
	</tr>
	<tr>
		<th style="width:12em;">最大同時{write:SHOPPING_LABEL_ORDER}数</th>
		<td>
			{write:shopping.product.unit.unit_object->'max_at_once'}
		</td>
	</tr>
	<tr>
		<th style="width:12em;">公開販売期間</th>
		<td>
			{if:strlen(shopping.product.unit.unit_object->'open_date')==0 && strlen(shopping.product.unit.unit_object->'close_date')==0}
				制限なし
			{else}
				{if:strlen(shopping.product.unit.unit_object->'open_date')>0}
					{write:shopping.product.unit.unit_object->'open_date'}から
				{/if}
				{if:strlen(shopping.product.unit.unit_object->'close_date')>0}
					{write:shopping.product.unit.unit_object->'close_date'}まで
				{/if}
			{/if}
		</td>
	</tr>
	{if:shopping.product.unit.unit_object->'shoppingProductObject'->'delivery_type'==900}
	<tr>
		<th style="width:12em;">チェックイン時間</th>
		<td>
			{write:shopping.product.unit.unit_object->'default_start_time'}
		</td>
	</tr>
	<tr>
		<th style="width:12em;">チェックアウト時間</th>
		<td>
			{write:substr(shopping.product.unit.unit_object->'default_start_time',0,2) + (shopping.product.unit.unit_object->'service_term'/(60*60)) - 24}:00
		</td>
	</tr>
	{else-if:shopping.product.unit.unit_object->'shoppingProductObject'->'delivery_type'>=200}
	<tr>
		<th style="width:12em;">サービス提供時間</th>
		<td>
			{if:(shopping.product.unit.unit_object->'service_term' % (60*60))==0}
				{write:(shopping.product.unit.unit_object->'service_term' / (60*60))}時間
			{else-if:(shopping.product.unit.unit_object->'service_term' % (60))==0}
				{write:(shopping.product.unit.unit_object->'service_term' / (60))}分
			{else}
				{write:(shopping.product.unit.unit_object->'service_term')}秒
			{/if}
		</td>
	</tr>
	{/if}
	{if:shopping.product.unit.unit_object->'shoppingProductObject'->'delivery_type'>=200}
	<tr>
		<th style="width:12em;white-space:nowrap;">カレンダー種別</th>
		<td>
			{if:'1'==shopping.product.unit.unit_object->'calendar_type'}個別カレンダー利用
			{else-if:'2'==shopping.product.unit.unit_object->'calendar_type'}プロダクトカレンダー利用
			{else}全体カレンダー利用{/if}
		</td>
	</tr>
	<tr>
		<th style="width:12em;">予約日制限</th>
		<td>
			{if:strlen(shopping.product.unit.unit_object->'rsv_permit_start')>0 && shopping.product.unit.unit_object->'rsv_permit_start'>0}
			{write:shopping.product.unit.unit_object->'rsv_permit_start'}営業日後から
			{else}
			当日から
			{/if}
			{if:strlen(shopping.product.unit.unit_object->'rsv_permit_limit')>0 && shopping.product.unit.unit_object->'rsv_permit_limit'>0}
				{write:shopping.product.unit.unit_object->'rsv_permit_limit'}日後まで
			{else}
			制限なく
			{/if}
			予約可能
		</td>
	</tr>
	{/if}
	<tr>
		<th style="width:12em;">{write:SHOPPING_LABEL_PRODUCT}フラグ</th>
		<td>
			{if:count(shopping.product.unit.unit_object::flagObjectHash)>0}
			<table>
			<tbdy>
			<tr>
				<th style="border-style:none;">{write:SHOPPING_LABEL_PRODUCT}フラグ種別</th>
				<th style="border-style:none;">表示順序</th>
				<th style="border-style:none;">公開日</th>
			</tr>
			{foreach:shopping.product.unit.unit_object::flagObjectHash flagId flagObjectHash}
			<tr>
				<td style="border-style:none;vertical-align:top;">
					{write:flagObjectHash['flag_name']}
				</td>
				<td style="border-style:none;vertical-align:top;text-align:center;">
					{write:flagObjectHash['order_number']}
				</td>
				<td style="border-style:none;vertical-align:top;">
					{if:strlen(flagObjectHash['open_date'])>0 or strlen(flagObjectHash['close_date'])>0}
					<span style="white-space:nowrap;">
					{if:strlen(flagObjectHash['open_date'])>0}
					{write:flagObjectHash['open_date_year']}年
					{write:flagObjectHash['open_date_month']}月
					{write:flagObjectHash['open_date_day']}日
					{/if}
					&nbsp;～
					{if:strlen(flagObjectHash['close_date'])>0}
					{write:flagObjectHash['close_date_year']}年
					{write:flagObjectHash['close_date_month']}月
					{write:flagObjectHash['close_date_day']}日
					{/if}
					</span>
					{/if}
				</td>
			</tr>
			{/foreach}
			</tbody>
			</table>
			{/if}
		</td>
	</tr>
	<tr>
		<th style="width:12em;">付与ポイント数</th>
		<td>
			{write:shopping.product.unit.unit_object->'present_point'}Pt.
		</td>
	</tr>
	<tr>
		<th style="width:12em;">梱包目安値</th>
		<td>
			{write:shopping.product.unit.unit_object->'delivery_weight'}
		</td>
	</tr>
	<tr>
		<th style="width:12em;">標準価格(税込)</th>
		<td>{write:shopping.product.unit.unit_object->'price_standard'}円</td>
	</tr>
	<tr>
		<th style="width:12em;">販売価格(税込)</th>
		<td>{write:shopping.product.unit.unit_object->'price_sell'}円</td>
	</tr>
	<tr>
		<th style="width:12em;">仕入れ値(税込)</th>
		<td>{write:shopping.product.unit.unit_object->'cost'}円</td>
	</tr>
	<tr>
		<th style="width:12em;">月次課金価格(税込)</th>
		<td>{write:shopping.product.unit.unit_object->'price_monthly'}円</td>
	</tr>
	<tr>
		<th style="width:12em;">順序番号</th>
		<td>{write:shopping.product.unit.unit_object->'order_number'}</td>
	</tr>
	<tr>
		<th style="width:12em;">プロモ割引</th>
		<td>
			{if:shopping.product.unit.unit_object->'discount_exception'!='1'}通常{/if}
			{if:shopping.product.unit.unit_object->'discount_exception'=='1'}割引しない{/if}
		</td>
	</tr>
	<tr>
		<th style="width:12em;">紹介文</th>
		<td>{write:nl2br(shopping.product.unit.unit_object->'description')}</td>
	</tr>
	</tbody>
	</table>
	<br />
	
	{set:fileIdArrayOrg shopping.product.unit.unit_object->'fileIdArray_org'}
	{set:fileIdArray shopping.product.unit.unit_object->'fileIdArray'}
	{set:uploader shopping.product.unit.unit_object->'uploader'}
	{set:fileBinObjectHash uploader->'fileBinObjectHash'}
	{if:count(fileIdArray)>0 || count(fileBinObjectHash)>0}
	<h2 class="global">{write:SHOPPING_LABEL_PRODUCT}販売単位の画像</h2>
	<table class="detail" style="width:96%;margin:0 auto;">
	<tbody>
	<?php for( $GLOBALS['num']=0; $GLOBALS['num']<3; $GLOBALS['num']++ ) { ?>
	<tr>
		<th style="width:12em;">画像{write:num+1}</th>
		<td>
			<table style="margin:0 auto;border-style:none;">
			<tbody>
			<tr>
				<td style="width:48%;vertical-align:middle;text-align:center;border-style:none;">
					{if:isset(fileIdArrayOrg[num])}<img src="/file/download.php?fi={write:fileIdArrayOrg[num]}&amp;w=180&amp;h=180" />{else}登録なし{/if}
				</td>
				<td style="width:4%;vertical-align:middle;text-align:center;border-style:none;">→</td>
				<td style="width:48%;vertical-align:middle;text-align:center;border-style:none;">
					{if:isset(fileBinObjectHash[num])}
						<!-- アップロードされている -->
						<img src="/file/download.php?t=tmp&amp;fi={write:fileBinObjectHash[num]->'file_id'}&amp;w=180&amp;h=180" />
					{else}
						<!-- アップロードなし -->
						{if:isset(fileIdArrayOrg[num]) && isset(fileIdArray[num]) && fileIdArrayOrg[num]==fileIdArray[num]}
							<img src="/file/download.php?fi={write:fileIdArrayOrg[num]}&amp;w=180&amp;h=180" />
						{else}
							登録なし
						{/if}
					{/if}
				</td>
			</tr>
			</tbody>
			</table>
		</td>
	</tr>
	<?php } ?>
	</tbody>
	</table>
	<br />
	{/if}
	
	<div id="shopping-product-download-files"{if:'11'==shopping.product.unit.unit_object->'delivery_type'}{else} style="position:absolute;z-index:-999;top:0px;left:0px;display:none;visibility:hidden;"{/if}>
	<h2 class="global">ダウンロード用ファイル</h2>
	<?php for( $GLOBALS['num']=100; $GLOBALS['num']<103; $GLOBALS['num']++ ) { ?>
	{set:fileBinObject shopping.product.unit.fileObjectOrgHash[num]}
	{if:!is_null(fileBinObjectHash[num])}
		{set:fileBinObject fileBinObjectHash[num]}
	{/if}
	{if:!is_null(fileBinObject)}
	<div style="width:95%;margin:0 auto;font-weight:bold;">
		ダウンロード用ファイル{write:(num-99)}
	</div>
	<table class="detail" style="width:96%;margin:0 auto;">
	<tbody>
	<tr>
		<th style="width:12em;">ダウンロード時ファイル名</th>
		<td>
			{write:fileBinObject->'file_name'}
			&nbsp;
			<span style="font-size:x-small;">[<a href="/file/download.php?t=tmp&amp;fi={write:fileBinObject->'file_id'}" target="_blank" title="ダウンロード確認">ダウンロード確認</a>]</span>
		</td>
	</tr>
	<tr>
		<th style="width:12em;">Content-Type</th>
		<td>
			{write:nl2br(fileBinObject->'mime_type')}
		</td>
	</tr>
	<tr>
		<th style="width:12em;">対象ユーザーエージェント<br />正規表現</th>
		<td>
			{write:nl2br(fileBinObject->'target_agent')}
		</td>
	</tr>
	<tr>
		<th style="width:12em;">追加レスポンスヘッダ</th>
		<td>
			{write:nl2br(fileBinObject->'response_headers')}
		</td>
	</tr>
	</tbody>
	</table><br />
	{/if}
	<?php } ?>
	</div>

	<h2>{write:SHOPPING_LABEL_PRODUCT}情報の上書き設定</h2>
	<table class="detail" style="width:96%;margin:0 auto;">
	<tbody>
	<tr>
		<th style="width:12em;">数え方</th>
		<td>{write:shopping.product.unit.unit_object->'unit_string'}</td>
	</tr>
	<tr>
		<th style="width:12em;">商品種別</th>
		<td>{write:SHOPPING_DELIVERY_TYPE_HASH[shopping.product.unit.unit_object->'delivery_type']}</td>
	</tr>
	<tr>
		<th style="width:12em;">閲覧許可</th>
		<td style="padding:0px;">
			{foreach:MEMBER_MEMBER_CLASS_HASH key value}
			<input type="checkbox" name="member_viewable[]" value="{write:key}"
			{if:in_array(key,shopping.product.unit.unit_object->'memberViewableArray')} checked{/if}
			disabled="disabled"
			/>{write:mb_substr(value,0,10)}
			{/foreach}
		</td>
	</tr>
	<tr>
		<th style="width:12em;">{write:SHOPPING_LABEL_ORDER}許可</th>
		<td style="padding:0px;">
			{foreach:MEMBER_MEMBER_CLASS_HASH key value}
			<input type="checkbox" name="member_purchasable[]" value="{write:key}"
			{if:in_array(key,shopping.product.unit.unit_object->'memberPurchasableArray')} checked{/if}
			disabled="disabled"
			/>{write:mb_substr(value,0,10)}
			{/foreach}
		</td>
	</tr>
	</tbody>
	</table><br />
	
	{if:strlen(shopping.product.unit.unit_object->'detail_comment')>0}
	<h2>追加説明文(HTML可)</h2>
	<div style="width:96%;margin:0 auto;border:solid 1px #808080;padding:3px;">
		{write:shopping.product.unit.unit_object->'detail_comment' noescape}
	</div>
	<br />
	{/if}
	
	{if:shopping.product.unit.unit_object->hasUniqueOption()}
	<h2 class="global">販売単位の固有の{write:SHOPPING_LABEL_ORDER}オプション</h2>
	<?php
		for( $GLOBALS['optionNumber']=1; $GLOBALS['optionNumber']<=5; $GLOBALS['optionNumber']++ ) {
			$GLOBALS['optionVarName']		= 'option'.$GLOBALS['optionNumber'].'_name';
			$GLOBALS['optionItemsName']	= 'option'.$GLOBALS['optionNumber'].'_items';
			$GLOBALS['optionUrlName']		= 'option'.$GLOBALS['optionNumber'].'_url';
			$GLOBALS['optionExpName']	= 'option'.$GLOBALS['optionNumber'].'_explanation';
			$GLOBALS['optionCalcName']		= 'option'.$GLOBALS['optionNumber'].'_calculate';
			$optionItemArray	= explode("\n",str_replace("\n\n","\n",str_replace("\r\n","\n",str_replace("\r","\n",trim($GLOBALS['shopping.product.unit.unit_object']->$GLOBALS['optionItemsName'])))));
			$GLOBALS['optionType']		= $optionItemArray[0];
			if( '__INPUT_TYPE_TEXT__' == $GLOBALS['optionType'] ) {
				$GLOBALS['optionCols']	= $optionItemArray[1];
			} else if( '__INPUT_TYPE_TEXTAREA__' == $GLOBALS['optionType'] ) {
				$GLOBALS['optionCols']	= $optionItemArray[1];
				$GLOBALS['optionRows']	= $optionItemArray[2];
			} else {
				$GLOBALS['optionType']	= '__SELECT__';
			}
	?>
	{if:strlen(trim(shopping.product.unit.unit_object->optionItemsName))>0}
	<table class="detail" style="width:95%;margin:0 auto;">
	<tbody>
	<tr>
		<th style="width:12em;">オプション{write:optionNumber}項目名</th>
		<td>{write:shopping.product.unit.unit_object->optionVarName}</td>
	</tr>
	<tr>
		<th style="width:12em;">オプション{write:optionNumber}設定</th>
		<td>
			{if:optionType=='__INPUT_TYPE_TEXT__'}
				[テキスト] 入力欄サイズ：{write:optionCols}
			{else-if:optionType=='__INPUT_TYPE_TEXTAREA__'}
				[複数行テキスト] 横幅：{write:optionCols} 行数：{write:optionRows}
			{else-if:strlen(trim(shopping.product.unit.unit_object->optionItemsName))>0}
				[選択ボックス]<br />
				{write:nl2br(shopping.product.unit.unit_object->optionItemsName)}
			{/if}
		</td>
	</tr>
	<tr>
		<th style="width:12em;">オプション{write:optionNumber}説明文</th>
		<td>
			{write:shopping.product.unit.unit_object->optionExpName noescape}
		</td>
	</tr>
	<tr>
		<th style="width:12em;">オプション金額計算方法</th>
		<td>
			{if:'1'!=shopping.product.unit.unit_object->optionCalcName}注文数で乗算する{/if}
			{if:'1'==shopping.product.unit.unit_object->optionCalcName}注文数で乗算しない{/if}
		</td>
	</tr>
	</tbody>
	</table><br />
	{/if}
	<?php } ?>
	{/if}

	<p style="text-align:center;">
		<input type="button" value="編集画面に戻る" style="padding:10px;" onclick="window.history.back();" />
		<input type="submit" value="この編集で保存" style="padding:10px;" />
	</p>
	<p style="text-align:center;">
	</p>
	</form>
	<br />

{/if}
	<hr style="width:96%;margin:0 auto;margin-top:1em;" />
	<div style="width:96%;margin:0 auto;text-align:right;">
		{if:is_object(shoppingProductObject->'searchDataObject')}
		<span style="white-space:nowrap"><a href="../../../search/data/detail.php?schdi={write:shoppingProductObject->'searchDataObject'->'data_id'}"
		>&gt;&gt;{write:shoppingProductObject->'searchDataObject'->'subject'}の詳細</a></span>
		<span style="white-space:nowrap">&nbsp;&nbsp;<a href="../?schdi={write:shoppingProductObject->'searchDataObject'->'data_id'}"
		>&gt;&gt;{write:shoppingProductObject->'searchDataObject'->'subject'}の{write:SHOPPING_LABEL_PRODUCT}一覧</a></span>
		<span style="white-space:nowrap">&nbsp;&nbsp;<a href="../detail.php?shpdn={write:shoppingProductObject->'product_number'}"
		>&gt;&gt;{write:shoppingProductObject->'product_name'}の詳細</a></span>
		{else}
		<span style="white-space:nowrap"><a href="../">&gt;&gt;{write:SHOPPING_LABEL_PRODUCT}管理</a></span>
		<span style="white-space:nowrap">&nbsp;&nbsp;<a href="../">&gt;&gt;{write:SHOPPING_LABEL_PRODUCT}一覧</a></span>
		{/if}
	</div>