<?php include_once( "../../../spider.inc.php" ); ?>
{module:system.package.LoadList}
{module:system.package.install.Session}

	{foreach:system.package.install.install_object_hash packageObject}
	{if:packageObject->getPackageId()=='shopping'}{set:targetPackageObject packageObject}{/if}
	{/foreach}
	
	{if:is_object(targetPackageObject)}
	{set:definitionHash targetPackageObject->'definitionHash'}
	<h1>{write:targetPackageObject->getPackageViewName()}パッケージ</h1>
	{if:targetPackageObject->isInstall()}
	<input type="hidden" name="SHOPPING_INIT_OPTION" value="{write:definitionHash['SHOPPING_INIT_OPTION']}" />
	{/if}

	<h2>データベースオプション</h2>
	<table style="width:95%;margin:0 auto;">
	<tbody>
	{if:targetPackageObject->isInstall()}
	{else}
	<tr>
		<th style="width:16em;">初期化オプション</th>
		<td>
			<select name="SHOPPING_INIT_OPTION">
				<option value="1"{if:'1'==definitionHash['SHOPPING_INIT_OPTION']} selected{/if}>既存テーブルを利用</option>
				<option value="2"{if:'2'==definitionHash['SHOPPING_INIT_OPTION']} selected{/if}>テーブルがなければ作成</option>
				<option value="3"{if:'3'==definitionHash['SHOPPING_INIT_OPTION']} selected{/if}>テーブルを削除して作成</option>
			</select>
		</td>
	</tr>
	{/if}
	<tr>
		<th style="width:16em;">{write:SHOPPING_LABEL_ORDER}番号の文字列</th>
		<td>
			<input type="text" name="SHOPPING_ORDER_ID_FORMAT" size="70" value="{write:definitionHash['SHOPPING_ORDER_ID_FORMAT']}" /><br />
			<span style="color:#ff0000;font-size:x-small;line-height:1.2em;">
				※連番の桁を変更したい場合は{num:6}の6を変更してください。3～6で変更できます。<br />
				※年月を連番に入れられます。<br />&nbsp;&nbsp;西暦年(4桁)={Y}, 西暦年(下2桁)={y}, 月(2桁揃え)={m}を入力してください。<br />
				※{write:SHOPPING_LABEL_ORDER}IDは合計16桁以下の英数字になるように調整する必要があります。<br />
				※連番部分{num:数字}は末尾にしか入力できません。<br />
			</span>
		</td>
	</tr>
	</tbody>
	</table>
	
	<h2>消費税の扱い</h2>
	<p>
		{write:SHOPPING_LABEL_ORDER}者へのメールや画面表示で表示するお支払金額合計の内消費税表記計算方法を設定してください。
	</p>
	<table style="width:95%;margin:0 auto;">
	<tbody>
	<tr>
		<th style="width:16em;">消費税率</th>
		<td>
			<input type="text" size="5" name="SHOPPING_TAX_RATE" value="{write:definitionHash['SHOPPING_TAX_RATE']}" />％
		</td>
	</tr>
	<tr>
		<th style="width:16em;">消費税の計算方法</th>
		<td>
			<select name="SHOPPING_TAX_RULE">
				<option value="1"{if:'1'==definitionHash['SHOPPING_TAX_RULE']} selected{/if}>合計金額に税率で計算（切り捨て）</option>
				<option value="2"{if:'2'==definitionHash['SHOPPING_TAX_RULE']} selected{/if}>合計金額に税率で計算（切り上げ）</option>
				<option value="3"{if:'3'==definitionHash['SHOPPING_TAX_RULE']} selected{/if}>合計金額に税率で計算（四捨五入）</option>
				<option value="4"{if:'4'==definitionHash['SHOPPING_TAX_RULE']} selected{/if}>合計金額に税率で計算（五捨六入）</option>
				<option value="11"{if:'11'==definitionHash['SHOPPING_TAX_RULE']} selected{/if}>各{write:SHOPPING_LABEL_ORDER}{write:SHOPPING_LABEL_PRODUCT}に税率で計算（切り捨て）して合計</option>
				<option value="12"{if:'12'==definitionHash['SHOPPING_TAX_RULE']} selected{/if}>各{write:SHOPPING_LABEL_ORDER}{write:SHOPPING_LABEL_PRODUCT}に税率で計算（切り上げ）して合計</option>
				<option value="13"{if:'13'==definitionHash['SHOPPING_TAX_RULE']} selected{/if}>各{write:SHOPPING_LABEL_ORDER}{write:SHOPPING_LABEL_PRODUCT}に税率で計算（四捨五入）して合計</option>
				<option value="14"{if:'14'==definitionHash['SHOPPING_TAX_RULE']} selected{/if}>各{write:SHOPPING_LABEL_ORDER}{write:SHOPPING_LABEL_PRODUCT}に税率で計算（五捨六入）して合計</option>
			</select>
		</td>
	</tr>
	</tbody>
	</table>
	

	<h2>{write:SHOPPING_LABEL_ORDER}通知先メールアドレス</h2>
	<p>
		カンマ区切りで複数入力できます<br />
	</p>
	<table style="width:95%;margin:0 auto;">
	<tbody>
	<tr>
		<th style="width:16em;">通知先メールアドレス</th>
		<td>
			<input type="text" name="SHOPPING_MAIL_ADDRESS_NOTIFY" size="90" value="{write:definitionHash['SHOPPING_MAIL_ADDRESS_NOTIFY']}" />
		</td>
	</tr>
	<tr>
		<th style="width:16em;">BCCメールアドレス</th>
		<td>
			<input type="text" name="SHOPPING_MAIL_ADDRESS_BCC" size="90" value="{write:definitionHash['SHOPPING_MAIL_ADDRESS_BCC']}" /><br />
			<span style="color:#ff0000;font-size:x-small;line-height:1.2em;">
				全ての送信メールをBCCで送信するアドレスを設定できます
			</span>
		</td>
	</tr>
	</tbody>
	</table>
	
	<h2>ショッピング ポイント基本設定</h2>
	<table style="width:95%;margin:0 auto;">
	<tbody>
	<tr>
		<th style="width:16em;">ポイント付与規則</th>
		<td>
			<select name="SHOPPING_POINT_METHOD">
				<option value="0"{if:'0'==definitionHash['SHOPPING_POINT_METHOD']} selected{/if}>{write:SHOPPING_LABEL_ORDER}{write:SHOPPING_LABEL_PRODUCT}分全てのポイントをそのまま付与</option>
				<option value="1"{if:'1'==definitionHash['SHOPPING_POINT_METHOD']} selected{/if}>{write:SHOPPING_LABEL_ORDER}{write:SHOPPING_LABEL_PRODUCT}ポイントから利用ポイント分を差し引いて付与</option>
			</select>
		</td>
	</tr>
	<tr>
		<th style="width:16em;">ポイント清算設定</th>
		<td>
			<select name="SHOPPING_POINT_SETTLE_METHOD">
				<option value="1"{if:'1'==definitionHash['SHOPPING_POINT_SETTLE_METHOD']} selected{/if}>{write:SHOPPING_LABEL_PRODUCT}代金</option>
				<option value="2"{if:'2'==definitionHash['SHOPPING_POINT_SETTLE_METHOD']} selected{/if}>支払金額</option>
			</select>
			の<select name="SHOPPING_POINT_SETTLE_RATE">
				<option value="0"{if:'0'==definitionHash['SHOPPING_POINT_SETTLE_RATE']} selected{/if}>0</option>
				<option value="10"{if:'10'==definitionHash['SHOPPING_POINT_SETTLE_RATE']} selected{/if}>10</option>
				<option value="20"{if:'20'==definitionHash['SHOPPING_POINT_SETTLE_RATE']} selected{/if}>20</option>
				<option value="30"{if:'30'==definitionHash['SHOPPING_POINT_SETTLE_RATE']} selected{/if}>30</option>
				<option value="40"{if:'40'==definitionHash['SHOPPING_POINT_SETTLE_RATE']} selected{/if}>40</option>
				<option value="50"{if:'50'==definitionHash['SHOPPING_POINT_SETTLE_RATE']} selected{/if}>50</option>
				<option value="60"{if:'60'==definitionHash['SHOPPING_POINT_SETTLE_RATE']} selected{/if}>60</option>
				<option value="70"{if:'70'==definitionHash['SHOPPING_POINT_SETTLE_RATE']} selected{/if}>70</option>
				<option value="80"{if:'80'==definitionHash['SHOPPING_POINT_SETTLE_RATE']} selected{/if}>80</option>
				<option value="90"{if:'90'==definitionHash['SHOPPING_POINT_SETTLE_RATE']} selected{/if}>90</option>
				<option value="100"{if:'100'==definitionHash['SHOPPING_POINT_SETTLE_RATE']} selected{/if}>100</option>
			</select>％までポイント利用可能<br />
			<input type="text" name="SHOPPING_POINT_UNIT" size="5" value="{write:definitionHash['SHOPPING_POINT_UNIT']}" />Pt.単位で利用<br />
			<span style="form_attention">※0に設定するとテキストエリアで自由入力になります</span>
		</td>
	</tr>
	</tbody>
	</table>
		
	<h2>ショッピング 配送基本設定</h2>
	<table style="width:95%;margin:0 auto;">
	<tbody>
	<tr>
		<th style="width:16em;">配送無料条件金額</th>
		<td>
			<input type="text" name="SHOPPING_DELIVERY_FREE_PRICE" size="20" value="{write:definitionHash['SHOPPING_DELIVERY_FREE_PRICE']}" />円以上
		</td>
	</tr>
	<tr>
		<th style="width:16em;">クール便の計算方法</th>
		<td>
			<select name="SHOPPING_DELIVERY_TYPE_OPERATION">
				<option value="0"{if:'0'==definitionHash['SHOPPING_DELIVERY_TYPE_OPERATION']} selected{/if}>クール便の荷物を含むなら全てクール便で配送</option>
				<option value="1"{if:'1'==definitionHash['SHOPPING_DELIVERY_TYPE_OPERATION']} selected{/if}>クール便の荷物を含むなら別口で配送</option>
			</select>
		</td>
	</tr>
	<tr>
		<th style="width:16em;">お届け希望日の表示</th>
		<td>
			<input type="text" name="SHOPPING_DELIVERY_WISHFUL_DAY_START" size="2" value="{write:definitionHash['SHOPPING_DELIVERY_WISHFUL_DAY_START']}"
			/>日後から<input type="text" name="SHOPPING_DELIVERY_WISHFUL_DAY_END" size="2" value="{write:definitionHash['SHOPPING_DELIVERY_WISHFUL_DAY_END']}"
			/>日後まで表示する
		</td>
	</tr>
	</tbody>
	</table>
		
	<h2>ショッピング オプション設定</h2>
	<table style="width:95%;margin:0 auto;">
	<tbody>
	<tr>
		<th style="width:16em;">ラッピングフリーワード欄表示</th>
		<td>
			<select name="SHOPPING_DELIVERY_RAPPING_FREEWORD">
				<option value="off"{if:'off'==definitionHash['SHOPPING_DELIVERY_RAPPING_FREEWORD']} selected{/if}>表示しない</option>
				<option value="on"{if:'on'==definitionHash['SHOPPING_DELIVERY_RAPPING_FREEWORD']} selected{/if}>表示する</option>
			</select>
		</td>
	</tr>
	</tbody>
	</table>
	
	<br />
	<h2>状態変更メール通知設定</h2>
	{if:in_array('database2',system.package.installedPackageIdArray)}
		{imodule:database2.Connect}
		{if:in_array('member',system.package.installedPackageIdArray)}
			{imodule:member.mail.template.LoadList}
		{/if}
	{/if}
	<table style="width:95%;margin:0 auto;">
	<tbody>
	{foreach:SHOPPING_ORDER_STATUS_HASH statusNumber statusName}
	<tr>
		<th style="width:16em;">{write:SHOPPING_LABEL_ORDER}者宛 {write:statusName}</th>
		<td>
			{if:is_array(member.mail.template.data_array)}
			<select name="SHOPPING_ORDER_STATUS_MAIL[{write:statusNumber}]">
				<option value="">なし</option>
			{foreach:member.mail.template.data_array mailTemplateObject}{if:mailTemplateObject->'template_type'!='1'}
				<option value="{write:mailTemplateObject->'template_id'}"
				{if:definitionHash['SHOPPING_ORDER_STATUS_MAIL'][statusNumber]==mailTemplateObject->'template_id'} selected{/if}
				>{write:mailTemplateObject->'template_name'}</option>
			{/if}{/foreach}
			</select>
			{else}
			<input type="hidden" name="SHOPPING_ORDER_STATUS_MAIL[{write:statusNumber}]" value="{write:definitionHash['SHOPPING_ORDER_STATUS_MAIL'][statusNumber]}" />
			{/if}
		</td>
	</tr>
	{/foreach}
	{foreach:SHOPPING_ORDER_STATUS_HASH statusNumber statusName}
	<tr>
		<th style="width:16em;">オーナー宛{write:statusName}</th>
		<td>
			{if:is_array(member.mail.template.data_array)}
			<select name="SHOPPING_ORDER_STATUS_OWNER_MAIL[{write:statusNumber}]">
				<option value="">なし</option>
			{foreach:member.mail.template.data_array mailTemplateObject}{if:mailTemplateObject->'template_type'!='1'}
				<option value="{write:mailTemplateObject->'template_id'}"
				{if:definitionHash['SHOPPING_ORDER_STATUS_OWNER_MAIL'][statusNumber]==mailTemplateObject->'template_id'} selected{/if}
				>{write:mailTemplateObject->'template_name'}</option>
			{/if}{/foreach}
			</select>
			{else}
			<input type="hidden" name="SHOPPING_ORDER_STATUS_OWNER_MAIL[{write:statusNumber}]" value="{write:definitionHash['SHOPPING_ORDER_STATUS_OWNER_MAIL'][statusNumber]}" />
			{/if}
		</td>
	</tr>
	{/foreach}
	</tbody>
	</table>
	<br />
	<h2>申込内容変更完了時の状態設定</h2>
	<table style="width:95%;margin:0 auto;">
	<tbody>
	<tr>
		<th>管理者操作時</th>
		<td>
			<select name="SHOPPING_ORDER_MODIFY_STATUS[1]">
			{foreach:SHOPPING_ORDER_STATUS_HASH statusNumber statusName}
				<option value="{write:statusNumber}"
				{if:definitionHash['SHOPPING_ORDER_MODIFY_STATUS'][1]==statusNumber} selected{/if}
				>{write:statusName}</option>
			{/foreach}
			</select>
	</tr>
	<tr>
		<th>申込者操作時</th>
		<td>
			<select name="SHOPPING_ORDER_MODIFY_STATUS[2]">
			{foreach:SHOPPING_ORDER_STATUS_HASH statusNumber statusName}
				<option value="{write:statusNumber}"
				{if:definitionHash['SHOPPING_ORDER_MODIFY_STATUS'][2]==statusNumber} selected{/if}
				>{write:statusName}</option>
			{/foreach}
			</select>
	</tr>
	<tr>
		<th>オーナー操作時</th>
		<td>
			<select name="SHOPPING_ORDER_MODIFY_STATUS[3]">
			{foreach:SHOPPING_ORDER_STATUS_HASH statusNumber statusName}
				<option value="{write:statusNumber}"
				{if:definitionHash['SHOPPING_ORDER_MODIFY_STATUS'][3]==statusNumber} selected{/if}
				>{write:statusName}</option>
			{/foreach}
			</select>
	</tr>
	</tbody>
	</table>
	<br />

	<h2>ショッピング ダウンロード{write:SHOPPING_LABEL_PRODUCT}設定</h2>
	<table style="width:95%;margin:0 auto;">
	<tbody>
	<tr>
		<th style="width:16em;">ダウンロードURL</th>
		<td>
			<input type="text" name="SHOPPING_DOWNLOAD_URL" size="80" value="{write:definitionHash['SHOPPING_DOWNLOAD_URL']}" />
			<span class="form_attention">※{write:SHOPPING_LABEL_ORDER}完了メールに記載するダウンロード用PHPのURL。必要な場合のみ変更してください。</span>
		</td>
	</tr>
	<tr>
		<th style="width:16em;">ダウンロード回数制限</th>
		<td>
			<input type="text" name="SHOPPING_DOWNLOAD_MAX_COUNT" size="5" value="{write:definitionHash['SHOPPING_DOWNLOAD_MAX_COUNT']}" />回まで<br />
			<span class="form_attention">※1-99で設定してください。空にすると一度{write:SHOPPING_LABEL_ORDER}した{write:SHOPPING_LABEL_PRODUCT}のダウンロード回数は制限なしになります。</span>
		</td>
	</tr>
	<tr>
		<th style="width:16em;">ダウンロード期間制限</th>
		<td>
			{write:SHOPPING_LABEL_ORDER}完了日時から<input type="text" name="SHOPPING_DOWNLOAD_ENABLE_FROM_ORDER" size="5" value="{write:definitionHash['SHOPPING_DOWNLOAD_ENABLE_FROM_ORDER']}" />日間<br />
			<span class="form_attention">※1-99で設定してください。空にすると一度{write:SHOPPING_LABEL_ORDER}した{write:SHOPPING_LABEL_PRODUCT}のダウンロード期間は制限なしになります。</span><br />
			最後のダウンロードから<input type="text" name="SHOPPING_DOWNLOAD_ENABLE_FROM_LAST" size="5" value="{write:definitionHash['SHOPPING_DOWNLOAD_ENABLE_FROM_LAST']}" />分間<br />
			<span class="form_attention">※空にすると一度{write:SHOPPING_LABEL_ORDER}した{write:SHOPPING_LABEL_PRODUCT}のダウンロード期間は制限なしになります。</span><br />
		</td>
	</tr>
	</tbody>
	</table>

	<h2>ショッピング プロモーション基本設定</h2>
	<table style="width:95%;margin:0 auto;">
	<tbody>
	<tr>
		<th style="width:16em;">プロモーション固定額割引条件</th>
		<td>
			<input type="text" name="SHOPPING_PROMO_FIXED_DISCOUNT_BTM" size="20" value="{write:definitionHash['SHOPPING_PROMO_FIXED_DISCOUNT_BTM']}" />円以上
		</td>
	</tr>
	<tr>
		<th style="width:16em;">プロモーション固定額報酬条件</th>
		<td>
			<input type="text" name="SHOPPING_PROMO_FIXED_FEE_BTM" size="20" value="{write:definitionHash['SHOPPING_PROMO_FIXED_FEE_BTM']}" />円以上
		</td>
	</tr>
	</tbody>
	</table>

	<h2>ショッピング 会員登録設定</h2>
	<table style="width:95%;margin:0 auto;">
	<tbody>
	<tr>
		<th style="width:16em;">会員登録種別利用</th>
		<td>
			<input type="checkbox" name="SHOPPING_MEMBER_CLASSES[]" value="51"{if:in_array('51',definitionHash['SHOPPING_MEMBER_CLASSES'])} checked{/if} />アフィリエイト会員
			<input type="checkbox" name="SHOPPING_MEMBER_CLASSES[]" value="52"{if:in_array('52',definitionHash['SHOPPING_MEMBER_CLASSES'])} checked{/if} />特別割引会員
			<input type="checkbox" name="SHOPPING_MEMBER_CLASSES[]" value="53"{if:in_array('53',definitionHash['SHOPPING_MEMBER_CLASSES'])} checked{/if} />{write:SHOPPING_LABEL_PRODUCT}販売会員
			<br />
			<span class="form_attention">※このシステムで利用する会員種別をチェックしてください。ここでチェックしても公募設定しなければ管理パネルからしか設定できません。<br />
		</td>
	</tr>
	<tr>
		<th style="width:16em;">会員種別の公募</th>
		<td>
			<input type="checkbox" name="SHOPPING_MEMBER_CLASSES_REGISTABLE[]" value="51"{if:in_array('51',definitionHash['SHOPPING_MEMBER_CLASSES_REGISTABLE'])} checked{/if} />アフィリエイト会員
			<input type="checkbox" name="SHOPPING_MEMBER_CLASSES_REGISTABLE[]" value="52"{if:in_array('52',definitionHash['SHOPPING_MEMBER_CLASSES_REGISTABLE'])} checked{/if} />特別割引会員
			<input type="checkbox" name="SHOPPING_MEMBER_CLASSES_REGISTABLE[]" value="53"{if:in_array('53',definitionHash['SHOPPING_MEMBER_CLASSES_REGISTABLE'])} checked{/if} />{write:SHOPPING_LABEL_PRODUCT}販売会員
			<br />
			<span class="form_attention">※公開ページで登録可能にする会員種別をチェックしてください。<br />
		</td>
	</tr>
	<tr>
		<th style="width:16em;">直アフィリエイト会員設定</th>
		<td>
			紹介経由{write:SHOPPING_LABEL_ORDER}
			=
			<input type="text" size="10" name="SHOPPING_AFFILIATE_DISCOUNT_VALUE" value="{write:definitionHash['SHOPPING_AFFILIATE_DISCOUNT_VALUE']}"
			/><select name="SHOPPING_AFFILIATE_DISCOUNT_TYPE">
				<option value="rate"{if:'rate'==definitionHash['SHOPPING_AFFILIATE_DISCOUNT_TYPE']} selected{/if}>%</option>
				<option value="money"{if:'money'==definitionHash['SHOPPING_AFFILIATE_DISCOUNT_TYPE']} selected{/if}>円</option>
			</select>
			<br />
			紹介成果報酬
			=
			<input type="text" size="10" name="SHOPPING_AFFILIATE_PAY_VALUE" value="{write:definitionHash['SHOPPING_AFFILIATE_PAY_VALUE']}"
			/><select name="SHOPPING_AFFILIATE_PAY_TYPE">
				<option value="rate"{if:'rate'==definitionHash['SHOPPING_AFFILIATE_PAY_TYPE']} selected{/if}>%</option>
				<option value="money"{if:'money'==definitionHash['SHOPPING_AFFILIATE_PAY_TYPE']} selected{/if}>円</option>
			</select>
			<br />
			セルフ{write:SHOPPING_LABEL_ORDER}(卸販売)
			=
			<select name="SHOPPING_AFFILIATE_BUYING_FLAG">
				<option value="0"{if:'0'==definitionHash['SHOPPING_AFFILIATE_BUYING_FLAG']} selected{/if}>許可しない</option>
				<option value="1"{if:'1'==definitionHash['SHOPPING_AFFILIATE_BUYING_FLAG']} selected{/if}>先払いのみ</option>
				<option value="2"{if:'2'==definitionHash['SHOPPING_AFFILIATE_BUYING_FLAG']} selected{/if}>許可</option>
			</select>
			<input type="text" size="10" name="SHOPPING_AFFILIATE_BUYING_RATE" value="{write:definitionHash['SHOPPING_AFFILIATE_BUYING_RATE']}"
			/>%引
			<br />
		</td>
	</tr>
	</tbody>
	</table>
	
	<h2>ショッピング {write:SHOPPING_LABEL_PRODUCT}・販売単位の会員別制限の初期設定</h2>
	<p>
		{write:SHOPPING_LABEL_PRODUCT}、販売単位の閲覧と{write:SHOPPING_LABEL_ORDER}の制限を会員種別ごとに設定することができます。<br />
	</p>
	<table style="width:95%;margin:0 auto;text-align:center;">
	<thead>
	<tr>
		<th style="width:16em;">会員種別</th>
		{foreach:MEMBER_MEMBER_CLASS_HASH key value}
		<th title="{write:value}">{write:mb_substr(value,0,1)}</th>
		{/foreach}
	</tr>
	</thead>
	<tbody>
	<tr>
		<th style="width:16em;">閲覧</th>
		{foreach:MEMBER_MEMBER_CLASS_HASH key value}
		<td><input type="checkbox" name="SHOPPING_MEMBER_VIEWABLE[]" value="{write:key}"{if:is_array(definitionHash['SHOPPING_MEMBER_VIEWABLE']) && in_array(key,definitionHash['SHOPPING_MEMBER_VIEWABLE'])} checked{/if} /></td>
		{/foreach}
	</tr>
	<tr>
		<th style="width:16em;">{write:SHOPPING_LABEL_ORDER}</th>
		{foreach:MEMBER_MEMBER_CLASS_HASH key value}
		<td><input type="checkbox" name="SHOPPING_MEMBER_PURCHASBLE[]" value="{write:key}"{if:is_array(definitionHash['SHOPPING_MEMBER_PURCHASBLE']) && in_array(key,definitionHash['SHOPPING_MEMBER_PURCHASBLE'])} checked{/if} /></td>
		{/foreach}
	</tr>
	</tbody>
	</table>
	<br />
	<h2>ショッピング 予約利用時の設定</h2>
	<table style="width:95%;margin:0 auto;">
	<tbody>
	<tr>
		<th style="width:16em;">予約制限</th>
		<td>
			<input type="text" size="3" name="SHOPPING_RESERVE_ENABLE_START"
			value="{write:definitionHash['SHOPPING_RESERVE_ENABLE_START']}" />日後から<input
			type="text" size="3" name="SHOPPING_RESERVE_ENABLE_LIMIT"
			value="{write:definitionHash['SHOPPING_RESERVE_ENABLE_LIMIT']}" />日後まで予約可能
			<br />
			同時に<input type="text" size="3" name="SHOPPING_RSV_LIMIT_UNIT_AT_ONCE"
			value="{write:definitionHash['SHOPPING_RSV_LIMIT_UNIT_AT_ONCE']}" />{write:SHOPPING_LABEL_PRODUCT}まで申し込み可能<br />
			<br />
			同時に<input type="text" size="3" name="SHOPPING_RSV_LIMIT_TERM_AT_ONCE"
			value="{write:definitionHash['SHOPPING_RSV_LIMIT_TERM_AT_ONCE']}" />期間のみ申し込み可能<br />
		</td>
	</tr>
	</tbody>
	</table>
	<br />
	<h2>ショッピング 予約利用時の設定</h2>
	<table style="width:95%;margin:0 auto;">
	<tbody>
	<tr>
		<th style="width:16em;">チェックイン時間</th>
		<td>
			<input type="text" size="10" name="SHOPPING_RESERVE_STAY_CHECKIN" value="{write:definitionHash['SHOPPING_RESERVE_STAY_CHECKIN']}" />
		</td>
	</tr>
	<tr>
		<th style="width:16em;">チェックアウト時間</th>
		<td>
			<input type="text" size="10" name="SHOPPING_RESERVE_STAY_CHECKOUT" value="{write:definitionHash['SHOPPING_RESERVE_STAY_CHECKOUT']}" />
		</td>
	</tr>
	</tbody>
	</table>
	<br />
	
	<h2>ショッピング {write:SHOPPING_LABEL_ORDER}時アップロードファイル</h2>
	<table style="width:95%;margin:0 auto;">
	<tbody>
	<tr>
		<th style="width:16em;">{write:SHOPPING_LABEL_ORDER}アップロードファイル利用</th>
		<td>
			<select name="SHOPPING_ORDER_ITEM_FILE_USE">
				<option value="0"{if:'1'!=definitionHash['SHOPPING_ORDER_ITEM_FILE_USE']} selected{/if}>利用しない</option>
				<option value="1"{if:'1'==definitionHash['SHOPPING_ORDER_ITEM_FILE_USE']} selected{/if}>利用する</option>
			</select>
		</td>
	</tr>
	<tr>
		<th style="width:16em;">保存フォルダパス</th>
		<td>
			<input type="text" size="70" name="SHOPPING_ORDER_ITEM_FILE_ROOT" value="{write:definitionHash['SHOPPING_ORDER_ITEM_FILE_ROOT']}" />
		</td>
	</tr>
	</tbody>
	</table>
	<br />
	
	{else}
	<p>操作が正しくありません</p>
	{/if}