<?php include_once( "../../../spider.inc.php" ); ?>
{charset:UTF-8}
{template:admin_default.tpl}
{module:member.upload.Form}
{preset:page_title MEMBER_PERSONAL_LABEL . '管理 > CSV登録'}

	<div class="panc">
		<a href="../../">管理パネルトップ</a>
		&gt; <a href="../">{write:MEMBER_PERSONAL_LABEL}情報一覧</a>
		&gt; CSVデータ登録
	</div>

	<h1>
		{write:MEMBER_PERSONAL_LABEL}管理 &gt; CSVデータ登録
	</h1>
	
	{if:IS_ERROR}
	<ul class="error">
		{foreach:errors as error}
		<li>{write:error}</li>
		{/foreach}
	</ul>
	<p style="text-align:center;">
		<input type="button" value="{write:MEMBER_PERSONAL_LABEL}管理に戻る" onclick="window.location.href='../'" />
	</p>
	{else}
	<p style="text-align:center;">
		取り込むCSVファイルを選択して[アップロード]をクリックしてください。
	</p>
	<br />
	<form name="mform" id="mform" action="./confirm.php" method="post" enctype="multipart/form-data">
	<table style="margin:0 auto;width:40em;">
	<tr>
		<th style="vertical-align:top;">CSVファイル</th>
		<td>
			<input type="file" name="csvfile" size="40" />
			<br />
			<input type="checkbox" name="ignore_first_line" value="true"
				{if:member.upload.registInformationHash['ignoreFirstLine']} checked{/if} />一行目はカラム名なので取り込まない
				<span style="font-size:x-small;">[<a href="javascript:" title="一行目がデータ行ではなくカラム名の行の場合はチェックを入れてください。">?</a>]</span>
			<br />
			<input type="checkbox" name="crypt_password_column" value="true"
				{if:member.upload.registInformationHash['crypt_password_column']} checked{/if} />CSVのパスワードが平文なので暗号化する
				<span style="font-size:x-small;">[<a href="javascript:" title="CSV記述のパスワードが平文の場合はチェックを入れてください。">?</a>]</span>
			<br />
		</td>
	</tr>
	</table>
	
	<p style="text-align:center;">
		CSVデータのカラム順序どおりにを右側のボックスに並べてください。
	</p>
	<table style="width:40em;margin:0 auto;">
	<thead>
	<tr>
		<th style="text-align:center;padding:3px;">選択項目</th>
		<th style="text-align:center;padding:3px;"></th>
		<th style="text-align:center;padding:3px;">登録カラム順序</th>
	</tr>
	</thead>
	<tbody>
	<tr>
		<td style="width:15em;">
			<select name="items[]" id="selectableItemBox" style="width:15em;height:20em;" multiple></select>
		</td>
		<td style="width:8em;text-align:center;">
			<input type="button" value="追加&gt;&gt;" onclick="memberUploadAdd()" /><br />
			<input type="button" value="&lt;&lt;削除" onclick="memberUploadDel()" />
		</td>
		<td style="width:15em;">
			<select name="selected_items[]" id="selectedItemBox" style="width:15em;height:20em;" multiple></select>
		</td>
	</tr>
	</tbody>
	</table>
	
	<p style="text-align:center;">
		<input type="button" value="アップロード" onclick="memberUploadSubmit()"
		/><br />
	</p>
	</form>


<script language="JavaScript" type="text/javascript"><!--
// 選択可能リスト
var selectableItems	= new Array();
// 選択リスト
var selectedItems	= new Array();
// 選択可能セレクトボックス
var selectableBox	= null;
// 選択セレクトボックス
var selectedBox		= null;
/*
 * 初期化
 */
function memberUploadInitialize() {
	// グローバルの選択可能リストと選択リストを初期化
	selectableItems	= new Array();
	selectedItems	= new Array();
	// 表示に利用するセレクトボックスを設定
	selectableBox	= document.getElementById('selectableItemBox');
	selectedBox		= document.getElementById('selectedItemBox');
	//
	var optionElm	= null;
	{foreach:MEMBER_UPLOAD_COLUMN_NAME_DEFINITION itemKey itemName}
	optionElm				= new Option('{write:itemName}','{write:itemKey}');
	optionElm.innerHTML		= optionElm.text;
	{if:itemKey=='product_id'}
	optionElm.style.color	= '#ff0000';
	{/if}
	{if:in_array(itemKey,member.upload.columnSelectedArray)}
	selectedItems.push(optionElm);
	{else}
	selectableItems.push(optionElm);
	{/if}
	{/foreach}
	memberUploadReview();
}
/**
 * 選択に追加
 */
function memberUploadAdd() {
	var delPos	= 0;
	for( var num=0; num<selectableBox.length; num++ ) {
		if( selectableBox.options[num].selected ) {
			selectableBox.options[num].selected	= false;
			selectedItems.push(selectableBox.options[num]);
			selectableItems.splice(delPos,1);
			delPos--;
		}
		delPos++;
	}
	memberUploadReview();
}
/**
 * 選択から削除
 */
function memberUploadDel() {
	var delPos	= 0;
	for( var num=0; num<selectedBox.length; num++ ) {
		if( selectedBox.options[num].selected ) {
			selectedBox.options[num].selected	= false;
			selectableItems.push(selectedBox.options[num]);
			selectedItems.splice(delPos,1);
			delPos--;
		}
		delPos++;
	}
	memberUploadReview();
}
/**
 * 再表示
 */
function memberUploadReview() {
	selectableBox.length	= 0;
	for( var num=0; num<selectableItems.length; num++ ) {
		var optionElm			= selectableItems[num];
		optionElm.innerHTML		= optionElm.text;
		selectableBox.appendChild(optionElm);
	}
	selectedBox.length	= 0;
	for( var num=0; num<selectedItems.length; num++ ) {
		var optionElm			= selectedItems[num];
		optionElm.innerHTML		= optionElm.text;
		selectedBox.appendChild(optionElm);
	}
}
/**
 * submit機能
 */
function memberUploadSubmit() {
	for( var num=0; num<selectedBox.length; num++ ) {
		selectedBox.options[num].selected	= true;
	}
	document.mform.submit();
}
if(window.attachEvent){
	window.attachEvent('onload',memberUploadInitialize);
}else{
	window.addEventListener('DOMContentLoaded',memberUploadInitialize,false);
}
//--></script>
	{/if}

	<hr style="width:96%;margin:0 auto;margin-top:1em;" />
	<div style="width:96%;margin:0 auto;text-align:right;">
		<a href="../">&gt;&gt; {write:MEMBER_PERSONAL_LABEL}一覧へ戻る</a>
	</div>