<?php include_once( "../../../spider.inc.php" ); ?>
{charset:UTF-8}
{template:admin_default.tpl}
{module:member.mail.LoadList}
{preset:page_title MEMBER_PERSONAL_LABEL . '管理 > 配信メール一覧'}

	<h1>{write:MEMBER_PERSONAL_LABEL}管理 &gt; 配信メール一覧</h1>
		
	{if:IS_ERROR}
		<h2 style="padding-left:2em;color:#FF6666;">エラーです</h2>
		<ul class="error">
		{foreach:errors error}
			<li>{write:error}</li>
		{/foreach}
		</ul>
	{/if}
	<form name="sform" action="./index.php" method="get">
	<input type="hidden" name="pn" value="{write:member.mail.page_number}" />
	<table style="margin:0 auto;width:96%;">
	<tbody>
	<tr>
		<td>
			状態：<select name="mmst" onchange="document.sform.submit()">
				<option value="">全て</option>
				<option value="0"{if:'0'==member.mail.statusFlag} selected{/if}>未処理</option>
				<option value="1"{if:'1'==member.mail.statusFlag} selected{/if}>未配信</option>
				<option value="2"{if:'2'==member.mail.statusFlag} selected{/if}>配信済</option>
			</select>
			&nbsp;&nbsp;
			並べ替え <select name="msi" onchange="document.sform.submit()">
				<option value=""{if:''==member.mail.sortItem} selected{/if}>予約日時</option>
				<option value="reg"{if:'reg'==member.mail.sortItem} selected{/if}>作成日時</option>
				<option value="cmp"{if:'cmp'==member.mail.sortItem} selected{/if}>完了日時</option>
			</select><select name="mso" onchange="document.sform.submit()">
				<option value="desc"{if:'desc'==member.mail.sortOrder} selected{/if}>降順</option>
				<option value="asc"{if:'asc'==member.mail.sortOrder} selected{/if}>昇順</option>
			</select>
			<br />
			予約日時：<select name="tsy">
			<?php for($year=date('Y')+2;$year>date('Y')-10;$year--) { $request_object->setAttribute('page.year',$year); ?>
				<option value="{write:page.year}"
					{if:member.mail.target_start_year=page.year} selected{/if}
					>{write:page.year}</option>
			<?php } ?>
			</select>年<select name="tsm">
			<?php for($month=1;$month<=12;$month++) { $request_object->setAttribute('page.month',sprintf('%02d',$month)); ?>
				<option value="{write:page.month}"
					{if:member.mail.target_start_month=page.month} selected{/if}
					>{write:page.month}</option>
			<?php } ?>
			</select>月<select name="tsd">
			<?php for($day=1;$day<=31;$day++) { $request_object->setAttribute('page.day',sprintf('%02d',$day)); ?>
				<option value="{write:page.day}"
					{if:member.mail.target_start_day=page.day} selected{/if}
					>{write:page.day}</option>
			<?php } ?>
			</select>日～<select name="tey">
			<?php for($year=date('Y')+2;$year>date('Y')-10;$year--) { $request_object->setAttribute('page.year',$year); ?>
				<option value="{write:page.year}"
					{if:member.mail.target_end_year=page.year} selected{/if}
					>{write:page.year}</option>
			<?php } ?>
			</select>年<select name="tem">
			<?php for($month=1;$month<=12;$month++) { $request_object->setAttribute('page.month',sprintf('%02d',$month)); ?>
				<option value="{write:page.month}"
					{if:member.mail.target_end_month=page.month} selected{/if}
					>{write:page.month}</option>
			<?php } ?>
			</select>月<select name="ted">
			<?php for($day=1;$day<=31;$day++) { $request_object->setAttribute('page.day',sprintf('%02d',$day)); ?>
				<option value="{write:page.day}"
					{if:member.mail.target_end_day=page.day} selected{/if}
					>{write:page.day}</option>
			<?php } ?>
			</select>日<input type="submit" value="期間変更" />
		</td>
		<td style="text-align:right;">
			ページ表示数：<select name="pr" onchange="document.sform.submit();">
			<option value="1"{if:member.mail.page_rows=1} selected{/if}>1</option>
			<option value="5"{if:member.mail.page_rows=5} selected{/if}>5</option>
			<option value="10"{if:member.mail.page_rows=10} selected{/if}>10</option>
			<option value="20"{if:member.mail.page_rows=20} selected{/if}>20</option>
			<option value="50"{if:member.mail.page_rows=50} selected{/if}>50</option>
			<option value="100"{if:member.mail.page_rows=100} selected{/if}>100</option>
			<option value="200"{if:member.mail.page_rows=200} selected{/if}>200</option>
			<option value="300"{if:member.mail.page_rows=300} selected{/if}>300</option>
			<option value="500"{if:member.mail.page_rows=500} selected{/if}>500</option>
			<option value="1000"{if:member.mail.page_rows=1000} selected{/if}>1000</option>
			</select>
		</td>
	</tr>
	<tr>
		<td>
		</td>
		<td style="text-align:right;">
			<input type="button" value="未配信メール全送信" onclick="memberMailSendStart('')" onkeypress="memberMailSendStart('')" />
		</td>
	</tr>
	</tbody>
	</table>
	</form>

	<form name="listform">
	<table class="paging" style="margin:0 auto;width:96%;border-style:none;">
	<tr>
		<td style="width:6em;">
			{if:member.mail.has_prev_page}
				<input type="button" value="前のページ" onclick="FormerCommon.prevPage()" onkeypress="FormerCommon.prevPage()" />
			{else}
				<span style="color:#D0D0D0;">前のページ</span>
			{/if}
		</td>
		<td style="text-align:center;">
			{write:member.mail.total_count}件  {write:member.mail.page_number} / {write:member.mail.total_page}ページ
		</td>
		<td style="width:6em;">
			{if:member.mail.has_next_page}
				<input type="button" value="次のページ" onclick="FormerCommon.nextPage()" onkeypress="FormerCommon.nextPage()" />
			{else}
				<span style="color:#D0D0D0;">次のページ</span>
			{/if}
		</td>
	</tr>
	</table>

	<table class="list" style="width:96%;margin:0 auto;">
	<thead>
	<tr>
		<th>タイトル</th>
		<th style="width:3em;white-space:nowrap;text-align:center;">対象</th>
		<th>日時</th>
		<th style="width:3em;white-space:nowrap;font-size:small;color:#30d030;">未配信</th>
		<th style="width:3em;white-space:nowrap;font-size:small;color:#3040ff;">配信済</th>
		<th style="width:3em;white-space:nowrap;font-size:small;color:#ff3030;">エラー</th>
		<th style="width:3em;white-space:nowrap;font-size:small;">総数</th>
		<th style="width:6em;white-space:nowrap;font-size:small;">操作</th>
	</tr>
	</thead>
	<tbody>
	{foreach:member.mail.data_array mailObject}
	<tr class="status_{write:mailObject->'status_flag'}">
		<td>
			{write-mpic:mailObject::subject}[<a href="./detail.php?magid={write:urlencode(mailObject->'mail_id')}">詳細</a>]
		</td>
		<td style="width:3em;white-space:nowrap;text-align:center;font-weight:bold;">
			{if:mailObject->'select_type'=='q'}
				<span style="color:#aaaa00;">検索</span>
			{else-if:mailObject->'select_type'=='s'}
				<span style="color:#00aaaa;">選択</span>
			{else}
				<span style="color:#aa00aa;">個別</span>
			{/if}
		</td>
		<td style="padding:0px;">
			<table class="mail-date-info">
			<tbody>
			<tr>
				<td>作成</td><td>:</td>
				<td>
					{write:sprintf('%01d',mailObject->'registered_date_month')}月{write:sprintf('%01d',mailObject->'registered_date_day')}日
					{write:sprintf('%02d',mailObject->'registered_date_hour')}:{write:sprintf('%02d',mailObject->'registered_date_min')}
				</td>
			</tr>
			{if:strlen(mailObject->'completed_date')>0}
			<tr>
				<td>完了</td><td>:</td>
				<td>
					{write:sprintf('%01d',mailObject->'completed_date_month')}月{write:sprintf('%01d',mailObject->'completed_date_day')}日
					{write:sprintf('%02d',mailObject->'completed_date_hour')}:{write:sprintf('%02d',mailObject->'completed_date_min')}
				</td>
			</tr>
			{else-if:strtotime(mailObject->'reserve_date')>=strtotime(mailObject->'registered_date')}
			<tr>
				<td>予定</td><td>:</td>
				<td>
					{write:sprintf('%01d',mailObject->'reserve_date_month')}月{write:sprintf('%01d',mailObject->'reserve_date_day')}日
					{write:sprintf('%02d',mailObject->'reserve_date_hour')}:{write:sprintf('%02d',mailObject->'reserve_date_min')}
				</td>
			</tr>
			{/if}
			</tbody>
			</table>
		</td>
		<td style="width:3em;white-space:nowrap;text-align:right;">
			{write:number_format(mailObject->'mail_count_reserved')}
		</td>
		<td style="width:3em;white-space:nowrap;text-align:right;">
			{write:number_format(mailObject->'mail_count_delivered')}
		</td>
		<td style="width:3em;white-space:nowrap;text-align:right;{if:mailObject->'mail_count_error'>0}color:#ff3030;{/if}">
			{write:number_format(mailObject->'mail_count_error')}
			{if:mailObject->'mail_count_error'>0}
			{set:statusCountHash mailObject->'delivery_status_hash'}
			<div id="mail-error-detail-{write:mailObject->'mail_id'}" style="display:none;visibility:hidden;position:absolute;">
			{foreach:MEMBER_MAIL_DELIVERY_STATUS_HASH statusNumber statusName}
				{write:statusName} : {write:number_format(statusCountHash[statusNumber])}<br />
			{/foreach}
			</div>
			{/if}
		</td>
		<td style="width:3em;white-space:nowrap;text-align:right;">
			{write:number_format(mailObject->'total_count')}
		</td>
		<td style="width:6em;white-space:nowrap;text-align:center;padding:0px;">
			{if:mailObject->'status_flag'<2}
			<input type="button" style="width:100%;" value="配信開始"
				onclick="memberMailSendStart('{write:mailObject->'mail_id'}')" onkeypress="memberMailSendStart('{write:mailObject->'mail_id'}')"
				/><br />
			<input type="button" style="width:100%;" value="削除"
				onclick="member_mail_deleteMail('{write:mailObject->'mail_id'}');" /><br />
			{else}
				-
			{/if}
		</td>
	</tr>
	{/foreach}
	</tbody>
	</table>
	</form>

	<form name="member_mail_delform" action="./delete.php" method="post">
	<input type="hidden" name="mail_id" value="" />
	</form>

<style type="text/css">
<!--
table.mail-date-info {
	border-style:none;
	border-collapse:collapse;
}
table.mail-date-info tbody tr td {
	border-style:none;
}
tr.status_0 td {
	background-color: #80ffa0;
}
tr.status_1 td {
	background-color: #80ffff;
}
tr.status_2 td {
	background-color: #f0f0f0;
}
-->
</style>
<script language="JavaScript" type="text/javascript"><!--
function member_mail_deleteMail(mailId) {
	if( confirm('この操作は取り消せません!\n本当に削除しますか？') ) {
		document.member_mail_delform.mail_id.value	= mailId;
		document.member_mail_delform.submit();
	}
}
/**
 * 送信パネル
 */
var membermailSendPanelId	= 'member-mail-send-panel';
function memberMailSendPanelResize() {
	var sendPanel	= document.getElementById(membermailSendPanelId);
	var wall		= document.getElementById('innerblock-wall');
	if( wall ) {
		wall.style.height	= '450px';
	}
	if( sendPanel ) {
		var marginTop			= 0;
		var marginLeft			= 0;
		var cWidth				= 800;
		var cHeight				= 498;
		if ( document.documentElement ) {
			marginLeft	= document.documentElement.scrollLeft + ( ( document.documentElement.clientWidth - cWidth ) / 2 );
			marginTop	= document.documentElement.scrollTop + ( (document.documentElement.clientHeight -cHeight) / 2 );
		} else {
			marginLeft	= document.body.scrollLeft + ( ( document.body.clientWidth - cWidth ) / 2 );
			marginTop	= document.body.scrollTop + ( ( document.body.clientHeight - cHeight ) / 2 );
		}
		sendPanel.style.width	= String(cWidth) + 'px';
		sendPanel.style.height	= String(cHeight) + 'px';
		sendPanel.style.left	= String(marginLeft) + 'px';
		sendPanel.style.top		= String(marginTop) + 'px';
	}
}
function membarMailSendPanelClose() {
	var sendPanel	= document.getElementById(membermailSendPanelId);
	if( sendPanel ) {
		var bodyTags 	= document.getElementsByTagName('body');
		if( bodyTags && bodyTags[0] ) {
			bodyTags[0].removeChild(sendPanel);
		} else {
			alert('bodyタグがありません。このページのHTMLが正しく記述されていない可能性があります。');
		}
	}
	setTimeout(FormerCommon.displayWhiteIn, 100);
}
/**
 * 送信処理開始
 */
var memberMailSendMailId	= '';
function memberMailSendStart(mailId) {
	memberMailSendMailId	= mailId;
	var sendPanel				= document.createElement('div');
	sendPanel.innerHTML			= '';
	sendPanel.id				= membermailSendPanelId;
	sendPanel.style.position	= 'absolute';
	sendPanel.style.zIndex		= '99999';
	var bodyTags 	= document.getElementsByTagName('body');
	if( bodyTags && bodyTags[0] ) {
		bodyTags[0].appendChild(sendPanel);
		if(window.attachEvent){
			window.attachEvent('onscroll',memberMailSendPanelResize);
			window.attachEvent('onresize',memberMailSendPanelResize);
		}else{
			window.addEventListener('scroll',memberMailSendPanelResize,false);
			window.addEventListener('resize',memberMailSendPanelResize,false);
		}
		memberMailSendPanelResize();
		memberMailSendCreateListStart();
	} else {
		alert('bodyタグがありません。このページのHTMLが正しく記述されていない可能性があります。');
		setTimeout(FormerCommon.displayWhiteIn, 100);
	}
}
/**
 * 送信リスト準備
 */
var createListContinueFlag	= false;
function memberMailSendCreateListStart() {
	FormerCommon.displayGrayOut(9999);
	createListContinueFlag	= true;
	memberMailSendCreateList();
}
function memberMailSendCreateListEnd() {
	createListContinueFlag	= false;
}
function memberMailSendCreateList() {
	FormerCommon.displayGrayOut(9999);
	if( createListContinueFlag ) {
		templateHttpObject	= FormerCommon.createHttpRequest(memberMailSendCreateListResult);
		if (templateHttpObject) {
			FormerCommon.displayGrayOut(9999);
			var url	= "./createlist.php?magid="+memberMailSendMailId+"&sao=10";
			templateHttpObject.open("GET",url,true);
			templateHttpObject.send(null);
		}
	}
}
function memberMailSendCreateListResult() {
	if ((templateHttpObject.readyState == 4) && (templateHttpObject.status == 200)){
		var sendPanel	= document.getElementById(membermailSendPanelId);
		sendPanel.innerHTML	= templateHttpObject.responseText;
		if( createListContinueFlag ) {
			setTimeout(memberMailSendCreateList, 2000);
		}
	} else if ((templateHttpObject.readyState == 4) && (templateHttpObject.status != 200)){
		alert('サーバーと通信できませんでした。');
	}
}
/**
 * 送信処理
 */
var sendMailContinueFlag	= false;
function memberMailSendMailPostStart() {
	FormerCommon.displayGrayOut(9999);
	sendMailContinueFlag	= true;
	memberMailSendMailPost();
}
function memberMailSendMailPostEnd() {
	sendMailContinueFlag	= false;
	window.location.reload();
}
function memberMailSendMailPost() {
	FormerCommon.displayGrayOut(9999);
	if( sendMailContinueFlag ) {
		templateHttpObject	= FormerCommon.createHttpRequest(memberMailSendMailPostResult);
		if (templateHttpObject) {
			FormerCommon.displayGrayOut(9999);
			var url	= "./send.php?magid="+memberMailSendMailId+"&sao=1";
			templateHttpObject.open("GET",url,true);
			templateHttpObject.send(null);
		}
	}
}
function memberMailSendMailPostResult() {
	if ((templateHttpObject.readyState == 4) && (templateHttpObject.status == 200)){
		var sendPanel	= document.getElementById(membermailSendPanelId);
		sendPanel.innerHTML	= templateHttpObject.responseText;
		if( sendMailContinueFlag ) {
			setTimeout(memberMailSendMailPost, 1000);
		}
	} else if ((templateHttpObject.readyState == 4) && (templateHttpObject.status != 200)){
		alert('サーバーと通信できませんでした。');
	}
}

//--></script>