<?php include_once( "../spider.inc.php" ); ?>
{charset:UTF-8}
{template:admin_default.tpl}
{module:system.login.Require}
{module:system.package.LoadList}
{preset:page_title '管理パネルトップ'}

	<h1>管理パネルトップ</h1>
	{if:count(system.package.installedPackageIdArray)>0}
		{set:lastPackageAlert ''}
		{foreach:system.package.existsPackageObjectHash key packageConfigObject}{if:packageConfigObject->hasPackageMenu()}
			{if:strlen(packageConfigObject->getAlertMessages(request_object))>0}
				{set:lastPackageAlert packageConfigObject->getAlertMessages(request_object)}
			{/if}
		{/if}{/foreach}
		{write:lastPackageAlert noescape}
		
		<!-- パッケージメニューの表示	-->
		<dl class="package-index" style="width:55%;padding:2px;">
		{foreach:system.package.existsPackageObjectHash key packageConfigObject}{if:packageConfigObject->hasPackageMenu()}
			{if:packageConfigObject->isInstall()}
			<!-- インストール済みパッケージの場合	-->
			<dt><a href="./{write:packageConfigObject->getPackageId()}/">{write:packageConfigObject->getPackageViewName()}</a></dt>
			<dd>{write:packageConfigObject->getPackageDescription() noescape}</dd>
			{else}
			<!-- 未インストールパッケージの場合	-->
			<dt><span style="color:#ff0000;">{write:packageConfigObject->getPackageViewName()}</span></dt>
			<dd>インストールされていません！<a href="./system/package/install/form.php?sitpi={write:packageConfigObject->getPackageId()}">こちら</a>からインストールと初期設定をおこなってください。</dd>
			{/if}
		{/if}{/foreach}
		</dl>
		
		<br style="clear:both;" />
		<h1>システムサマリー</h1>
		<?php
			// サマリーファイルの存在を確認します。
			$curDir	= dirname($_SERVER['SCRIPT_FILENAME']);
			if ($curDh = opendir($curDir)) {
				while (($fileName = readdir($curDh)) !== false) {
					if( preg_match('/^\\./',$fileName) == 0 ) {
						$absolutePath	= $curDir.DIRECTORY_SEPARATOR.$fileName;
						if( preg_match('/[dD][iI][rR]/',filetype($absolutePath) ) > 0 ) {
							$summaryPath	= $absolutePath.DIRECTORY_SEPARATOR.'summary.php';
							if( file_exists($summaryPath) ) {
								// サマリーファイルが存在するならアクセスして内容を表示します
								$summaryUrl		= SPIDER_URL_BASE.basename(dirname(__FILE__)).'/'.$fileName.'/summary.php';
								echo "<div id='summery-".$fileName."' class='system-index-package-summery' style='width:95%;margin:0 auto;'>読み込み中...</div>";
							}
						}
					}
				}
				closedir($curDh);
			}
		?>
<script language="JavaScript" type="text/javascript"><!--
/**
 * version.xmlを確認
 */
var panelTopHttpObject;
function systemGetMdsToolsVersion() {
	panelTopHttpObject	= FormerCommon.createHttpRequest(systemGetMdsToolsVersionResult);
	if( panelTopHttpObject ) {
		panelTopHttpObject.open("GET",'./getnews.php?rt=ver',true);
		panelTopHttpObject.send(null);
	} else {
		alert('サーバー通信作成に失敗しました!');
	}
}
function systemGetMdsToolsVersionResult() {
	if ((panelTopHttpObject.readyState == 4) && (panelTopHttpObject.status == 200)){
		var updateBlock		= document.getElementById('update-info');
		if( updateBlock ) {
			updateBlock.innerHTML	= '';
			var domDoc		= panelTopHttpObject.responseXML;
			if( domDoc ) {
				var nodes		= domDoc.getElementsByTagName('release');
				if( nodes.length > 0 ) {
					var lastReleaseInfo = nodes[0];
					var versionAttribute = lastReleaseInfo.getAttributeNode("version");
					var lastVersion = versionAttribute.value.replace('.','');
					var nowVersion	= new String('<?php echo RELEASE_VERSION; ?>').replace('.','');
					if( nowVersion < lastVersion ) {
						var childs	= lastReleaseInfo.childNodes;
						var description;
						for( var cnum=0; cnum<childs.length; cnum++ ) {
							if( childs[cnum].tagName == 'description' ) {
								description	= childs[cnum].firstChild.nodeValue;
								break;
							}
						}
						var updateMsg	= document.createElement('div');
						updateMsg.style.padding = '5px';
						updateMsg.style.marginBottom = '15px';
						updateMsg.style.border = 'solid 1px #dddd30';
						updateMsg.style.color = '#c00000';
						updateMsg.style.backgroundColor = '#ffffa0';
						updateMsg.innerHTML	= '利用可能なアップデート '+ versionAttribute.value +'<br />'
							+description
							+' <a href="/<?php echo SYSTEM_DIR_NAME_ADMIN_PANEL; ?>/system/update/" target="_blank">ソフトウェア更新画面</a>を確認ください!';
						updateBlock.appendChild(updateMsg);
					}
				}
			}
			systemGetMdsToolsAdv();
		}
		panelTopHttpObject = null;
		systemGetMdsToolsNews();
	} else if ((panelTopHttpObject.readyState == 4) && (panelTopHttpObject.status != 200)){
		panelTopHttpObject = null;
		systemGetMdsToolsNews();
	}
}
/**
 * MDS Toolsの記事RSSを取得
 */
function systemGetMdsToolsNews() {
	panelTopHttpObject	= FormerCommon.createHttpRequest(systemGetMdsToolsNewsResult);
	if( panelTopHttpObject ) {
		panelTopHttpObject.open("GET",'./getnews.php',true);
		panelTopHttpObject.send(null);
	} else {
		alert('サーバー通信作成に失敗しました!');
	}
}
function systemGetMdsToolsNewsResult() {
	if ((panelTopHttpObject.readyState == 4) && (panelTopHttpObject.status == 200)){
		var newsBlock		= document.getElementById('mds-tools-news');
		if( newsBlock ) {
			newsBlock.innerHTML	= '';
			var domDoc		= panelTopHttpObject.responseXML;
			if(domDoc) {
				var nodes		= domDoc.getElementsByTagName('item');
				for( var num=0; num<nodes.length; num++ ) {
					var targetItem	= nodes[num];
					var childs		= targetItem.childNodes;
					var title,pubDate,description;
					for( var cnum=0; cnum<childs.length; cnum++ ) {
						if( childs[cnum].tagName == 'title' ) {
							//alert(childs[cnum].firstChild.nodeValue);
							title	= childs[cnum].firstChild.nodeValue;
						} else if( childs[cnum].tagName == 'pubDate' ) {
							pubDate	= childs[cnum].firstChild.nodeValue;
						} else if( childs[cnum].tagName == 'description' ) {
							description	= childs[cnum].firstChild.nodeValue;
						}
					}
					var date = new Date(pubDate);
					var topicElm = document.createElement('div');
					var dateElm	= document.createElement('div');
					dateElm.style.fontWeight	= 'bold';
					dateElm.innerHTML			= date.getFullYear() + '年' + (date.getMonth()+1) + '月' + date.getDate() + '日';
					topicElm.appendChild(dateElm);
					var descElm	= document.createElement('div');
					descElm.style.fontSize	= '12px';
					descElm.innerHTML	= description;
					topicElm.appendChild(descElm);
					topicElm.style.paddingBottom	= '3px';
					if( num % 2 == 1 ) {
						topicElm.style.backgroundColor	= '#f0fff0';
					}
					newsBlock.appendChild(topicElm);
				}
			}
		}
		panelTopHttpObject	= null;
		systemGetMdsToolsBbs();
	} else if ((panelTopHttpObject.readyState == 4) && (panelTopHttpObject.status != 200)){
		panelTopHttpObject	= null;
		systemGetMdsToolsBbs();
	}
}

/**
 * MDS Toolsフォーラムの記事RSSを取得
 */
function systemGetMdsToolsBbs() {
	panelTopHttpObject	= FormerCommon.createHttpRequest(systemGetMdsToolsBbsResult);
	if( panelTopHttpObject ) {
		panelTopHttpObject.open("GET",'./getnews.php?rt=bbs',true);
		panelTopHttpObject.send(null);
	} else {
		alert('サーバー通信作成に失敗しました!');
	}
}
function systemGetMdsToolsBbsResult() {
	if ((panelTopHttpObject.readyState == 4) && (panelTopHttpObject.status == 200)){
		var newsBlock		= document.getElementById('mds-tools-bbs');
		if( newsBlock ) {
			newsBlock.innerHTML	= '';
			var domDoc		= panelTopHttpObject.responseXML;
			if( domDoc ) {
				var nodes		= domDoc.getElementsByTagName('item');
				for( var num=0; num<nodes.length; num++ ) {
					var targetItem	= nodes[num];
					var childs		= targetItem.childNodes;
					var title,pubDate,description,link;
					for( var cnum=0; cnum<childs.length; cnum++ ) {
						if( childs[cnum].tagName == 'title' ) {
							//alert(childs[cnum].firstChild.nodeValue);
							title	= childs[cnum].firstChild.nodeValue;
						} else if( childs[cnum].tagName == 'pubDate' ) {
							pubDate	= childs[cnum].firstChild.nodeValue;
						} else if( childs[cnum].tagName == 'description' ) {
							description	= childs[cnum].firstChild.nodeValue;
						} else if( childs[cnum].tagName == 'link' ) {
							link	= childs[cnum].firstChild.nodeValue;
						}
					}
					var date = new Date(pubDate);
					var topicElm = document.createElement('div');
					var titleElm = document.createElement('div');
					titleElm.innerHTML	= '<a href="' + link + '" target="_blank">' + title + '</a>';
					topicElm.appendChild(titleElm);
					var descElm	= document.createElement('div');
					descElm.style.fontSize	= '12px';
					descElm.innerHTML	= description;
					topicElm.appendChild(descElm);
					topicElm.style.paddingBottom	= '3px';
					if( num % 2 == 1 ) {
						topicElm.style.backgroundColor	= '#f0fff0';
					}
					newsBlock.appendChild(topicElm);
				}
			}
		}
		panelTopHttpObject	= null;
		systemInitSummery();
	} else if ((panelTopHttpObject.readyState == 4) && (panelTopHttpObject.status != 200)){
		panelTopHttpObject	= null;
		systemInitSummery();
	}
}
function systemGetMdsToolsAdv() {
	systemGetMdsToolsAdvExecute('top',1,'update-info');
}

var systemIndexPackageSummeryArray;
var systemIndexPackageNameArray;
function systemInitSummery() {
	systemIndexPackageSummeryArray	= new Array();
	systemIndexPackageNameArray	= new Array();
<?php
	// サマリーファイルの存在を確認します。
	$curDir	= dirname($_SERVER['SCRIPT_FILENAME']);
	if ($curDh = opendir($curDir)) {
		while (($fileName = readdir($curDh)) !== false) {
			if( preg_match('/^\\./',$fileName) == 0 ) {
				$absolutePath	= $curDir.DIRECTORY_SEPARATOR.$fileName;
				if( preg_match('/[dD][iI][rR]/',filetype($absolutePath) ) > 0 ) {
					$summaryPath	= $absolutePath.DIRECTORY_SEPARATOR.'summary.php';
					if( file_exists($summaryPath) ) {
						// サマリーファイルが存在するならアクセスして内容を表示します
						$summaryUrl		= './'.$fileName.'/summary.php';
						echo "\tsystemIndexPackageSummeryArray.push('".$summaryUrl."');\n";
						echo "\tsystemIndexPackageNameArray.push('".$fileName."');\n";
					}
				}
			}
		}
		closedir($curDh);
	}
?>
	systemIndexGetSummery();
}

var systemIndexPackageHttpObject;
function systemIndexGetSummery() {
	if( systemIndexPackageSummeryArray && systemIndexPackageSummeryArray.length > 0 ) {
		var nextUrl		= systemIndexPackageSummeryArray.shift();
		systemIndexPackageHttpObject	= FormerCommon.createHttpRequest(systemIndexGetSummeryResult);
		if( systemIndexPackageHttpObject ) {
			systemIndexPackageHttpObject.open("GET",nextUrl,true);
			systemIndexPackageHttpObject.send(null);
		} else {
			alert('サーバー通信作成に失敗しました!');
		}
	}
}
function systemIndexGetSummeryResult() {
	if ((systemIndexPackageHttpObject.readyState == 4) && (systemIndexPackageHttpObject.status == 200)){
		var nextName	= systemIndexPackageNameArray.shift();
		var divId		= 'summery-' + nextName;
		var divElm		= document.getElementById(divId);
		divElm.innerHTML	= systemIndexPackageHttpObject.responseText;
		systemIndexGetSummery();
	} else if ((systemIndexPackageHttpObject.readyState == 4) && (systemIndexPackageHttpObject.status != 200)){
	}
}

if(window.attachEvent){
	window.attachEvent('onload',systemGetMdsToolsVersion);
}else{
	window.addEventListener('DOMContentLoaded',systemGetMdsToolsVersion,false);
}
//--></script>
	{else}
		<p>
			<span style="color:#ff6060;font-weight:bold;">パッケージがインストールされていません。
			「<a href="./system/package/">パッケージ管理</a>」ページからパッケージをインストールしてください。</span>
			&nbsp;&nbsp;
		</p>
		<div style="width:95%;margin:0 auto;font-weight:bold;text-align:right;">
			<a href="./system/package">&gt;&gt;パッケージ管理へ</a>
		</div>
		<br />
	{/if}
