<?php include_once( "../../../../spider.inc.php" ); ?>
{charset:UTF-8}
{template:admin_default.tpl}
{module:design.template.LoadList}
{module:content.LoadFolders}
{module:content.LoadList}
{preset:page_title 'デザイン管理 > デザインテンプレート適用'}

	<div class="panc">
		<a href="../../" title="管理パネルのトップページを表示します">管理パネルトップ</a>
		&gt; <a href="../" title="デザイン管理トップページを表示します">デザイン管理</a>
		&gt; デザインの変更
	</div>
	<h1>デザイン管理 &gt; デザインの変更</h1>
	
{if:IS_ERROR}
	<h2>
		エラー
	</h2>
	<ul class="error">
	{foreach:errors error}
		<li>{write:error}</li>
	{/foreach}
	</ul>
{else}

	<form name="sform" action="./index.php" method="get">
	<p>
		右サイドの「テンプレート選択」のボックスで適用したいデザインテンプレートを選択してから対象のページの右側にある「適用」をクリックしてデザインを変更してください。
		表示されている全てのページのデザインを変更するにはページ下部の「このフォルダの全てのページに選択テンプレートを適用」リンクをクリックしてください。
	</p>
	<table style="width:95%;margin:0 auto;">
	<tody>
	<tr>
		<td>
			<div id="design-tpl-apply-folder-select">
			フォルダ選択 <select name="ccurf" onchange="designTemplateGetPageList();">
			{foreach:content.folderArray folderPath}{if:preg_match('/^\\/js/',folderPath)==0 && preg_match('/^\\/upload/',folderPath)==0 && preg_match('/^\\/file/',folderPath)==0}
				<option value="{write:folderPath}"
					{if:content.currentFoloder==folderPath} selected{/if}
					>{write:folderPath}</option>
			{/if}{/foreach}
			</select>
			</div>
		</td>
		<td style="text-align:right;">
			<input type="button" id="loadAllButton"
				value="サイト内全表示モード"
				onclick="designTemplateChangeToAllMode()" />
		</td>
	</tr>
	<tbody>
	</table>
	</form>
	<br />
	
	<form name="listform" action="#">
	<div style="width:95%;margin:0 auto;text-align:right;">
		<input type="checkbox" name="apply_page_html" value="1" checked
		/>ページHTMLが同梱されている場合に適用する
	</div>
	<table class="list" style="width:95%;margin:0 auto;">
	<thead>
	<tr>
		<th style="width:30%;white-space:nowrap;">ファイル名</th>
		<th style="width:55%;white-space:nowrap;">ページタイトル</th>
		<th style="width:15%;white-space:nowrap;">テンプレート変更</th>
	</tr>
	</thead>
	<tbody id="page-list">
	</tbody>
	</table>
	<br />	
	</form>
	
	<div style="width:95%;margin:0 auto;text-align:right;padding-top:1em;">
	<form name="allform" action="./" method="get">
		表示中の全ページのデザインを変更 →
		<select name="templateselect" onfocus="designTemplateSetPrevIndex(this);">
		{foreach:design.template.templateInfoHash templateFileName templateInfo}
			<option value="{write:templateInfo->'file_name'}"
				{if:'default.fmt'==templateInfo->'file_name'} selected{/if}
				>{write:templateInfo->'view_name'}</option>
		{/foreach}
		</select><input type="button" value="変更" onclick="designTemplateApplyAll(document.allform.templateselect);" />
		<br />
		
		<div id="allpages"></div>
	</form>
	<br />
		
		<a href="../"
			title="デザインテンプレートファイルをアップロードして新規デザインテンプレートを登録します"
			>&gt;&gt; デザインテンプレート管理でテンプレートを新規作成</a>
	</div>

<script language="JavaScript" type="text/javascript"><!--
var designTemplateApplyViewMode	= 1;	// 1=個別表示モード , 0=全表示モード
var designTemplateApplyCurrentFolderIndex;
var designTemplateApplyPageObjectArray	= new Array();
/**
 * 現在表示中のページを全てクリアします
 */
function designTemplateCrearPageList() {
	designTemplateApplyPageObjectArray	= new Array();
	var tbodyObject = document.getElementById('page-list');
	if( tbodyObject ) {
		var childs = tbodyObject.childNodes;
		for( var i=childs.length-1; i>=0; i-- ) {
			tbodyObject.removeChild(childs[i]);
		}
	}
}
/**
 * ターゲットフォルダのページ一覧を読み込み
 */
function designTemplateGetPageList() {
	contentGetContentList(
		document.sform.ccurf.options[document.sform.ccurf.selectedIndex].value,
		designTemplateGetPageListResult);
}
/**
 * 読み込んだページ一覧をテーブルに追加
 */
function designTemplateGetPageListResult(contentObjectArray) {
	// 個別表示モードなら一度全てのページ表示を消去
	if( 1 == designTemplateApplyViewMode ) {
		designTemplateApplyCurrentFolderIndex	= document.sform.ccurf.selectedIndex;
		designTemplateCrearPageList();
	}
	// 表示テーブルを取得して追加
	var tbodyObject = document.getElementById('page-list');
	if( tbodyObject ) {
		for( var num=0; num<contentObjectArray.length; num++ ) {
			var contentObject	= contentObjectArray[num];
			if( contentObject.type == 'spider-dynamic' && contentObject.template && contentObject.template.length > 0 ) {
				// ダイナミックページなら処理
				designTemplateApplyPageObjectArray.push(contentObject);
				var trElm	= document.createElement('tr');
				var tdFile	= document.createElement('td');
				var fileUri	= contentObject.folder+'/'+contentObject.name;
				if( contentObject.folder == '/' ) {
					fileUri	= contentObject.folder+contentObject.name;
				}
				if( 1 == designTemplateApplyViewMode ) {
					tdFile.innerHTML	= contentObject.name;
				} else {
					tdFile.innerHTML	= fileUri;
				}
				trElm.appendChild(tdFile);
				var tdTitle	= document.createElement('td');
				tdTitle.innerHTML	= contentObject.title;
				trElm.appendChild(tdTitle);
				var tdTpl	= document.createElement('td');
				var tplSel	= designTemplateGetPageListTemplateSelect(contentObject);
				tdTpl.appendChild(tplSel);
				trElm.appendChild(tdTpl);
				tbodyObject.appendChild(trElm);
			}
		}
	}
	// 表示モード制御
	var btn = document.getElementById('loadAllButton');
	if( 1 == designTemplateApplyViewMode ) {
		// 個別表示モードなら終了
		btn.value = 'サイト内全表示モード';
	} else {
		// 全表示モード
		if( document.sform.ccurf.length - 1 > document.sform.ccurf.selectedIndex ) {
			// 残りがあるなら再実行
			document.sform.ccurf.selectedIndex++;
			designTemplateGetPageList();
		} else {
			// 完了しているなら終了
			btn.disabled	= '';
		}
	}
}
/**
 * サイト内表示モード読み込み開始
 */
function designTemplateChangeToAllMode() {
	designTemplateApplyViewMode			= 0;
	document.sform.ccurf.selectedIndex	= 0;
	// ボタン制御
	var btn = document.getElementById('loadAllButton');
	btn.value = 'フォルダ表示モードに戻る';
	btn.disabled	= 'disabled';
	btn.onclick		= designTemplateChangeToFolderMode;
	// セレクトボックス制御
	var sel	= document.getElementById('design-tpl-apply-folder-select');
	sel.style.display	= 'none';
	sel.style.visibility	= 'hidden';
	// 実行開始
	designTemplateCrearPageList();
	designTemplateGetPageList();
}
/**
 * フォルダ表示モードに戻る
 */
function designTemplateChangeToFolderMode() {
	designTemplateApplyViewMode			= 1;
	document.sform.ccurf.selectedIndex	= designTemplateApplyCurrentFolderIndex;
	designTemplateGetPageList();
	// ボタン制御
	var btn = document.getElementById('loadAllButton');
	btn.value = 'サイト内全表示モード';
	btn.onclick	= designTemplateChangeToAllMode;
	// セレクトボックス制御
	var sel	= document.getElementById('design-tpl-apply-folder-select');
	sel.style.display	= 'block';
	sel.style.visibility	= 'visible';
}
/**
 * テンプレートセレクトボックスのオブジェクトを作成して取得
 */
function designTemplateGetPageListTemplateSelect(contentObject) {
	var selectElm			= document.createElement('select');
	selectElm.contentObject	= contentObject;
	{foreach:design.template.templateInfoHash templateFileName templateInfo}

	var op{write:design_template_templateInfoHash_loop_counter} = document.createElement('option');
	op{write:design_template_templateInfoHash_loop_counter}.value = '{write:templateInfo->'file_name'}';
	op{write:design_template_templateInfoHash_loop_counter}.text = '{write:templateInfo->'view_name'}';
	op{write:design_template_templateInfoHash_loop_counter}.label = '{write:templateInfo->'view_name'}';
	selectElm.appendChild(op{write:design_template_templateInfoHash_loop_counter});
	if( contentObject.template == '{write:templateInfo->'file_name'}' ) {
		selectElm.selectedIndex = {write:design_template_templateInfoHash_loop_counter -1};
	}
	
	{/foreach}
	
	selectElm.onchange = function() {
		designTemplateApplyOne( this.contentObject, this );
	};
	selectElm.onfocus = function() {
		designTemplateSetPrevIndex(this)
	};
	return selectElm;
}
/**
 * テンプレート選択ボックス復元
 */
 var designTemplatePrevIndex;
 function designTemplateSetPrevIndex(selectElement) {
 	designTemplatePrevIndex	= selectElement.selectedIndex;
 }
/**
 * 個別にテンプレートを適用する
 */
function designTemplateApplyOne( contentObject, selectElement ) {
	if( confirm(contentObject.name+'のデザインテンプレートを変更してよろしいですか？') ) {
		var applyPageHtml	= false;
		if( document.listform.apply_page_html.checked ) {
			applyPageHtml	= true;
		}
		var fileUri	= contentObject.folder+'/'+contentObject.name;
		if( contentObject.folder == '/' ) {
			fileUri	= contentObject.folder+contentObject.name;
		}
		designTemplateApplyPage( selectElement.options[selectElement.selectedIndex].value, fileUri, true, applyPageHtml, null );
	} else {
		selectElement.selectedIndex	= designTemplatePrevIndex;
	}
}
/**
 * 表示中の全てのページに適用する
 */
var designTemplateApplyAllIndex		= 0;
var designTemplateApplyAllTemplate	= '';
function designTemplateApplyAll(selectElement) {
	if( confirm('表示中の全ページのデザインテンプレートを変更してよろしいですか？') ) {
		designTemplateApplyAllTemplate	= selectElement.options[selectElement.selectedIndex].value;
		designTemplateApplyAllIndex		= 0;
		designTemplateApplyAllExecute();
	} else {
		selectElement.selectedIndex	= designTemplatePrevIndex;
	}
}
function designTemplateApplyAllExecute() {
	var applyPageHtml	= false;
	if( document.listform.apply_page_html.checked ) {
		applyPageHtml	= true;
	}
	if( designTemplateApplyAllIndex < designTemplateApplyPageObjectArray.length ) {
		var contentObject	= designTemplateApplyPageObjectArray[designTemplateApplyAllIndex];
		designTemplateApplyAllIndex++;
		if( contentObject ) {
			var fileUri	= contentObject.folder+'/'+contentObject.name;
			if( contentObject.folder == '/' ) {
				fileUri	= contentObject.folder+contentObject.name;
			}
			if( contentObject.type == 'spider-dynamic' && contentObject.template && contentObject.template.length > 0 ) {
				FormerCommon.displayGrayoutMessage(
						fileUri + 'にデザインを適用しています..<br />' +
						designTemplateApplyAllIndex+'/'+String(designTemplateApplyPageObjectArray.length)+'ファイルにデザインテンプレートを適用しました...'
					);
				designTemplateApplyPage( designTemplateApplyAllTemplate, fileUri, true, applyPageHtml, designTemplateApplyAllExecute );
			} else {
				designTemplateApplyAllExecute();
			}
		} else {
			alert('ページ情報の読み込みに失敗している為デザイン適用できません。恐れ入りますが画面をリロードします。');
			window.location.reload();
		}
	} else {
		// 完了
		designTemplateApplyAllIndex		= 0;
		setTimeout(FormerCommon.displayWhiteIn, 100);
		if( 1 == designTemplateApplyViewMode ) {
			designTemplateGetPageList();
		} else {
			designTemplateChangeToAllMode();
		}
	}
}
/**
 * 初期処理
 */
if(window.attachEvent){
	window.attachEvent('onload',designTemplateGetPageList);
}else{
	window.addEventListener('DOMContentLoaded',designTemplateGetPageList,false);
}
//--></script>
{/if}