<?php include_once( "../../spider.inc.php" ); ?>
{charset:UTF-8}
<?php header( 'Content-type: text/plain;charset=UTF-8' ); ?>
/** デザインテンプレート適用向けのHTTP通信オブジェクト	*/
var designTemplateApplyHttpObject;
/**
 * ページ個別にデザインテンプレートを適用します
 * @param templateFileName テンプレートファイル名
 * @param pageUri 適用ページURI
 * @param applyPage ページが存在した時に適用するか否かのbooleanフラグ
 * @param callbackFunction 適用が完了した時に実行するコールバック関数
 */
function designTemplateApplyPage( templateFileName, pageUri, applyTemplate, applyPage, callbackFunction ) {
	var contents	= "command=0";
	contents	+= "&" + encodeURIComponent('page_uri')+ "="+encodeURIComponent(pageUri);
	contents	+= "&" + encodeURIComponent('template_file_name')+ "="+encodeURIComponent(templateFileName);
	if( applyTemplate ) {
		contents	+= "&" + encodeURIComponent('apply_template')+ "="+encodeURIComponent('true');
	}
	if( applyPage && 'import' == applyPage ) {
		contents	+= "&" + encodeURIComponent('apply_pages')+ "="+encodeURIComponent('import');
	} else if( applyPage ) {
		contents	+= "&" + encodeURIComponent('apply_pages')+ "="+encodeURIComponent('true');
	}
	designTemplateApplyHttpObject	= FormerCommon.createHttpRequest(designTemplateApplyPageResult);
	if (designTemplateApplyHttpObject) {
		designTemplateApplyHttpObject.callbackFunction	= callbackFunction;
		designTemplateApplyHttpObject.open("POST",'<?php echo SPIDER_URI_BASE.SYSTEM_DIR_NAME_ADMIN_PANEL; ?>/design/template/apply/save.php',true);
		designTemplateApplyHttpObject.setRequestHeader("Content-Type", "application/x-www-form-urlencoded");
		designTemplateApplyHttpObject.send(contents);
		FormerCommon.displayGrayOut(9999);
	} else {
		alert('サーバーへの接続作成に失敗しました。');
	}
}
function designTemplateApplyPageResult() {
	if ((designTemplateApplyHttpObject.readyState == 4) && (designTemplateApplyHttpObject.status == 200)){
	    var lines	= designTemplateApplyHttpObject.responseText.cr2lf().split(LF);
	    var isError = false;
	    var error_message	= '';
	    for( var i=0; i<lines.length; i++ ){
			if( String(lines[i]).cr2lf().trim().length>0 ){
				var result	= String(lines[i]).cr2lf().trim();
				if( result == 'OK' ) {
					break;
				} else if( isError ) {
					error_message += result + "\n";
				} else {
					isError	= true;
				}
			}
		}
		if( isError ) {
			alert('適用に失敗しました!\n'+error_message);
			setTimeout(FormerCommon.displayWhiteIn, 100);
		} else {
			if( designTemplateApplyHttpObject.callbackFunction ) {
				// コールバック関数が指定されている場合はコールバック関数をコール
				var funcType	= typeof(designTemplateApplyHttpObject.callbackFunction);
				if( 'function' == funcType ) {
					designTemplateApplyHttpObject.callbackFunction();
				} else if( 'string' == funcType ) {
					eval(designTemplateApplyHttpObject.callbackFunction);
				}
			} else {
				// コールバック関数指定がない場合はグレイアウトを終えて終了
				setTimeout(FormerCommon.displayWhiteIn, 100);
			}
		}
	} else if ((designTemplateApplyHttpObject.readyState == 4) && (designTemplateApplyHttpObject.status != 200)){
		setTimeout(FormerCommon.displayWhiteIn, 100);
		alert('適用時にサーバー通信でエラーが発生しました。');
	}
}