<?php include_once( "../../../spider.inc.php" ); ?>
{module:system.package.LoadList}
{module:system.package.install.Session}

	{foreach:system.package.install.install_object_hash packageObject}
	{if:packageObject->getPackageId()=='database2'}{set:targetPackageObject packageObject}{/if}
	{/foreach}
	
	{if:is_object(targetPackageObject)}
	{set:definitionHash targetPackageObject->'definitionHash'}
	<h1>{write:targetPackageObject->getPackageViewName()}パッケージ</h1>

	<table style="width:95%;margin:0 auto;">
	<tr>
		<th style="width:16em;">データベースの種類</th>
		<td>
			{if:'pgsql'==definitionHash['DATABASE_DATABASE_TYPE']}PostgreSQL{/if}
			{if:'mysql'==definitionHash['DATABASE_DATABASE_TYPE']}MySQL{/if}
		</td>
	</tr>
	<tr>
		<th>データベース名</th>
		<td>
			{write:definitionHash['DATABASE_DATABASE_NAME']}
		</td>
	</tr>
	<tr>
		<th>データベース接続ユーザ名</th>
		<td>{write:definitionHash['DATABASE_DATABASE_USER']}
		</td>
	</tr>
	<tr>
		<th>データベース接続パスワード</th>
		<td>
			{write:preg_replace('/[.]/','*',definitionHash['DATABASE_DATABASE_PASSWORD'])}
		</td>
	</tr>
	<tr>
		<th>データベース文字コード</th>
		<td>
			{write:definitionHash['DATABASE_DATABASE_CHARSET']}
		</td>
	</tr>
	<tr>
		<th>データベースホスト名</th>
		<td>
			<span style="font-weight:bold;">▼マスタデータベース(更新用ホスト)</span><span class="required">※</span><br />
			{write:definitionHash['DATABASE_DATABASE_HOST'][0]}:{write:definitionHash['DATABASE_DATABASE_PORT'][0]}<br />
			<span style="font-weight:bold;">▼スレーブ1</span>&nbsp;<span style="font-size:x-small;">※分散サーバー環境で必要な場合のみ入力してください</span><br />
			{write:definitionHash['DATABASE_DATABASE_HOST'][1]}:{write:definitionHash['DATABASE_DATABASE_PORT'][1]}<br />
			<span style="font-weight:bold;">▼スレーブ2</span>&nbsp;<span style="font-size:x-small;">※分散サーバー環境で必要な場合のみ入力してください</span><br />
			{write:definitionHash['DATABASE_DATABASE_HOST'][2]}:{write:definitionHash['DATABASE_DATABASE_PORT'][2]}<br />
		</td>
	</tr>
	<tr>
		<th style="width:16em;">初期化オプション</th>
		<td>
			{if:'1'==definitionHash['DATABASE_DATABASE_INIT_OPTION']}既存データベースを利用{/if}
			{if:'2'==definitionHash['DATABASE_DATABASE_INIT_OPTION']}データベースを新規に作成{/if}
			{if:'3'==definitionHash['DATABASE_DATABASE_INIT_OPTION']}データベースを削除して作成{/if}
			<br />
			<br />
			<div id="DATABASE_DATABASE_INIT_OPTION_form">
				※↓新規作成・削除して作成の場合のみ入力
				<table style="border-style:none;">
				<tr>
					<td style="width:10em;">作成権限ユーザ：</td><td>{write:definitionHash['DATABASE_DATABASE_CREATE_USER']}</td>
				</tr><tr>
					<td>作成権限パスワード：</td><td>{write:preg_replace('/[.]/','*',definitionHash['DATABASE_DATABASE_CREATE_PASSWORD'])}</td>
				</tr>
				</table>
			</div>
		</td>
	</tr>
	</table>
	{else}
	<p>操作が正しくありません</p>
	{/if}