// former_coomon.js version 0.2
// CopyRight(C) m_nakashima@users.sourceforge.jp
// http://sourceforge.jp/projects/shopformer/
// m_nakashima@users.sourceforge.jp
//

// --------------------------------------------------------
// global definition
// --------------------------------------------------------
var LF		= String.fromCharCode(10);
var CR		= String.fromCharCode(13);
var TAB		= String.fromCharCode(9);
var global_is_opera = ( navigator.userAgent.indexOf('Opera')!=-1 );
FormerCommon = function() {
	var self	= document.createElement('div');
	return self;
}
FormerCommon.isInit					= false;
FormerCommon.path					= null;
// --------------------------------------------------------
// display grayout functions
// --------------------------------------------------------
FormerCommon.displayGrayoutPanel	= null;
FormerCommon.isDisplayGrayOut		= false;
FormerCommon.displayGrayOutLoading	= false;
FormerCommon.displayGrayOut			= function( zIndex ) {
	if( FormerCommon.isDisplayGrayOut ) {
		return true;
	}
	if( !FormerCommon.isInit ) {
		FormerCommon.init();
	}
	FormerCommon.isDisplayGrayOut		= true;
	FormerCommon.displayGrayOutLoading	= true;
	if( !FormerCommon.displayGrayoutPanel ) {
		FormerCommon.displayGrayoutPanel						= document.createElement('div');
		FormerCommon.displayGrayoutPanel.colorNumber			= 255;
		FormerCommon.displayGrayoutPanel.style.position			= 'absolute';
		FormerCommon.displayGrayoutPanel.style.display			= 'block';
		FormerCommon.displayGrayoutPanel.style.zIndex			= String(zIndex);
		FormerCommon.displayGrayoutPanel.style.top				= '0px';
		FormerCommon.displayGrayoutPanel.style.left				= '0px';
		FormerCommon.displayGrayoutPanel.style.backgroundColor	= '#FFFFFF';
		FormerCommon.displayGrayoutPanel.style.width			= String(FormerCommon.getPageWidth())+'px';
		FormerCommon.displayGrayoutPanel.style.height			= String(FormerCommon.getPageHeight())+'px';
		FormerCommon.displayGrayoutPanel.style.filter			= 'alpha(opacity=60)';
		FormerCommon.displayGrayoutPanel.style.opacity			= '0.6';
		FormerCommon.displayGrayoutPanel.style.textAlign		= 'center';
		if(window.attachEvent){
			window.attachEvent('onscroll',FormerCommon.displayGrayResize);
		}else{
			window.addEventListener('scroll',FormerCommon.displayGrayResize,false);
		}
		var imgObject	= new Image();
		imgObject.src	= FormerCommon.path + 'images/loading_l_01.gif';
		var scrollTop			= (document.documentElement.scrollTop || document.body.scrollTop);
		var clientHeight	= (document.documentElement.clientHeight || document.body.clientHeight);
		var marginTop	= (clientHeight-imgObject.height)/2 + scrollTop;
		imgObject.style.marginTop	= String(marginTop)+'px';
		FormerCommon.displayGrayoutPanel.loadingImage	= imgObject;
		FormerCommon.displayGrayoutPanel.appendChild(imgObject);
		FormerCommon.displayGrayoutPanel.messageBox		= document.createElement('div');
		FormerCommon.displayGrayoutPanel.messageBox.style.color = '#ffffff';
		FormerCommon.displayGrayoutPanel.appendChild(FormerCommon.displayGrayoutPanel.messageBox);
	}
	var bodyTags 	= document.getElementsByTagName('body');
	bodyTags[0].appendChild(FormerCommon.displayGrayoutPanel);
	FormerCommon.displayToGray();
}
FormerCommon.displayGrayoutMessage = function(message) {
	if( FormerCommon.displayGrayoutPanel && FormerCommon.displayGrayoutPanel.messageBox ) {
		FormerCommon.displayGrayoutPanel.messageBox.innerHTML	= message;
	}
}
FormerCommon.displayToGray	= function() {
	if( FormerCommon.displayGrayoutPanel ) {
		FormerCommon.displayGrayOutLoading	= true;
		if( FormerCommon.displayGrayoutPanel.colorNumber > 0 ){
			FormerCommon.displayGrayoutPanel.colorNumber	-= 50;
		}
		if( FormerCommon.displayGrayoutPanel.colorNumber < 0 ) {
			FormerCommon.displayGrayoutPanel.colorNumber	= 0;
		}
		FormerCommon.displayGrayoutPanel.style.backgroundColor
			= '#'
				+ FormerCommon.int2hexString(FormerCommon.displayGrayoutPanel.colorNumber)
				+ FormerCommon.int2hexString(FormerCommon.displayGrayoutPanel.colorNumber)
				+ FormerCommon.int2hexString(FormerCommon.displayGrayoutPanel.colorNumber);
		var topY	= (document.documentElement.scrollTop || document.body.scrollTop);
		var leftX	= (document.documentElement.scrollLeft || document.body.scrollLeft);
		window.scroll(leftX,topY+1);
		window.scroll(leftX,topY);
		if( FormerCommon.displayGrayoutPanel.colorNumber > 0 ){
			setTimeout(FormerCommon.displayToGray,100);
			return false;
		} else {
			FormerCommon.displayGrayOutLoading	= false;
			return true;
		}
	}
}
FormerCommon.displayWhiteIn = function() {
	if( FormerCommon.isDisplayGrayOut && FormerCommon.displayGrayoutPanel ) {
		if( FormerCommon.displayGrayOutLoading == true ) {
			setTimeout(FormerCommon.displayWhiteIn,100);
		} else if( FormerCommon.displayToWhite() ) {
			FormerCommon.displayGrayoutMessage('');
			var bodyTags 	= document.getElementsByTagName('body');
			bodyTags[0].removeChild(FormerCommon.displayGrayoutPanel);
			FormerCommon.isDisplayGrayOut	= false;
		} else {
			setTimeout(FormerCommon.displayWhiteIn,100);
		}
	}
}
FormerCommon.displayToWhite	= function() {
	if( FormerCommon.displayGrayoutPanel ) {
		if( FormerCommon.displayGrayoutPanel.colorNumber < 255 ){
			FormerCommon.displayGrayoutPanel.colorNumber	+= 30;
		}
		if( FormerCommon.displayGrayoutPanel.colorNumber > 255 ) {
			FormerCommon.displayGrayoutPanel.colorNumber	= 255;
		}
		FormerCommon.displayGrayoutPanel.style.backgroundColor
			= '#'
				+ FormerCommon.int2hexString(FormerCommon.displayGrayoutPanel.colorNumber)
				+ FormerCommon.int2hexString(FormerCommon.displayGrayoutPanel.colorNumber)
				+ FormerCommon.int2hexString(FormerCommon.displayGrayoutPanel.colorNumber);
		if( FormerCommon.displayGrayoutPanel.colorNumber < 255 ){
			return false;
		} else {
			return true;
		}
	}
}
FormerCommon.displayGrayResize	= function() {
	if( FormerCommon.isDisplayGrayOut && FormerCommon.displayGrayoutPanel ) {
		FormerCommon.displayGrayoutPanel.style.width			= String(FormerCommon.getPageWidth())+'px';
		FormerCommon.displayGrayoutPanel.style.height			= String(FormerCommon.getPageHeight())+'px';
		if( FormerCommon.displayGrayoutPanel.loadingImage ) {
			var scrollTop			= (document.documentElement.scrollTop || document.body.scrollTop);
			var scrollLeft		= (document.documentElement.scrollLeft || document.body.scrollLeft);
			var clientHeight	= (document.documentElement.clientHeight || document.body.clientHeight);
			var clientWidth		= (document.documentElement.clientWidth || document.body.clientWidth);
			var imgObject	= FormerCommon.displayGrayoutPanel.loadingImage;
			var marginTop	= (clientHeight-imgObject.height)/2 + scrollTop;
			imgObject.style.marginTop	= String(marginTop)+'px';
		}
	}
}
// --------------------------------------------------------
// Page Information Methods
// --------------------------------------------------------
//
// get page inner width
//
FormerCommon.getPageWidth	= function() {
	var width	= 0;
	if( window.innerWidth ) {
		width	= window.innerWidth;
	}
	if ( document.documentElement ) {
		width	= Math.max( width, document.documentElement.scrollWidth );
		width	= Math.max( width, document.documentElement.clientWidth );
	} else {
		width	= Math.max( width, document.body.scrollWidth );
		width	= Math.max( width, document.body.clientWidth );
	}
	return width;
}
//
// get page inner height
//
FormerCommon.getPageHeight	= function() {
	var height	= 0;
	if( window.innerHeight ) {
		height	= window.innerHeight;
	}
	if ( document.documentElement.clientHeight && document.documentElement.scrollHeight ) {
		height	= Math.max( height, document.documentElement.scrollHeight );
		height	= Math.max( height, document.documentElement.clientHeight );
	} else {
		height	= Math.max( height, document.body.scrollHeight );
		height	= Math.max( height, document.body.clientHeight );
	}
	return height;
}
//-----------------------------------------------------------------------------
// get scroll width
//-----------------------------------------------------------------------------
FormerCommon.getScrollWidth		= function() {  
	var value = 0;
	if( document.all && !global_is_opera){
		value = parseInt(document.documentElement.scrollLeft);
	} else {
		value = parseInt(self.pageXOffset);
	}
	return value;
}
//-----------------------------------------------------------------------------
// get scroll height
//-----------------------------------------------------------------------------
FormerCommon.getScrollHeight	= function() {  
	var value = 0;
	if( document.all && !global_is_opera){
		value = parseInt(document.documentElement.scrollTop);
	} else {
		value = parseInt(self.pageYOffset);
	}
	return value;
}
// --------------------------------------------------------
// utility methods
// --------------------------------------------------------
//
// button image
//
FormerCommon.buttonMouseOver	= function( image ) {
	image.style.cursor	= 'pointer';
	var imageSrc	= image.src;
	imageSrc		= imageSrc.replace('_off.gif','_on.gif');
	image.src		= imageSrc;
}
FormerCommon.buttonMouseOut		= function( image ) {
	var imageSrc	= image.src;
	imageSrc		= imageSrc.replace('_on.gif','_off.gif');
	image.src		= imageSrc;
}

//
// integer to hex string
//
FormerCommon.int2hexString = function( number ) {
	var charArray	= new Array(
		'0','1','2','3','4','5','6','7','8','9',
		'a','b','c','d','e','f'
	);
	var n16=0;              
	var result ="";
	while (number > 0) {
		n16		= number % 16;
		number	= ( number - n16 ) / 16;
		result = charArray[n16] + result;
	}
	if( result.length == 0 ) {
		result	= '00';
	}else if( result.length == 1 ) {
		result	= '0' + result;
	}
	return result;
}
//
// hex string to inteter value
//
FormerCommon.hexString2Int = function( hexString ) {
	hexString		= hexString.toLowerCase();
	var k 			= 1;
	var returnVal	= 0;
	for( var i=hexString.length - 1; i>=0; i-- ) {
		var str = hexString.substr(i,1);
		if('a'==str){ str='10'; }
		else if('b'==str){ str='11'; }
		else if('c'==str){ str='12'; }
		else if('d'==str){ str='13'; }
		else if('e'==str){ str='14'; }
		else if('f'==str){ str='15'; }
		returnVal += parseInt(str) * k;
		k*=16;
	}
	return returnVal;
}
//
// Create Random String
//
FormerCommon.RandomString = function() {
	this.str = '';
//	this.randam_char_array	= new Array(
//		'a','b','c','d','e','f','g','h','i','j'
//		,'k','l','m','n','o','p','q','r','s','t'
//		,'u','v','w','x','y','z'
//		,'A','B','C','D','E','F','G','H','I','J'
//		,'K','L','M','N','O','P','Q','R','S','T'
//		,'U','V','W','X','Y','Z'
//		,'0','1','2','3','4','5','6','7','8','9'
//	);
	this.randam_char_array	= new Array(
		'a','b','c','d','e','f','g','h','i','j'
		,'k','m','n','p','q','r','s','t'
		,'u','v','w','x','y','z'
		,'A','B','C','D','E','F','G','H','J'
		,'K','L','M','N','O','P','Q','R','S','T'
		,'U','V','W','X','Y','Z'
		,'2','3','4','5','6','7','8','9'
	);
	this.get = function(strlen) {
		var str = '';
		for( i=0; i<strlen; i++ ){
			var rand = Math.floor( Math.random() * this.randam_char_array.length );
			str += this.randam_char_array[rand];
		}
		this.str=str;
		return str;
	}
	this.set = function(obj,strlen) {
		this.get(strlen);
		obj.value = this.str;
	}
}
// --------------------------------------------------------
// Mouse Action Methods
// --------------------------------------------------------
//
// get mouse x
//
FormerCommon.getMouseX = function(e){
	if(window.opera){
		return e.clientX;
	} else if(document.all) {
		var leftMargin	= 0;
		if( document.documentElement ) {
			leftMargin	= document.documentElement.scrollLeft;
		} else {
			leftMargin	= document.body.scrollLeft;
		}
		return leftMargin+event.clientX;
	} else if(document.layers||document.getElementById) {
		return e.pageX;
	}
	return;
}
//
// get mouse y
//
FormerCommon.getMouseY = function(e){
	if(window.opera){
		return e.clientY;
	} else if(document.all) {
		var topMargin	= 0;
		if( document.documentElement ) {
			topMargin	= document.documentElement.scrollTop;
		} else {
			topMargin	= document.body.scrollTop;
		}
		return topMargin + event.clientY;
	} else if(document.layers||document.getElementById){
		return e.pageY;
	}
}

// --------------------------------------------------------
// String prototype additional methods
// --------------------------------------------------------
//
// String replace CR to LF
//
String.prototype.cr2lf = function() {
	return this.replace(String.fromCharCode(13)+String.fromCharCode(10), String.fromCharCode(10)).replace(String.fromCharCode(13), String.fromCharCode(10));
}
//
// String trim
//
String.prototype.trim = function() {
	return this.replace(/^\s+|\s+$/g, '');
}
//
// String rtim
//
String.prototype.rtrim = function() {
	return this.replace(/\s+$/g, '');
}
//
// String ltrim
//
String.prototype.ltrim = function() {
	return this.replace(/^\s+/g, '');
}
// --------------------------------------------------------
// FormerCommon http request
// --------------------------------------------------------
FormerCommon.createHttpRequest	= function(cbFunc) {
	var XMLhttpObject = null;
	try{
		XMLhttpObject = new XMLHttpRequest();
	}catch(e){
		try{
			XMLhttpObject = new ActiveXObject("Msxml2.XMLHTTP");
		}catch(e){
			try{
				XMLhttpObject = new ActiveXObject("Microsoft.XMLHTTP");
			}catch(e){
				return null;
			}
		}
	}
	if( cbFunc && XMLhttpObject) {
		var funcType	= typeof(cbFunc);
		if( 'function' == funcType ) {
			XMLhttpObject.onreadystatechange	= cbFunc;
		} else if( 'string' == funcType ) {
			XMLhttpObject.onreadystatechange	= function() {
				eval(cbFunc);
			};
		}
	}
	return XMLhttpObject;
}

// --------------------------------------------------------
// FormerCommon http request:createFormContents
// --------------------------------------------------------
FormerCommon.createFormContents	= function(element) {
	var contents	= '';
	if( element ) {
		var childs = element.childNodes;
		for( var i=0; i < childs.length; i++ ) {
			var child		= childs[i];
			var id			= child.id;
			var tag_name	= child.nodeName;
			var class_name	= child.className;
			var itemtype	= child.type;
			if( 'INPUT' == tag_name && 'text' == itemtype ) {
				contents	+= "&" + encodeURIComponent(child.name)+ "="+encodeURIComponent(child.value);
			} else if( 'INPUT' == tag_name && 'hidden' == itemtype ) {
				contents	+= "&" + encodeURIComponent(child.name)+ "="+encodeURIComponent(child.value);
			} else if( 'INPUT' == tag_name && 'checkbox' == itemtype ) {
				if( child.checked ) {
					contents	+= "&" + encodeURIComponent(child.name)+ "="+encodeURIComponent(child.value);
				}
			} else if( 'INPUT' == tag_name && 'radio' == itemtype ) {
				if( child.checked ) {
					contents	+= "&" + encodeURIComponent(child.name)+ "="+encodeURIComponent(child.value);
				}
			} else if( 'SELECT' == tag_name ) {
				var index	= child.selectedIndex;
				var value	= child.options[index].value;
				contents	+= "&" + encodeURIComponent(child.name)+ "="+encodeURIComponent(value);
			} else if( 'TEXTAREA' == tag_name ) {
				contents	+= "&" + encodeURIComponent(child.name)+ "="+encodeURIComponent(child.value);
			}
			contents	+= FormerCommon.createFormContents( child );
		}
	}
	return contents;
}

// --------------------------------------------------------
// FormerCommon execute post form
// --------------------------------------------------------
FormerCommon.postFormHttpObject;
FormerCommon.executePostForm	= function( formObject, execOk, execNg ) {
	if( formObject ) {
		FormerCommon.postFormHttpObject	= FormerCommon.createHttpRequest(FormerCommon.executePostFormResult);
		if (FormerCommon.postFormHttpObject) {
			FormerCommon.postFormHttpObject.execOk	= execOk;
			FormerCommon.postFormHttpObject.execNg	= execNg;
			var url			= formObject.action;
			var contents	= FormerCommon.createFormContents(formObject);
			FormerCommon.displayGrayOut(9999);
			FormerCommon.postFormHttpObject.open("POST",url,true);
			FormerCommon.postFormHttpObject.setRequestHeader("Content-Type", "application/x-www-form-urlencoded");
			FormerCommon.postFormHttpObject.send(contents);
		} else {
			alert('サーバーへの接続作成に失敗しました。');
		}
	} else {
		alert('JavaScriptライブラリ利用方法が正しくありません。');
	}
}
FormerCommon.executePostFormResult	= function() {
	if ((FormerCommon.postFormHttpObject.readyState == 4) && (FormerCommon.postFormHttpObject.status == 200)){
	    var lines	= FormerCommon.postFormHttpObject.responseText.cr2lf().split(LF);
	    var isError = false;
	    var error_message	= '';
	    for( var i=0; i<lines.length; i++ ){
			if( String(lines[i]).cr2lf().trim().length>0 ){
				var result	= String(lines[i]).cr2lf().trim();
				if( result == 'OK' ) {
					break;
				} else if( isError ) {
					error_message += result + "\n";
				} else {
					isError	= true;
				}
			}
		}
		if( isError ) {
			alert(error_message);
			if( FormerCommon.postFormHttpObject.execNg ) {
				var funcType	= typeof(FormerCommon.postFormHttpObject.execNg);
				if( 'function' == funcType ) {
					FormerCommon.postFormHttpObject.execNg;
				} else if( 'string' == funcType ) {
					eval(FormerCommon.postFormHttpObject.execNg);
				}
			}
		} else {
			if( FormerCommon.postFormHttpObject.execOk ) {
				var funcType	= typeof(FormerCommon.postFormHttpObject.execOk);
				if( 'function' == funcType ) {
					FormerCommon.postFormHttpObject.execOk;
				} else if( 'string' == funcType ) {
					eval(FormerCommon.postFormHttpObject.execOk);
				}
			}
		}
		setTimeout(FormerCommon.displayWhiteIn, 100);
	} else if ((FormerCommon.postFormHttpObject.readyState == 4) && (FormerCommon.postFormHttpObject.status != 200)){
		alert('サーバー通信でエラーが発生しました!\n' + FormerCommon.postFormHttpObject.status);
		setTimeout(FormerCommon.displayWhiteIn, 100);
	}
}

// --------------------------------------------------------
// FormerCommon getElementAbsolutePosition
// --------------------------------------------------------
FormerCommon.getElementAbsolutePosition	= function(element) {
	var offsetTrail	= (typeof element == 'string') ? document.getElementById(element) : element;
	var offsetLeft	= 0;
	var offsetTop	= 0;
	while (offsetTrail) {
		offsetLeft += offsetTrail.offsetLeft;
		offsetTop += offsetTrail.offsetTop;
		offsetTrail = offsetTrail.offsetParent;
	}
	if (navigator.userAgent.indexOf('Mac') != -1 && typeof document.body.leftMargin != "undefined") {
		offsetLeft += document.body.leftMargin;
		offsetTop += document.body.topMargin;
	}
	return ({left: offsetLeft, top: offsetTop});
}

//-----------------------------------------------------------------------------
// FormerCommon : Paging
//-----------------------------------------------------------------------------
FormerCommon.nextPage =function(){
	var next_page = document.sform.pn.value;
	if( NaN != parseInt(next_page) ){
		next_page = parseInt(next_page);
	}
	next_page++;
	document.sform.pn.value = String(next_page);
	document.sform.submit();
}
FormerCommon.prevPage =function(){
	var prev_page = document.sform.pn.value;
	if( NaN != parseInt(prev_page) ){
		prev_page = parseInt(prev_page);
	}
	prev_page--;
	document.sform.pn.value = String(prev_page);
	document.sform.submit();
}
FormerCommon.jumpPage =function(pageNumber){
	if( NaN != parseInt(pageNumber) ){
		document.sform.pn.value = String(pageNumber);
		document.sform.submit();
	}
}
// --------------------------------------------------------
// FormerCommon initiarize
// --------------------------------------------------------
FormerCommon.init = function() {
	if( !FormerCommon.isInit ) {
		var scriptTags 	= document.getElementsByTagName('script');
		for(var i=0,n=scriptTags.length;i<n;i++) {
			if(scriptTags[i].src.match('formercommon.js')) {
				FormerCommon.path = scriptTags[i].src.replace('formercommon.js','');
				break;
			}
		}
		FormerCommon.isInit	= true;
	}
}
//------------------------------------------------------------------------------
// FormerCommon: set cookie
//------------------------------------------------------------------------------
FormerCommon.setCookie = function(key,value,time) {
	key			= escape(new String(key).trim());
	value		= escape(value);
	var new_params	= new Array();
	new_params.push( key + '=' + value );
	var now = new Date;
	now.setTime(now.getTime() + time * 1000);
	var strings	= new_params.join('; ') + '; expires=' + now.toGMTString() +'; path=/';
	document.cookie	= strings;
}
//------------------------------------------------------------------------------
// FormerCommon: get cookie
//------------------------------------------------------------------------------
FormerCommon.getCookie = function(key) {
	key			= escape(new String(key).trim());
	var strings	= document.cookie;
	if( strings && strings.length>0 ) {
		var params	= strings.split(';');
		for( var i=0; i<params.length; i++ ) {
			var values	= params[i].split('=');
			var tkey		= new String(values[0]).trim();
			var tvalue	= new String(values[1]).trim();
			if( key === tkey ) {
				return unescape(tvalue);
			} else {
			}
		}
	}
	return '';
}
//------------------------------------------------------------------------------
// FormerCommon: set array cookie
//------------------------------------------------------------------------------
FormerCommon.setArrayCookie = function(key,strArray,time) {
	key			= escape(new String(key).trim());
	var value	= strArray.join(',');
	FormerCommon.setCookie(key,value,time);
}
//------------------------------------------------------------------------------
// FormerCommon: get Array cookie
//------------------------------------------------------------------------------
FormerCommon.getArrayCookie = function(key) {
	var str = FormerCommon.getCookie(key);
	if( str.length > 0 ) {
		var arr	= str.split(',');
		return arr;
	} else {
		return new Array();
	}
}

if(window.attachEvent){
	window.attachEvent('onload',FormerCommon.init);
	window.attachEvent('onresize',FormerCommon.displayGrayResize);
}else{
	window.addEventListener('DOMContentLoaded',FormerCommon.init,false);
	window.addEventListener('resize',FormerCommon.displayGrayResize,false);
}