/*
	CTimeOutMgr
	񓯊^CAEgssNX
	̃NX́AO[oɂPASĂ̔񓯊^CAEg̏sB
	񓯊pXbhB

	Version		: 0.0 (Release1)

	쐬		: 2002/05/25 (Yuh)
	C		: ----/--/--
	藚	: 
*/

#include "stdafx.h"
#include "TimeOut.h"

#ifdef _DEBUG
#undef THIS_FILE
static char THIS_FILE[]=__FILE__;
#define new DEBUG_NEW
#endif

//	W^CAEg
#define	DEFAULT_TIME_OUT	180000

//	^CAEg}l[W{
CTimeOutMgr	_globalManager;

//////////////////////////////////////////////////////////////////////
// \z/
//////////////////////////////////////////////////////////////////////

CTimeOutMgr::CTimeOutMgr()
{
	SCOPE_LOCK();

	m_break = 0;
	m_thread = NULL;
	StartThread();
	m_defaultTimeOutTime = DEFAULT_TIME_OUT;
}

CTimeOutMgr::~CTimeOutMgr()
{
	m_break = 1;

	while(IsRunning())
		Sleep(100);
}

//////////////////////////////////////////////////////////////////////
// XbhǗ
//////////////////////////////////////////////////////////////////////
//	Jn
void CTimeOutMgr::StartThread()
{
	CWinThread *tmp = AfxBeginThread(WorkThread,(LPVOID)this);
	tmp->SetThreadPriority(THREAD_PRIORITY_BELOW_NORMAL);
	m_thread = tmp->m_hThread;
}


//	s֐
UINT CTimeOutMgr::WorkThread(LPVOID pParam)
{
	CTimeOutMgr	*obj = (CTimeOutMgr*)pParam;
	obj->ThreadMain();

	return(0);
}

//	C
void CTimeOutMgr::ThreadMain()
{

	while(m_break == 0)
	{
		Sleep(100);
		{
			SCOPE_LOCK();

			int		i;
			DWORD	curTick = GetTickCount();
			for(i=(int)m_timeOutArray.GetSize() - 1;i>=0;i--)
			{
				if(m_timeOutArray[i].m_timeOutTime <= curTick || m_timeOutArray[i].m_startTick > curTick)
				{
					CTimeOut * timeOut = m_timeOutArray[i].m_class;

					m_timeOutArray.RemoveAt(i);
					timeOut->m_timeOutFlag = 1;
					timeOut->OnTimeOut();
					break;
				}
			}
		}
	}
}

//	sH
int CTimeOutMgr::IsRunning()
{
	if(m_thread==NULL)
		return(0);

	DWORD	tmp;
	::GetExitCodeThread(m_thread,&tmp);

	if(tmp==STILL_ACTIVE)
	{
		return(1);
	}

	m_thread=NULL;
	return(0);

}

//////////////////////////////////////////////////////////////////////
// ^CAEg
//////////////////////////////////////////////////////////////////////
//	ǉ
void CTimeOutMgr::AddTimeOut(CTimeOut *timeOut, int tick)
{
	if(tick <=0)
		tick = m_defaultTimeOutTime;

	CTimeOutInfo	add;
	add.m_class = timeOut;
	add.m_startTick = GetTickCount();
	add.m_timeOutTime = add.m_startTick + tick;

	SCOPE_LOCK();
	m_timeOutArray.Add(add);
}

//	폜
void CTimeOutMgr::DeleteTimeOut(CTimeOut *timeOut)
{
	SCOPE_LOCK();

	int	i;
	for(i=(int)m_timeOutArray.GetSize() - 1;i>=0;i--)
	{
		if(m_timeOutArray[i].m_class == timeOut)
			m_timeOutArray.RemoveAt(i);
	}
}

//////////////////////////////////////////////////////////////////////
// ݒ
//////////////////////////////////////////////////////////////////////
void CTimeOutMgr::SetDefaultTimeOutTime(int tick)
{
	SCOPE_LOCK();

	m_defaultTimeOutTime = tick;
}

//////////////////////////////////////////////////////////////////////
// }l[W̎擾
//////////////////////////////////////////////////////////////////////
CTimeOutMgr * CTimeOutMgr::GetGlobalManager()
{
	return(&_globalManager);
}



//////////////////////////////////////////////////////////////////////
// \z/
//////////////////////////////////////////////////////////////////////

CTimeOut::CTimeOut()
{
	m_timeOutFlag = 0;
}

CTimeOut::~CTimeOut()
{
	StopTimeOut();
}

void CTimeOut::OnTimeOut()
{

}

//////////////////////////////////////////////////////////////////////
// ^CAEg̐ݒ
//////////////////////////////////////////////////////////////////////
void CTimeOut::SetTimeOut(int tick)
{
	m_timeOutFlag = 0;
	StopTimeOut();
	CTimeOutMgr::GetGlobalManager()->AddTimeOut(this,tick);
}

void CTimeOut::StopTimeOut()
{
	CTimeOutMgr::GetGlobalManager()->DeleteTimeOut(this);
}
