#pragma once

#include "Workspace.h"
#include "threadskeleton.h"
#include "logwriter.h"
#include "mimetypemgr.h"
#include "bandwidthmgr.h"
#include "ListenerManager.h"
#include "IntervalTimer.h"
#include "SSLContext.h"
#include "ContextManager.h"



/*!
	class CSettingSwap

	T[oݒ̒u
*/
class CSettingSwap : public IWorkspaceAutoSwap
{
public:
	CSettingSwap(CWorkspaceAccess serverInfo) {m_serverInfo = serverInfo;};
	CString SwapString(CString key,CString data);
	void Delete() { delete this; };

	CWorkspaceAccess	m_serverInfo;	
};


/*!
	class CServer

	T[os܂
*/
class CServer : public CThreadSkeleton
{
public:
	CServer(void);
	virtual ~CServer(void);

	/////////////////////////////////////////////////////////////////////////////
	//	T[oc[
	/////////////////////////////////////////////////////////////////////////////
	//!	MIME^Cv}l[W̎擾
	CMimeTypeMgr GetCMimeTypeMgr() { SCOPE_LOCK(); return m_mimeTypes; };

	//!	ш敝}l[W̎擾
	CBandWidthMgr *GetCBandWidthMgr() { return &m_bandWidthMgr; };

	//!	ReLXg}l[W擾
	CContextManager *GetContextManager() { return &m_contextMgr; };

	//!	]ʂݒ
	void AddTrans(__int64 send,__int64 recv) { m_bandWidthMgr.AddTrans(send,recv); };

	//!	ڑ擾
	int GetConnectCount();

	//!	I[o[[hԂ擾
	int ServerIsOverload();

	//!	SSLReLXg擾
	SSL_CTX *GetCTX() { return m_sslContext.GetCTX(); };

protected:
	/////////////////////////////////////////////////////////////////////////////
	//	T[oNn
	/////////////////////////////////////////////////////////////////////////////
	//!	T[o̐ݒ
	void InitServerInfo(void);

	//!	҂󂯊Jn
	int StartListen(void);

	//!	SĂ̐ڑ̒~
	void KillAllConnection();

	//!	SSL
	void InitSSL();

	/////////////////////////////////////////////////////////////////////////////
	//	T[on
	/////////////////////////////////////////////////////////////////////////////
	//!	Xbh{
	void ThreadMain();

	//!	̐ڑ҂
	void WaitNextConnection(int timeout);

	//!	̃ANZX擾
	int GetNextAccess(CAcceptedSocket &nextAccess, int waitTime);

	//!	ؒfڑj
	void ClearCompletedConnections();

	//!	T[oג
	void CheckServerLoad();

	//!	T[oXV
	void UpdateServerInfo();

	//!	T[oXe[^Xݒ
	void SetServerStatus(CString status, CTimeSpan viewTime = CTimeSpan(1,0,0,0));

protected:
	//////////////////////////////////////////////////////////////////////////////////////
	//	oϐ
	//////////////////////////////////////////////////////////////////////////////////////
	//!	őڑ
	int					m_maxConnect;

	//!	ڑ
	CPtrArray			m_connections;

	//!	ReLXg}l[W
	CContextManager		m_contextMgr;

	//!	MimeTypẽLbV
	CMimeTypeMgr		m_mimeTypes;

	//!	ш搧
	CBandWidthMgr		m_bandWidthMgr;

	//!	Xi
	CListenerManager	m_listener;

	//!	SSLReLXg
	CSSLContext			m_sslContext;

	//!	׃tO
	CInterlockCounter	m_overloadFlag;

	//!	ׂƔf臒l
	int					m_overloadThreshold;

	//!	׏Ԉێ^C}
	CIntervalTimer		m_overloadKeepTimer;

	//!	T[oXe[^X
	CTime				m_statusHideTime;

public:
	CWorkspace			m_settingRoot;			//!<	ݒ胋[g
	CWorkspace			m_infoRoot;				//!<	T[o񃋁[g
	CWorkspaceAccess	m_serverInfo;			//!<	T[o̈

	//!	ݒ
	CWorkspaceAccess	m_setting;


	CLogWriter			m_log;					//!<	OC^[
};

