#pragma once

#include "Buffer.h"
#include "Workspace.h"
#include "server.h"


class CResponse
{
public:
	CResponse(CServer *server,CWorkspaceAccess context);
	virtual ~CResponse(void);

	virtual void PreCreateResponse() = 0;				//	1:X|X		
	virtual void SetNextData(CBuffer &data) = 0;		//	2:Mf[^̐ݒ(JԂ)
	virtual void CreateResponse() = 0;					//	3:X|X̐
	virtual __int64 GetResponseSize() = 0;				//	4:X|XTCY̎擾
	virtual CWorkspaceAccess GetResponseInfo();			//	5:X|X擾
	virtual int GetNextData(CBuffer &data) = 0;			//	6:X|X̎擾

	void SetResponseCode(int code);
	static CString GetHTTPResponseString(int code);		//	X|X擾

public:
	CWorkspaceAccess	m_context;
	CWorkspaceAccess	m_setting;				//!<	ݒ
	CWorkspaceAccess	m_serverInfo;			//!<	T[o̈
	CWorkspaceAccess	m_requestInfo;			//!<	NGXg
	CWorkspaceAccess	m_requestOptions;		//!<	NGXgIvV
	CWorkspaceAccess	m_responseInfo;			//!<	X|X
	CWorkspaceAccess	m_responseOptions;		//!<	X|XIvV
	CServer			*m_server;

private:
	void SetupDefaultResponse();
};
