/*
	̃R[h́A䳉(SAKA)lJIS2000.DLL̃\[XɍĂ܂B

	IWĩRs[Cg:
	JIS X 0213:2000 ΉR[hϊDLL (jis2000.h)
								Copyright(C)2000 䳉(SAKA)
*/
#include "Buffer.h"


#define	JIS2K_ASCII			0x0000
#define	JIS2K_JIS			0x0100
#define	JIS2K_SJIS			0x0200
#define	JIS2K_EUC			0x0400
#define	JIS2K_UNICODE		0x0800
#define	JIS2K_UTF8			0x0801
#define	JIS2K_UTF7			0x0802
#define	JIS2K_NON			0x1000
#define	JIS2K_BINARY		0x2000

#define	JIS2K_KANJI1		0x0001
#define	JIS2K_KANJI2		0x0002
#define	JIS2K_KANJI3		0x0004
#define	JIS2K_KANJI4		0x0008
#define	JIS2K_HIKANJI1		0x0010
#define	JIS2K_HIKANJI3		0x0040
#define JIS2K_XJIS0208		JIS2K_KANJI1 + JIS2K_KANJI2 + JIS2K_HIKANJI1
#define JIS2K_XJIS0213		JIS2K_KANJI3 + JIS2K_KANJI4 + JIS2K_HIKANJI3

class CJISUtility
{
public:
	static int GetKanjiCodeType(CString string);
	static CString ToSjisString(CString string);
	static CString UnicodeToUTF8(CBuffer unicode);
	static CString SjisToUTF8(CString sjis);

//	JIS2000IWi֐
public:
	static int GetJis2000Version(void);
	static int GetKanjiCodeType(const char *code, const int count);

	static size_t SjisToUnicode(wchar_t *unicode, const char* sjis, const size_t count);
	static size_t UnicodeToSjis(char *sjis, const wchar_t *unicode, const size_t count);

	static size_t SjisToIso2022jp3(char *jis, const char *sjis, const size_t count);
	static size_t SjisToIso2022jp3Strict(char *jis, const char *sjis, const size_t count);
	static size_t SjisToIso2022jp3Compatible(char *jis, const char *sjis, const size_t count);
	static size_t Iso2022jpToSjis(char *sjis, const char *jis, const size_t count);

	static size_t SjisToEuc(char *euc, const char *sjis, const size_t count);
	static size_t EucToSjis(char *sjis, const char *euc, const size_t count);

	static size_t X0201ToX0208Kana(char *zen, const char *han, const size_t count);
	static size_t WinsjisToSjis2000(char *sjis, const char *win, const size_t count);

	static size_t UnicodeToUTF8(char* utf8, const wchar_t *unicode, const size_t count);
	static size_t UTF8ToUnicode(wchar_t *unicode, const char* utf8, const size_t count);

	static size_t UnicodeToUTF7(char* utf7, const wchar_t *unicode, const size_t count);
	static size_t UnicodeToUTF7Strict(char* utf7, const wchar_t *unicode, const size_t count);
	static size_t UTF7ToUnicode(wchar_t *unicode , const char* utf7, const size_t count);

private:
	static int _issjis2000(const unsigned short sjis);
	static int _isx0208pullout(const unsigned short sjis);

	static unsigned short _getsjis(const unsigned char* sjis, int *nByte);
	static size_t _setmbyte(char* buf, const unsigned short code);

	static unsigned short _sjis2jis(const unsigned short sjis, int *plane);
	static unsigned short _jis2sjis(const unsigned short jis, const int plane);

	static wchar_t _sjis2unicode(const unsigned short sjis);
	static unsigned short _unicode2sjis(const wchar_t uni);
	static wchar_t _utf8toucs2(const unsigned char *utf8, int *nByte);
	static size_t _ucs2toutf8(unsigned char *utf8, const wchar_t uni);

	static unsigned short _x0212_2sjis(const unsigned short jis);

	static size_t _sjis2iso2022jp(char *jis, const char *sjis, const size_t count, int mode);

	static size_t _utf7encode(char *utf7, const wchar_t *uni, const size_t count, const size_t num);
	static size_t _utf7decode(wchar_t *uni, const char *utf7, const size_t count, size_t *num);
	static size_t _utf16toutf7(char* utf7, const wchar_t *uni, const size_t count, bool strict);
};

/*****	end of file	*****/