/*!
	XV

	2005/05/20 CheckRange,GetETag̗OC
*/



#include "StdAfx.h"
#include "fileresponse.h"
#include "connection.h"
#include "DateUtility.h"
#include "SystemResponse.h"

CFileResponse::CFileResponse(CServer *server,CWorkspaceAccess context,CRequest request,CAlias alias)
: CNormalResponse(server,context,request,alias)
{
	//	͖Ƃ
	if(alias.IsExist()==0)
		throw new CSystemResponse(server,context,"w肳ꂽt@C݂͑܂",404);

	//	\bhGET?
	if(request.m_method != "GET" && request.m_method != "HEAD")
		throw new CSystemResponse(server,context,"ΉĂȂ\bhł",405);
}

CFileResponse::~CFileResponse(void)
{
	try
	{
		m_file.Close();
	}
	catch(CFileException *err)
	{
		err->Delete();
	}
}



/*
	X|X
*/
void CFileResponse::CreateResponse()
{
	//	X|XR[h
	SetResponseCode(200);	//	OK

	//	t@CG[XR[v
	try
	{
		TRACE("File : %s\n",m_alias.GetTarget());
		if(!m_file.Open(m_alias.GetTarget(),	CFile::modeRead | CFile::shareDenyWrite))
			throw CSystemResponse(m_server, m_context, "t@C̃I[vɎs܂AT[o[̃t@ĆAgp̂߃bNĂ\܂", 500);

		//	XṼ`FbN
		CFileStatus	stat;
		m_file.GetStatus(stat);
		int update = CheckUpdate(stat.m_mtime);

		//	ETag`FbN
		int update2 = CheckETag(m_file);

		if(update == 1 || update2 == 1 || (update == -1 && update2 == -1))
		{
			//	W[
			CheckRange();

			//	mimetypě
			CMimeTypeMgr	mgr = m_server->GetCMimeTypeMgr();
			m_responseOptions.SetConfig("Content-Type",mgr.GetMimeTypeByName(m_alias.GetTarget()));										//	^Cv
		}
		else
			throw new CSystemResponse(m_server,m_context,"^[Qbg͍XVĂ܂",304);
	}
	catch(CFileException *err)
	{
		TRACE("File error : %s\n",err->m_strFileName);
		err->Delete();
		throw CSystemResponse(m_server, m_context, "t@C̑Ɏs܂AVXeG[ł", 500);
	}
}


/*!
	X|XTCY̎擾
*/
__int64 CFileResponse::GetResponseSize()
{
	try
	{
		return(m_file.GetLength() - m_file.GetPosition());
	}
	catch(CFileException *err)
	{
		TRACE("File error : %s\n",err->m_strFileName);
		err->Delete();
		throw CSystemResponse(m_server, m_context, "t@C̑Ɏs܂AVXeG[ł", 500);
	}
}

/*!
	X|X̎擾
*/
int CFileResponse::GetNextData(CBuffer &data)
{
	try
	{
		int size = m_file.Read(data.GetPtr(),data.GetSize());
		data.ReSize(size);
		return(size);
	}
	catch(CFileException *err) 
	{
		TRACE("File error : %s\n",err->m_strFileName);
		err->Delete();
		throw CServerFatalException("t@C̑Ɏs܂AVXeG[ł");	//	MȂ̂ŁAvIG[
	}
}

/*!
 *	W[
 *
 *	@return		0:
 */
int CFileResponse::CheckRange()
{
	try
	{
		//	Rangewb_́H
		CString range = m_requestOptions.GetConfig("Range","");
		if(range != "")
		{
			//	T|[gĂ̂H(bytesH)
			//	Range: bytes=xxxx-
			if(range.Left(6).CompareNoCase("bytes=")==0)
			{
				range = range.Mid(6);
				int index = range.Find("-");
				if(index != -1)
					range = range.Left(index);

				__int64	start = _atoi64(range);
				if(start < 0 || (unsigned)start >= m_file.GetLength())
					return(-1);

				//	W[
				m_file.Seek(start,CFile::begin);
				SetResponseCode(206);
				CString	str;
				m_responseOptions.SetConfig("Accept-Ranges","bytes");
				str.Format("bytes %I64d-%I64d/%I64d",start,m_file.GetLength(),m_file.GetLength());
				m_responseOptions.SetConfig("Content-Range",str);
			}
		}
	}
	catch(CFileException *err) 
	{
		TRACE("File error : %s\n",err->m_strFileName);
		err->Delete();
		throw CSystemResponse(m_server, m_context, "t@C̑Ɏs܂AVXeG[ł", 500);
	}
			
	return(0);
}


/*!
 *	XV̊mFLast-modified̐ݒ
 *
 *	@param	date	^[Qbg̍XV
 *	@return			1:XVĂ
 */
int CFileResponse::CheckUpdate(CTime date)
{
	//	XVt̏o
	m_responseOptions.SetConfig("Last-modified",CDateUtility::GetGMTString(date));

	//	XV`FbN
	CString modified = m_requestOptions.GetConfig("If-Modified-Since","");
	if(modified.IsEmpty())
		return -1;

	CTime lm = CDateUtility::StringToCTime(modified);
	if(date <= lm && lm != 0)
		return(0);

	return 1;
}


/*!
 *	ETag̊mFETag̐ݒ
 *
 *	@param	tag		^[Qbg̏
 *	@return			1:XVĂ
 */
int CFileResponse::CheckETag(CFile &file)
{
	//	ETag̏o
	CString tag = GetETag(file);
	m_responseOptions.SetConfig("ETag",tag);

	//	ETag`FbN
	CString modified = m_requestOptions.GetConfig("If-None-Match","");
	if(modified.IsEmpty())
		return(-1);

	if(modified == tag)
		return(0);

	return(1);
}


/*!
	ETga̎擾
*/
CString	CFileResponse::GetETag(CFile &file)
{
	try
	{
		CFileStatus	stat;
		m_file.GetStatus(stat);

		//	04WebServerETaǵAt@CTCYAt@CpXAt@Ct擾
		__int64 size = m_file.GetLength();
		CTime	time = stat.m_mtime;
		CString	path = m_file.GetFilePath();

		int	calc=0;
		unsigned char *buf = (unsigned char *)path.GetBuffer();
		for(int i=0;i<path.GetLength();i++)
			calc += buf[i];

		CString str;
		str.Format("\"%I64x-%I64x:%04d\"",size,time.GetTime(),calc);

		return(str);
	}
	catch(CFileException *err) 
	{
		TRACE("File error : %s\n",err->m_strFileName);
		err->Delete();
		throw CSystemResponse(m_server, m_context, "t@C̑Ɏs܂AVXeG[ł", 500);
	}
}



